/*
 * Decompiled with CFR 0.152.
 */
package org.langmeta.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.langmeta.internal.io.FileIO$;
import org.langmeta.internal.io.PathIO$;
import org.langmeta.io.AbsolutePath;
import org.langmeta.io.Fragment;
import org.langmeta.io.Multipath;
import org.langmeta.io.Multipath$;
import org.langmeta.io.RelativePath;
import org.langmeta.io.RelativePath$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.sys.package$;

public abstract class Multipath$class {
    public static String syntax(Multipath $this) {
        return $this.shallow().mkString(File.pathSeparator);
    }

    public static List deep(Multipath $this) {
        ObjectRef buf = ObjectRef.create((Object)((LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)Nil$.MODULE$)));
        $this.shallow().foreach((Function1)new Serializable($this, buf){
            public static final long serialVersionUID = 0L;
            public final ObjectRef buf$1;

            public final void apply(AbsolutePath base) {
                if (base.isDirectory()) {
                    FileIO$.MODULE$.listAllFilesRecursively(base).files().foreach((Function1)new Serializable(this, base){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Multipath$.anonfun.deep.1 $outer;
                        private final AbsolutePath base$1;

                        public final LinkedHashSet<Fragment> apply(RelativePath relpath) {
                            return ((LinkedHashSet)this.$outer.buf$1.elem).$plus$eq((Object)new Fragment(this.base$1, relpath));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.base$1 = base$1;
                        }
                    });
                } else if (base.isFile()) {
                    if (base.toString().endsWith(".jar")) {
                        this.exploreJar$1(base);
                    } else {
                        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Obtained non-jar file ", ". Expected directory or *.jar file."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base})));
                    }
                }
            }

            private final void exploreJar$1(AbsolutePath base) {
                FileInputStream stream = new FileInputStream(base.toFile());
                try {
                    try {
                        ZipInputStream zip = new ZipInputStream(stream);
                        ZipEntry entry = zip.getNextEntry();
                        while (entry != null) {
                            BoxedUnit boxedUnit;
                            if (entry.getName().endsWith("/")) {
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                RelativePath name = RelativePath$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(entry.getName())).stripPrefix("/"));
                                boxedUnit = ((LinkedHashSet)this.buf$1.elem).$plus$eq((Object)new Fragment(base, name));
                            }
                            entry = zip.getNextEntry();
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                finally {
                    stream.close();
                }
            }
            {
                this.buf$1 = buf$1;
            }
        });
        return ((LinkedHashSet)buf.elem).toList();
    }

    public static Option relativize(Multipath $this, URI uri) {
        return $this.deep().find((Function1)new Serializable($this, uri){
            public static final long serialVersionUID = 0L;
            private final URI uri$1;

            public final boolean apply(Fragment x$1) {
                URI uRI = x$1.uri();
                URI uRI2 = this.uri$1;
                return !(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null);
            }
            {
                this.uri$1 = uri$1;
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final RelativePath apply(Fragment x$2) {
                return x$2.name();
            }
        });
    }

    public static Option find(Multipath $this, RelativePath name) {
        return $this.deep().find((Function1)new Serializable($this, name){
            public static final long serialVersionUID = 0L;
            private final RelativePath name$1;

            public final boolean apply(Fragment x$3) {
                RelativePath relativePath = x$3.name();
                RelativePath relativePath2 = this.name$1;
                return !(relativePath != null ? !((Object)relativePath).equals(relativePath2) : relativePath2 != null);
            }
            {
                this.name$1 = name$1;
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final URI apply(Fragment x$4) {
                return x$4.uri();
            }
        });
    }

    public static void visit(Multipath $this, Function1 getVisitor) {
        $this.shallow().foreach((Function1)new Serializable($this, getVisitor){
            public static final long serialVersionUID = 0L;
            private final Function1 getVisitor$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(AbsolutePath base) {
                Object object;
                if (base.isDirectory()) {
                    FileVisitor visitor = (FileVisitor)this.getVisitor$1.apply((Object)base);
                    object = Files.walkFileTree(base.toNIO(), visitor);
                    return object;
                } else if (base.isFile()) {
                    String string = PathIO$.MODULE$.extension(base.toNIO());
                    if (!"jar".equals(string)) throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected jar file, obtained ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base})));
                    AbsolutePath root = FileIO$.MODULE$.jarRootPath(base);
                    FileVisitor visitor = (FileVisitor)this.getVisitor$1.apply((Object)root);
                    Path path = Files.walkFileTree(root.toNIO(), visitor);
                    object = path;
                    return object;
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.getVisitor$1 = getVisitor$1;
            }
        });
    }

    public static void $init$(Multipath $this) {
    }
}

