/*
 * Decompiled with CFR 0.152.
 */
package org.langmeta.internal.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import org.langmeta.internal.io.JSIO$;
import org.langmeta.internal.io.ListFiles;
import org.langmeta.io.AbsolutePath;
import org.langmeta.io.AbsolutePath$;
import org.langmeta.io.RelativePath;
import org.langmeta.io.RelativePath$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.scalajs.js.Array;

public final class PlatformFileIO$ {
    public static PlatformFileIO$ MODULE$;

    static {
        new PlatformFileIO$();
    }

    public InputStream newInputStream(URI uri) {
        return new ByteArrayInputStream(this.readAllBytes(uri));
    }

    public byte[] readAllBytes(URI uri) {
        block3: {
            block4: {
                String string;
                String string2;
                block2: {
                    string2 = uri.getScheme();
                    string = "file";
                    if (string2 != null) break block2;
                    if (string == null) break block3;
                    break block4;
                }
                if (string2.equals(string)) break block3;
            }
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't read ", " as InputStream"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
        }
        return this.readAllBytes(AbsolutePath$.MODULE$.apply(uri.getPath(), AbsolutePath$.MODULE$.workingDirectory()));
    }

    public byte[] readAllBytes(AbsolutePath path) {
        return (byte[])JSIO$.MODULE$.inNode((Function0 & Serializable & scala.Serializable)() -> {
            void var3_3;
            Array<Object> jsArray = JSIO$.MODULE$.fs().readFileSync(path.toString());
            int len = jsArray.length();
            byte[] result = new byte[len];
            for (int curr = 0; curr < len; ++curr) {
                result[curr] = (byte)BoxesRunTime.unboxToInt((Object)jsArray.apply(curr));
            }
            return var3_3;
        });
    }

    public String slurp(AbsolutePath path, Charset charset) {
        return (String)JSIO$.MODULE$.inNode((Function0 & Serializable & scala.Serializable)() -> JSIO$.MODULE$.fs().readFileSync(path.toString(), charset.toString()));
    }

    public ListFiles listFiles(AbsolutePath path) {
        return (ListFiles)JSIO$.MODULE$.inNode((Function0 & Serializable & scala.Serializable)() -> {
            ListFiles listFiles;
            if (path.isFile()) {
                listFiles = new ListFiles(path, (List<RelativePath>)Nil$.MODULE$);
            } else {
                Array<String> jsArray = JSIO$.MODULE$.fs().readdirSync(path.toString());
                Builder builder = List$.MODULE$.newBuilder();
                builder.sizeHint(jsArray.length());
                for (int curr = 0; curr < jsArray.length(); ++curr) {
                    builder.$plus$eq((Object)RelativePath$.MODULE$.apply((String)jsArray.apply(curr)));
                }
                listFiles = new ListFiles(path, (List<RelativePath>)((List)builder.result()));
            }
            return listFiles;
        });
    }

    public boolean isFile(AbsolutePath path) {
        return JSIO$.MODULE$.isFile(path.toString());
    }

    public boolean isDirectory(AbsolutePath path) {
        return JSIO$.MODULE$.isDirectory(path.toString());
    }

    public ListFiles listAllFilesRecursively(AbsolutePath root) {
        Builder builder = List$.MODULE$.newBuilder();
        this.loop$1(root, root, builder);
        return new ListFiles(root, (List<RelativePath>)((List)builder.result()));
    }

    private final void loop$1(AbsolutePath path2, AbsolutePath root$1, Builder builder$1) {
        if (path2.isDirectory()) {
            this.listFiles(path2).foreach((Function1 & Serializable & scala.Serializable)path -> {
                this.loop$1(path, root$1, builder$1);
                return BoxedUnit.UNIT;
            });
        } else {
            builder$1.$plus$eq((Object)path2.toRelative(root$1));
        }
    }

    private PlatformFileIO$() {
        MODULE$ = this;
    }
}

