/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.lsp;

import com.typesafe.scalalogging.Logger;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.ParsingFailure;
import io.circe.jawn.package$;
import io.circe.syntax.package;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Cancelable;
import monix.execution.CancelableFuture;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.meta.jsonrpc.BaseProtocolMessage;
import scala.meta.jsonrpc.Message;
import scala.meta.jsonrpc.Message$;
import scala.meta.jsonrpc.NamedJsonRpcService;
import scala.meta.jsonrpc.Notification;
import scala.meta.jsonrpc.Request;
import scala.meta.jsonrpc.RequestId;
import scala.meta.jsonrpc.RequestId$;
import scala.meta.jsonrpc.Response;
import scala.meta.jsonrpc.Response$;
import scala.meta.jsonrpc.Service;
import scala.meta.jsonrpc.Service$;
import scala.meta.jsonrpc.Services;
import scala.meta.lsp.CancelParams;
import scala.meta.lsp.CancelParams$;
import scala.meta.lsp.LanguageClient;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u0005%\u0011a\u0002T1oOV\fw-Z*feZ,'O\u0003\u0002\u0004\t\u0005\u0019An\u001d9\u000b\u0005\u00151\u0011\u0001B7fi\u0006T\u0011aB\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u00195\ta!\u0003\u0002\u000e\r\t1\u0011I\\=SK\u001aD\u0001b\u0004\u0001\u0003\u0002\u0003\u0006I\u0001E\u0001\u0003S:\u00042!\u0005\f\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003!\u0011X-Y2uSZ,'\"A\u000b\u0002\u000b5|g.\u001b=\n\u0005]\u0011\"AC(cg\u0016\u0014h/\u00192mKB\u0011\u0011\u0004H\u0007\u00025)\u00111\u0004B\u0001\bUN|gN\u001d9d\u0013\ti\"DA\nCCN,\u0007K]8u_\u000e|G.T3tg\u0006<W\r\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0003\u0019\u0019G.[3oiB\u0011\u0011EI\u0007\u0002\u0005%\u00111E\u0001\u0002\u000f\u0019\u0006tw-^1hK\u000ec\u0017.\u001a8u\u0011!)\u0003A!A!\u0002\u00131\u0013\u0001C:feZL7-Z:\u0011\u0005e9\u0013B\u0001\u0015\u001b\u0005!\u0019VM\u001d<jG\u0016\u001c\b\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002!I,\u0017/^3tiN\u001b\u0007.\u001a3vY\u0016\u0014\bC\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0015\u0003%)\u00070Z2vi&|g.\u0003\u00021[\tI1k\u00195fIVdWM\u001d\u0005\te\u0001\u0011\t\u0011)A\u0005g\u00051An\\4hKJ\u0004\"\u0001N\u001e\u000e\u0003UR!AN\u001c\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005aJ\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003i\n1aY8n\u0013\taTG\u0001\u0004M_\u001e<WM\u001d\u0005\u0006}\u0001!\taP\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0001\u000b%i\u0011#F!\t\t\u0003\u0001C\u0003\u0010{\u0001\u0007\u0001\u0003C\u0003 {\u0001\u0007\u0001\u0005C\u0003&{\u0001\u0007a\u0005C\u0003+{\u0001\u00071\u0006C\u00033{\u0001\u00071\u0007C\u0004H\u0001\t\u0007I\u0011\u0002%\u0002)\u0005\u001cG/\u001b<f\u00072LWM\u001c;SKF,Xm\u001d;t+\u0005I\u0005\u0003\u0002&P#fk\u0011a\u0013\u0006\u0003\u00196\u000b!bY8oGV\u0014(/\u001a8u\u0015\tqe!\u0001\u0006d_2dWm\u0019;j_:L!\u0001U&\u0003\u000fQ\u0013\u0018.Z'baB\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u0006G&\u00148-\u001a\u0006\u0002-\u0006\u0011\u0011n\\\u0005\u00031N\u0013AAS:p]B\u0011AFW\u0005\u000376\u0012!bQ1oG\u0016d\u0017M\u00197f\u0011\u0019i\u0006\u0001)A\u0005\u0013\u0006)\u0012m\u0019;jm\u0016\u001cE.[3oiJ+\u0017/^3tiN\u0004\u0003bB0\u0001\u0005\u0004%I\u0001Y\u0001\u0013G\u0006t7-\u001a7O_RLg-[2bi&|g.F\u0001b!\tI\"-\u0003\u0002d5\t\u0019b*Y7fI*\u001bxN\u001c*qGN+'O^5dK\"1Q\r\u0001Q\u0001\n\u0005\f1cY1oG\u0016dgj\u001c;jM&\u001c\u0017\r^5p]\u0002Bqa\u001a\u0001C\u0002\u0013%\u0001.\u0001\u000biC:$G.\u001a:t\u0005flU\r\u001e5pI:\u000bW.Z\u000b\u0002SB!!.\u001d;b\u001d\tYw\u000e\u0005\u0002m\r5\tQN\u0003\u0002o\u0011\u00051AH]8pizJ!\u0001\u001d\u0004\u0002\rA\u0013X\rZ3g\u0013\t\u00118OA\u0002NCBT!\u0001\u001d\u0004\u0011\u0005),\u0018B\u0001<t\u0005\u0019\u0019FO]5oO\"1\u0001\u0010\u0001Q\u0001\n%\fQ\u0003[1oI2,'o\u001d\"z\u001b\u0016$\bn\u001c3OC6,\u0007\u0005C\u0003{\u0001\u0011\u000510\u0001\niC:$G.\u001a,bY&$W*Z:tC\u001e,Gc\u0001?\u0002\fA)Q0!\u0001\u0002\u00065\taP\u0003\u0002\u0000)\u0005!QM^1m\u0013\r\t\u0019A \u0002\u0005)\u0006\u001c8\u000eE\u0002\u001a\u0003\u000fI1!!\u0003\u001b\u0005!\u0011Vm\u001d9p]N,\u0007bBA\u0007s\u0002\u0007\u0011qB\u0001\b[\u0016\u001c8/Y4f!\rI\u0012\u0011C\u0005\u0004\u0003'Q\"aB'fgN\fw-\u001a\u0005\b\u0003/\u0001A\u0011AA\r\u00035A\u0017M\u001c3mK6+7o]1hKR\u0019A0a\u0007\t\u000f\u00055\u0011Q\u0003a\u00011!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0012!C:uCJ$H+Y:l+\t\t\u0019\u0003E\u0003~\u0003\u0003\t)\u0003E\u0002\f\u0003OI1!!\u000b\u0007\u0005\u0011)f.\u001b;\t\u000f\u00055\u0002\u0001\"\u0001\u00020\u00051A.[:uK:$\"!!\n")
public final class LanguageServer {
    private final Observable<BaseProtocolMessage> in;
    private final LanguageClient client;
    private final Scheduler requestScheduler;
    public final Logger scala$meta$lsp$LanguageServer$$logger;
    private final TrieMap<Json, Cancelable> scala$meta$lsp$LanguageServer$$activeClientRequests;
    private final NamedJsonRpcService cancelNotification;
    private final Map<String, NamedJsonRpcService> handlersByMethodName;

    public TrieMap<Json, Cancelable> scala$meta$lsp$LanguageServer$$activeClientRequests() {
        return this.scala$meta$lsp$LanguageServer$$activeClientRequests;
    }

    private NamedJsonRpcService cancelNotification() {
        return this.cancelNotification;
    }

    private Map<String, NamedJsonRpcService> handlersByMethodName() {
        return this.handlersByMethodName;
    }

    public Task<Response> handleValidMessage(Message message) {
        Task task;
        Message message2 = message;
        if (message2 instanceof Response) {
            Response response = (Response)message2;
            task = Task$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> {
                $this.client.clientRespond(response);
                return Response$.MODULE$.empty();
            });
        } else if (message2 instanceof Notification) {
            Task task2;
            Notification notification = (Notification)message2;
            String method = notification.method();
            Option option = this.handlersByMethodName().get((Object)method);
            if (None$.MODULE$.equals(option)) {
                task2 = Task$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> {
                    BoxedUnit boxedUnit;
                    if ($this.scala$meta$lsp$LanguageServer$$logger.underlying().isErrorEnabled()) {
                        $this.scala$meta$lsp$LanguageServer$$logger.underlying().error("Unknown method '{}'", new Object[]{method});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return Response$.MODULE$.empty();
                });
            } else if (option instanceof Some) {
                Some some = (Some)option;
                NamedJsonRpcService handler = (NamedJsonRpcService)some.value();
                task2 = handler.handle((Object)message).map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
                    Response response;
                    Response response2 = x0$1;
                    if (Response.Empty$.MODULE$.equals(response2)) {
                        response = Response$.MODULE$.empty();
                    } else {
                        BoxedUnit boxedUnit;
                        if ($this.scala$meta$lsp$LanguageServer$$logger.underlying().isErrorEnabled()) {
                            $this.scala$meta$lsp$LanguageServer$$logger.underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Obtained non-empty response ", " for notification ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response2, message})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected Response.empty"})).s((Seq)Nil$.MODULE$));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        response = Response$.MODULE$.empty();
                    }
                    return response;
                }).onErrorRecover((PartialFunction)new Serializable(this, message){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LanguageServer $outer;
                    private final Message message$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        Option option = NonFatal$.MODULE$.unapply(A1);
                        if (!option.isEmpty()) {
                            BoxedUnit boxedUnit;
                            Throwable e = (Throwable)option.get();
                            if (this.$outer.scala$meta$lsp$LanguageServer$$logger.underlying().isErrorEnabled()) {
                                this.$outer.scala$meta$lsp$LanguageServer$$logger.underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error handling notification ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.message$1})), e);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            object = Response$.MODULE$.empty();
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        boolean bl = !option.isEmpty();
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.message$1 = message$1;
                    }
                });
            } else {
                throw new MatchError((Object)option);
            }
            task = task2;
        } else if (message2 instanceof Request) {
            Task task3;
            Request request = (Request)message2;
            String method = request.method();
            RequestId id = request.id();
            Option option = this.handlersByMethodName().get((Object)method);
            if (None$.MODULE$.equals(option)) {
                task3 = Task$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> {
                    BoxedUnit boxedUnit;
                    if ($this.scala$meta$lsp$LanguageServer$$logger.underlying().isInfoEnabled()) {
                        $this.scala$meta$lsp$LanguageServer$$logger.underlying().info("Method not found '{}'", new Object[]{method});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return Response$.MODULE$.methodNotFound(method, id);
                });
            } else if (option instanceof Some) {
                Some some = (Some)option;
                NamedJsonRpcService handler = (NamedJsonRpcService)some.value();
                Task response = handler.handle((Object)request).onErrorRecover((PartialFunction)new Serializable(this, request){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LanguageServer $outer;
                    private final Request x4$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        Option option = NonFatal$.MODULE$.unapply(A1);
                        if (!option.isEmpty()) {
                            BoxedUnit boxedUnit;
                            Throwable e = (Throwable)option.get();
                            if (this.$outer.scala$meta$lsp$LanguageServer$$logger.underlying().isErrorEnabled()) {
                                this.$outer.scala$meta$lsp$LanguageServer$$logger.underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unhandled error handling request ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x4$1})), e);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            object = Response$.MODULE$.internalError(e.getMessage(), this.x4$1.id());
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x2) {
                        Throwable throwable = x2;
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        boolean bl = !option.isEmpty();
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x4$1 = x4$1;
                    }
                });
                CancelableFuture runningResponse = response.runAsync(this.requestScheduler);
                this.scala$meta$lsp$LanguageServer$$activeClientRequests().put((Object)package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)request.id()), RequestId$.MODULE$.encoder()), (Object)runningResponse);
                task3 = Task$.MODULE$.fromFuture((Future)runningResponse);
            } else {
                throw new MatchError((Object)option);
            }
            task = task3;
        } else {
            throw new MatchError((Object)message2);
        }
        return task;
    }

    public Task<Response> handleMessage(BaseProtocolMessage message) {
        Task<Response> task;
        Either either = package$.MODULE$.parseByteBuffer(ByteBuffer.wrap(message.content()));
        if (either instanceof Left) {
            Left left = (Left)either;
            ParsingFailure err = (ParsingFailure)left.value();
            task = Task$.MODULE$.now((Object)Response$.MODULE$.parseError(err.toString()));
        } else if (either instanceof Right) {
            Task<Response> task2;
            Right right = (Right)either;
            Json json = (Json)right.value();
            Either either2 = json.as(Message$.MODULE$.decoder());
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                DecodingFailure err = (DecodingFailure)left.value();
                task2 = Task$.MODULE$.now((Object)Response$.MODULE$.invalidRequest(err.toString()));
            } else if (either2 instanceof Right) {
                Right right2 = (Right)either2;
                Message msg = (Message)right2.value();
                task2 = this.handleValidMessage(msg);
            } else {
                throw new MatchError((Object)either2);
            }
            task = task2;
        } else {
            throw new MatchError((Object)either);
        }
        return task;
    }

    public Task<BoxedUnit> startTask() {
        return this.in.foreachL((Function1 & java.io.Serializable & Serializable)msg -> {
            LanguageServer.$anonfun$startTask$1(this, msg);
            return BoxedUnit.UNIT;
        });
    }

    public void listen() {
        BoxedUnit boxedUnit;
        CancelableFuture f = this.startTask().runAsync(this.requestScheduler);
        if (this.scala$meta$lsp$LanguageServer$$logger.underlying().isInfoEnabled()) {
            this.scala$meta$lsp$LanguageServer$$logger.underlying().info("Listening....");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Await$.MODULE$.result((Awaitable)f, (Duration)Duration$.MODULE$.Inf());
    }

    public static final /* synthetic */ void $anonfun$startTask$1(LanguageServer $this, BaseProtocolMessage msg) {
        $this.handleMessage(msg).map((Function1 & java.io.Serializable & Serializable)response -> $this.client.serverRespond((Response)response)).onErrorRecover((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LanguageServer $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    if (this.$outer.scala$meta$lsp$LanguageServer$$logger.underlying().isErrorEnabled()) {
                        this.$outer.scala$meta$lsp$LanguageServer$$logger.underlying().error("Unhandled error", e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Throwable throwable = x3;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).runAsync($this.requestScheduler);
    }

    public LanguageServer(Observable<BaseProtocolMessage> in, LanguageClient client, Services services, Scheduler requestScheduler, Logger logger) {
        this.in = in;
        this.client = client;
        this.requestScheduler = requestScheduler;
        this.scala$meta$lsp$LanguageServer$$logger = logger;
        this.scala$meta$lsp$LanguageServer$$activeClientRequests = TrieMap$.MODULE$.empty();
        this.cancelNotification = Service$.MODULE$.notification("$/cancelRequest", (Service)new Service<CancelParams, BoxedUnit>(this){
            private final /* synthetic */ LanguageServer $outer;

            public Task<BoxedUnit> handle(CancelParams params) {
                Task task;
                Json id = params.id();
                Option option = this.$outer.scala$meta$lsp$LanguageServer$$activeClientRequests().get((Object)id);
                if (None$.MODULE$.equals(option)) {
                    task = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
                        BoxedUnit boxedUnit;
                        if ($this.$outer.scala$meta$lsp$LanguageServer$$logger.underlying().isWarnEnabled()) {
                            $this.$outer.scala$meta$lsp$LanguageServer$$logger.underlying().warn("Can't cancel request {}, no active request found.", new Object[]{id});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        Response$.MODULE$.empty();
                    });
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    Cancelable request = (Cancelable)some.value();
                    task = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
                        BoxedUnit boxedUnit;
                        if ($this.$outer.scala$meta$lsp$LanguageServer$$logger.underlying().isInfoEnabled()) {
                            $this.$outer.scala$meta$lsp$LanguageServer$$logger.underlying().info("Cancelling request {}", new Object[]{id});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        request.cancel();
                        $this.$outer.scala$meta$lsp$LanguageServer$$activeClientRequests().remove((Object)id);
                        Response$.MODULE$.cancelled(id);
                    });
                } else {
                    throw new MatchError((Object)option);
                }
                return task;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handle$1(scala.meta.lsp.LanguageServer$$anon$1 io.circe.Json ), $anonfun$handle$2(scala.meta.lsp.LanguageServer$$anon$1 io.circe.Json monix.execution.Cancelable )}, serializedLambda);
            }
        }, CancelParams$.MODULE$.decodeCancelParams());
        this.handlersByMethodName = services.addService(this.cancelNotification()).byMethodName();
    }
}

