/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.worksheets;

import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JFunction2;
import dotty.runtime.function.JProcedure1;
import java.io.Serializable;
import mdoc.document.Binder;
import mdoc.document.Statement;
import mdoc.interfaces.RangePosition;
import mdoc.internal.cli.Context;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.InputFile$;
import mdoc.internal.cli.Settings;
import mdoc.internal.io.StoreReporter;
import mdoc.internal.markdown.EvaluatedDocument;
import mdoc.internal.markdown.Instrumented;
import mdoc.internal.markdown.Instrumenter$;
import mdoc.internal.markdown.MarkdownBuilder$;
import mdoc.internal.markdown.MarkdownCompiler;
import mdoc.internal.markdown.SectionInput;
import mdoc.internal.markdown.SectionInput$;
import mdoc.internal.worksheets.EvaluatedWorksheet;
import mdoc.internal.worksheets.EvaluatedWorksheet$;
import mdoc.internal.worksheets.EvaluatedWorksheetStatement;
import mdoc.internal.worksheets.EvaluatedWorksheetStatement$;
import mdoc.internal.worksheets.RenderSummaryResult;
import mdoc.internal.worksheets.RenderSummaryResult$;
import pprint.PPrinter;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.meta.inputs.Input;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;

public class WorksheetProvider {
    private final Settings settings;
    private final StoreReporter reporter;
    private final int minimumMargin;

    public WorksheetProvider(Settings settings) {
        this.settings = settings;
        this.reporter = new StoreReporter();
        this.minimumMargin = 20;
    }

    public EvaluatedWorksheet evaluateWorksheet(Input.VirtualFile input, Context ctx) {
        SectionInput sectionInput = SectionInput$.MODULE$.apply((Input)input, ctx);
        List sectionInputs = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SectionInput[]{sectionInput}));
        InputFile file = InputFile$.MODULE$.fromRelativeFilename(input.path(), this.settings);
        Instrumented instrumented = Instrumenter$.MODULE$.instrument(file, (List<SectionInput>)sectionInputs, this.settings, this.reporter);
        MarkdownCompiler compiler = ctx.compiler(instrumented);
        EvaluatedDocument rendered = MarkdownBuilder$.MODULE$.buildDocument(compiler, this.reporter, (List<SectionInput>)sectionInputs, instrumented, input.path());
        Iterator decorations = rendered.sections().iterator().flatMap((Function1)(JFunction1 & Serializable)section -> section.section().statements().map((Function1)(JFunction1 & Serializable)statement -> this.renderDecoration((Statement)statement)));
        return EvaluatedWorksheet$.MODULE$.apply((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((IterableOnceOps)this.reporter.diagnostics().map((Function1)(JFunction1 & Serializable)d -> d)).toSeq()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)decorations.filterNot((Function1)(JFunction1 & Serializable)_$1 -> _$1.summary().isEmpty()).map((Function1)(JFunction1 & Serializable)d -> d).toList()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)instrumented.fileImports().map((Function1)(JFunction1 & Serializable)_$2 -> _$2.toInterface())).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)instrumented.scalacOptionImports().map((Function1)(JFunction1 & Serializable)_$3 -> _$3.value())).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(compiler.classpathEntries()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)instrumented.dependencies().toSeq()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)instrumented.repositories().toSeq()).asJava());
    }

    private EvaluatedWorksheetStatement renderDecoration(Statement statement) {
        mdoc.document.RangePosition pos = statement.position();
        mdoc.document.RangePosition range = new mdoc.document.RangePosition(pos.startLine(), pos.startColumn(), pos.endLine(), pos.endColumn());
        int margin = scala.math.package$.MODULE$.max(this.minimumMargin, this.settings.screenWidth() - statement.position().endColumn());
        boolean isEmptyValue = this.isUnitType(statement) || statement.binders().isEmpty();
        RenderSummaryResult renderSummaryResult = this.renderSummary(statement, margin, isEmptyValue);
        String details = this.renderDetails(statement, isEmptyValue);
        return EvaluatedWorksheetStatement$.MODULE$.apply((RangePosition)range, renderSummaryResult.summary(), details, renderSummaryResult.isSummaryComplete());
    }

    private String renderDetails(Statement statement, boolean isEmptyValue) {
        StringBuilder out = new StringBuilder();
        if (!isEmptyValue) {
            statement.binders().iterator().foreach((Function1)(JProcedure1 & Serializable)binder -> {
                out.append(out.nonEmpty() ? "\n" : "").append(binder.name()).append(": ").append(binder.tpeString()).append(" = ");
                PPrinter.BlackWhite$.MODULE$.tokenize(binder.value(), this.settings.screenWidth(), this.settings.screenHeight(), PPrinter.BlackWhite$.MODULE$.tokenize$default$4(), PPrinter.BlackWhite$.MODULE$.tokenize$default$5()).foreach((Function1)(JFunction1 & Serializable)text -> out.appendAll(text.getChars()));
            });
        }
        StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(statement.out())).foreach((Function1)(JFunction1 & Serializable)line -> out.append(out.nonEmpty() ? "\n" : "").append("// ").append(line));
        return out.toString();
    }

    private RenderSummaryResult renderSummary(Statement statement, int margin, boolean isEmptyValue) {
        boolean bl;
        StringBuilder out = new StringBuilder();
        if (isEmptyValue) {
            if (!statement.out().isEmpty()) {
                Iterator lines = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(statement.out()));
                out.append((String)lines.next());
                bl = lines.hasNext() || out.length() > margin;
            } else {
                bl = false;
            }
        } else {
            boolean isSingle = statement.binders().lengthCompare(1) == 0;
            bl = BoxesRunTime.unboxToBoolean((Object)statement.binders().iterator().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)((JFunction2 & Serializable)(arg_0, arg_1) -> WorksheetProvider.$anonfun$adapted$1(margin, out, isSingle, arg_0, arg_1))));
        }
        boolean isOverMargin = bl;
        return RenderSummaryResult$.MODULE$.apply(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(out.result()), margin), !isOverMargin);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isUnitType(Statement statement) {
        List list = statement.binders();
        if (!(list instanceof .colon.colon)) return false;
        .colon.colon colon2 = (.colon.colon)list;
        List list2 = colon2.next$access$1();
        Binder head = (Binder)colon2.head();
        Nil$ nil$ = package$.MODULE$.Nil();
        List list3 = list2;
        if (nil$ == null) {
            if (list3 != null) {
                return false;
            }
        } else if (!nil$.equals(list3)) return false;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Object object = head.value();
        if (boxedUnit != null) {
            if (!boxedUnit.equals(object)) return false;
            return true;
        }
        if (object == null) return true;
        return false;
    }

    private static final boolean $anonfun$5$$anonfun$adapted$1(Object _$6) {
        return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)_$6)));
    }

    private static final /* synthetic */ boolean $anonfun$8(char x$1) {
        char c = x$1;
        return '\n' != c;
    }

    private static final boolean $anonfun$adapted$2(Object x$1) {
        return WorksheetProvider.$anonfun$8(BoxesRunTime.unboxToChar((Object)x$1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final /* synthetic */ boolean $anonfun$9(int margin$1, StringBuilder out$4, boolean isSingle$1, boolean x$1, Binder x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)x$1), (Object)x$2);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
        if (bl) {
            return true;
        }
        if (false != bl) throw new MatchError((Object)tuple2);
        Binder binder = (Binder)tuple2._2();
        if (!isSingle$1) {
            out$4.append(out$4.isEmpty() ? "" : ", ").append(binder.name()).append("=");
        }
        Iterator chunk = PPrinter.BlackWhite$.MODULE$.tokenize(binder.value(), margin$1 - out$4.length(), PPrinter.BlackWhite$.MODULE$.tokenize$default$3(), PPrinter.BlackWhite$.MODULE$.tokenize$default$4(), PPrinter.BlackWhite$.MODULE$.tokenize$default$5()).map((Function1)(JFunction1 & Serializable)_$4 -> _$4.getChars()).filterNot((Function1)(JFunction1 & Serializable)_$5 -> {
            Object object = Predef$.MODULE$.charArrayOps(_$5);
            return ArrayOps$.MODULE$.iterator$extension(object).forall((Function1)((JFunction1 & Serializable)WorksheetProvider::$anonfun$5$$anonfun$adapted$1));
        }).flatMap((Function1)(JFunction1 & Serializable)_$7 -> {
            Object object = Predef$.MODULE$.charArrayOps(_$7);
            return ArrayOps$.MODULE$.iterator$extension(object);
        }).filter((Function1)((JFunction1 & Serializable)WorksheetProvider::$anonfun$adapted$2));
        out$4.appendAll((IterableOnce)chunk);
        if (out$4.length() <= margin$1) return false;
        return true;
    }

    private static final boolean $anonfun$adapted$1(int margin$2, StringBuilder out$5, boolean isSingle$2, Object x$1, Object x$2) {
        return WorksheetProvider.$anonfun$9(margin$2, out$5, isSingle$2, BoxesRunTime.unboxToBoolean((Object)x$1), (Binder)x$2);
    }
}

