/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.io;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicBoolean;
import mdoc.Reporter;
import mdoc.internal.io.ConsoleColors;
import mdoc.internal.io.ConsoleReporter$;
import mdoc.internal.pos.PositionSyntax$;
import mdoc.internal.pos.PositionSyntax$XtensionPositionsScalafix$;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.meta.inputs.Position;
import scala.meta.package$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConsoleReporter
implements Reporter {
    private final PrintStream ps;
    private final String myDebug;
    private final String myInfo;
    private final String myWarning;
    private final String myError;
    private int myWarnings;
    private int myErrors;
    private final AtomicBoolean isDebugEnabled;

    public static Reporter default() {
        return ConsoleReporter$.MODULE$.default();
    }

    public static ConsoleColors $lessinit$greater$default$2() {
        return ConsoleReporter$.MODULE$.$lessinit$greater$default$2();
    }

    public ConsoleReporter(PrintStream ps, ConsoleColors colors) {
        this.ps = ps;
        this.myDebug = (String)colors.green().apply((Object)"debug");
        this.myInfo = (String)colors.blue().apply((Object)"info");
        this.myWarning = (String)colors.yellow().apply((Object)"warning");
        this.myError = (String)colors.red().apply((Object)"error");
        this.myWarnings = 0;
        this.myErrors = 0;
        this.isDebugEnabled = new AtomicBoolean(false);
    }

    public String formatMessage(Position pos, String severity, String message) {
        return PositionSyntax$XtensionPositionsScalafix$.MODULE$.formatMessage$extension(PositionSyntax$.MODULE$.XtensionPositionsScalafix(pos), "", message);
    }

    @Override
    public int warningCount() {
        return this.myWarnings;
    }

    @Override
    public int errorCount() {
        return this.myErrors;
    }

    @Override
    public boolean hasWarnings() {
        return this.myWarnings > 0;
    }

    @Override
    public boolean hasErrors() {
        return this.myErrors > 0;
    }

    @Override
    public void reset() {
        this.myWarnings = 0;
        this.myErrors = 0;
    }

    @Override
    public void error(Throwable throwable) {
        this.error((Position)package$.MODULE$.Position().None(), throwable);
    }

    @Override
    public void error(Position pos, Throwable throwable) {
        this.error(pos, PositionSyntax$.MODULE$.XtensionThrowable(throwable).message());
        throwable.printStackTrace(this.ps);
    }

    @Override
    public void error(Position pos, String msg) {
        this.error(this.formatMessage(PositionSyntax$.MODULE$.XtensionPositionMdoc(pos).toUnslicedPosition(), "error", msg));
    }

    @Override
    public void error(String msg) {
        ++this.myErrors;
        this.ps.println(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.myError), ": " + msg));
    }

    @Override
    public void warning(Position pos, String msg) {
        this.warning(this.formatMessage(PositionSyntax$.MODULE$.XtensionPositionMdoc(pos).toUnslicedPosition(), "warning", msg));
    }

    @Override
    public void warning(String msg) {
        ++this.myWarnings;
        this.ps.println(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.myWarning), ": " + msg));
    }

    @Override
    public void info(Position pos, String msg) {
        this.info(this.formatMessage(PositionSyntax$.MODULE$.XtensionPositionMdoc(pos).toUnslicedPosition(), "info", msg));
    }

    @Override
    public void info(String msg) {
        this.ps.println(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.myInfo), ": " + msg));
    }

    @Override
    public void debug(Function0 msg) {
        if (this.isDebugEnabled.get()) {
            this.ps.println(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.myDebug), ": " + msg.apply()));
        }
    }

    @Override
    public void setDebugEnabled(boolean isDebugEnabled) {
        this.isDebugEnabled.set(isDebugEnabled);
    }

    @Override
    public void print(String msg) {
        this.ps.print(msg);
    }

    @Override
    public void println(String msg) {
        this.ps.println(msg);
    }
}

