/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.Settings;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Builder;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.runtime.BoxedUnit;

public final class IO$ {
    public static final IO$ MODULE$;
    private final SimpleFileVisitor<Path> deleteVisitor;

    static {
        new IO$();
    }

    public void foreachOutput(Settings settings, Function2<AbsolutePath, RelativePath, BoxedUnit> fn) {
        AbsolutePath root = settings.out();
        Files.walkFileTree(root.toNIO(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(settings, fn, root){
            private final Settings settings$1;
            private final Function2 fn$1;
            private final AbsolutePath root$1;

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                AbsolutePath path = AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory());
                RelativePath relpath = path.toRelative(this.root$1);
                Object object = this.settings$1.isExplicitlyExcluded(relpath) ? BoxedUnit.UNIT : this.fn$1.apply((Object)path, (Object)relpath);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                RelativePath relpath = AbsolutePath$.MODULE$.apply(dir, AbsolutePath$.MODULE$.workingDirectory()).toRelative(this.root$1);
                return this.settings$1.isExplicitlyExcluded(relpath) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }
            {
                this.settings$1 = settings$1;
                this.fn$1 = fn$1;
                this.root$1 = root$1;
            }
        });
    }

    public List<InputFile> inputFiles(Settings settings) {
        Builder buf = List$.MODULE$.newBuilder();
        this.foreachInputFile(settings, (Function1<InputFile, BoxedUnit>)new Serializable(buf){
            public static final long serialVersionUID = 0L;
            private final Builder buf$1;

            public final void apply(InputFile x$1) {
                this.buf$1.$plus$eq((Object)x$1);
            }
            {
                this.buf$1 = buf$1;
            }
        });
        return (List)buf.result();
    }

    public void foreachInputFile(Settings settings, Function1<InputFile, BoxedUnit> fn) {
        AbsolutePath cwd = settings.cwd();
        Path root = settings.in().toNIO();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(settings, fn, cwd, root){
            private final Settings settings$2;
            private final Function1 fn$2;
            private final AbsolutePath cwd$1;
            private final Path root$2;

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Option<InputFile> option;
                block4: {
                    block3: {
                        block2: {
                            option = this.settings$2.toInputFile(AbsolutePath$.MODULE$.apply(file, this.cwd$1));
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            InputFile inputFile = (InputFile)some.x();
                            BoxedUnit boxedUnit = (BoxedUnit)this.fn$2.apply((Object)inputFile);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return FileVisitResult.CONTINUE;
                }
                throw new MatchError(option);
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                RelativePath relpath = RelativePath$.MODULE$.apply(this.root$2.relativize(dir));
                return this.settings$2.isExplicitlyExcluded(relpath) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }
            {
                this.settings$2 = settings$2;
                this.fn$2 = fn$2;
                this.cwd$1 = cwd$1;
                this.root$2 = root$2;
            }
        };
        Files.walkFileTree(root, (FileVisitor<? super Path>)visitor);
    }

    public SimpleFileVisitor<Path> deleteVisitor() {
        return this.deleteVisitor;
    }

    public void cleanTarget(AbsolutePath dir) {
        Files.walkFileTree(dir.toNIO(), this.deleteVisitor());
    }

    private IO$() {
        MODULE$ = this;
        this.deleteVisitor = new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        };
    }
}

