/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.cli;

import com.vladsch.flexmark.util.options.MutableDataSet;
import io.methvin.watcher.DirectoryChangeEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mdoc.Reporter;
import mdoc.internal.cli.Exit;
import mdoc.internal.cli.Exit$;
import mdoc.internal.cli.FileException;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.MainOps$;
import mdoc.internal.cli.Messages$;
import mdoc.internal.cli.Settings;
import mdoc.internal.cli.Timer;
import mdoc.internal.io.IO$;
import mdoc.internal.io.MdocFileListener;
import mdoc.internal.io.MdocFileListener$;
import mdoc.internal.livereload.LiveReload;
import mdoc.internal.livereload.UndertowLiveReload;
import mdoc.internal.livereload.UndertowLiveReload$;
import mdoc.internal.markdown.DocumentLinks;
import mdoc.internal.markdown.DocumentLinks$;
import mdoc.internal.markdown.LinkHygiene$;
import mdoc.internal.markdown.Markdown$;
import mdoc.internal.pos.DiffUtils$;
import metaconfig.Configured;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.meta.inputs.Input;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0005%\u0011q!T1j]>\u00038O\u0003\u0002\u0004\t\u0005\u00191\r\\5\u000b\u0005\u00151\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0003\u001d\tA!\u001c3pG\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\"A\u0011\u0003\u0001B\u0001B\u0003%!#\u0001\u0005tKR$\u0018N\\4t!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\u0005TKR$\u0018N\\4t\u0011!9\u0002A!A!\u0002\u0013A\u0012\u0001C7be.$wn\u001e8\u0011\u0005e!S\"\u0001\u000e\u000b\u0005ma\u0012aB8qi&|gn\u001d\u0006\u0003;y\tA!\u001e;jY*\u0011q\u0004I\u0001\tM2,\u00070\\1sW*\u0011\u0011EI\u0001\bm2\fGm]2i\u0015\u0005\u0019\u0013aA2p[&\u0011QE\u0007\u0002\u000f\u001bV$\u0018M\u00197f\t\u0006$\u0018mU3u\u0011!9\u0003A!A!\u0002\u0013A\u0013\u0001\u0003:fa>\u0014H/\u001a:\u0011\u0005%RS\"\u0001\u0004\n\u0005-2!\u0001\u0003*fa>\u0014H/\u001a:\t\u000b5\u0002A\u0011\u0001\u0018\u0002\rqJg.\u001b;?)\u0011y\u0003'\r\u001a\u0011\u0005M\u0001\u0001\"B\t-\u0001\u0004\u0011\u0002\"B\f-\u0001\u0004A\u0002\"B\u0014-\u0001\u0004A\u0003b\u0002\u001b\u0001\u0001\u0004%I!N\u0001\u000bY&4XM]3m_\u0006$W#\u0001\u001c\u0011\u0007-9\u0014(\u0003\u00029\u0019\t1q\n\u001d;j_:\u0004\"A\u000f\u001f\u000e\u0003mR!\u0001\u000e\u0003\n\u0005uZ$A\u0003'jm\u0016\u0014V\r\\8bI\"9q\b\u0001a\u0001\n\u0013\u0001\u0015A\u00047jm\u0016\u0014X\r\\8bI~#S-\u001d\u000b\u0003\u0003\u0012\u0003\"a\u0003\"\n\u0005\rc!\u0001B+oSRDq!\u0012 \u0002\u0002\u0003\u0007a'A\u0002yIEBaa\u0012\u0001!B\u00131\u0014a\u00037jm\u0016\u0014X\r\\8bI\u0002BQ!\u0013\u0001\u0005\n)\u000bqb\u001d;beRd\u0015N^3sK2|\u0017\r\u001a\u000b\u0002\u0003\")A\n\u0001C\u0001\u0015\u0006!A.\u001b8u\u0011\u0015q\u0005\u0001\"\u0001P\u00039A\u0017M\u001c3mK6\u000b'o\u001b3po:$\"\u0001U*\u0011\u0005M\t\u0016B\u0001*\u0003\u0005\u0011)\u00050\u001b;\t\u000bQk\u0005\u0019A+\u0002\t\u0019LG.\u001a\t\u0003'YK!a\u0016\u0002\u0003\u0013%s\u0007/\u001e;GS2,\u0007\"B-\u0001\t\u0003Q\u0016!\u00055b]\u0012dWMU3hk2\f'OR5mKR\u0011\u0001k\u0017\u0005\u0006)b\u0003\r!\u0016\u0005\u0006;\u0002!\tAX\u0001\u000bQ\u0006tG\r\\3GS2,GC\u0001)`\u0011\u0015!F\f1\u0001V\u0011\u0015\t\u0007\u0001\"\u0001c\u0003%9(/\u001b;f!\u0006$\b\u000eF\u0002BG\u0012DQ\u0001\u00161A\u0002UCQ!\u001a1A\u0002\u0019\faa\u001d;sS:<\u0007CA4k\u001d\tY\u0001.\u0003\u0002j\u0019\u00051\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tIG\u0002C\u0003o\u0001\u0011\u0005q.\u0001\u000bhK:,'/\u0019;f\u0007>l\u0007\u000f\\3uKNKG/\u001a\u000b\u0002!\")\u0011\u000f\u0001C\u0001_\u0006\u0019!/\u001e8\t\u000bM\u0004A\u0011\u0001;\u0002!!\fg\u000e\u001a7f/\u0006$8\r[#wK:$HCA!v\u0011\u00151(\u000f1\u0001x\u0003\u0015)g/\u001a8u!\tAx0D\u0001z\u0015\tQ80A\u0004xCR\u001c\u0007.\u001a:\u000b\u0005ql\u0018aB7fi\"4\u0018N\u001c\u0006\u0002}\u0006\u0011\u0011n\\\u0005\u0004\u0003\u0003I(\u0001\u0006#je\u0016\u001cGo\u001c:z\u0007\"\fgnZ3Fm\u0016tG\u000f\u0003\u0004\u0002\u0006\u0001!\tAS\u0001\u000feVtg)\u001b7f/\u0006$8\r[3s\u0011\u0019\tI\u0001\u0001C\u0001\u0015\u0006Y1\r\\3beN\u001b'/Z3o\u0011\u0019\ti\u0001\u0001C\u0001\u0015\u0006)r/Y5uS:<gi\u001c:GS2,7\t[1oO\u0016\u001c\bbBA\t\u0001\u0011\u0005\u00111C\u0001\u000eG>l\u0007/\u001b7fI\u001aKG.Z:\u0015\u000b\u0005\u000b)\"a\b\t\u0011\u0005]\u0011q\u0002a\u0001\u00033\t\u0011A\u001c\t\u0004\u0017\u0005m\u0011bAA\u000f\u0019\t\u0019\u0011J\u001c;\t\u0011\u0005\u0005\u0012q\u0002a\u0001\u0003G\tQ\u0001^5nKJ\u00042aEA\u0013\u0013\r\t9C\u0001\u0002\u0006)&lWM\u001d\u0005\b\u0003W\u0001A\u0011AA\u0017\u00039\u0019w.\u001c9jY&twMR5mKN$2!QA\u0018\u0011!\t9\"!\u000bA\u0002\u0005eqaBA\u001a\u0005!\u0005\u0011QG\u0001\b\u001b\u0006Lgn\u00149t!\r\u0019\u0012q\u0007\u0004\u0007\u0003\tA\t!!\u000f\u0014\u0007\u0005]\"\u0002C\u0004.\u0003o!\t!!\u0010\u0015\u0005\u0005U\u0002\u0002CA!\u0003o!\t!a\u0011\u0002\u000fA\u0014xnY3tgR1\u0011\u0011DA#\u0003'Bq!EA \u0001\u0004\t9\u0005E\u0003\u0002J\u0005=##\u0004\u0002\u0002L)\u0011\u0011QJ\u0001\u000b[\u0016$\u0018mY8oM&<\u0017\u0002BA)\u0003\u0017\u0012!bQ8oM&<WO]3e\u0011\u00199\u0013q\ba\u0001Q\u0001")
public final class MainOps {
    private final Settings settings;
    private final MutableDataSet markdown;
    private final Reporter reporter;
    private Option<LiveReload> livereload;

    public static int process(Configured<Settings> configured, Reporter reporter) {
        return MainOps$.MODULE$.process(configured, reporter);
    }

    private Option<LiveReload> livereload() {
        return this.livereload;
    }

    private void livereload_$eq(Option<LiveReload> x$1) {
        this.livereload = x$1;
    }

    private void startLivereload() {
        if (!this.settings.noLivereload()) {
            UndertowLiveReload livereload = UndertowLiveReload$.MODULE$.apply(this.settings.out().toNIO(), this.settings.host(), this.settings.port(), this.reporter, UndertowLiveReload$.MODULE$.apply$default$5());
            livereload.start();
            this.livereload_$eq((Option<LiveReload>)new Some((Object)livereload));
        }
    }

    public void lint() {
        if (this.settings.out().isDirectory() && !this.settings.noLinkHygiene()) {
            List<DocumentLinks> docs = DocumentLinks$.MODULE$.fromGeneratedSite(this.settings, this.reporter);
            LinkHygiene$.MODULE$.lint(docs, this.reporter, this.settings.verbose());
        }
    }

    public synchronized Exit handleMarkdown(InputFile file) {
        boolean fileHasErrors;
        int originalErrors = this.reporter.errorCount();
        if (this.settings.verbose()) {
            this.reporter.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.in()})));
        }
        Timer timer = new Timer();
        String source = FileIO$.MODULE$.slurp(file.in(), this.settings.charset());
        Input.VirtualFile input = package$.MODULE$.Input().VirtualFile().apply(file.in().toString(), source);
        this.markdown.set(Markdown$.MODULE$.InputKey(), (Object)new Some((Object)input));
        this.markdown.set(Markdown$.MODULE$.RelativePathKey(), (Object)new Some((Object)file.relpath()));
        String md = Markdown$.MODULE$.toMarkdown((Input)input, this.markdown, this.reporter, this.settings);
        boolean bl = fileHasErrors = this.reporter.errorCount() > originalErrors;
        if (!fileHasErrors) {
            this.writePath(file, md);
            if (this.settings.verbose()) {
                AbsolutePath arg$macro$1 = file.out();
                Timer arg$macro$2 = timer;
                this.reporter.info(new StringOps("  done => %s (%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2})));
            }
            this.livereload().foreach((Function1)new Serializable(this, file){
                public static final long serialVersionUID = 0L;
                private final InputFile file$1;

                public final void apply(LiveReload x$1) {
                    x$1.reload(this.file$1.out().toNIO());
                }
                {
                    this.file$1 = file$1;
                }
            });
        }
        return this.reporter.hasErrors() ? Exit$.MODULE$.error() : Exit$.MODULE$.success();
    }

    public Exit handleRegularFile(InputFile file) {
        Files.createDirectories(file.out().toNIO().getParent(), new FileAttribute[0]);
        Files.copy(file.in().toNIO(), file.out().toNIO(), StandardCopyOption.REPLACE_EXISTING);
        if (this.settings.verbose()) {
            this.reporter.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copied    ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.out().toNIO()})));
        }
        return Exit$.MODULE$.success();
    }

    public Exit handleFile(InputFile file) {
        Exit exit;
        try {
            if (this.settings.isIncluded(file.relpath())) {
                String string = PathIO$.MODULE$.extension(file.in().toNIO());
                Exit exit2 = "md".equals(string) ? this.handleMarkdown(file) : this.handleRegularFile(file);
                exit = exit2;
            } else {
                exit = Exit$.MODULE$.success();
            }
        }
        catch (Throwable throwable) {
            Exit exit3;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            new FileException(file.in(), e).printStackTrace();
            exit = exit3 = Exit$.MODULE$.error();
        }
        return exit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writePath(InputFile file, String string) {
        if (this.settings.check()) {
            String expected;
            if (!file.out().isFile()) return;
            String string2 = expected = FileIO$.MODULE$.slurp(file.out(), this.settings.charset());
            String string3 = string;
            if (!(string2 == null ? string3 != null : !string2.equals(string3))) return;
            String filename = file.out().toString();
            String diff = DiffUtils$.MODULE$.unifiedDiff(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (on disk)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (expected output)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})), (List<String>)new StringOps(Predef$.MODULE$.augmentString(expected)).linesIterator().toList(), (List<String>)new StringOps(Predef$.MODULE$.augmentString(string)).linesIterator().toList(), 3);
            this.reporter.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--test failed! To fix this problem, re-generate the documentation\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{diff})));
            return;
        } else {
            Files.createDirectories(file.out().toNIO().getParent(), new FileAttribute[0]);
            Files.write(file.out().toNIO(), string.getBytes(this.settings.charset()), new OpenOption[0]);
        }
    }

    public Exit generateCompleteSite() {
        List<InputFile> files = IO$.MODULE$.inputFiles(this.settings);
        Timer timer = new Timer();
        int n = files.length();
        this.compilingFiles(n);
        Exit exit = (Exit)files.foldLeft((Object)Exit$.MODULE$.success(), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MainOps $outer;

            public final Exit apply(Exit x0$1, InputFile x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                if (tuple2 != null) {
                    Exit accum = (Exit)tuple2._1();
                    InputFile file = (InputFile)tuple2._2();
                    Exit fileExit = this.$outer.handleFile(file);
                    Exit exit = accum.merge(fileExit);
                    return exit;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.lint();
        if (files.isEmpty()) {
            this.reporter.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no input files: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.settings.in()})));
        } else {
            this.compiledFiles(n, timer);
        }
        return exit;
    }

    public Exit run() {
        Exit exit;
        if (this.settings.cleanTarget() && Files.exists(this.settings.out().toNIO(), new LinkOption[0])) {
            IO$.MODULE$.cleanTarget(this.settings.out());
        }
        if (this.settings.watch()) {
            this.startLivereload();
        }
        Exit isOk = this.generateCompleteSite();
        if (this.settings.isFileWatching()) {
            this.waitingForFileChanges();
            this.runFileWatcher();
            exit = Exit$.MODULE$.success();
        } else {
            exit = isOk;
        }
        return exit;
    }

    public void handleWatchEvent(DirectoryChangeEvent event) {
        Option<InputFile> option;
        block6: {
            block5: {
                block4: {
                    AbsolutePath path;
                    String string = PathIO$.MODULE$.extension(event.path());
                    String string2 = "md";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.clearScreen();
                    }
                    if (!((option = this.settings.toInputFile(path = AbsolutePath$.MODULE$.apply(event.path(), AbsolutePath$.MODULE$.workingDirectory()))) instanceof Some)) break block4;
                    Some some = (Some)option;
                    InputFile inputFile = (InputFile)some.x();
                    this.reporter.reset();
                    Timer timer = new Timer();
                    this.compilingFiles(1);
                    this.handleFile(inputFile);
                    this.lint();
                    this.compiledFiles(1, timer);
                    this.waitingForFileChanges();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void runFileWatcher() {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        MdocFileListener watcher = MdocFileListener$.MODULE$.create(this.settings.in(), executor, System.in, (Function1<DirectoryChangeEvent, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MainOps $outer;

            public final void apply(DirectoryChangeEvent event) {
                this.$outer.handleWatchEvent(event);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        watcher.watchUntilInterrupted();
        this.livereload().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LiveReload x$2) {
                x$2.stop();
            }
        });
    }

    public void clearScreen() {
        Predef$.MODULE$.print((Object)"\u001b[H\u001b[2J");
    }

    public void waitingForFileChanges() {
        this.reporter.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for file changes (press enter to interrupt)"})).s((Seq)Nil$.MODULE$));
    }

    public void compiledFiles(int n, Timer timer) {
        String errors = Messages$.MODULE$.count("error", this.reporter.errorCount());
        String warnings = this.reporter.hasWarnings() ? new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", "})).s((Seq)Nil$.MODULE$)).append((Object)Messages$.MODULE$.count("warning", this.reporter.warningCount())).toString() : "";
        this.reporter.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiled in ", " (", "", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timer, errors, warnings})));
    }

    public void compilingFiles(int n) {
        String files = Messages$.MODULE$.count("file", n);
        this.reporter.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{files, this.settings.out()})));
    }

    public MainOps(Settings settings, MutableDataSet markdown, Reporter reporter) {
        this.settings = settings;
        this.markdown = markdown;
        this.reporter = reporter;
        this.livereload = None$.MODULE$;
    }
}

