/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.livereload;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.Headers;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import mdoc.Reporter;
import mdoc.internal.io.ConsoleReporter$;
import mdoc.internal.livereload.Resources$;
import mdoc.internal.livereload.SimpleHtml$;
import mdoc.internal.livereload.UndertowLiveReload;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxesRunTime;

public final class UndertowLiveReload$
implements Serializable {
    public static final UndertowLiveReload$ MODULE$;

    static {
        new UndertowLiveReload$();
    }

    public UndertowLiveReload apply(Path root, String host, int preferredPort, Reporter reporter, Function0<String> lastPreview) {
        int port = this.freePort(host, preferredPort, this.freePort$default$3());
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host, BoxesRunTime.boxToInteger((int)port)}));
        Set openChannels = Set$.MODULE$.empty();
        ResourceHandler fromFileSystem = Handlers.resource((ResourceManager)new PathResourceManager(root)).setDirectoryListingEnabled(true);
        PathHandler baseHandler = Handlers.path().addExactPath("/livereload.js", this.staticResource("/livereload.js")).addExactPath("/highlight.js", this.staticResource("/highlight.js")).addExactPath("/github.css", this.staticResource("/github.css")).addExactPath("/custom.css", this.staticResource("/custom.css")).addExactPath("/preview.css", this.staticResource("/preview.css")).addExactPath("/preview", new HttpHandler(lastPreview){
            private final Function0 lastPreview$1;

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html");
                exchange.getResponseSender().send((String)this.lastPreview$1.apply());
            }
            {
                this.lastPreview$1 = lastPreview$1;
            }
        }).addPrefixPath("/livereload", (HttpHandler)Handlers.websocket((WebSocketConnectionCallback)new UndertowLiveReload.LiveReloadConnectionCallback((Set<WebSocketChannel>)openChannels))).addPrefixPath("/", (HttpHandler)fromFileSystem);
        HttpHandler markdownHandler = new HttpHandler(root, url, baseHandler){
            private final Path root$1;
            private final String url$1;
            private final PathHandler baseHandler$1;

            public void handleRequest(HttpServerExchange exchange) {
                if (exchange.getRequestPath().endsWith(".md")) {
                    Path in = this.root$1.resolve(new StringOps(Predef$.MODULE$.augmentString(exchange.getRequestPath())).stripPrefix("/"));
                    String markdown = new String(Files.readAllBytes(in), StandardCharsets.UTF_8);
                    String html = SimpleHtml$.MODULE$.fromMarkdown(markdown, ((Object)in.getFileName()).toString(), this.url$1);
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html");
                    exchange.getResponseSender().send(html);
                } else {
                    this.baseHandler$1.handleRequest(exchange);
                }
            }
            {
                this.root$1 = root$1;
                this.url$1 = url$1;
                this.baseHandler$1 = baseHandler$1;
            }
        };
        Undertow server = Undertow.builder().addHttpListener(port, host).setHandler(markdownHandler).build();
        return new UndertowLiveReload(server, reporter, port, url, (Set<WebSocketChannel>)openChannels);
    }

    public String apply$default$2() {
        return "localhost";
    }

    public int apply$default$3() {
        return 4000;
    }

    public Reporter apply$default$4() {
        return ConsoleReporter$.MODULE$.default();
    }

    public Function0<String> apply$default$5() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        };
    }

    private HttpHandler staticResource(String path) {
        String text = Resources$.MODULE$.readPath(path);
        return new HttpHandler(path, text){
            private final String path$1;
            private final String text$1;

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, UndertowLiveReload$.MODULE$.mdoc$internal$livereload$UndertowLiveReload$$contentType(this.path$1));
                exchange.getResponseSender().send(this.text$1);
            }
            {
                this.path$1 = path$1;
                this.text$1 = text$1;
            }
        };
    }

    public String mdoc$internal$livereload$UndertowLiveReload$$contentType(String path) {
        return path.endsWith(".js") ? "application/javascript" : (path.endsWith(".css") ? "text/css" : (path.endsWith(".html") ? "text/html" : ""));
    }

    /*
     * WARNING - void declaration
     */
    private final int freePort(String host, int port, int maxRetries) {
        Throwable throwable3;
        block5: {
            int n;
            try {
                ServerSocket socket = new ServerSocket();
                try {
                    int free;
                    socket.bind(new InetSocketAddress(host, port));
                    n = free = socket.getLocalPort();
                }
                catch (Throwable throwable2) {
                    void var7_4;
                    var7_4.close();
                    throw throwable2;
                }
                socket.close();
            }
            catch (Throwable throwable3) {
                int n2;
                Throwable throwable4 = throwable3;
                if (!(throwable4 instanceof IOException) || maxRetries <= 0) break block5;
                n = n2 = this.freePort(host, port + 1, maxRetries - 1);
            }
            return n;
        }
        throw throwable3;
    }

    private final int freePort$default$3() {
        return 20;
    }

    public UndertowLiveReload apply(Undertow server, Reporter reporter, int port, String url, Set<WebSocketChannel> openChannels) {
        return new UndertowLiveReload(server, reporter, port, url, openChannels);
    }

    public Option<Tuple5<Undertow, Reporter, Object, String, Set<WebSocketChannel>>> unapply(UndertowLiveReload x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.server(), (Object)x$0.reporter(), (Object)BoxesRunTime.boxToInteger((int)x$0.port()), (Object)x$0.url(), x$0.openChannels()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private UndertowLiveReload$() {
        MODULE$ = this;
    }
}

