/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.cli;

import io.methvin.watcher.DirectoryChangeEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mdoc.Reporter;
import mdoc.internal.cli.Context;
import mdoc.internal.cli.Exit;
import mdoc.internal.cli.Exit$;
import mdoc.internal.cli.FileException;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.MainOps$;
import mdoc.internal.cli.Messages$;
import mdoc.internal.cli.Settings;
import mdoc.internal.cli.Timer;
import mdoc.internal.io.IO$;
import mdoc.internal.io.MdocFileListener;
import mdoc.internal.io.MdocFileListener$;
import mdoc.internal.livereload.LiveReload;
import mdoc.internal.livereload.UndertowLiveReload;
import mdoc.internal.livereload.UndertowLiveReload$;
import mdoc.internal.markdown.DocumentLinks;
import mdoc.internal.markdown.DocumentLinks$;
import mdoc.internal.markdown.LinkHygiene$;
import mdoc.internal.markdown.Markdown$;
import mdoc.internal.pos.DiffUtils$;
import metaconfig.Configured;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.meta.inputs.Input;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u0005%\u0011q!T1j]>\u00038O\u0003\u0002\u0004\t\u0005\u00191\r\\5\u000b\u0005\u00151\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0003\u001d\tA!\u001c3pG\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\"A\u0011\u0003\u0001B\u0001B\u0003%!#A\u0004d_:$X\r\u001f;\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!aB\"p]R,\u0007\u0010\u001e\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005eQ\u0002CA\n\u0001\u0011\u0015\tb\u00031\u0001\u0013\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003!\u0019X\r\u001e;j]\u001e\u001cX#\u0001\u0010\u0011\u0005My\u0012B\u0001\u0011\u0003\u0005!\u0019V\r\u001e;j]\u001e\u001c\b\"\u0002\u0012\u0001\t\u0003\u0019\u0013\u0001\u0003:fa>\u0014H/\u001a:\u0016\u0003\u0011\u0002\"!\n\u0014\u000e\u0003\u0019I!a\n\u0004\u0003\u0011I+\u0007o\u001c:uKJDq!\u000b\u0001A\u0002\u0013%!&\u0001\u0006mSZ,'/\u001a7pC\u0012,\u0012a\u000b\t\u0004\u00171r\u0013BA\u0017\r\u0005\u0019y\u0005\u000f^5p]B\u0011q&M\u0007\u0002a)\u0011\u0011\u0006B\u0005\u0003eA\u0012!\u0002T5wKJ+Gn\\1e\u0011\u001d!\u0004\u00011A\u0005\nU\na\u0002\\5wKJ,Gn\\1e?\u0012*\u0017\u000f\u0006\u00027sA\u00111bN\u0005\u0003q1\u0011A!\u00168ji\"9!hMA\u0001\u0002\u0004Y\u0013a\u0001=%c!1A\b\u0001Q!\n-\n1\u0002\\5wKJ,Gn\\1eA!)a\b\u0001C\u0005\u007f\u0005y1\u000f^1si2Kg/\u001a:fY>\fG\rF\u00017\u0011\u0015\t\u0005\u0001\"\u0001@\u0003\u0011a\u0017N\u001c;\t\u000b\r\u0003A\u0011\u0001#\u0002\u001d!\fg\u000e\u001a7f\u001b\u0006\u00148\u000eZ8x]R\u0011Q\t\u0013\t\u0003'\u0019K!a\u0012\u0002\u0003\t\u0015C\u0018\u000e\u001e\u0005\u0006\u0013\n\u0003\rAS\u0001\u0005M&dW\r\u0005\u0002\u0014\u0017&\u0011AJ\u0001\u0002\n\u0013:\u0004X\u000f\u001e$jY\u0016DQA\u0014\u0001\u0005\u0002=\u000b\u0011\u0003[1oI2,'+Z4vY\u0006\u0014h)\u001b7f)\t)\u0005\u000bC\u0003J\u001b\u0002\u0007!\nC\u0003S\u0001\u0011\u00051+\u0001\u0006iC:$G.\u001a$jY\u0016$\"!\u0012+\t\u000b%\u000b\u0006\u0019\u0001&\t\u000bY\u0003A\u0011A,\u0002\u0013]\u0014\u0018\u000e^3QCRDGc\u0001\u001cY3\")\u0011*\u0016a\u0001\u0015\")!,\u0016a\u00017\u000611\u000f\u001e:j]\u001e\u0004\"\u0001X0\u000f\u0005-i\u0016B\u00010\r\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001-\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005yc\u0001\"B2\u0001\t\u0003!\u0017\u0001F4f]\u0016\u0014\u0018\r^3D_6\u0004H.\u001a;f'&$X\rF\u0001F\u0011\u00151\u0007\u0001\"\u0001e\u0003\r\u0011XO\u001c\u0005\u0006Q\u0002!\t![\u0001\u0011Q\u0006tG\r\\3XCR\u001c\u0007.\u0012<f]R$\"A\u000e6\t\u000b-<\u0007\u0019\u00017\u0002\u000b\u00154XM\u001c;\u0011\u00055$X\"\u00018\u000b\u0005=\u0004\u0018aB<bi\u000eDWM\u001d\u0006\u0003cJ\fq!\\3uQZLgNC\u0001t\u0003\tIw.\u0003\u0002v]\n!B)\u001b:fGR|'/_\"iC:<W-\u0012<f]RDQa\u001e\u0001\u0005\u0002}\naB];o\r&dWmV1uG\",'\u000fC\u0003z\u0001\u0011\u0005q(A\u0006dY\u0016\f'oU2sK\u0016t\u0007\"B>\u0001\t\u0003y\u0014!F<bSRLgn\u001a$pe\u001aKG.Z\"iC:<Wm\u001d\u0005\u0006{\u0002!\tA`\u0001\u000eG>l\u0007/\u001b7fI\u001aKG.Z:\u0015\tYz\u0018\u0011\u0002\u0005\b\u0003\u0003a\b\u0019AA\u0002\u0003\u0005q\u0007cA\u0006\u0002\u0006%\u0019\u0011q\u0001\u0007\u0003\u0007%sG\u000fC\u0004\u0002\fq\u0004\r!!\u0004\u0002\u000bQLW.\u001a:\u0011\u0007M\ty!C\u0002\u0002\u0012\t\u0011Q\u0001V5nKJDq!!\u0006\u0001\t\u0003\t9\"\u0001\bd_6\u0004\u0018\u000e\\5oO\u001aKG.Z:\u0015\u0007Y\nI\u0002\u0003\u0005\u0002\u0002\u0005M\u0001\u0019AA\u0002\u000f\u001d\tiB\u0001E\u0001\u0003?\tq!T1j]>\u00038\u000fE\u0002\u0014\u0003C1a!\u0001\u0002\t\u0002\u0005\r2cAA\u0011\u0015!9q#!\t\u0005\u0002\u0005\u001dBCAA\u0010\u0011!\tY#!\t\u0005\u0002\u00055\u0012a\u00029s_\u000e,7o\u001d\u000b\u0007\u0003\u0007\ty#!\u0010\t\u000fq\tI\u00031\u0001\u00022A)\u00111GA\u001d=5\u0011\u0011Q\u0007\u0006\u0003\u0003o\t!\"\\3uC\u000e|gNZ5h\u0013\u0011\tY$!\u000e\u0003\u0015\r{gNZ5hkJ,G\r\u0003\u0004#\u0003S\u0001\r\u0001\n")
public final class MainOps {
    private final Context context;
    private Option<LiveReload> livereload;

    public static int process(Configured<Settings> configured, Reporter reporter) {
        return MainOps$.MODULE$.process(configured, reporter);
    }

    public Settings settings() {
        return this.context.settings();
    }

    public Reporter reporter() {
        return this.context.reporter();
    }

    private Option<LiveReload> livereload() {
        return this.livereload;
    }

    private void livereload_$eq(Option<LiveReload> x$1) {
        this.livereload = x$1;
    }

    private void startLivereload() {
        if (!this.settings().noLivereload()) {
            UndertowLiveReload livereload = UndertowLiveReload$.MODULE$.apply(this.settings().out().toNIO(), this.settings().host(), this.settings().port(), this.reporter(), UndertowLiveReload$.MODULE$.apply$default$5());
            livereload.start();
            this.livereload_$eq((Option<LiveReload>)new Some((Object)livereload));
        }
    }

    public void lint() {
        if (this.settings().out().isDirectory() && !this.settings().noLinkHygiene()) {
            List<DocumentLinks> docs = DocumentLinks$.MODULE$.fromGeneratedSite(this.settings(), this.reporter());
            LinkHygiene$.MODULE$.lint(docs, this.reporter(), this.settings().verbose());
        }
    }

    public synchronized Exit handleMarkdown(InputFile file) {
        boolean fileHasErrors;
        int originalErrors = this.reporter().errorCount();
        if (this.settings().verbose()) {
            this.reporter().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.in()})));
        }
        Timer timer = new Timer();
        String source = FileIO$.MODULE$.slurp(file.in(), this.settings().charset());
        Input.VirtualFile input = package$.MODULE$.Input().VirtualFile().apply(file.in().toString(), source);
        String md = Markdown$.MODULE$.toMarkdown((Input)input, this.context, file.relpath(), this.settings().site(), this.reporter(), this.settings());
        boolean bl = fileHasErrors = this.reporter().errorCount() > originalErrors;
        if (!fileHasErrors) {
            this.writePath(file, md);
            if (this.settings().verbose()) {
                AbsolutePath arg$macro$1 = file.out();
                Timer arg$macro$2 = timer;
                this.reporter().info(new StringOps("  done => %s (%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2})));
            }
            this.livereload().foreach((Function1)new Serializable(this, file){
                public static final long serialVersionUID = 0L;
                private final InputFile file$1;

                public final void apply(LiveReload x$1) {
                    x$1.reload(this.file$1.out().toNIO());
                }
                {
                    this.file$1 = file$1;
                }
            });
        }
        return this.reporter().hasErrors() ? Exit$.MODULE$.error() : Exit$.MODULE$.success();
    }

    public Exit handleRegularFile(InputFile file) {
        Files.createDirectories(file.out().toNIO().getParent(), new FileAttribute[0]);
        Files.copy(file.in().toNIO(), file.out().toNIO(), StandardCopyOption.REPLACE_EXISTING);
        if (this.settings().verbose()) {
            this.reporter().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copied    ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.out().toNIO()})));
        }
        return Exit$.MODULE$.success();
    }

    public Exit handleFile(InputFile file) {
        Exit exit;
        try {
            if (this.settings().isIncluded(file.relpath())) {
                String extension = PathIO$.MODULE$.extension(file.in().toNIO());
                exit = this.settings().isMarkdownFileExtension().apply((Object)extension) ? this.handleMarkdown(file) : this.handleRegularFile(file);
            } else {
                exit = Exit$.MODULE$.success();
            }
        }
        catch (Throwable throwable) {
            Exit exit2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            new FileException(file.in(), e).printStackTrace();
            exit = exit2 = Exit$.MODULE$.error();
        }
        return exit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writePath(InputFile file, String string) {
        if (this.settings().check()) {
            String expected;
            if (!file.out().isFile()) return;
            String string2 = expected = FileIO$.MODULE$.slurp(file.out(), this.settings().charset());
            String string3 = string;
            if (!(string2 == null ? string3 != null : !string2.equals(string3))) return;
            String filename = file.out().toString();
            String diff = DiffUtils$.MODULE$.unifiedDiff(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (on disk)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (expected output)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})), (List<String>)new StringOps(Predef$.MODULE$.augmentString(expected)).linesIterator().toList(), (List<String>)new StringOps(Predef$.MODULE$.augmentString(string)).linesIterator().toList(), 3);
            this.reporter().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--test failed! To fix this problem, re-generate the documentation\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{diff})));
            return;
        } else {
            Files.createDirectories(file.out().toNIO().getParent(), new FileAttribute[0]);
            Files.write(file.out().toNIO(), string.getBytes(this.settings().charset()), new OpenOption[0]);
        }
    }

    public Exit generateCompleteSite() {
        List<InputFile> files = IO$.MODULE$.inputFiles(this.settings());
        Timer timer = new Timer();
        int n = files.length();
        this.compilingFiles(n);
        Exit exit = (Exit)files.foldLeft((Object)Exit$.MODULE$.success(), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MainOps $outer;

            public final Exit apply(Exit x0$1, InputFile x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                if (tuple2 != null) {
                    Exit accum = (Exit)tuple2._1();
                    InputFile file = (InputFile)tuple2._2();
                    Exit fileExit = this.$outer.handleFile(file);
                    Exit exit = accum.merge(fileExit);
                    return exit;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.lint();
        if (files.isEmpty()) {
            this.reporter().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no input files: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.settings().in()})));
        } else {
            this.compiledFiles(n, timer);
        }
        return exit;
    }

    public Exit run() {
        Exit exit;
        if (this.settings().cleanTarget() && Files.exists(this.settings().out().toNIO(), new LinkOption[0])) {
            IO$.MODULE$.cleanTarget(this.settings().out());
        }
        if (this.settings().watch()) {
            this.startLivereload();
        }
        Exit isOk = this.generateCompleteSite();
        if (this.settings().isFileWatching()) {
            this.waitingForFileChanges();
            this.runFileWatcher();
            exit = Exit$.MODULE$.success();
        } else {
            exit = isOk;
        }
        return exit;
    }

    public void handleWatchEvent(DirectoryChangeEvent event) {
        Option<InputFile> option;
        block6: {
            block5: {
                block4: {
                    String string = PathIO$.MODULE$.extension(event.path());
                    String string2 = "md";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.clearScreen();
                    }
                    AbsolutePath path = AbsolutePath$.MODULE$.apply(event.path(), AbsolutePath$.MODULE$.workingDirectory());
                    option = this.settings().toInputFile(path);
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    InputFile inputFile = (InputFile)some.x();
                    this.reporter().reset();
                    Timer timer = new Timer();
                    this.compilingFiles(1);
                    this.handleFile(inputFile);
                    this.lint();
                    this.compiledFiles(1, timer);
                    this.waitingForFileChanges();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void runFileWatcher() {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        MdocFileListener watcher = MdocFileListener$.MODULE$.create(this.settings().in(), executor, System.in, (Function1<DirectoryChangeEvent, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MainOps $outer;

            public final void apply(DirectoryChangeEvent event) {
                this.$outer.handleWatchEvent(event);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        watcher.watchUntilInterrupted();
        this.livereload().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LiveReload x$2) {
                x$2.stop();
            }
        });
    }

    public void clearScreen() {
        Predef$.MODULE$.print((Object)"\u001b[H\u001b[2J");
    }

    public void waitingForFileChanges() {
        this.reporter().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for file changes (press enter to interrupt)"})).s((Seq)Nil$.MODULE$));
    }

    public void compiledFiles(int n, Timer timer) {
        String errors = Messages$.MODULE$.count("error", this.reporter().errorCount());
        String warnings = this.reporter().hasWarnings() ? new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", "})).s((Seq)Nil$.MODULE$)).append((Object)Messages$.MODULE$.count("warning", this.reporter().warningCount())).toString() : "";
        this.reporter().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiled in ", " (", "", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timer, errors, warnings})));
    }

    public void compilingFiles(int n) {
        String files = Messages$.MODULE$.count("file", n);
        this.reporter().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{files, this.settings().out()})));
    }

    public MainOps(Context context) {
        this.context = context;
        this.livereload = None$.MODULE$;
    }
}

