/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.cli;

import coursierapi.Dependency;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import mdoc.Reporter;
import mdoc.internal.cli.Context;
import mdoc.internal.cli.Feedback$;
import mdoc.internal.cli.Settings;
import mdoc.internal.io.ConsoleReporter$;
import mdoc.internal.markdown.MarkdownBuilder$;
import mdoc.internal.markdown.MarkdownCompiler;
import metaconfig.ConfError;
import metaconfig.ConfError$;
import metaconfig.Configured;
import metaconfig.Configured$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;

public final class Context$
implements Serializable {
    public static final Context$ MODULE$;

    static {
        new Context$();
    }

    public Configured<Context> fromSettings(Settings settings, Reporter reporter) {
        Configured configured;
        if (settings.in().isEmpty()) {
            configured = Configured$.MODULE$.error(Feedback$.MODULE$.mustBeNonEmpty("in"));
        } else if (settings.out().isEmpty()) {
            configured = Configured$.MODULE$.error(Feedback$.MODULE$.mustBeNonEmpty("out"));
        } else if (settings.in().length() != settings.out().length()) {
            configured = Configured$.MODULE$.error(Feedback$.MODULE$.inputDifferentLengthOutput(settings.in(), settings.out()));
        } else {
            Configured configured2;
            List errors = settings.outputByInput().iterator().map((Function1)new Serializable(settings){
                public static final long serialVersionUID = 0L;
                private final Settings settings$1;

                public final Option<ConfError> apply(Tuple2<AbsolutePath, AbsolutePath> x0$1) {
                    Tuple2<AbsolutePath, AbsolutePath> tuple2 = x0$1;
                    if (tuple2 != null) {
                        AbsolutePath input = (AbsolutePath)tuple2._1();
                        AbsolutePath output = (AbsolutePath)tuple2._2();
                        Option<ConfError> option = Context$.MODULE$.mdoc$internal$cli$Context$$validateInputOutputPair(this.settings$1, input, output);
                        return option;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.settings$1 = settings$1;
                }
            }).toList();
            List list = (List)errors.flatten((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<ConfError> apply(Option<ConfError> xo) {
                    return Option$.MODULE$.option2Iterable(xo);
                }
            });
            if (Nil$.MODULE$.equals(list)) {
                Context context = this.fromOptions(settings, reporter);
                settings.onLoad(reporter);
                configured2 = reporter.hasErrors() ? Configured$.MODULE$.error("Failed to load modifiers") : Configured$.MODULE$.ok((Object)context);
            } else {
                configured2 = ((ConfError)list.foldLeft((Object)ConfError$.MODULE$.empty(), (Function2)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final ConfError apply(ConfError x$2, ConfError x$3) {
                        return x$2.combine(x$3);
                    }
                })).notOk();
            }
            configured = configured2;
        }
        return configured;
    }

    private boolean assumedRegularFile(Settings settings, AbsolutePath absPath) {
        String extension = PathIO$.MODULE$.extension(absPath.toNIO());
        return settings.markdownExtensions().toSet().contains((Object)extension);
    }

    public Option<ConfError> mdoc$internal$cli$Context$$validateInputOutputPair(Settings settings, AbsolutePath input, AbsolutePath output) {
        Object object;
        if (Files.exists(input.toNIO(), new LinkOption[0])) {
            AbsolutePath absolutePath = input;
            AbsolutePath absolutePath2 = output;
            object = !(absolutePath != null ? !absolutePath.equals(absolutePath2) : absolutePath2 != null) ? new Some((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.inputEqualOutput(input))) : (output.toNIO().startsWith(input.toNIO()) && !this.assumedRegularFile(settings, output) ? new Some((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.outSubdirectoryOfIn(input.toNIO(), output.toNIO()))) : (input.isFile() && output.isDirectory() ? new Some((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.outputCannotBeDirectory(input, output))) : (input.isDirectory() && output.isFile() ? new Some((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.outputCannotBeRegularFile(input, output))) : None$.MODULE$)));
        } else {
            object = new Some((Object)ConfError$.MODULE$.fileDoesNotExist(input.toNIO()));
        }
        return object;
    }

    public Context fromCompiler(Settings options, Reporter reporter, MarkdownCompiler compiler2) {
        return new Context(options, reporter, compiler2, this.$lessinit$greater$default$4());
    }

    public Context fromOptions(Settings options, Reporter reporter) {
        MarkdownCompiler compiler2 = MarkdownBuilder$.MODULE$.fromClasspath(options.classpath(), options.scalacOptions());
        return this.fromCompiler(options, reporter, compiler2);
    }

    public Reporter fromOptions$default$2() {
        return ConsoleReporter$.MODULE$.default();
    }

    public Context apply(Settings settings, Reporter reporter, MarkdownCompiler compiler2, Map<Tuple2<Set<Dependency>, List<String>>, MarkdownCompiler> compilers) {
        return new Context(settings, reporter, compiler2, compilers);
    }

    public Option<Tuple4<Settings, Reporter, MarkdownCompiler, Map<Tuple2<Set<Dependency>, List<String>>, MarkdownCompiler>>> unapply(Context x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.settings(), (Object)x$0.reporter(), (Object)x$0.compiler(), x$0.compilers()));
    }

    public Map<Tuple2<Set<Dependency>, List<String>>, MarkdownCompiler> $lessinit$greater$default$4() {
        return Map$.MODULE$.empty();
    }

    public Map<Tuple2<Set<Dependency>, List<String>>, MarkdownCompiler> apply$default$4() {
        return Map$.MODULE$.empty();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Context$() {
        MODULE$ = this;
    }
}

