/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.cli;

import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.hashing.FileHash;
import io.methvin.watcher.hashing.FileHasher;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mdoc.Reporter;
import mdoc.internal.cli.Context;
import mdoc.internal.cli.Exit;
import mdoc.internal.cli.Exit$;
import mdoc.internal.cli.FileException;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.InputFile$;
import mdoc.internal.cli.MainOps$;
import mdoc.internal.cli.Messages$;
import mdoc.internal.cli.Settings;
import mdoc.internal.cli.Timer;
import mdoc.internal.io.IO$;
import mdoc.internal.io.MdocFileListener;
import mdoc.internal.io.MdocFileListener$;
import mdoc.internal.livereload.LiveReload;
import mdoc.internal.livereload.UndertowLiveReload;
import mdoc.internal.livereload.UndertowLiveReload$;
import mdoc.internal.markdown.DocumentLinks;
import mdoc.internal.markdown.DocumentLinks$;
import mdoc.internal.markdown.LinkHygiene$;
import mdoc.internal.markdown.Markdown$;
import mdoc.internal.pos.DiffUtils$;
import metaconfig.Configured;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.meta.inputs.Input;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0001\u0003\u0005%\u0011q!T1j]>\u00038O\u0003\u0002\u0004\t\u0005\u00191\r\\5\u000b\u0005\u00151\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0003\u001d\tA!\u001c3pG\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\"A\u0011\u0003\u0001B\u0001B\u0003%!#A\u0004d_:$X\r\u001f;\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!aB\"p]R,\u0007\u0010\u001e\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005eQ\u0002CA\n\u0001\u0011\u0015\tb\u00031\u0001\u0013\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003!\u0019X\r\u001e;j]\u001e\u001cX#\u0001\u0010\u0011\u0005My\u0012B\u0001\u0011\u0003\u0005!\u0019V\r\u001e;j]\u001e\u001c\b\"\u0002\u0012\u0001\t\u0003\u0019\u0013\u0001\u0003:fa>\u0014H/\u001a:\u0016\u0003\u0011\u0002\"!\n\u0014\u000e\u0003\u0019I!a\n\u0004\u0003\u0011I+\u0007o\u001c:uKJDq!\u000b\u0001A\u0002\u0013%!&\u0001\u0006mSZ,'/\u001a7pC\u0012,\u0012a\u000b\t\u0004\u00171r\u0013BA\u0017\r\u0005\u0019y\u0005\u000f^5p]B\u0011q&M\u0007\u0002a)\u0011\u0011\u0006B\u0005\u0003eA\u0012!\u0002T5wKJ+Gn\\1e\u0011\u001d!\u0004\u00011A\u0005\nU\na\u0002\\5wKJ,Gn\\1e?\u0012*\u0017\u000f\u0006\u00027sA\u00111bN\u0005\u0003q1\u0011A!\u00168ji\"9!hMA\u0001\u0002\u0004Y\u0013a\u0001=%c!1A\b\u0001Q!\n-\n1\u0002\\5wKJ,Gn\\1eA!)a\b\u0001C\u0005\u007f\u0005y1\u000f^1si2Kg/\u001a:fY>\fG\rF\u00017\u0011\u0015\t\u0005\u0001\"\u0001@\u0003\u0011a\u0017N\u001c;\t\u000b\r\u0003A\u0011\u0001#\u0002\u001d!\fg\u000e\u001a7f\u001b\u0006\u00148\u000eZ8x]R\u0011Q\t\u0013\t\u0003'\u0019K!a\u0012\u0002\u0003\t\u0015C\u0018\u000e\u001e\u0005\u0006\u0013\n\u0003\rAS\u0001\u0005M&dW\r\u0005\u0002\u0014\u0017&\u0011AJ\u0001\u0002\n\u0013:\u0004X\u000f\u001e$jY\u0016DQA\u0014\u0001\u0005\u0002=\u000b\u0011\u0003[1oI2,'+Z4vY\u0006\u0014h)\u001b7f)\t)\u0005\u000bC\u0003J\u001b\u0002\u0007!\nC\u0003S\u0001\u0011\u00051+\u0001\u0006iC:$G.\u001a$jY\u0016$\"!\u0012+\t\u000b%\u000b\u0006\u0019\u0001&\t\u000bY\u0003A\u0011A,\u0002\u0013]\u0014\u0018\u000e^3QCRDGc\u0001\u001cY3\")\u0011*\u0016a\u0001\u0015\")!,\u0016a\u00017\u000611\u000f\u001e:j]\u001e\u0004\"\u0001X0\u000f\u0005-i\u0016B\u00010\r\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001-\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005yc\u0001\"B2\u0001\t\u0003!\u0017\u0001F4f]\u0016\u0014\u0018\r^3D_6\u0004H.\u001a;f'&$X\rF\u0001F\u0011\u00151\u0007\u0001\"\u0001e\u0003\r\u0011XO\u001c\u0005\bQ\u0002\u0011\r\u0011\"\u0001j\u0003\u0019A\u0017m\u001d5fgV\t!\u000e\u0005\u0003laJ\\X\"\u00017\u000b\u00055t\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003_2\t!bY8mY\u0016\u001cG/[8o\u0013\t\tHNA\u0002NCB\u0004\"a]=\u000e\u0003QT!!S;\u000b\u0005Y<\u0018a\u00018j_*\t\u00010\u0001\u0003kCZ\f\u0017B\u0001>u\u0005\u0011\u0001\u0016\r\u001e5\u0011\u0007q\fY!D\u0001~\u0015\tqx0A\u0004iCND\u0017N\\4\u000b\t\u0005\u0005\u00111A\u0001\bo\u0006$8\r[3s\u0015\u0011\t)!a\u0002\u0002\u000f5,G\u000f\u001b<j]*\u0011\u0011\u0011B\u0001\u0003S>L1!!\u0004~\u0005!1\u0015\u000e\\3ICND\u0007bBA\t\u0001\u0001\u0006IA[\u0001\bQ\u0006\u001c\b.Z:!\u0011\u001d\t)\u0002\u0001C\u0001\u0003/\t\u0001\u0003[1oI2,w+\u0019;dQ\u00163XM\u001c;\u0015\u0007Y\nI\u0002\u0003\u0005\u0002\u001c\u0005M\u0001\u0019AA\u000f\u0003\u0015)g/\u001a8u!\u0011\ty\"!\t\u000e\u0003}L1!a\t\u0000\u0005Q!\u0015N]3di>\u0014\u0018p\u00115b]\u001e,WI^3oi\"1\u0011q\u0005\u0001\u0005\u0002}\naB];o\r&dWmV1uG\",'\u000f\u0003\u0004\u0002,\u0001!\taP\u0001\fG2,\u0017M]*de\u0016,g\u000e\u0003\u0004\u00020\u0001!\taP\u0001\u0016o\u0006LG/\u001b8h\r>\u0014h)\u001b7f\u0007\"\fgnZ3t\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003k\tQbY8na&dW\r\u001a$jY\u0016\u001cH#\u0002\u001c\u00028\u0005\u0005\u0003\u0002CA\u001d\u0003c\u0001\r!a\u000f\u0002\u00039\u00042aCA\u001f\u0013\r\ty\u0004\u0004\u0002\u0004\u0013:$\b\u0002CA\"\u0003c\u0001\r!!\u0012\u0002\u000bQLW.\u001a:\u0011\u0007M\t9%C\u0002\u0002J\t\u0011Q\u0001V5nKJDq!!\u0014\u0001\t\u0003\ty%\u0001\bd_6\u0004\u0018\u000e\\5oO\u001aKG.Z:\u0015\u0007Y\n\t\u0006\u0003\u0005\u0002:\u0005-\u0003\u0019AA\u001e\u000f\u001d\t)F\u0001E\u0001\u0003/\nq!T1j]>\u00038\u000fE\u0002\u0014\u000332a!\u0001\u0002\t\u0002\u0005m3cAA-\u0015!9q#!\u0017\u0005\u0002\u0005}CCAA,\u0011!\t\u0019'!\u0017\u0005\u0002\u0005\u0015\u0014a\u00029s_\u000e,7o\u001d\u000b\u0007\u0003w\t9'!\u001e\t\u000fq\t\t\u00071\u0001\u0002jA)\u00111NA9=5\u0011\u0011Q\u000e\u0006\u0003\u0003_\n!\"\\3uC\u000e|gNZ5h\u0013\u0011\t\u0019(!\u001c\u0003\u0015\r{gNZ5hkJ,G\r\u0003\u0004#\u0003C\u0002\r\u0001\n")
public final class MainOps {
    private final Context context;
    private Option<LiveReload> livereload;
    private final Map<Path, FileHash> hashes;

    public static int process(Configured<Settings> configured, Reporter reporter) {
        return MainOps$.MODULE$.process(configured, reporter);
    }

    public Settings settings() {
        return this.context.settings();
    }

    public Reporter reporter() {
        return this.context.reporter();
    }

    private Option<LiveReload> livereload() {
        return this.livereload;
    }

    private void livereload_$eq(Option<LiveReload> x$1) {
        this.livereload = x$1;
    }

    private void startLivereload() {
        List list;
        block6: {
            block4: {
                block5: {
                    if (this.settings().noLivereload()) break block4;
                    list = this.settings().out();
                    if (!Nil$.MODULE$.equals(list)) break block5;
                    this.reporter().error("Can't start LiveReload server since --out is empty. To fix this problem, specify an --out argument.");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (!(list instanceof .colon.colon)) break block6;
                .colon.colon colon2 = (.colon.colon)list;
                AbsolutePath out2 = (AbsolutePath)colon2.head();
                List tail = colon2.tl$1();
                if (tail.nonEmpty()) {
                    this.reporter().warning(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting LiveReload server at directory ", " and ignoring --out value(s) ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{out2, tail.mkString(", ")}))).append((Object)"To LiveReload another directory, place that directory as the first --out argument.").toString());
                }
                UndertowLiveReload livereload = UndertowLiveReload$.MODULE$.apply(out2.toNIO(), this.settings().host(), this.settings().port(), this.reporter(), UndertowLiveReload$.MODULE$.apply$default$5());
                livereload.start();
                this.livereload_$eq((Option<LiveReload>)new Some((Object)livereload));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)list);
    }

    public void lint() {
        this.settings().out().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MainOps $outer;

            public final void apply(AbsolutePath out2) {
                if (out2.isDirectory() && !this.$outer.settings().noLinkHygiene()) {
                    List<DocumentLinks> docs = DocumentLinks$.MODULE$.fromGeneratedSite(this.$outer.settings(), this.$outer.reporter());
                    LinkHygiene$.MODULE$.lint(docs, this.$outer.reporter(), this.$outer.settings().verbose());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public synchronized Exit handleMarkdown(InputFile file) {
        boolean fileHasErrors;
        int originalErrors = this.reporter().errorCount();
        if (this.settings().verbose()) {
            this.reporter().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.inputFile()})));
        }
        Timer timer = new Timer();
        String source = FileIO$.MODULE$.slurp(file.inputFile(), this.settings().charset());
        Input.VirtualFile input = package$.MODULE$.Input().VirtualFile().apply(file.inputFile().toString(), source);
        String md = Markdown$.MODULE$.toMarkdown((Input)input, this.context, file, (scala.collection.immutable.Map<String, String>)this.settings().site(), this.reporter(), this.settings());
        boolean bl = fileHasErrors = this.reporter().errorCount() > originalErrors;
        if (!fileHasErrors) {
            this.writePath(file, md);
            if (this.settings().verbose()) {
                AbsolutePath arg$macro$1 = file.outputFile();
                Timer arg$macro$2 = timer;
                this.reporter().info(new StringOps("  done => %s (%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2})));
            }
            this.livereload().foreach((Function1)new Serializable(this, file){
                public static final long serialVersionUID = 0L;
                private final InputFile file$1;

                public final void apply(LiveReload x$1) {
                    x$1.reload(this.file$1.outputFile().toNIO());
                }
                {
                    this.file$1 = file$1;
                }
            });
        }
        return this.reporter().hasErrors() ? Exit$.MODULE$.error() : Exit$.MODULE$.success();
    }

    public Exit handleRegularFile(InputFile file) {
        Files.createDirectories(file.outputFile().toNIO().getParent(), new FileAttribute[0]);
        Files.copy(file.inputFile().toNIO(), file.outputFile().toNIO(), StandardCopyOption.REPLACE_EXISTING);
        if (this.settings().verbose()) {
            this.reporter().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copied    ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.outputFile().toNIO()})));
        }
        return Exit$.MODULE$.success();
    }

    public Exit handleFile(InputFile file) {
        Exit exit;
        try {
            if (this.settings().isIncluded(file.relpath())) {
                String extension = PathIO$.MODULE$.extension(file.inputFile().toNIO());
                exit = this.settings().isMarkdownFileExtension().apply((Object)extension) ? this.handleMarkdown(file) : this.handleRegularFile(file);
            } else {
                exit = Exit$.MODULE$.success();
            }
        }
        catch (Throwable throwable) {
            Exit exit2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            new FileException(file.inputFile(), e).printStackTrace();
            exit = exit2 = Exit$.MODULE$.error();
        }
        return exit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writePath(InputFile file, String string) {
        if (this.settings().check()) {
            String expected;
            if (!file.outputFile().isFile()) return;
            String string2 = expected = FileIO$.MODULE$.slurp(file.outputFile(), this.settings().charset());
            String string3 = string;
            if (!(string2 == null ? string3 != null : !string2.equals(string3))) return;
            String filename = file.outputFile().toString();
            String diff = DiffUtils$.MODULE$.unifiedDiff(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (on disk)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (expected output)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})), (List<String>)new StringOps(Predef$.MODULE$.augmentString(expected)).linesIterator().toList(), (List<String>)new StringOps(Predef$.MODULE$.augmentString(string)).linesIterator().toList(), 3);
            this.reporter().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--test failed! To fix this problem, re-generate the documentation\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{diff})));
            return;
        } else if (file.outputFile().isDirectory()) {
            this.reporter().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"can't write output file '", "' because it's a directory. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.outputFile()}))).append((Object)"To fix this problem, either remove this directory or point the --out argument to another path.").toString());
            return;
        } else {
            Files.createDirectories(file.outputFile().toNIO().getParent(), new FileAttribute[0]);
            Files.write(file.outputFile().toNIO(), string.getBytes(this.settings().charset()), new OpenOption[0]);
        }
    }

    public Exit generateCompleteSite() {
        List files = (List)IO$.MODULE$.inputFiles(this.settings()).sorted(InputFile$.MODULE$.ordering());
        Timer timer = new Timer();
        int n = files.length();
        this.compilingFiles(n);
        Exit exit = (Exit)files.foldLeft((Object)Exit$.MODULE$.success(), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MainOps $outer;

            public final Exit apply(Exit x0$1, InputFile x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                if (tuple2 != null) {
                    Exit accum = (Exit)tuple2._1();
                    InputFile file = (InputFile)tuple2._2();
                    Exit fileExit = this.$outer.handleFile(file);
                    Exit exit = accum.merge(fileExit);
                    return exit;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.lint();
        if (files.isEmpty()) {
            this.reporter().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no input files: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.settings().in()})));
        } else {
            this.compiledFiles(n, timer);
        }
        return exit;
    }

    public Exit run() {
        Exit exit;
        this.settings().out().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MainOps $outer;

            public final void apply(AbsolutePath out2) {
                if (this.$outer.settings().cleanTarget() && Files.exists(out2.toNIO(), new LinkOption[0])) {
                    IO$.MODULE$.cleanTarget(out2);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (this.settings().watch()) {
            this.startLivereload();
        }
        Exit isOk = this.generateCompleteSite();
        if (this.settings().isFileWatching()) {
            this.waitingForFileChanges();
            this.runFileWatcher();
            exit = Exit$.MODULE$.success();
        } else {
            exit = isOk;
        }
        return exit;
    }

    public Map<Path, FileHash> hashes() {
        return this.hashes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleWatchEvent(DirectoryChangeEvent event) {
        AbsolutePath path = AbsolutePath$.MODULE$.apply(event.path(), AbsolutePath$.MODULE$.workingDirectory());
        Option option = this.settings().toInputFile(path);
        if (!(option instanceof Some)) {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        Some some = (Some)option;
        InputFile inputFile = (InputFile)some.x();
        Map<Path, FileHash> map = this.hashes();
        synchronized (map) {
            BoxedUnit boxedUnit;
            Option oldHash = this.hashes().get((Object)event.path());
            FileHash newHash = FileHasher.DEFAULT_FILE_HASHER.hash(event.path());
            if (oldHash.contains((Object)newHash)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                String string = PathIO$.MODULE$.extension(event.path());
                String string2 = "md";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.clearScreen();
                }
                this.hashes().put((Object)event.path(), (Object)newHash);
                this.reporter().reset();
                Timer timer = new Timer();
                this.compilingFiles(1);
                this.handleFile(inputFile);
                this.lint();
                this.compiledFiles(1, timer);
                this.waitingForFileChanges();
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl33 : MonitorExitStatement: MONITOREXIT : map
            BoxedUnit boxedUnit3 = boxedUnit2;
            return;
        }
    }

    public void runFileWatcher() {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        MdocFileListener watcher = MdocFileListener$.MODULE$.create((List<AbsolutePath>)this.settings().in(), executor, System.in, (Function1<DirectoryChangeEvent, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MainOps $outer;

            public final void apply(DirectoryChangeEvent event) {
                this.$outer.handleWatchEvent(event);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        watcher.watchUntilInterrupted();
        this.livereload().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LiveReload x$2) {
                x$2.stop();
            }
        });
    }

    public void clearScreen() {
        Predef$.MODULE$.print((Object)"\u001b[H\u001b[2J");
    }

    public void waitingForFileChanges() {
        this.reporter().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for file changes (press enter to interrupt)"})).s((Seq)Nil$.MODULE$));
    }

    public void compiledFiles(int n, Timer timer) {
        String errors = Messages$.MODULE$.count("error", this.reporter().errorCount());
        String warnings = this.reporter().hasWarnings() ? new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", "})).s((Seq)Nil$.MODULE$)).append((Object)Messages$.MODULE$.count("warning", this.reporter().warningCount())).toString() : "";
        this.reporter().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiled in ", " (", "", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timer, errors, warnings})));
    }

    public void compilingFiles(int n) {
        String files = Messages$.MODULE$.count("file", n);
        this.reporter().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{files, this.settings().out().mkString(", ")})));
    }

    public MainOps(Context context) {
        this.context = context;
        this.livereload = None$.MODULE$;
        this.hashes = Map$.MODULE$.empty();
    }
}

