/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.Settings;
import mdoc.internal.io.IO$;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Builder;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.runtime.BoxedUnit;

public final class IO$ {
    public static final IO$ MODULE$;
    private final SimpleFileVisitor<Path> deleteVisitor;

    static {
        new IO$();
    }

    public void foreachOutput(Settings settings, Function2<AbsolutePath, RelativePath, BoxedUnit> fn) {
        settings.out().foreach((Function1)new Serializable(settings, fn){
            public static final long serialVersionUID = 0L;
            public final Settings settings$1;
            public final Function2 fn$1;

            public final Path apply(AbsolutePath root) {
                return Files.walkFileTree(root.toNIO(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, root){
                    private final /* synthetic */ anonfun.foreachOutput.1 $outer;
                    private final AbsolutePath root$1;

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        AbsolutePath path = AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory());
                        RelativePath relpath = path.toRelative(this.root$1);
                        Object object = this.$outer.settings$1.isExplicitlyExcluded(relpath) ? BoxedUnit.UNIT : this.$outer.fn$1.apply((Object)path, (Object)relpath);
                        return FileVisitResult.CONTINUE;
                    }

                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        RelativePath relpath = AbsolutePath$.MODULE$.apply(dir, AbsolutePath$.MODULE$.workingDirectory()).toRelative(this.root$1);
                        return this.$outer.settings$1.isExplicitlyExcluded(relpath) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.root$1 = root$1;
                    }
                });
            }
            {
                this.settings$1 = settings$1;
                this.fn$1 = fn$1;
            }
        });
    }

    public List<InputFile> inputFiles(Settings settings) {
        Builder buf = List$.MODULE$.newBuilder();
        this.foreachInputFile(settings, (Function1<InputFile, BoxedUnit>)new Serializable(buf){
            public static final long serialVersionUID = 0L;
            private final Builder buf$1;

            public final void apply(InputFile x$1) {
                this.buf$1.$plus$eq((Object)x$1);
            }
            {
                this.buf$1 = buf$1;
            }
        });
        return (List)buf.result();
    }

    public void foreachInputFile(Settings settings, Function1<InputFile, BoxedUnit> fn) {
        AbsolutePath cwd = settings.cwd();
        settings.in().foreach((Function1)new Serializable(settings, fn, cwd){
            public static final long serialVersionUID = 0L;
            public final Settings settings$2;
            public final Function1 fn$2;
            public final AbsolutePath cwd$1;

            public final Object apply(AbsolutePath root) {
                Object object;
                SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(this, root){
                    private final /* synthetic */ anonfun.foreachInputFile.1 $outer;
                    private final AbsolutePath root$2;

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        IO$.MODULE$.mdoc$internal$io$IO$$handle$1(AbsolutePath$.MODULE$.apply(file, this.$outer.cwd$1), this.$outer.settings$2, this.$outer.fn$2);
                        return FileVisitResult.CONTINUE;
                    }

                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        RelativePath relpath = RelativePath$.MODULE$.apply(this.root$2.toNIO().relativize(dir));
                        return this.$outer.settings$2.isExplicitlyExcluded(relpath) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.root$2 = root$2;
                    }
                };
                if (root.isFile()) {
                    IO$.MODULE$.mdoc$internal$io$IO$$handle$1(root, this.settings$2, this.fn$2);
                    object = BoxedUnit.UNIT;
                } else {
                    object = root.isDirectory() ? Files.walkFileTree(root.toNIO(), (FileVisitor<? super Path>)visitor) : BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.settings$2 = settings$2;
                this.fn$2 = fn$2;
                this.cwd$1 = cwd$1;
            }
        });
    }

    public SimpleFileVisitor<Path> deleteVisitor() {
        return this.deleteVisitor;
    }

    public void cleanTarget(AbsolutePath dir) {
        Files.walkFileTree(dir.toNIO(), this.deleteVisitor());
    }

    public final void mdoc$internal$io$IO$$handle$1(AbsolutePath file, Settings settings$2, Function1 fn$2) {
        settings$2.toInputFile(file).foreach(fn$2);
    }

    private IO$() {
        MODULE$ = this;
        this.deleteVisitor = new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        };
    }
}

