/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.cli;

import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.hashing.FileHasher;
import io.methvin.watcher.hashing.HashCode;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mdoc.Reporter;
import mdoc.internal.cli.Context;
import mdoc.internal.cli.Exit;
import mdoc.internal.cli.Exit$;
import mdoc.internal.cli.FileException;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.InputFile$;
import mdoc.internal.cli.MainOps$;
import mdoc.internal.cli.Messages$;
import mdoc.internal.cli.Settings;
import mdoc.internal.cli.Timer;
import mdoc.internal.io.IO$;
import mdoc.internal.io.MdocFileListener;
import mdoc.internal.io.MdocFileListener$;
import mdoc.internal.livereload.LiveReload;
import mdoc.internal.livereload.UndertowLiveReload;
import mdoc.internal.livereload.UndertowLiveReload$;
import mdoc.internal.markdown.DocumentLinks;
import mdoc.internal.markdown.DocumentLinks$;
import mdoc.internal.markdown.LinkHygiene$;
import mdoc.internal.markdown.Markdown$;
import mdoc.internal.pos.DiffUtils$;
import metaconfig.Configured;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.meta.inputs.Input;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001\u0002\u000f\u001e\u0005\u0011B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006a\u0001!\t!\r\u0005\u0006i\u0001!\t!\u000e\u0005\u0006s\u0001!\tA\u000f\u0005\b\u007f\u0001\u0001\r\u0011\"\u0003A\u0011\u001dI\u0005\u00011A\u0005\n)Ca\u0001\u0015\u0001!B\u0013\t\u0005\"B)\u0001\t\u0013\u0011\u0006\"B*\u0001\t\u0003\u0011\u0006\"\u0002+\u0001\t\u0003)\u0006\"\u00020\u0001\t\u0003y\u0006\"B1\u0001\t\u0003\u0011\u0007\"\u00023\u0001\t\u0003)\u0007\"\u0002;\u0001\t\u0003)\b\"\u0002<\u0001\t\u0003)\bbB<\u0001\u0005\u0004%\t\u0001\u001f\u0005\b\u0003[\u0001\u0001\u0015!\u0003z\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAa!a\u0010\u0001\t\u0003\u0011\u0006BBA!\u0001\u0011\u0005!\u000b\u0003\u0004\u0002D\u0001!\tA\u0015\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\ti\u0006\u0001C\u0001\u0003?:q!a\u0019\u001e\u0011\u0003\t)G\u0002\u0004\u001d;!\u0005\u0011q\r\u0005\u0007ae!\t!!\u001b\t\u000f\u0005-\u0014\u0004\"\u0001\u0002n\t9Q*Y5o\u001fB\u001c(B\u0001\u0010 \u0003\r\u0019G.\u001b\u0006\u0003A\u0005\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002E\u0005!Q\u000eZ8d\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g\u0003\u001d\u0019wN\u001c;fqR\u0004\"!\f\u0018\u000e\u0003uI!aL\u000f\u0003\u000f\r{g\u000e^3yi\u00061A(\u001b8jiz\"\"AM\u001a\u0011\u00055\u0002\u0001\"B\u0016\u0003\u0001\u0004a\u0013\u0001C:fiRLgnZ:\u0016\u0003Y\u0002\"!L\u001c\n\u0005aj\"\u0001C*fiRLgnZ:\u0002\u0011I,\u0007o\u001c:uKJ,\u0012a\u000f\t\u0003yuj\u0011!I\u0005\u0003}\u0005\u0012\u0001BU3q_J$XM]\u0001\u000bY&4XM]3m_\u0006$W#A!\u0011\u0007\u0019\u0012E)\u0003\u0002DO\t1q\n\u001d;j_:\u0004\"!R$\u000e\u0003\u0019S!aP\u0010\n\u0005!3%A\u0003'jm\u0016\u0014V\r\\8bI\u0006qA.\u001b<fe\u0016dw.\u00193`I\u0015\fHCA&O!\t1C*\u0003\u0002NO\t!QK\\5u\u0011\u001dye!!AA\u0002\u0005\u000b1\u0001\u001f\u00132\u0003-a\u0017N^3sK2|\u0017\r\u001a\u0011\u0002\u001fM$\u0018M\u001d;MSZ,'/\u001a7pC\u0012$\u0012aS\u0001\u0005Y&tG/\u0001\biC:$G.Z'be.$wn\u001e8\u0015\u0005YK\u0006CA\u0017X\u0013\tAVD\u0001\u0003Fq&$\b\"\u0002.\u000b\u0001\u0004Y\u0016\u0001\u00024jY\u0016\u0004\"!\f/\n\u0005uk\"!C%oaV$h)\u001b7f\u0003EA\u0017M\u001c3mKJ+w-\u001e7be\u001aKG.\u001a\u000b\u0003-\u0002DQAW\u0006A\u0002m\u000b!\u0002[1oI2,g)\u001b7f)\t16\rC\u0003[\u0019\u0001\u00071,A\u0005xe&$X\rU1uQR\u00191JZ4\t\u000bik\u0001\u0019A.\t\u000b!l\u0001\u0019A5\u0002\rM$(/\u001b8h!\tQ\u0017O\u0004\u0002l_B\u0011AnJ\u0007\u0002[*\u0011anI\u0001\u0007yI|w\u000e\u001e \n\u0005A<\u0013A\u0002)sK\u0012,g-\u0003\u0002sg\n11\u000b\u001e:j]\u001eT!\u0001]\u0014\u0002)\u001d,g.\u001a:bi\u0016\u001cu.\u001c9mKR,7+\u001b;f)\u00051\u0016a\u0001:v]\u00061\u0001.Y:iKN,\u0012!\u001f\t\u0007u~\f\u0019!!\u0006\u000e\u0003mT!\u0001`?\u0002\u000f5,H/\u00192mK*\u0011apJ\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0001w\n\u0019Q*\u00199\u0011\t\u0005\u0015\u0011\u0011C\u0007\u0003\u0003\u000fQ1AWA\u0005\u0015\u0011\tY!!\u0004\u0002\u00079LwN\u0003\u0002\u0002\u0010\u0005!!.\u0019<b\u0013\u0011\t\u0019\"a\u0002\u0003\tA\u000bG\u000f\u001b\t\u0005\u0003/\tI#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003\u001dA\u0017m\u001d5j]\u001eTA!a\b\u0002\"\u00059q/\u0019;dQ\u0016\u0014(\u0002BA\u0012\u0003K\tq!\\3uQZLgN\u0003\u0002\u0002(\u0005\u0011\u0011n\\\u0005\u0005\u0003W\tIB\u0001\u0005ICND7i\u001c3f\u0003\u001dA\u0017m\u001d5fg\u0002\n\u0001\u0003[1oI2,w+\u0019;dQ\u00163XM\u001c;\u0015\u0007-\u000b\u0019\u0004C\u0004\u00026I\u0001\r!a\u000e\u0002\u000b\u00154XM\u001c;\u0011\t\u0005e\u00121H\u0007\u0003\u0003;IA!!\u0010\u0002\u001e\t!B)\u001b:fGR|'/_\"iC:<W-\u0012<f]R\faB];o\r&dWmV1uG\",'/A\u0006dY\u0016\f'oU2sK\u0016t\u0017!F<bSRLgn\u001a$pe\u001aKG.Z\"iC:<Wm]\u0001\u000eG>l\u0007/\u001b7fI\u001aKG.Z:\u0015\u000b-\u000bI%a\u0015\t\u000f\u0005-c\u00031\u0001\u0002N\u0005\ta\u000eE\u0002'\u0003\u001fJ1!!\u0015(\u0005\rIe\u000e\u001e\u0005\b\u0003+2\u0002\u0019AA,\u0003\u0015!\u0018.\\3s!\ri\u0013\u0011L\u0005\u0004\u00037j\"!\u0002+j[\u0016\u0014\u0018AD2p[BLG.\u001b8h\r&dWm\u001d\u000b\u0004\u0017\u0006\u0005\u0004bBA&/\u0001\u0007\u0011QJ\u0001\b\u001b\u0006Lgn\u00149t!\ti\u0013d\u0005\u0002\u001aKQ\u0011\u0011QM\u0001\baJ|7-Z:t)\u0019\ti%a\u001c\u0002~!1Ag\u0007a\u0001\u0003c\u0002R!a\u001d\u0002zYj!!!\u001e\u000b\u0005\u0005]\u0014AC7fi\u0006\u001cwN\u001c4jO&!\u00111PA;\u0005)\u0019uN\u001c4jOV\u0014X\r\u001a\u0005\u0006sm\u0001\ra\u000f")
public final class MainOps {
    private final Context context;
    private Option<LiveReload> livereload;
    private final Map<Path, HashCode> hashes;

    public static int process(Configured<Settings> configured, Reporter reporter) {
        return MainOps$.MODULE$.process(configured, reporter);
    }

    public Settings settings() {
        return this.context.settings();
    }

    public Reporter reporter() {
        return this.context.reporter();
    }

    private Option<LiveReload> livereload() {
        return this.livereload;
    }

    private void livereload_$eq(Option<LiveReload> x$1) {
        this.livereload = x$1;
    }

    private void startLivereload() {
        if (!this.settings().noLivereload()) {
            List<AbsolutePath> list = this.settings().out();
            if (Nil$.MODULE$.equals(list)) {
                this.reporter().error("Can't start LiveReload server since --out is empty. To fix this problem, specify an --out argument.");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                AbsolutePath out = (AbsolutePath)colon2.head();
                List tail = colon2.tl$access$1();
                if (tail.nonEmpty()) {
                    this.reporter().warning(new StringBuilder(153).append("Starting LiveReload server at directory ").append(out).append(" and ignoring --out value(s) ").append(tail.mkString(", ")).append(". ").append("To LiveReload another directory, place that directory as the first --out argument.").toString());
                }
                UndertowLiveReload livereload = UndertowLiveReload$.MODULE$.apply(out.toNIO(), this.settings().host(), this.settings().port(), this.reporter(), UndertowLiveReload$.MODULE$.apply$default$5());
                livereload.start();
                this.livereload_$eq((Option<LiveReload>)new Some((Object)livereload));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(list);
            }
        }
    }

    public void lint() {
        this.settings().out().foreach((Function1 & Serializable & scala.Serializable)out -> {
            MainOps.$anonfun$lint$1(this, out);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized Exit handleMarkdown(InputFile file) {
        boolean fileHasErrors;
        int originalErrors = this.reporter().errorCount();
        if (this.settings().verbose()) {
            this.reporter().info(new StringBuilder(10).append("Compiling ").append(file.inputFile()).toString());
        }
        Timer timer = new Timer();
        String source = FileIO$.MODULE$.slurp(file.inputFile(), this.settings().charset());
        Input.VirtualFile input = package$.MODULE$.Input().VirtualFile().apply(file.inputFile().toString(), source);
        String md = Markdown$.MODULE$.toMarkdown((Input)input, this.context, file, this.settings().site(), this.reporter(), this.settings());
        boolean bl = fileHasErrors = this.reporter().errorCount() > originalErrors;
        if (!fileHasErrors) {
            this.writePath(file, md);
            if (this.settings().verbose()) {
                AbsolutePath arg$macro$1 = file.outputFile();
                Timer arg$macro$2 = timer;
                this.reporter().info(new StringOps("  done => %s (%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2})));
            }
            this.livereload().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.reload(file.outputFile().toNIO());
                return BoxedUnit.UNIT;
            });
        }
        return this.reporter().hasErrors() ? Exit$.MODULE$.error() : Exit$.MODULE$.success();
    }

    public Exit handleRegularFile(InputFile file) {
        block0: {
            Files.createDirectories(file.outputFile().toNIO().getParent(), new FileAttribute[0]);
            Files.copy(file.inputFile().toNIO(), file.outputFile().toNIO(), StandardCopyOption.REPLACE_EXISTING);
            if (!this.settings().verbose()) break block0;
            this.reporter().info(new StringBuilder(10).append("Copied    ").append(file.outputFile().toNIO()).toString());
        }
        return Exit$.MODULE$.success();
    }

    public Exit handleFile(InputFile file) {
        Exit exit;
        block5: {
            try {
                if (!this.settings().isIncluded(file.relpath())) {
                    exit = Exit$.MODULE$.success();
                    break block5;
                }
                String extension = PathIO$.MODULE$.extension(file.inputFile().toNIO());
                if (this.settings().isMarkdownFileExtension().apply((Object)extension)) {
                    exit = this.handleMarkdown(file);
                    break block5;
                }
                exit = this.handleRegularFile(file);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                new FileException(file.inputFile(), e).printStackTrace();
                Exit exit2 = Exit$.MODULE$.error();
                exit = exit2;
            }
        }
        return exit;
    }

    public void writePath(InputFile file, String string) {
        if (this.settings().check()) {
            String expected;
            if (!file.outputFile().isFile()) {
                return;
            }
            String string2 = expected = FileIO$.MODULE$.slurp(file.outputFile(), this.settings().charset());
            String string3 = string;
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                String filename = file.outputFile().toString();
                String diff = DiffUtils$.MODULE$.unifiedDiff(new StringBuilder(10).append(filename).append(" (on disk)").toString(), new StringBuilder(18).append(filename).append(" (expected output)").toString(), (List<String>)new StringOps(Predef$.MODULE$.augmentString(expected)).linesIterator().toList(), (List<String>)new StringOps(Predef$.MODULE$.augmentString(string)).linesIterator().toList(), 3);
                this.reporter().error(new StringBuilder(66).append("--test failed! To fix this problem, re-generate the documentation\n").append(diff).toString());
            }
        } else if (file.outputFile().isDirectory()) {
            this.reporter().error(new StringBuilder(147).append("can't write output file '").append(file.outputFile()).append("' because it's a directory. ").append("To fix this problem, either remove this directory or point the --out argument to another path.").toString());
        } else {
            Files.createDirectories(file.outputFile().toNIO().getParent(), new FileAttribute[0]);
            Files.write(file.outputFile().toNIO(), string.getBytes(this.settings().charset()), new OpenOption[0]);
        }
    }

    public Exit generateCompleteSite() {
        List files = (List)IO$.MODULE$.inputFiles(this.settings()).sorted(InputFile$.MODULE$.ordering());
        Timer timer = new Timer();
        int n = files.length();
        this.compilingFiles(n);
        Exit exit = (Exit)files.foldLeft((Object)Exit$.MODULE$.success(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Exit accum = (Exit)tuple2._1();
            InputFile file = (InputFile)tuple2._2();
            Exit fileExit = this.handleFile(file);
            Exit exit = accum.merge(fileExit);
            return exit;
        });
        this.lint();
        if (files.isEmpty()) {
            this.reporter().error(new StringBuilder(16).append("no input files: ").append(this.settings().in()).toString());
        } else {
            this.compiledFiles(n, timer);
        }
        return exit;
    }

    /*
     * WARNING - void declaration
     */
    public Exit run() {
        Exit exit;
        this.settings().out().foreach((Function1 & Serializable & scala.Serializable)out -> {
            MainOps.$anonfun$run$1(this, out);
            return BoxedUnit.UNIT;
        });
        if (this.settings().watch()) {
            this.startLivereload();
        }
        Exit isOk = this.generateCompleteSite();
        if (this.settings().isFileWatching()) {
            this.waitingForFileChanges();
            this.runFileWatcher();
            exit = Exit$.MODULE$.success();
        } else {
            void var1_1;
            exit = var1_1;
        }
        return exit;
    }

    public Map<Path, HashCode> hashes() {
        return this.hashes;
    }

    public void handleWatchEvent(DirectoryChangeEvent event) {
        AbsolutePath path = AbsolutePath$.MODULE$.apply(event.path(), AbsolutePath$.MODULE$.workingDirectory());
        Option<InputFile> option = this.settings().toInputFile(path);
        if (option instanceof Some) {
            Some some = (Some)option;
            InputFile inputFile = (InputFile)some.value();
            Map<Path, HashCode> map = this.hashes();
            synchronized (map) {
                Option oldHash = this.hashes().get((Object)event.path());
                HashCode newHash = FileHasher.DEFAULT_FILE_HASHER.hash(event.path());
                if (!oldHash.contains((Object)newHash)) {
                    String string = PathIO$.MODULE$.extension(event.path());
                    String string2 = "md";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.clearScreen();
                    }
                    this.hashes().put((Object)event.path(), (Object)newHash);
                    this.reporter().reset();
                    Timer timer = new Timer();
                    this.compilingFiles(1);
                    this.handleFile(inputFile);
                    this.lint();
                    this.compiledFiles(1, timer);
                    this.waitingForFileChanges();
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public void runFileWatcher() {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        MdocFileListener watcher = MdocFileListener$.MODULE$.create(this.settings().in(), executor, System.in, (Function1<DirectoryChangeEvent, BoxedUnit>)(Function1 & Serializable & scala.Serializable)event -> {
            this.handleWatchEvent(event);
            return BoxedUnit.UNIT;
        });
        watcher.watchUntilInterrupted();
        this.livereload().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
    }

    public void clearScreen() {
        Predef$.MODULE$.print((Object)"\u001b[H\u001b[2J");
    }

    public void waitingForFileChanges() {
        this.reporter().println("Waiting for file changes (press enter to interrupt)");
    }

    public void compiledFiles(int n, Timer timer) {
        String errors = Messages$.MODULE$.count("error", this.reporter().errorCount());
        String warnings = this.reporter().hasWarnings() ? new StringBuilder(2).append(", ").append(Messages$.MODULE$.count("warning", this.reporter().warningCount())).toString() : "";
        this.reporter().info(new StringBuilder(15).append("Compiled in ").append(timer).append(" (").append(errors).append(warnings).append(")").toString());
    }

    public void compilingFiles(int n) {
        String files = Messages$.MODULE$.count("file", n);
        this.reporter().info(new StringBuilder(14).append("Compiling ").append(files).append(" to ").append(this.settings().out().mkString(", ")).toString());
    }

    public static final /* synthetic */ void $anonfun$lint$1(MainOps $this, AbsolutePath out) {
        block0: {
            if (!out.isDirectory() || $this.settings().noLinkHygiene()) break block0;
            List<DocumentLinks> docs = DocumentLinks$.MODULE$.fromGeneratedSite($this.settings(), $this.reporter());
            LinkHygiene$.MODULE$.lint(docs, $this.reporter(), $this.settings().verbose());
        }
    }

    public static final /* synthetic */ void $anonfun$run$1(MainOps $this, AbsolutePath out) {
        block0: {
            if (!$this.settings().cleanTarget() || !Files.exists(out.toNIO(), new LinkOption[0])) break block0;
            IO$.MODULE$.cleanTarget(out);
        }
    }

    public MainOps(Context context) {
        this.context = context;
        this.livereload = None$.MODULE$;
        this.hashes = Map$.MODULE$.empty();
    }
}

