/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.Settings;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Builder;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.runtime.BoxedUnit;

public final class IO$ {
    public static IO$ MODULE$;
    private final SimpleFileVisitor<Path> deleteVisitor;

    static {
        new IO$();
    }

    public void foreachOutput(Settings settings, Function2<AbsolutePath, RelativePath, BoxedUnit> fn) {
        settings.out().foreach((Function1 & java.io.Serializable & Serializable)root -> Files.walkFileTree(root.toNIO(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(root, settings, fn){
            private final AbsolutePath root$1;
            private final Settings settings$1;
            private final Function2 fn$1;

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                AbsolutePath path = AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory());
                RelativePath relpath = path.toRelative(this.root$1);
                Object object = !this.settings$1.isExplicitlyExcluded(relpath) ? this.fn$1.apply((Object)path, (Object)relpath) : BoxedUnit.UNIT;
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                RelativePath relpath = AbsolutePath$.MODULE$.apply(dir, AbsolutePath$.MODULE$.workingDirectory()).toRelative(this.root$1);
                return this.settings$1.isExplicitlyExcluded(relpath) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }
            {
                this.root$1 = root$1;
                this.settings$1 = settings$1;
                this.fn$1 = fn$1;
            }
        }));
    }

    public List<InputFile> inputFiles(Settings settings) {
        Builder buf = List$.MODULE$.newBuilder();
        this.foreachInputFile(settings, (Function1<InputFile, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)x$1 -> {
            buf.$plus$eq((Object)x$1);
            return BoxedUnit.UNIT;
        });
        return (List)buf.result();
    }

    public void foreachInputFile(Settings settings, Function1<InputFile, BoxedUnit> fn) {
        AbsolutePath cwd = settings.cwd();
        settings.in().foreach((Function1 & java.io.Serializable & Serializable)root -> {
            Object object;
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(cwd, root, settings, fn){
                private final AbsolutePath cwd$1;
                private final AbsolutePath root$2;
                private final Settings settings$2;
                private final Function1 fn$2;

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    IO$.mdoc$internal$io$IO$$handle$1(AbsolutePath$.MODULE$.apply(file, this.cwd$1), this.settings$2, this.fn$2);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    RelativePath relpath = RelativePath$.MODULE$.apply(this.root$2.toNIO().relativize(dir));
                    return this.settings$2.isExplicitlyExcluded(relpath) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
                }
                {
                    this.cwd$1 = cwd$1;
                    this.root$2 = root$2;
                    this.settings$2 = settings$2;
                    this.fn$2 = fn$2;
                }
            };
            if (root.isFile()) {
                IO$.mdoc$internal$io$IO$$handle$1(root, settings, fn);
                object = BoxedUnit.UNIT;
            } else {
                object = root.isDirectory() ? Files.walkFileTree(root.toNIO(), (FileVisitor<? super Path>)visitor) : BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public SimpleFileVisitor<Path> deleteVisitor() {
        return this.deleteVisitor;
    }

    public void cleanTarget(AbsolutePath dir) {
        Files.walkFileTree(dir.toNIO(), this.deleteVisitor());
    }

    public static final void mdoc$internal$io$IO$$handle$1(AbsolutePath file, Settings settings$2, Function1 fn$2) {
        settings$2.toInputFile(file).foreach(fn$2);
    }

    private IO$() {
        MODULE$ = this;
        this.deleteVisitor = new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        };
    }
}

