/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.worksheets;

import java.io.Serializable;
import mdoc.document.Binder;
import mdoc.document.Statement;
import mdoc.interfaces.RangePosition;
import mdoc.internal.cli.Context;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.InputFile$;
import mdoc.internal.cli.Settings;
import mdoc.internal.document.Printing$;
import mdoc.internal.io.StoreReporter;
import mdoc.internal.markdown.EvaluatedDocument;
import mdoc.internal.markdown.Instrumented;
import mdoc.internal.markdown.Instrumenter$;
import mdoc.internal.markdown.MarkdownBuilder$;
import mdoc.internal.markdown.MarkdownCompiler;
import mdoc.internal.markdown.SectionInput;
import mdoc.internal.markdown.SectionInput$;
import mdoc.internal.worksheets.EvaluatedWorksheet;
import mdoc.internal.worksheets.EvaluatedWorksheetStatement;
import mdoc.internal.worksheets.RenderSummaryResult;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.LinkedHashSet$;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.meta.inputs.Input;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0002\u0007\u000e\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\u0006E\u0001!\ta\t\u0005\bO\u0001\u0011\r\u0011\"\u0003)\u0011\u0019y\u0003\u0001)A\u0005S!9\u0001\u0007\u0001b\u0001\n\u0013\t\u0004BB\u001b\u0001A\u0003%!\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0003Z\u0001\u0011%!\fC\u0003g\u0001\u0011%q\rC\u0003w\u0001\u0011%q\u000f\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0002\u0012/>\u00148n\u001d5fKR\u0004&o\u001c<jI\u0016\u0014(B\u0001\b\u0010\u0003)9xN]6tQ\u0016,Go\u001d\u0006\u0003!E\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002%\u0005!Q\u000eZ8d\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g\u0003!\u0019X\r\u001e;j]\u001e\u001c\bCA\u000f!\u001b\u0005q\"BA\u0010\u0010\u0003\r\u0019G.[\u0005\u0003Cy\u0011\u0001bU3ui&twm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u00112\u0003CA\u0013\u0001\u001b\u0005i\u0001\"B\u000e\u0003\u0001\u0004a\u0012\u0001\u0003:fa>\u0014H/\u001a:\u0016\u0003%\u0002\"AK\u0017\u000e\u0003-R!\u0001L\b\u0002\u0005%|\u0017B\u0001\u0018,\u00055\u0019Fo\u001c:f%\u0016\u0004xN\u001d;fe\u0006I!/\u001a9peR,'\u000fI\u0001\u000e[&t\u0017.\\;n\u001b\u0006\u0014x-\u001b8\u0016\u0003I\u0002\"AF\u001a\n\u0005Q:\"aA%oi\u0006qQ.\u001b8j[VlW*\u0019:hS:\u0004\u0013!E3wC2,\u0018\r^3X_J\\7\u000f[3fiR\u0019\u0001h\u000f+\u0011\u0005\u0015J\u0014B\u0001\u001e\u000e\u0005I)e/\u00197vCR,GmV8sWNDW-\u001a;\t\u000bq:\u0001\u0019A\u001f\u0002\u000b%t\u0007/\u001e;\u0011\u0005y\nfBA L\u001d\t\u0001\u0005J\u0004\u0002B\r:\u0011!)R\u0007\u0002\u0007*\u0011AiE\u0001\u0007yI|w\u000e\u001e \n\u0003aI!aR\f\u0002\t5,G/Y\u0005\u0003\u0013*\u000bq\u0001]1dW\u0006<WM\u0003\u0002H/%\u0011A*T\u0001\u0006\u0013:\u0004X\u000f^\u0005\u0003\u001d>\u0013q!\u00117jCN,7O\u0003\u0002Q\u0015\u00061\u0011N\u001c9viNL!AU*\u0003\u0017YK'\u000f^;bY\u001aKG.\u001a\u0006\u0003\u00196CQ!V\u0004A\u0002Y\u000b1a\u0019;y!\tir+\u0003\u0002Y=\t91i\u001c8uKb$\u0018\u0001\u0005:f]\u0012,'\u000fR3d_J\fG/[8o)\tYf\f\u0005\u0002&9&\u0011Q,\u0004\u0002\u001c\u000bZ\fG.^1uK\u0012<vN]6tQ\u0016,Go\u0015;bi\u0016lWM\u001c;\t\u000b}C\u0001\u0019\u00011\u0002\u0013M$\u0018\r^3nK:$\bCA1e\u001b\u0005\u0011'BA2\u0012\u0003!!wnY;nK:$\u0018BA3c\u0005%\u0019F/\u0019;f[\u0016tG/A\u0007sK:$WM\u001d#fi\u0006LGn\u001d\u000b\u0004QB\f\bCA5n\u001d\tQ7\u000e\u0005\u0002C/%\u0011AnF\u0001\u0007!J,G-\u001a4\n\u00059|'AB*ue&twM\u0003\u0002m/!)q,\u0003a\u0001A\")!/\u0003a\u0001g\u0006a\u0011n]#naRLh+\u00197vKB\u0011a\u0003^\u0005\u0003k^\u0011qAQ8pY\u0016\fg.A\u0007sK:$WM]*v[6\f'/\u001f\u000b\u0005qndh\u0010\u0005\u0002&s&\u0011!0\u0004\u0002\u0014%\u0016tG-\u001a:Tk6l\u0017M]=SKN,H\u000e\u001e\u0005\u0006?*\u0001\r\u0001\u0019\u0005\u0006{*\u0001\rAM\u0001\u0007[\u0006\u0014x-\u001b8\t\u000bIT\u0001\u0019A:\u0002\u0015%\u001cXK\\5u)f\u0004X\rF\u0002t\u0003\u0007AQaX\u0006A\u0002\u0001\u0004")
public class WorksheetProvider {
    private final Settings settings;
    private final StoreReporter reporter;
    private final int minimumMargin;

    private StoreReporter reporter() {
        return this.reporter;
    }

    private int minimumMargin() {
        return this.minimumMargin;
    }

    public EvaluatedWorksheet evaluateWorksheet(Input.VirtualFile input, Context ctx) {
        SectionInput sectionInput = SectionInput$.MODULE$.apply((Input)input, ctx);
        .colon.colon sectionInputs = new .colon.colon((Object)sectionInput, (List)Nil$.MODULE$);
        InputFile file = InputFile$.MODULE$.fromRelativeFilename(input.path(), this.settings);
        Instrumented instrumented = Instrumenter$.MODULE$.instrument(file, (List<SectionInput>)sectionInputs, this.settings, this.reporter());
        MarkdownCompiler compiler = ctx.compiler(instrumented);
        EvaluatedDocument rendered = MarkdownBuilder$.MODULE$.buildDocument(compiler, this.reporter(), (List<SectionInput>)sectionInputs, instrumented, input.path());
        Iterator decorations = rendered.sections().iterator().flatMap((Function1 & Serializable & scala.Serializable)section -> (List)section.section().statements().map((Function1 & Serializable & scala.Serializable)statement -> this.renderDecoration((Statement)statement), List$.MODULE$.canBuildFrom()));
        return new EvaluatedWorksheet((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(((SetLike)this.reporter().diagnostics().map((Function1 & Serializable & scala.Serializable)d -> d, LinkedHashSet$.MODULE$.canBuildFrom())).toSeq()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)decorations.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WorksheetProvider.$anonfun$evaluateWorksheet$4(x$1))).map((Function1 & Serializable & scala.Serializable)d -> d).toList()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)instrumented.fileImports().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toInterface(), List$.MODULE$.canBuildFrom())).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)instrumented.scalacOptionImports().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.value(), List$.MODULE$.canBuildFrom())).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(compiler.classpathEntries()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(instrumented.dependencies().toSeq()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)instrumented.repositories().toSeq()).asJava());
    }

    private EvaluatedWorksheetStatement renderDecoration(Statement statement) {
        mdoc.document.RangePosition pos = statement.position();
        mdoc.document.RangePosition range = new mdoc.document.RangePosition(pos.startLine(), pos.startColumn(), pos.endLine(), pos.endColumn());
        int margin = package$.MODULE$.max(this.minimumMargin(), this.settings.screenWidth() - statement.position().endColumn());
        boolean isEmptyValue = this.isUnitType(statement) || statement.binders().isEmpty();
        RenderSummaryResult renderSummaryResult = this.renderSummary(statement, margin, isEmptyValue);
        String details = this.renderDetails(statement, isEmptyValue);
        return new EvaluatedWorksheetStatement((RangePosition)range, renderSummaryResult.summary(), details, renderSummaryResult.isSummaryComplete());
    }

    private String renderDetails(Statement statement, boolean isEmptyValue) {
        StringBuilder out = new StringBuilder();
        if (!isEmptyValue) {
            statement.binders().iterator().foreach((Function1 & Serializable & scala.Serializable)binder -> {
                WorksheetProvider.$anonfun$renderDetails$1(this, out, binder);
                return BoxedUnit.UNIT;
            });
        }
        new StringOps(Predef$.MODULE$.augmentString(statement.out())).linesIterator().foreach((Function1 & Serializable & scala.Serializable)line -> out.append(out.nonEmpty() ? "\n" : "").append("// ").append(line));
        return out.toString();
    }

    private RenderSummaryResult renderSummary(Statement statement, int margin, boolean isEmptyValue) {
        boolean bl;
        StringBuilder out = new StringBuilder();
        if (isEmptyValue) {
            if (!statement.out().isEmpty()) {
                Iterator lines = new StringOps(Predef$.MODULE$.augmentString(statement.out())).linesIterator();
                out.append((String)lines.next());
                bl = lines.hasNext() || out.length() > margin;
            } else {
                bl = false;
            }
        } else {
            boolean isSingle = statement.binders().lengthCompare(1) == 0;
            bl = BoxesRunTime.unboxToBoolean((Object)statement.binders().iterator().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)WorksheetProvider.$anonfun$renderSummary$1(isSingle, out, margin, BoxesRunTime.unboxToBoolean((Object)x0$1), x1$1))));
        }
        boolean isOverMargin = bl;
        return new RenderSummaryResult((String)new StringOps(Predef$.MODULE$.augmentString(out.result())).take(margin), !isOverMargin);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isUnitType(Statement statement) {
        List list = statement.binders();
        if (!(list instanceof .colon.colon)) return false;
        .colon.colon colon2 = (.colon.colon)list;
        Binder head = (Binder)colon2.head();
        List list2 = colon2.tl$access$1();
        if (!Nil$.MODULE$.equals(list2)) return false;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Object object = head.value();
        if (boxedUnit != null) {
            if (!boxedUnit.equals(object)) return false;
            return true;
        }
        if (object == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$evaluateWorksheet$4(EvaluatedWorksheetStatement x$1) {
        return x$1.summary().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$renderDetails$1(WorksheetProvider $this, StringBuilder out$1, Binder binder) {
        out$1.append(out$1.nonEmpty() ? "\n" : "").append(binder.name()).append(": ").append(binder.tpeString()).append(" = ");
        Printing$.MODULE$.print(binder.value(), out$1, $this.settings.screenWidth(), $this.settings.screenHeight());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$renderSummary$1(boolean isSingle$1, StringBuilder out$2, int margin$1, boolean x0$1, Binder x1$1) {
        boolean bl;
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x0$1), (Object)x1$1);
        if (tuple2 != null && (bl = tuple2._1$mcZ$sp())) {
            return true;
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        boolean bl2 = tuple2._1$mcZ$sp();
        Binder binder = (Binder)tuple2._2();
        if (false != bl2) throw new MatchError((Object)tuple2);
        Object object2 = !isSingle$1 ? out$2.append(out$2.isEmpty() ? "" : ", ").append(binder.name()).append(": ").append(binder.tpeString()).append(" = ") : BoxedUnit.UNIT;
        object2 = isSingle$1 ? out$2.append(": ").append(binder.tpeString()).append(" = ") : BoxedUnit.UNIT;
        Printing$.MODULE$.printOneLine(binder.value(), out$2, margin$1 - out$2.length());
        if (out$2.length() <= margin$1) return false;
        return true;
    }

    public WorksheetProvider(Settings settings) {
        this.settings = settings;
        this.reporter = new StoreReporter();
        this.minimumMargin = 20;
    }
}

