/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.cli;

import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.hashing.FileHash;
import io.methvin.watcher.hashing.FileHasher;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mdoc.Reporter;
import mdoc.internal.cli.Context;
import mdoc.internal.cli.Exit;
import mdoc.internal.cli.Exit$;
import mdoc.internal.cli.FileException;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.InputFile$;
import mdoc.internal.cli.MainOps$;
import mdoc.internal.cli.Messages$;
import mdoc.internal.cli.Settings;
import mdoc.internal.cli.Timer;
import mdoc.internal.io.IO$;
import mdoc.internal.io.MdocFileListener;
import mdoc.internal.io.MdocFileListener$;
import mdoc.internal.livereload.LiveReload;
import mdoc.internal.livereload.UndertowLiveReload;
import mdoc.internal.livereload.UndertowLiveReload$;
import mdoc.internal.markdown.DocumentLinks;
import mdoc.internal.markdown.DocumentLinks$;
import mdoc.internal.markdown.LinkHygiene$;
import mdoc.internal.markdown.Markdown$;
import mdoc.internal.pos.DiffUtils$;
import metaconfig.Configured;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.meta.inputs.Input;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public final class MainOps {
    private final Context context;
    private Option<LiveReload> livereload;
    private final Map hashes;

    public static int process(Configured<Settings> configured, Reporter reporter) {
        return MainOps$.MODULE$.process(configured, reporter);
    }

    public MainOps(Context context) {
        this.context = context;
        this.livereload = None$.MODULE$;
        this.hashes = (Map)Map$.MODULE$.empty();
    }

    public Settings settings() {
        return this.context.settings();
    }

    public Reporter reporter() {
        return this.context.reporter();
    }

    private void startLivereload() {
        if (!this.settings().noLivereload()) {
            List list = this.settings().out();
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                this.reporter().error("Can't start LiveReload server since --out is empty. To fix this problem, specify an --out argument.");
            } else if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                AbsolutePath out = (AbsolutePath)colon2.head();
                List tail = list3;
                if (tail.nonEmpty()) {
                    this.reporter().warning("Starting LiveReload server at directory " + out + " and ignoring --out value(s) " + tail.mkString(", ") + ". " + "To LiveReload another directory, place that directory as the first --out argument.");
                }
                UndertowLiveReload livereload = UndertowLiveReload$.MODULE$.apply(out.toNIO(), this.settings().host(), this.settings().port(), this.reporter(), UndertowLiveReload$.MODULE$.apply$default$5());
                livereload.start();
                this.livereload = Some$.MODULE$.apply((Object)livereload);
            } else {
                throw new MatchError((Object)list);
            }
        }
    }

    public void lint() {
        this.settings().out().foreach((Function1)(JProcedure1 & Serializable)out -> {
            if (out.isDirectory() && !this.settings().noLinkHygiene()) {
                List<DocumentLinks> docs = DocumentLinks$.MODULE$.fromGeneratedSite(this.settings(), this.reporter());
                LinkHygiene$.MODULE$.lint(docs, this.reporter(), this.settings().verbose());
            }
        });
    }

    public Exit handleMarkdown(InputFile file) {
        Exit exit;
        MainOps mainOps = this;
        synchronized (mainOps) {
            boolean fileHasErrors;
            int originalErrors = this.reporter().errorCount();
            if (this.settings().verbose()) {
                this.reporter().info("Compiling " + file.inputFile());
            }
            Timer timer = new Timer();
            String source = FileIO$.MODULE$.slurp(file.inputFile(), this.settings().charset());
            Input.VirtualFile input = scala.meta.package$.MODULE$.Input().VirtualFile().apply(file.inputFile().toString(), source);
            String md = Markdown$.MODULE$.toMarkdown((Input)input, this.context, file, (scala.collection.immutable.Map<String, String>)this.settings().site(), this.reporter(), this.settings());
            boolean bl = fileHasErrors = this.reporter().errorCount() > originalErrors;
            if (!fileHasErrors) {
                this.writePath(file, md);
                if (this.settings().verbose()) {
                    this.reporter().info(StringOps$.MODULE$.format$extension("  done => %s (%s)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{file.outputFile(), timer})));
                }
                this.livereload.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.reload(file.outputFile().toNIO()));
            }
            exit = this.reporter().hasErrors() ? Exit$.MODULE$.error() : Exit$.MODULE$.success();
        }
        return exit;
    }

    public Exit handleRegularFile(InputFile file) {
        Files.createDirectories(file.outputFile().toNIO().getParent(), new FileAttribute[0]);
        Files.copy(file.inputFile().toNIO(), file.outputFile().toNIO(), StandardCopyOption.REPLACE_EXISTING);
        if (this.settings().verbose()) {
            this.reporter().info("Copied    " + file.outputFile().toNIO());
        }
        return Exit$.MODULE$.success();
    }

    public Exit handleFile(InputFile file) {
        Exit exit;
        try {
            if (!this.settings().isIncluded(file.relpath())) {
                exit = Exit$.MODULE$.success();
            } else {
                String extension = PathIO$.MODULE$.extension(file.inputFile().toNIO());
                exit = this.settings().isMarkdownFileExtension().apply((Object)extension) ? this.handleMarkdown(file) : this.handleRegularFile(file);
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                new FileException(file.inputFile(), e).printStackTrace();
                exit = Exit$.MODULE$.error();
            }
            throw throwable;
        }
        return exit;
    }

    public void writePath(InputFile file, String string) {
        if (this.settings().check()) {
            String expected;
            if (!file.outputFile().isFile()) {
                return;
            }
            String string2 = expected = FileIO$.MODULE$.slurp(file.outputFile(), this.settings().charset());
            String string3 = string;
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                String filename = file.outputFile().toString();
                String diff = DiffUtils$.MODULE$.unifiedDiff("" + filename + " (on disk)", "" + filename + " (expected output)", (List<String>)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(expected)).toList(), (List<String>)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(string)).toList(), 3);
                this.reporter().error("--test failed! To fix this problem, re-generate the documentation\n" + diff);
            }
        } else if (file.outputFile().isDirectory()) {
            this.reporter().error("can't write output file '" + file.outputFile() + "' because it's a directory. " + "To fix this problem, either remove this directory or point the --out argument to another path.");
        } else {
            Files.createDirectories(file.outputFile().toNIO().getParent(), new FileAttribute[0]);
            Files.write(file.outputFile().toNIO(), string.getBytes(this.settings().charset()), new OpenOption[0]);
        }
    }

    public Exit generateCompleteSite() {
        List files = (List)IO$.MODULE$.inputFiles(this.settings()).sorted(InputFile$.MODULE$.ordering());
        Timer timer = new Timer();
        int n = files.length();
        this.compilingFiles(n);
        Exit exit = (Exit)files.foldLeft((Object)Exit$.MODULE$.success(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Exit accum = (Exit)tuple2._1();
            InputFile file = (InputFile)tuple2._2();
            Exit fileExit = this.handleFile(file);
            return accum.merge(fileExit);
        });
        this.lint();
        if (files.isEmpty()) {
            this.reporter().error("no input files: " + this.settings().in());
        } else {
            this.compiledFiles(n, timer);
        }
        return exit;
    }

    /*
     * WARNING - void declaration
     */
    public Exit run() {
        Exit exit;
        this.settings().out().foreach((Function1)(JProcedure1 & Serializable)out -> {
            if (this.settings().cleanTarget() && Files.exists(out.toNIO(), new LinkOption[0])) {
                IO$.MODULE$.cleanTarget((AbsolutePath)out);
            }
        });
        if (this.settings().watch()) {
            this.startLivereload();
        }
        Exit isOk = this.generateCompleteSite();
        if (this.settings().isFileWatching()) {
            this.waitingForFileChanges();
            this.runFileWatcher();
            exit = Exit$.MODULE$.success();
        } else {
            void var1_1;
            exit = var1_1;
        }
        return exit;
    }

    public Map<Path, FileHash> hashes() {
        return this.hashes;
    }

    public void handleWatchEvent(DirectoryChangeEvent event) {
        AbsolutePath path = AbsolutePath$.MODULE$.apply(event.path(), AbsolutePath$.MODULE$.workingDirectory());
        Option option = this.settings().toInputFile(path);
        if (option instanceof Some) {
            InputFile inputFile = (InputFile)((Some)option).value();
            Map<Path, FileHash> map = this.hashes();
            synchronized (map) {
                BoxedUnit boxedUnit;
                Option oldHash = this.hashes().get((Object)event.path());
                FileHash newHash = FileHasher.DEFAULT_FILE_HASHER.hash(event.path());
                if (!oldHash.contains((Object)newHash)) {
                    String string = PathIO$.MODULE$.extension(event.path());
                    String string2 = "md";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.clearScreen();
                    }
                    this.hashes().put((Object)event.path(), (Object)newHash);
                    this.reporter().reset();
                    Timer timer = new Timer();
                    this.compilingFiles(1);
                    this.handleFile(inputFile);
                    this.lint();
                    this.compiledFiles(1, timer);
                    this.waitingForFileChanges();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
    }

    public void runFileWatcher() {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        MdocFileListener watcher = MdocFileListener$.MODULE$.create((List<AbsolutePath>)this.settings().in(), executor, System.in, (Function1<DirectoryChangeEvent, BoxedUnit>)(JProcedure1 & Serializable)event -> this.handleWatchEvent((DirectoryChangeEvent)event));
        watcher.watchUntilInterrupted();
        this.livereload.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.stop());
    }

    public void clearScreen() {
        Predef$.MODULE$.print((Object)"\u001b[H\u001b[2J");
    }

    public void waitingForFileChanges() {
        this.reporter().println("Waiting for file changes (press enter to interrupt)");
    }

    public void compiledFiles(int n, Timer timer) {
        String errors = Messages$.MODULE$.count("error", this.reporter().errorCount());
        String warnings = this.reporter().hasWarnings() ? ", " + Messages$.MODULE$.count("warning", this.reporter().warningCount()) : "";
        this.reporter().info("Compiled in " + timer + " (" + errors + warnings + ")");
    }

    public void compilingFiles(int n) {
        String files = Messages$.MODULE$.count("file", n);
        this.reporter().info("Compiling " + files + " to " + this.settings().out().mkString(", "));
    }
}

