/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import java.io.Serializable;
import mdoc.Reporter;
import mdoc.interfaces.ImportedScriptFile;
import mdoc.internal.cli.InputFile;
import mdoc.internal.markdown.FileImport$;
import mdoc.internal.markdown.Rename;
import mdoc.internal.pos.PositionSyntax$;
import mdoc.internal.pos.TokenEditDistance;
import mdoc.internal.pos.TokenEditDistance$;
import mdoc.internal.worksheets.ImportedScriptFile$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.meta.Importee;
import scala.meta.Importer;
import scala.meta.Importer$;
import scala.meta.Name;
import scala.meta.Term;
import scala.meta.inputs.Input;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class FileImport
implements Product,
Serializable {
    private final AbsolutePath path;
    private final Term qualifier;
    private final Name.Indeterminate importName;
    private final String objectName;
    private final String packageName;
    private final String source;
    private final List dependencies;
    private final List renames;
    private final String fullyQualifiedName;
    private final String prefix;
    private final Input toInput;
    private final Option edit;

    public static FileImport apply(AbsolutePath absolutePath, Term term, Name.Indeterminate indeterminate, String string, String string2, String string3, List<FileImport> list, List<Rename> list2) {
        return FileImport$.MODULE$.apply(absolutePath, term, indeterminate, string, string2, string3, list, list2);
    }

    public static FileImport fromProduct(Product product) {
        return FileImport$.MODULE$.fromProduct(product);
    }

    public static FileImport unapply(FileImport fileImport) {
        return FileImport$.MODULE$.unapply(fileImport);
    }

    public FileImport(AbsolutePath path, Term qualifier, Name.Indeterminate importName, String objectName, String packageName, String source, List<FileImport> dependencies, List<Rename> renames) {
        this.path = path;
        this.qualifier = qualifier;
        this.importName = importName;
        this.objectName = objectName;
        this.packageName = packageName;
        this.source = source;
        this.dependencies = dependencies;
        this.renames = renames;
        this.fullyQualifiedName = "" + packageName + "." + objectName;
        this.prefix = "package " + packageName + "; object " + objectName + " {";
        StringBuilder out = new StringBuilder().append(this.prefix());
        IntRef i = IntRef.create((int)0);
        ((List)renames.sortBy((Function1 & Serializable)_$1 -> _$1.from().start(), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)rename -> {
            int n;
            out.append(source, i$1.elem, rename.from().start()).append(rename.to());
            i$1.elem = n = rename.from().end();
        });
        out.append(source, i.elem, source.length()).append("\n}\n");
        this.toInput = Input.VirtualFile$.MODULE$.apply(path.syntax(), out.toString());
        this.edit = TokenEditDistance$.MODULE$.apply((Input)Input.VirtualFile$.MODULE$.apply(path.syntax(), source), this.toInput());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FileImport)) return false;
        FileImport fileImport = (FileImport)object;
        AbsolutePath absolutePath = this.path();
        AbsolutePath absolutePath2 = fileImport.path();
        if (absolutePath == null) {
            if (absolutePath2 != null) {
                return false;
            }
        } else if (!absolutePath.equals(absolutePath2)) return false;
        Term term = this.qualifier();
        Term term2 = fileImport.qualifier();
        if (term == null) {
            if (term2 != null) {
                return false;
            }
        } else if (!term.equals(term2)) return false;
        Name.Indeterminate indeterminate = this.importName();
        Name.Indeterminate indeterminate2 = fileImport.importName();
        if (indeterminate == null) {
            if (indeterminate2 != null) {
                return false;
            }
        } else if (!indeterminate.equals(indeterminate2)) return false;
        String string = this.objectName();
        String string2 = fileImport.objectName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.packageName();
        String string4 = fileImport.packageName();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.source();
        String string6 = fileImport.source();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        List<FileImport> list = this.dependencies();
        List<FileImport> list2 = fileImport.dependencies();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        List<Rename> list3 = this.renames();
        List<Rename> list4 = fileImport.renames();
        if (list3 == null) {
            if (list4 == null) return true;
            return false;
        } else {
            if (!list3.equals(list4)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof FileImport;
    }

    public int productArity() {
        return 8;
    }

    public String productPrefix() {
        return "FileImport";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            case 4: {
                object = this._5();
                break;
            }
            case 5: {
                object = this._6();
                break;
            }
            case 6: {
                object = this._7();
                break;
            }
            case 7: {
                object = this._8();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "path";
                break;
            }
            case 1: {
                string = "qualifier";
                break;
            }
            case 2: {
                string = "importName";
                break;
            }
            case 3: {
                string = "objectName";
                break;
            }
            case 4: {
                string = "packageName";
                break;
            }
            case 5: {
                string = "source";
                break;
            }
            case 6: {
                string = "dependencies";
                break;
            }
            case 7: {
                string = "renames";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public AbsolutePath path() {
        return this.path;
    }

    public Term qualifier() {
        return this.qualifier;
    }

    public Name.Indeterminate importName() {
        return this.importName;
    }

    public String objectName() {
        return this.objectName;
    }

    public String packageName() {
        return this.packageName;
    }

    public String source() {
        return this.source;
    }

    public List<FileImport> dependencies() {
        return this.dependencies;
    }

    public List<Rename> renames() {
        return this.renames;
    }

    public String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public String prefix() {
        return this.prefix;
    }

    public Input toInput() {
        return this.toInput;
    }

    public Option<TokenEditDistance> edit() {
        return this.edit;
    }

    public ImportedScriptFile toInterface() {
        return ImportedScriptFile$.MODULE$.apply(this.path().toNIO(), this.packageName(), this.objectName(), this.toInput().text(), this.source(), PositionSyntax$.MODULE$.SeqHasAsJava((Seq)this.dependencies().map((Function1 & Serializable)_$2 -> _$2.toInterface())).asJava());
    }

    public FileImport copy(AbsolutePath path, Term qualifier, Name.Indeterminate importName, String objectName, String packageName, String source, List<FileImport> dependencies, List<Rename> renames) {
        return new FileImport(path, qualifier, importName, objectName, packageName, source, dependencies, renames);
    }

    public AbsolutePath copy$default$1() {
        return this.path();
    }

    public Term copy$default$2() {
        return this.qualifier();
    }

    public Name.Indeterminate copy$default$3() {
        return this.importName();
    }

    public String copy$default$4() {
        return this.objectName();
    }

    public String copy$default$5() {
        return this.packageName();
    }

    public String copy$default$6() {
        return this.source();
    }

    public List<FileImport> copy$default$7() {
        return this.dependencies();
    }

    public List<Rename> copy$default$8() {
        return this.renames();
    }

    public AbsolutePath _1() {
        return this.path();
    }

    public Term _2() {
        return this.qualifier();
    }

    public Name.Indeterminate _3() {
        return this.importName();
    }

    public String _4() {
        return this.objectName();
    }

    public String _5() {
        return this.packageName();
    }

    public String _6() {
        return this.source();
    }

    public List<FileImport> _7() {
        return this.dependencies();
    }

    public List<Rename> _8() {
        return this.renames();
    }

    public static class Matcher {
        private final InputFile file;
        private final Reporter reporter;

        public Matcher(InputFile file, Reporter reporter) {
            this.file = file;
            this.reporter = reporter;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Option<List<FileImport>> unapply(Importer importer) {
            None$ none$;
            Option option;
            Importer importer2 = importer;
            if (importer2 != null && !(option = Importer$.MODULE$.unapply(importer2)).isEmpty()) {
                Tuple2 tuple2 = (Tuple2)option.get();
                Term.Ref qual = (Term.Ref)tuple2._1();
                List importees = (List)tuple2._2();
                Importer importer3 = importer2;
                if (this.isFileQualifier((Term)qual)) {
                    List<Option<FileImport>> parsed = FileImport$.MODULE$.mdoc$internal$markdown$FileImport$$$fromImportees(this.file.inputFile(), (Term)qual, (List<Importee>)importees, this.reporter);
                    if (parsed.forall((Function1 & Serializable)_$3 -> _$3.isDefined())) {
                        none$ = Some$.MODULE$.apply((Object)parsed.map((Function1 & Serializable)_$4 -> (FileImport)_$4.get()));
                        return none$;
                    }
                    none$ = None$.MODULE$;
                    return none$;
                }
            }
            none$ = None$.MODULE$;
            return none$;
        }

        private boolean isFileQualifier(Term qual) {
            boolean bl;
            block2: {
                Matcher matcher = this;
                Term term = qual;
                while (true) {
                    Option option;
                    String string;
                    Option option2;
                    Term term2;
                    if ((term2 = term) instanceof Term.Name && !(option2 = Term.Name$.MODULE$.unapply((Term.Name)term2)).isEmpty() && "$file".equals(string = (String)option2.get())) {
                        bl = true;
                        break block2;
                    }
                    if (!(term2 instanceof Term.Select) || (option = Term.Select$.MODULE$.unapply((Term.Select)term2)).isEmpty()) break;
                    Tuple2 tuple2 = (Tuple2)option.get();
                    Term next = (Term)tuple2._1();
                    Matcher matcher2 = matcher;
                    Term term3 = next;
                    matcher = matcher2;
                    term = term3;
                }
                bl = false;
            }
            return bl;
        }
    }
}

