/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.io;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.Settings;
import scala.Function1;
import scala.Function2;
import scala.collection.immutable.List;
import scala.collection.mutable.Builder;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class IO$
implements Serializable {
    private static final SimpleFileVisitor deleteVisitor;
    public static final IO$ MODULE$;

    private IO$() {
    }

    static {
        MODULE$ = new IO$();
        deleteVisitor = new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IO$.class);
    }

    public void foreachOutput(Settings settings, Function2<AbsolutePath, RelativePath, BoxedUnit> fn) {
        settings.out().foreach((Function1 & Serializable)root -> Files.walkFileTree(root.toNIO(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(settings, fn, root){
            private final Settings settings$1;
            private final Function2 fn$1;
            private final AbsolutePath root$1;
            {
                this.settings$1 = settings$6;
                this.fn$1 = fn$6;
                this.root$1 = root$3;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                AbsolutePath path = AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory());
                RelativePath relpath = path.toRelative(this.root$1);
                if (!this.settings$1.isExplicitlyExcluded(relpath)) {
                    this.fn$1.apply((Object)path, (Object)relpath);
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                RelativePath relpath = AbsolutePath$.MODULE$.apply(dir, AbsolutePath$.MODULE$.workingDirectory()).toRelative(this.root$1);
                return this.settings$1.isExplicitlyExcluded(relpath) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }
        }));
    }

    public List<InputFile> inputFiles(Settings settings) {
        Builder buf = package$.MODULE$.List().newBuilder();
        this.foreachInputFile(settings, (Function1<InputFile, BoxedUnit>)(JProcedure1 & Serializable)_$1 -> buf.$plus$eq(_$1));
        return (List)buf.result();
    }

    public void foreachInputFile(Settings settings, Function1<InputFile, BoxedUnit> fn) {
        AbsolutePath cwd = settings.cwd();
        settings.in().foreach((Function1)(JProcedure1 & Serializable)root -> {
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(settings, fn, cwd, root){
                private final Settings settings$1;
                private final Function1 fn$1;
                private final AbsolutePath cwd$1;
                private final AbsolutePath root$1;
                {
                    this.settings$1 = settings$7;
                    this.fn$1 = fn$7;
                    this.cwd$1 = cwd$3;
                    this.root$1 = root$4;
                }

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    IO$.MODULE$.mdoc$internal$io$IO$$$_$handle$1(this.settings$1, this.fn$1, AbsolutePath$.MODULE$.apply(file, this.cwd$1));
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    RelativePath relpath = RelativePath$.MODULE$.apply(this.root$1.toNIO().relativize(dir));
                    return this.settings$1.isExplicitlyExcluded(relpath) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
                }
            };
            if (root.isFile()) {
                this.mdoc$internal$io$IO$$$_$handle$1(settings, (Function1)fn, (AbsolutePath)root);
            } else if (root.isDirectory()) {
                Files.walkFileTree(root.toNIO(), (FileVisitor<? super Path>)visitor);
            }
        });
    }

    public SimpleFileVisitor<Path> deleteVisitor() {
        return deleteVisitor;
    }

    public void cleanTarget(AbsolutePath dir) {
        Files.walkFileTree(dir.toNIO(), this.deleteVisitor());
    }

    public final void mdoc$internal$io$IO$$$_$handle$1(Settings settings$3, Function1 fn$3, AbsolutePath file) {
        settings$3.toInputFile(file).foreach(fn$3);
    }
}

