/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import java.io.Serializable;
import java.net.URI;
import mdoc.Reporter;
import mdoc.internal.markdown.DocumentLinks;
import metaconfig.internal.Levenshtein$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class LinkHygiene$
implements Serializable {
    public static final LinkHygiene$ MODULE$ = new LinkHygiene$();

    private LinkHygiene$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LinkHygiene$.class);
    }

    public void lint(List<DocumentLinks> docs, Reporter reporter, boolean verbose) {
        Set isValidHeading = docs.iterator().flatMap((Function1 & Serializable)_$1 -> _$1.absoluteDefinitions()).toSet();
        docs.map((Function1 & Serializable)doc -> {
            URI enclosingDocument = doc.relpath().toURI(false);
            return Tuple2$.MODULE$.apply(doc, (Object)enclosingDocument);
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DocumentLinks doc = (DocumentLinks)tuple2._1();
            URI enclosingDocument = (URI)tuple2._2();
            doc.references().foreach((Function1)(JProcedure1 & Serializable)reference -> this.resolve(enclosingDocument, reference.url()).withFilter((Function1 & Serializable)uri -> uri.getScheme() == null && uri.getHost() == null).withFilter((Function1 & Serializable)uri -> !isValidHeading.apply(uri)).foreach((Function1)(JProcedure1 & Serializable)uri -> {
                String string;
                String string2;
                boolean isAbsolutePath = uri.getPath().startsWith("/");
                if (verbose) {
                    String headings = ((IterableOnceOps)((IterableOnceOps)isValidHeading.map((Function1 & Serializable)_$2 -> _$2.toString())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n  ");
                    string2 = "\nisValidHeading:\n  " + headings;
                } else {
                    string2 = "";
                }
                String debug = string2;
                Seq candidates = ((IterableOnceOps)isValidHeading.map((Function1 & Serializable)_$3 -> _$3.toString())).toSeq();
                Option<String> option = this.closestCandidate(uri.toString(), (Seq<String>)candidates);
                if (None$.MODULE$.equals(option)) {
                    string = ".";
                } else if (option instanceof Some) {
                    String similar = (String)((Some)option).value();
                    string = ", did you mean '" + similar + "'?";
                } else {
                    throw new MatchError(option);
                }
                String help = string;
                String hint = isAbsolutePath ? " To fix this problem, either make the link relative or turn it into complete URL such as http://example.com" + uri + "." : "";
                reporter.warning(reference.pos(), "Unknown link '" + uri + "'" + help + hint + debug);
            }));
        });
    }

    public Option<String> closestCandidate(String query, Seq<String> candidates) {
        Object object;
        if (candidates.isEmpty()) {
            object = None$.MODULE$;
        } else {
            String candidate = (String)((IterableOps)candidates.sortBy((Function1 & Serializable)s2 -> Levenshtein$.MODULE$.distance(query, s2), (Ordering)Ordering.Int$.MODULE$)).head();
            int maxLength = query.length() + candidate.length();
            int minDifference = package$.MODULE$.abs(query.length() - candidate.length());
            double difference = (double)Levenshtein$.MODULE$.distance(candidate, query) - (double)minDifference;
            double ratio = ((double)maxLength - difference) / (double)maxLength;
            object = ratio > 0.9 ? Some$.MODULE$.apply((Object)candidate) : None$.MODULE$;
        }
        return object;
    }

    private Option<URI> resolve(URI baseUri, String reference) {
        None$ none$;
        try {
            none$ = Some$.MODULE$.apply((Object)baseUri.resolve(reference).normalize());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }
}

