/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import java.io.Serializable;
import mdoc.PostModifier;
import mdoc.PreModifier;
import mdoc.StringModifier;
import mdoc.internal.cli.Context;
import mdoc.internal.markdown.CodeFence;
import mdoc.internal.markdown.Mod;
import mdoc.internal.markdown.Modifier;
import mdoc.internal.markdown.Modifier$;
import mdoc.internal.markdown.ScalaFenceInput;
import mdoc.internal.markdown.ScalaFenceInput$;
import mdoc.internal.markdown.Text;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;

public class FenceInput {
    private final Context ctx;
    private final Input baseInput;

    public FenceInput(Context ctx, Input baseInput) {
        this.ctx = ctx;
        this.baseInput = baseInput;
    }

    public Option<Modifier> getModifier(Text info) {
        None$ none$;
        String string = StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(info.value()));
        if (!string.startsWith("scala mdoc")) {
            none$ = None$.MODULE$;
        } else if (!StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(string), ':')) {
            none$ = Some$.MODULE$.apply((Object)Modifier.Default$.MODULE$.apply());
        } else {
            String mode = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(string), "scala mdoc:");
            none$ = Modifier$.MODULE$.apply(mode).orElse(() -> this.getModifier$$anonfun$1(mode)).orElse(() -> this.getModifier$$anonfun$2(info, mode));
        }
        return none$;
    }

    private void invalid(Text info, String message) {
        int offset = "scala mdoc:".length();
        int start = info.pos().start() + offset;
        int end = info.pos().end() - 1;
        Position.Range pos = Position.Range$.MODULE$.apply(this.baseInput, start, end);
        this.ctx.reporter().error((Position)pos, message);
    }

    private boolean invalidCombination(Text info, String mod1, String mod2) {
        this.invalid(info, new StringBuilder(42).append("invalid combination of modifiers '").append(mod1).append("' and '").append(mod2).append("'").toString());
        return false;
    }

    private boolean isValid(Text info, Modifier mod) {
        boolean bl;
        if (mod.isFailOrWarn() && mod.isCrash()) {
            bl = this.invalidCombination(info, "crash", "fail");
        } else if (mod.isSilent() && mod.isInvisible()) {
            bl = this.invalidCombination(info, "silent", "invisible");
        } else if (mod.isReset() && mod.isNest()) {
            this.invalid(info, "the modifier 'nest' is redundant when used in combination with 'reset'. To fix this error, remove 'nest'");
            bl = false;
        } else if (mod.isCompileOnly()) {
            Set others = (Set)mod.mods().$minus((Object)Mod.CompileOnly$.MODULE$);
            if (others.isEmpty()) {
                bl = true;
            } else {
                String all = ((IterableOnceOps)others.map((Function1 & Serializable)_$1 -> _$1.toString().toLowerCase())).mkString(", ");
                this.invalid(info, new StringBuilder(48).append("compile-only cannot be used in combination with ").append(all).toString());
                bl = false;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public Option<ScalaFenceInput> unapply(CodeFence block) {
        None$ none$;
        Option<Modifier> option = this.getModifier(block.info());
        if (option instanceof Some) {
            Modifier mod = (Modifier)((Some)option).value();
            if (this.isValid(block.info(), mod)) {
                Input.Slice input = Input.Slice$.MODULE$.apply(this.baseInput, block.body().pos().start(), block.body().pos().end());
                none$ = Some$.MODULE$.apply((Object)ScalaFenceInput$.MODULE$.apply(block, (Input)input, mod));
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private final Option getModifier$$anonfun$3$$anonfun$1(String name$2, String info$2) {
        return this.ctx.settings().postModifiers().collectFirst((PartialFunction)new Serializable(name$2, info$2){
            private final String name$1;
            private final String info$1;
            {
                this.name$1 = name$7;
                this.info$1 = info$8;
            }

            public final boolean isDefinedAt(PostModifier x) {
                PostModifier postModifier;
                PostModifier mod = postModifier = x;
                String string = mod.name();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }

            public final Object applyOrElse(PostModifier x, Function1 function1) {
                PostModifier postModifier;
                PostModifier mod = postModifier = x;
                String string = mod.name();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null) ? Modifier.Post$.MODULE$.apply(mod, this.info$1) : function1.apply((Object)x);
            }
        });
    }

    private final Option getModifier$$anonfun$4$$anonfun$2(String name$4, String info$4) {
        return this.ctx.settings().preModifiers().collectFirst((PartialFunction)new Serializable(name$4, info$4){
            private final String name$1;
            private final String info$1;
            {
                this.name$1 = name$8;
                this.info$1 = info$9;
            }

            public final boolean isDefinedAt(PreModifier x) {
                PreModifier preModifier;
                PreModifier mod = preModifier = x;
                String string = mod.name();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }

            public final Object applyOrElse(PreModifier x, Function1 function1) {
                PreModifier preModifier;
                PreModifier mod = preModifier = x;
                String string = mod.name();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null) ? Modifier.Pre$.MODULE$.apply(mod, this.info$1) : function1.apply((Object)x);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Option getModifier$$anonfun$1(String mode$1) {
        Tuple2 tuple2;
        String[] stringArray = mode$1.split(":", 2);
        if (stringArray == null) throw new MatchError((Object)stringArray);
        Object object = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 1) == 0) {
            String string;
            String a = string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            tuple2 = Tuple2$.MODULE$.apply((Object)a, (Object)"");
        } else {
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 2) != 0) throw new MatchError((Object)stringArray);
            String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String a = string;
            String b = string2;
            tuple2 = Tuple2$.MODULE$.apply((Object)a, (Object)b);
        }
        Tuple2 tuple22 = tuple2;
        String name = (String)tuple22._1();
        String info = (String)tuple22._2();
        return this.ctx.settings().stringModifiers().collectFirst((PartialFunction)new Serializable(name, info){
            private final String name$1;
            private final String info$1;
            {
                this.name$1 = name$6;
                this.info$1 = info$7;
            }

            public final boolean isDefinedAt(StringModifier x) {
                StringModifier stringModifier;
                StringModifier mod = stringModifier = x;
                String string = mod.name();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }

            public final Object applyOrElse(StringModifier x, Function1 function1) {
                StringModifier stringModifier;
                StringModifier mod = stringModifier = x;
                String string = mod.name();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null) ? Modifier.Str$.MODULE$.apply(mod, this.info$1) : function1.apply((Object)x);
            }
        }).orElse(() -> this.getModifier$$anonfun$3$$anonfun$1(name, info)).orElse(() -> this.getModifier$$anonfun$4$$anonfun$2(name, info));
    }

    private final None$ getModifier$$anonfun$2(Text info$6, String mode$2) {
        this.invalid(info$6, new StringBuilder(15).append("Invalid mode '").append(mode$2).append("'").toString());
        return None$.MODULE$;
    }
}

