/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import mdoc.Reporter;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.Settings;
import mdoc.internal.markdown.CodePrinter;
import mdoc.internal.markdown.CodePrinter$;
import mdoc.internal.markdown.FailInstrumenter;
import mdoc.internal.markdown.FileImport;
import mdoc.internal.markdown.Gensym;
import mdoc.internal.markdown.Instrumented;
import mdoc.internal.markdown.Instrumented$;
import mdoc.internal.markdown.Instrumenter$;
import mdoc.internal.markdown.Instrumenter$Binders$;
import mdoc.internal.markdown.MagicImports;
import mdoc.internal.markdown.Modifier;
import mdoc.internal.markdown.SectionInput;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.meta.Dialect$;
import scala.meta.Import;
import scala.meta.Importer;
import scala.meta.Name;
import scala.meta.Name$;
import scala.meta.Term;
import scala.meta.Tree;
import scala.meta.Tree$;
import scala.meta.inputs.Position;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class Instrumenter {
    private final List<SectionInput> sections;
    private final Reporter reporter;
    private final MagicImports magic;
    private final ByteArrayOutputStream out;
    private final Gensym gensym;
    private final CodePrinter sb;

    public static Set<String> magicImports() {
        return Instrumenter$.MODULE$.magicImports();
    }

    public static String position(Position position) {
        return Instrumenter$.MODULE$.position(position);
    }

    public static String reset(Modifier modifier, String string) {
        return Instrumenter$.MODULE$.reset(modifier, string);
    }

    public static String stringLiteral(String string) {
        return Instrumenter$.MODULE$.stringLiteral(string);
    }

    public static String wrapBody(String string) {
        return Instrumenter$.MODULE$.wrapBody(string);
    }

    public Instrumenter(InputFile file, List<SectionInput> sections, Settings settings, Reporter reporter) {
        this.sections = sections;
        this.reporter = reporter;
        this.magic = new MagicImports(settings, reporter, file);
        this.out = new ByteArrayOutputStream();
        this.gensym = new Gensym();
        this.sb = new CodePrinter(new PrintStream(this.out), CodePrinter$.MODULE$.$lessinit$greater$default$2(), CodePrinter$.MODULE$.$lessinit$greater$default$3());
    }

    public Instrumented instrument() {
        this.printAsScript();
        return Instrumented$.MODULE$.fromSource(this.out.toString(), (List<Name.Indeterminate>)this.magic().scalacOptions().toList(), (List<Name.Indeterminate>)this.magic().dependencies().toList(), (List<Name.Indeterminate>)this.magic().repositories().toList(), (List<FileImport>)this.magic().files().values().toList(), this.reporter);
    }

    public MagicImports magic() {
        return this.magic;
    }

    public Gensym gensym() {
        return this.gensym;
    }

    public CodePrinter sb() {
        return this.sb;
    }

    private void printAsScript() {
        ((List)this.sections.zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
            Object object;
            Object object2;
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            SectionInput section = (SectionInput)tuple2._1();
            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
            if (section.mod().isReset()) {
                this.sb().unnest();
                object2 = this.sb().println(Instrumenter$.MODULE$.reset(section.mod(), this.gensym().fresh("App", this.gensym().fresh$default$2())));
            } else if (section.mod().isNest()) {
                this.sb().nest();
                object2 = BoxedUnit.UNIT;
            } else {
                object2 = BoxedUnit.UNIT;
            }
            this.sb().println("$doc.startSection();");
            if (section.mod().isFailOrWarn()) {
                this.sb().println(new java.lang.StringBuilder(22).append("$doc.startStatement(").append(Instrumenter$.MODULE$.position(section.source().pos())).append(");").toString());
                String out = new FailInstrumenter(this.sections, i).instrument();
                String literal = Instrumenter$.MODULE$.stringLiteral(out);
                String binder = this.gensym().fresh("res", this.gensym().fresh$default$2());
                this.sb().line((Function1<StringBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$1 -> _$1.append("val ").append(binder).append(" = _root_.mdoc.internal.document.FailSection(").append(literal).append(", ").append(Instrumenter$.MODULE$.position(section.source().pos())).append(");"));
                this.printBinder(binder, section.source().pos());
                object = this.sb().println("$doc.endStatement();");
                return this.sb().println("$doc.endSection();");
            } else if (section.mod().isCompileOnly()) {
                section.source().stats().foreach((Function1 & Serializable)stat -> {
                    this.sb().println(new java.lang.StringBuilder(22).append("$doc.startStatement(").append(Instrumenter$.MODULE$.position(stat.pos())).append(");").toString());
                    return this.sb().println("$doc.endStatement();");
                });
                object = this.sb().definition(new java.lang.StringBuilder(7).append("object ").append(this.gensym().fresh("compile", this.gensym().fresh$default$2())).toString(), (Function1<CodePrinter, BoxedUnit>)(JProcedure1 & Serializable)_$2 -> _$2.appendLines(section.source().pos().text(), _$2.appendLines$default$2()));
                return this.sb().println("$doc.endSection();");
            } else if (section.mod().isCrash()) {
                List<Tree> list = section.source().stats();
                if (list instanceof .colon.colon) {
                    List list2 = ((.colon.colon)list).next$access$1();
                    Tree head = (Tree)((.colon.colon)list).head();
                    this.sb().println(new java.lang.StringBuilder(22).append("$doc.startStatement(").append(Instrumenter$.MODULE$.position(head.pos())).append(");").toString());
                    this.sb().definition(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("$doc.crash("), Instrumenter$.MODULE$.position(head.pos()))), ")"), (Function1<CodePrinter, BoxedUnit>)(JProcedure1 & Serializable)cb -> section.source().stats().foreach((Function1 & Serializable)stat -> cb.appendLines(stat.pos().text(), cb.appendLines$default$2())));
                    this.sb().println("\n");
                    object = this.sb().println("$doc.endStatement();");
                    return this.sb().println("$doc.endSection();");
                } else {
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List<Tree> list3 = list;
                    if (nil$ != null ? !nil$.equals(list3) : list3 != null) throw new MatchError(list);
                    object = BoxedUnit.UNIT;
                }
                return this.sb().println("$doc.endSection();");
            } else {
                section.source().stats().foreach((Function1 & Serializable)stat -> {
                    this.sb().println(new java.lang.StringBuilder(22).append("$doc.startStatement(").append(Instrumenter$.MODULE$.position(stat.pos())).append(");").toString());
                    this.printStatement((Tree)stat, section.mod(), this.sb());
                    return this.sb().println("$doc.endStatement();");
                });
                object = BoxedUnit.UNIT;
            }
            return this.sb().println("$doc.endSection();");
        });
        this.sb().unnest();
    }

    private void printBinder(String name, Position pos) {
        this.sb().println(new java.lang.StringBuilder(16).append("$doc.binder(").append(name).append(", ").append(Instrumenter$.MODULE$.position(pos)).append(");").toString());
    }

    private void printStatement(Tree stat, Modifier m, CodePrinter sb) {
        if (!m.isCrash()) {
            Object object;
            Tuple2 tuple2;
            Option<List<Name>> option;
            Tree tree = stat;
            if (tree != null && !(option = Instrumenter$Binders$.MODULE$.unapply(tree)).isEmpty()) {
                List list;
                List names = list = (List)option.get();
                tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)names.map((Function1 & Serializable)name -> {
                    Name name2 = (Name)Predef$.MODULE$.ArrowAssoc(name);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)name2, (Object)name.pos());
                }));
            } else if (tree instanceof Term.EndMarker) {
                tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)package$.MODULE$.Nil());
            } else {
                String fresh = this.gensym().fresh("res", this.gensym().fresh$default$2());
                sb.line((Function1<StringBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$3 -> _$3.append(new java.lang.StringBuilder(7).append("val ").append(fresh).append(" = ").toString()));
                Object[] objectArray = new Tuple2[1];
                Name name2 = (Name)Predef$.MODULE$.ArrowAssoc((Object)Name$.MODULE$.apply(fresh));
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)name2, (Object)stat.pos());
                tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            }
            Tuple2 tuple22 = tuple2;
            boolean fresh = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
            List binders = (List)tuple22._2();
            Tree tree2 = stat;
            if (tree2 instanceof Import) {
                Import i = (Import)tree2;
                i.importers().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    block2: {
                        Importer importer;
                        block0: {
                            block1: {
                                importer = x$1;
                                if (importer == null) break block0;
                                Option<List<FileImport>> option = this.magic().Printable().unapply(importer);
                                if (option.isEmpty()) break block1;
                                List list = (List)option.get();
                                Importer importer2 = importer;
                                Instrumenter.printImporter$2(sb, importer2);
                                break block2;
                            }
                            if (this.magic().NonPrintable().unapply(importer)) break block2;
                        }
                        Importer importer3 = importer;
                        Instrumenter.printImporter$2(sb, importer3);
                    }
                });
                object = BoxedUnit.UNIT;
            } else {
                object = tree2 instanceof Term.EndMarker ? BoxedUnit.UNIT : sb.appendLines(stat.pos().text(), fresh);
            }
            binders.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Name name = (Name)tuple2._1();
                Position pos = (Position)tuple2._2();
                this.printBinder(scala.meta.package$.MODULE$.XtensionSyntax((Object)name, Tree$.MODULE$.showSyntax(Dialect$.MODULE$.current())).syntax(), pos);
            });
        }
    }

    private static final void printImporter$2(CodePrinter sb$1, Importer importer) {
        sb$1.line((Function1<StringBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$4 -> _$4.append("import ").append(importer.pos().text()).append(";"));
    }
}

