/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.io;

import fansi.Str;
import fansi.Str$;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicBoolean;
import mdoc.Reporter;
import mdoc.internal.io.ConsoleColors;
import mdoc.internal.io.ConsoleReporter$;
import mdoc.internal.pos.PositionSyntax$;
import mdoc.internal.pos.PositionSyntax$XtensionPositionsScalafix$;
import scala.Function0;
import scala.meta.inputs.Position;
import scala.meta.package$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConsoleReporter
implements Reporter {
    private final PrintStream ps;
    private final Str myDebug;
    private final Str myInfo;
    private final Str myWarning;
    private final Str myError;
    private int myWarnings;
    private int myErrors;
    private final AtomicBoolean isDebugEnabled;

    public static Reporter default() {
        return ConsoleReporter$.MODULE$.default();
    }

    public static ConsoleColors $lessinit$greater$default$2() {
        return ConsoleReporter$.MODULE$.$lessinit$greater$default$2();
    }

    public ConsoleReporter(PrintStream ps, ConsoleColors colors) {
        this.ps = ps;
        this.myDebug = colors.green().apply(Str$.MODULE$.implicitApply((CharSequence)"debug"));
        this.myInfo = colors.blue().apply(Str$.MODULE$.implicitApply((CharSequence)"info"));
        this.myWarning = colors.yellow().apply(Str$.MODULE$.implicitApply((CharSequence)"warning"));
        this.myError = colors.red().apply(Str$.MODULE$.implicitApply((CharSequence)"error"));
        this.myWarnings = 0;
        this.myErrors = 0;
        this.isDebugEnabled = new AtomicBoolean(false);
    }

    public String formatMessage(Position pos, String severity, String message) {
        return PositionSyntax$XtensionPositionsScalafix$.MODULE$.formatMessage$extension(PositionSyntax$.MODULE$.XtensionPositionsScalafix(pos), "", message);
    }

    public int warningCount() {
        return this.myWarnings;
    }

    public int errorCount() {
        return this.myErrors;
    }

    public boolean hasWarnings() {
        return this.myWarnings > 0;
    }

    public boolean hasErrors() {
        return this.myErrors > 0;
    }

    public void reset() {
        this.myWarnings = 0;
        this.myErrors = 0;
    }

    public void error(Throwable throwable) {
        this.error((Position)package$.MODULE$.Position().None(), throwable);
    }

    public void error(Position pos, Throwable throwable) {
        this.error(pos, PositionSyntax$.MODULE$.XtensionThrowable(throwable).message());
        throwable.printStackTrace(this.ps);
    }

    public void error(Position pos, String msg) {
        this.error(this.formatMessage(PositionSyntax$.MODULE$.XtensionPositionMdoc(pos).toUnslicedPosition(), "error", msg));
    }

    public void error(String msg) {
        ++this.myErrors;
        this.ps.println(this.myError.$plus$plus(Str$.MODULE$.implicitApply((CharSequence)new StringBuilder(2).append(": ").append(msg).toString())));
    }

    public void warning(Position pos, String msg) {
        this.warning(this.formatMessage(PositionSyntax$.MODULE$.XtensionPositionMdoc(pos).toUnslicedPosition(), "warning", msg));
    }

    public void warning(String msg) {
        ++this.myWarnings;
        this.ps.println(this.myWarning.$plus$plus(Str$.MODULE$.implicitApply((CharSequence)new StringBuilder(2).append(": ").append(msg).toString())));
    }

    public void info(Position pos, String msg) {
        this.info(this.formatMessage(PositionSyntax$.MODULE$.XtensionPositionMdoc(pos).toUnslicedPosition(), "info", msg));
    }

    public void info(String msg) {
        this.ps.println(this.myInfo.$plus$plus(Str$.MODULE$.implicitApply((CharSequence)new StringBuilder(2).append(": ").append(msg).toString())));
    }

    public void debug(Function0 msg) {
        if (this.isDebugEnabled.get()) {
            this.ps.println(this.myDebug.$plus$plus(Str$.MODULE$.implicitApply((CharSequence)new StringBuilder(2).append(": ").append(msg.apply()).toString())));
        }
    }

    public void setDebugEnabled(boolean isDebugEnabled) {
        this.isDebugEnabled.set(isDebugEnabled);
    }

    public void print(String msg) {
        this.ps.print(msg);
    }

    public void println(String msg) {
        this.ps.println(msg);
    }
}

