/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import dotty.tools.dotc.Compiler;
import dotty.tools.dotc.Run;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.interactive.InteractiveDriver;
import dotty.tools.dotc.interfaces.SourcePosition;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.reporting.UniqueMessagePositions;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourceFile$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.VirtualDirectory;
import dotty.tools.repl.AbstractFileClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import mdoc.Reporter;
import mdoc.internal.markdown.CodeBuilder;
import mdoc.internal.markdown.FileImport;
import mdoc.internal.markdown.MarkdownCompiler$;
import mdoc.internal.pos.EmptyResult;
import mdoc.internal.pos.PositionSyntax$;
import mdoc.internal.pos.PositionSyntax$XtensionPositionsScalafix$;
import mdoc.internal.pos.TokenEditDistance;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.internal.inputs.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

public class MarkdownCompiler {
    private final String classpath;
    private final String scalacOptions;
    private final AbstractFile target;
    private Contexts.FreshContext context;
    private final URLClassLoader appClassLoader;

    public static AbstractFile $lessinit$greater$default$3() {
        return MarkdownCompiler$.MODULE$.$lessinit$greater$default$3();
    }

    public MarkdownCompiler(String classpath, String scalacOptions, AbstractFile target) {
        this.classpath = classpath;
        this.scalacOptions = scalacOptions;
        this.target = target;
        this.context = this.newContext();
        Object object = Predef$.MODULE$.refArrayOps((Object[])classpath.split(File.pathSeparator));
        URL[] appClasspath = (URL[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)path -> new File((String)path).toURI().toURL(), ClassTag$.MODULE$.apply(URL.class));
        this.appClassLoader = new URLClassLoader(appClasspath, this.getClass().getClassLoader());
    }

    public String scalacOptions() {
        return this.scalacOptions;
    }

    private Contexts.FreshContext newContext() {
        List defaultFlags = (List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-color:never", "-unchecked", "-deprecation", "-Ximport-suggestion-timeout", "0"}));
        List options = Predef$.MODULE$.wrapRefArray((Object[])this.scalacOptions().split("\\s+")).toList();
        List settings = scala.package$.MODULE$.Nil().$colon$colon((Object)this.classpath).$colon$colon((Object)"-classpath").$colon$colon$colon(defaultFlags).$colon$colon$colon(options);
        InteractiveDriver driver = new InteractiveDriver((List)settings.distinct());
        Contexts.FreshContext ctx = driver.currentCtx().fresh();
        return ctx.setReporter((dotty.tools.dotc.reporting.Reporter)new CollectionReporter(this)).setSetting(ctx.settings().outputDir(), (Object)this.target);
    }

    public void shutdown() {
    }

    public Seq<Path> classpathEntries() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])((String)Settings.Setting$.MODULE$.value(this.context.settings().classpath(), (Contexts.Context)this.context)).split(File.pathSeparator));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)url -> Paths.get(url, new String[0]), ClassTag$.MODULE$.apply(Path.class)));
    }

    private void reset() {
        this.context = this.newContext();
    }

    private void clearTarget() {
        block0: {
            AbstractFile abstractFile = this.target;
            if (!(abstractFile instanceof VirtualDirectory)) break block0;
            VirtualDirectory vdir = (VirtualDirectory)abstractFile;
            vdir.clear();
        }
    }

    private SourceFile toSource(Input input) {
        return SourceFile$.MODULE$.virtual(PositionSyntax$.MODULE$.XtensionInputMdoc(input).filename(), new String(input.chars()), SourceFile$.MODULE$.virtual$default$3());
    }

    private Input toInput(dotty.tools.dotc.interfaces.SourceFile sourceFile) {
        return Input.String$.MODULE$.apply(new String(sourceFile.content()));
    }

    public boolean hasErrors() {
        return this.context.reporter().hasErrors();
    }

    public boolean hasWarnings() {
        return this.context.reporter().hasWarnings();
    }

    public void compileSources(Input input, Reporter vreporter, TokenEditDistance edit, List<FileImport> fileImports, Option<Contexts.Context> freshContext) {
        this.clearTarget();
        Contexts.Context context = (Contexts.Context)freshContext.getOrElse(this::$anonfun$1);
        Compiler compiler = new Compiler();
        Run run = compiler.newRun(context);
        List inputs = (List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Input[]{input}));
        Try res = Try$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$2(run, inputs)));
        this.report(vreporter, input, fileImports, run.runContext(), edit);
    }

    public Option<Contexts.Context> compileSources$default$5() {
        return None$.MODULE$;
    }

    public Option<Class<?>> compile(Input input, Reporter vreporter, TokenEditDistance edit, String className, List<FileImport> fileImports, int retry) {
        None$ none$;
        block5: {
            this.reset();
            Contexts.FreshContext freshContext = this.context.fresh().setSetting(this.context.settings().outputDir(), (Object)this.target);
            this.compileSources(input, vreporter, edit, fileImports, (Option<Contexts.Context>)Some$.MODULE$.apply((Object)freshContext));
            if (!freshContext.reporter().hasErrors()) {
                AbstractFileClassLoader loader = new AbstractFileClassLoader(this.target, (ClassLoader)this.appClassLoader);
                try {
                    none$ = Some$.MODULE$.apply((Object)loader.loadClass(className));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (retry < 1) {
                        this.reset();
                        none$ = this.compile(input, vreporter, edit, className, fileImports, retry + 1);
                        break block5;
                    }
                    vreporter.error(new StringBuilder(190).append(package$.MODULE$.XtensionInputSyntaxStructure(input).syntax()).append(": skipping file, the compiler produced no classfiles ").append("and reported no errors to explain what went wrong during compilation. ").append("Please report an issue to https://github.com/scalameta/mdoc/issues.").toString());
                    none$ = None$.MODULE$;
                }
            } else {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public int compile$default$6() {
        return 0;
    }

    public String fail(TokenEditDistance edit, Input input2, Position sectionPos) {
        Compiler compiler = new Compiler();
        Contexts.FreshContext freshContext = this.context.fresh();
        Run run = compiler.newRun((Contexts.Context)freshContext);
        List inputs = ((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Input[]{input2}))).map((Function1 & Serializable)input -> this.toSource((Input)input));
        run.compileSources(inputs);
        Contexts.Context runContext = run.runContext();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        runContext.reporter().pendingMessages((Contexts.Context)this.context).foreach((Function1)(JProcedure1 & Serializable)diagnostic -> {
            String msg = this.nullableMessage(diagnostic.message());
            Position mpos = this.toMetaPosition(edit, (SourcePosition)diagnostic.position().get());
            if (PositionSyntax$XtensionPositionsScalafix$.MODULE$.contains$extension(PositionSyntax$.MODULE$.XtensionPositionsScalafix(sectionPos), mpos) || diagnostic.level() == 2) {
                String string;
                int n = diagnostic.level();
                switch (n) {
                    case 2: {
                        string = "error";
                        break;
                    }
                    case 1: {
                        string = "warn";
                        break;
                    }
                    case 0: {
                        string = "info";
                        break;
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
                String severity = string;
                String formatted = PositionSyntax$.MODULE$.formatMessage(mpos, severity, new StringBuilder(1).append("\n").append(msg).toString(), false);
                ps.println(formatted);
            }
        });
        return out.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Position toMetaPosition(TokenEditDistance edit, SourcePosition pos) {
        Position position;
        int start = pos.start();
        int end = pos.end();
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(edit.toOriginal(start), edit.toOriginal(end - 1));
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Either either = (Either)tuple2._1();
        Either either2 = (Either)tuple2._2();
        if (either instanceof Right) {
            Position start2 = (Position)((Right)either).value();
            if (either2 instanceof Right) {
                Position end2 = (Position)((Right)either2).value();
                position = PositionSyntax$.MODULE$.XtensionPositionMdoc((Position)Position.Range$.MODULE$.apply(start2.input(), start2.start(), end2.end())).toUnslicedPosition();
                return position;
            }
        }
        position = MarkdownCompiler.toOffsetPosition$1(edit, pos.point() - 1);
        return position;
    }

    private String nullableMessage(String msgOrNull) {
        return msgOrNull == null ? "" : msgOrNull;
    }

    private void report(Reporter vreporter, Input input, List<FileImport> fileImports, Contexts.Context context, TokenEditDistance edit) {
        List infos = (List)context.reporter().pendingMessages(context).toSeq().sortBy((Function1 & Serializable)_$1 -> _$1.pos().source().path(), (Ordering)Ordering.String$.MODULE$);
        infos.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            block0: {
                String line;
                Position mpos;
                Diagnostic diagnostic = x$1;
                Diagnostic diagnostic2 = diagnostic;
                if (!diagnostic2.position().isPresent()) break block0;
                SourcePosition pos = (SourcePosition)diagnostic2.position().get();
                String msg = this.nullableMessage(diagnostic2.message());
                Position position = mpos = this.toMetaPosition(edit, pos);
                Position.None$ none$ = Position.None$.MODULE$;
                String actualMessage = !(position != null ? !position.equals(none$) : none$ != null) ? (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(line = pos.lineContent())) ? this.formatMessage(pos, msg) : msg) : msg;
                this.reportMessage(vreporter, diagnostic2, mpos, new StringBuilder(1).append("\n").append(actualMessage).toString());
            }
        });
    }

    private void reportMessage(Reporter vreporter, Diagnostic diagnostic, Position mpos, String message) {
        block1: {
            Diagnostic diagnostic2;
            block2: {
                block0: {
                    diagnostic2 = diagnostic;
                    if (!(diagnostic2 instanceof Diagnostic.Error)) break block0;
                    vreporter.error(mpos, message);
                    break block1;
                }
                if (!(diagnostic2 instanceof Diagnostic.Info)) break block2;
                vreporter.info(mpos, message);
                break block1;
            }
            if (!(diagnostic2 instanceof Diagnostic.Warning)) break block1;
            vreporter.warning(mpos, message);
        }
    }

    private String formatMessage(SourcePosition pos, String message) {
        return new CodeBuilder().println(new StringBuilder(26).append(pos.source().path()).append(":").append(pos.line() + 1).append(" (mdoc generated code) \n ").append(message).toString()).println(pos.lineContent()).toString();
    }

    private final Contexts.FreshContext $anonfun$1() {
        return this.newContext();
    }

    private final void $anonfun$2(Run run$1, List inputs$1) {
        run$1.compileSources(inputs$1.map((Function1 & Serializable)input -> this.toSource((Input)input)));
    }

    private static final Position toOffsetPosition$1(TokenEditDistance edit$2, int offset) {
        Position.None$ none$;
        Either<EmptyResult, Position> either = edit$2.toOriginal(offset);
        if (either instanceof Left) {
            none$ = Position.None$.MODULE$;
        } else if (either instanceof Right) {
            Position p = (Position)((Right)either).value();
            none$ = PositionSyntax$.MODULE$.XtensionPositionMdoc(p).toUnslicedPosition();
        } else {
            throw new MatchError(either);
        }
        return none$;
    }

    public class CollectionReporter
    extends dotty.tools.dotc.reporting.Reporter
    implements UniqueMessagePositions {
        private HashMap dotty$tools$dotc$reporting$UniqueMessagePositions$$positions;
        private final Builder allDiags;
        private final MarkdownCompiler $outer;

        public CollectionReporter(MarkdownCompiler $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            UniqueMessagePositions.$init$((UniqueMessagePositions)this);
            this.allDiags = scala.package$.MODULE$.List().newBuilder();
            Statics.releaseFence();
        }

        public HashMap dotty$tools$dotc$reporting$UniqueMessagePositions$$positions() {
            return this.dotty$tools$dotc$reporting$UniqueMessagePositions$$positions;
        }

        public void dotty$tools$dotc$reporting$UniqueMessagePositions$_setter_$dotty$tools$dotc$reporting$UniqueMessagePositions$$positions_$eq(HashMap x$0) {
            this.dotty$tools$dotc$reporting$UniqueMessagePositions$$positions = x$0;
        }

        public /* synthetic */ boolean dotty$tools$dotc$reporting$UniqueMessagePositions$$super$isHidden(Diagnostic dia, Contexts.Context x$2) {
            return super.isHidden(dia, x$2);
        }

        public Builder<Diagnostic, List<Diagnostic>> allDiags() {
            return this.allDiags;
        }

        public void doReport(Diagnostic dia, Contexts.Context x$2) {
            this.allDiags().$plus$eq((Object)dia);
        }

        public List<Diagnostic> pendingMessages(Contexts.Context x$1) {
            return (List)this.allDiags().result();
        }

        public final MarkdownCompiler mdoc$internal$markdown$MarkdownCompiler$CollectionReporter$$$outer() {
            return this.$outer;
        }
    }
}

