/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import java.io.Serializable;
import mdoc.Reporter;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.Settings;
import mdoc.internal.markdown.CodeFence;
import mdoc.internal.markdown.CodeFence$;
import mdoc.internal.markdown.MarkdownFile;
import mdoc.internal.markdown.MarkdownFile$;
import mdoc.internal.markdown.MarkdownFile$State$;
import mdoc.internal.markdown.MarkdownFile$State$CodeFence$;
import mdoc.internal.markdown.MarkdownFile$State$Text$;
import mdoc.internal.markdown.MarkdownPart;
import mdoc.internal.markdown.Text;
import mdoc.internal.markdown.Text$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class MarkdownFile
implements Product,
Serializable {
    private final Input input;
    private final InputFile file;
    private final List parts;
    private final ListBuffer<String> appends;

    public static MarkdownFile apply(Input input, InputFile inputFile, List<MarkdownPart> list) {
        return MarkdownFile$.MODULE$.apply(input, inputFile, list);
    }

    public static MarkdownFile fromProduct(Product product) {
        return MarkdownFile$.MODULE$.fromProduct(product);
    }

    public static MarkdownFile parse(Input input, InputFile inputFile, Reporter reporter, Settings settings) {
        return MarkdownFile$.MODULE$.parse(input, inputFile, reporter, settings);
    }

    public static MarkdownFile unapply(MarkdownFile markdownFile) {
        return MarkdownFile$.MODULE$.unapply(markdownFile);
    }

    public MarkdownFile(Input input, InputFile file, List<MarkdownPart> parts) {
        this.input = input;
        this.file = file;
        this.parts = parts;
        this.appends = ListBuffer$.MODULE$.empty();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof MarkdownFile)) return false;
        MarkdownFile markdownFile = (MarkdownFile)object;
        Input input = this.input();
        Input input2 = markdownFile.input();
        if (input == null) {
            if (input2 != null) {
                return false;
            }
        } else if (!input.equals(input2)) return false;
        InputFile inputFile = this.file();
        InputFile inputFile2 = markdownFile.file();
        if (inputFile == null) {
            if (inputFile2 != null) {
                return false;
            }
        } else if (!inputFile.equals(inputFile2)) return false;
        List<MarkdownPart> list = this.parts();
        List<MarkdownPart> list2 = markdownFile.parts();
        if (list == null) {
            if (list2 == null) return true;
            return false;
        } else {
            if (!list.equals(list2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof MarkdownFile;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "MarkdownFile";
    }

    public Object productElement(int n) {
        List<MarkdownPart> list;
        int n2 = n;
        switch (n2) {
            case 0: {
                list = this._1();
                break;
            }
            case 1: {
                list = this._2();
                break;
            }
            case 2: {
                list = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return list;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "input";
                break;
            }
            case 1: {
                string = "file";
                break;
            }
            case 2: {
                string = "parts";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public Input input() {
        return this.input;
    }

    public InputFile file() {
        return this.file;
    }

    public List<MarkdownPart> parts() {
        return this.parts;
    }

    public void appendText(String text) {
        this.appends.$plus$eq((Object)text);
    }

    public String renderToString() {
        StringBuilder out = new StringBuilder();
        this.parts().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.renderToString(out));
        this.appends.foreach((Function1 & Serializable)a -> out.append(a).append("\n"));
        return out.toString();
    }

    public MarkdownFile copy(Input input, InputFile file, List<MarkdownPart> parts) {
        return new MarkdownFile(input, file, parts);
    }

    public Input copy$default$1() {
        return this.input();
    }

    public InputFile copy$default$2() {
        return this.file();
    }

    public List<MarkdownPart> copy$default$3() {
        return this.parts();
    }

    public Input _1() {
        return this.input();
    }

    public InputFile _2() {
        return this.file();
    }

    public List<MarkdownPart> _3() {
        return this.parts();
    }

    public static class Parser {
        private final Input input;
        private final Settings settings;
        private final String text;

        public Parser(Input input, Reporter reporter, Settings settings) {
            this.input = input;
            this.settings = settings;
            this.text = input.text();
        }

        private Position newPos(int start, int end) {
            return Position.Range$.MODULE$.apply(this.input, start, end);
        }

        private Text newText(int start, int end) {
            int adaptedEnd = package$.MODULE$.max(start, end);
            Text part = Text$.MODULE$.apply(this.text.substring(start, adaptedEnd));
            part.pos_$eq(this.newPos(start, adaptedEnd));
            return part;
        }

        private CodeFence newCodeFence(State.CodeFence state, int backtickStart, int backtickEnd) {
            Text tag = this.newText(state.start(), state.start() + state.indent());
            Text open = this.newText(state.start(), state.start() + state.indent() + state.backticks().length()).dropLinePrefix(state.indent());
            Text info = this.newText(open.pos().end(), open.pos().end() + state.info().length());
            int adaptedBacktickStart = package$.MODULE$.max(0, backtickStart - 1);
            Text body = this.newText(info.pos().end(), adaptedBacktickStart).dropLinePrefix(state.indent());
            Text close = this.newText(adaptedBacktickStart, backtickEnd).dropLinePrefix(state.indent());
            CodeFence part = CodeFence$.MODULE$.apply(open, info, body, close, tag);
            part.pos_$eq(this.newPos(state.start(), backtickEnd));
            return part;
        }

        public List<MarkdownPart> acceptParts() {
            BoxedUnit boxedUnit;
            ObjectRef state = ObjectRef.create((Object)MarkdownFile$State$Text$.MODULE$);
            ListBuffer parts = ListBuffer$.MODULE$.empty();
            IntRef curr = IntRef.create((int)0);
            StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(this.text)).foreach((Function1)(JProcedure1 & Serializable)line -> {
                int n;
                BoxedUnit boxedUnit;
                int end = curr$1.elem + line.length();
                State state = (State)state$1.elem;
                if (MarkdownFile$State$Text$.MODULE$.equals(state)) {
                    int start = line.indexOf("```");
                    if (start == 0 || start > 0 && this.settings.allowCodeFenceIndented()) {
                        String fence = line.substring(start);
                        String backticks = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(fence), (Function1 & Serializable)_$2 -> this.$anonfun$1(BoxesRunTime.unboxToChar((Object)_$2)));
                        String info = fence.substring(backticks.length());
                        State.CodeFence codeFence = MarkdownFile$State$CodeFence$.MODULE$.apply(curr$1.elem, backticks, info, start);
                        state$1.elem = codeFence;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = parts.$plus$eq((Object)this.newText(curr$1.elem, end));
                    }
                } else if (state instanceof State.CodeFence) {
                    State.CodeFence s = (State.CodeFence)state;
                    int start = line.indexOf(s.backticks());
                    if (start == s.indent() && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(line), (Function1 & Serializable)ch -> this.acceptParts$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)ch)))) {
                        parts.$plus$eq((Object)this.newCodeFence(s, curr$1.elem, end));
                        MarkdownFile$State$Text$ markdownFile$State$Text$ = MarkdownFile$State$Text$.MODULE$;
                        state$1.elem = markdownFile$State$Text$;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)state);
                }
                curr$1.elem = n = curr$1.elem + line.length();
            });
            State state2 = (State)state.elem;
            if (state2 instanceof State.CodeFence) {
                State.CodeFence s = (State.CodeFence)state2;
                boxedUnit = parts.$plus$eq((Object)this.newCodeFence(s, this.text.length(), this.text.length()));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return parts.toList();
        }

        private final /* synthetic */ boolean $anonfun$1(char _$2) {
            return _$2 == '`';
        }

        private final /* synthetic */ boolean acceptParts$$anonfun$1$$anonfun$1(char ch) {
            return ch == '`' || RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(ch));
        }
    }

    public static abstract class State {
        public static int ordinal(State state) {
            return MarkdownFile$State$.MODULE$.ordinal(state);
        }
    }
}

