/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.cli;

import coursierapi.Dependency;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import mdoc.Reporter;
import mdoc.internal.cli.Context;
import mdoc.internal.cli.Feedback$;
import mdoc.internal.cli.Settings;
import mdoc.internal.io.ConsoleReporter$;
import mdoc.internal.markdown.MarkdownBuilder$;
import mdoc.internal.markdown.MarkdownCompiler;
import metaconfig.ConfError;
import metaconfig.ConfError$;
import metaconfig.Configured;
import metaconfig.Configured$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.deriving.Mirror;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;

public final class Context$
implements Mirror.Product,
Serializable {
    public static final Context$ MODULE$ = new Context$();

    private Context$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Context$.class);
    }

    public Context apply(Settings settings, Reporter reporter, MarkdownCompiler compiler, Map<Tuple2<Set<Dependency>, List<String>>, MarkdownCompiler> compilers) {
        return new Context(settings, reporter, compiler, compilers);
    }

    public Context unapply(Context x$1) {
        return x$1;
    }

    public String toString() {
        return "Context";
    }

    public Map<Tuple2<Set<Dependency>, List<String>>, MarkdownCompiler> $lessinit$greater$default$4() {
        return (Map)Map$.MODULE$.empty();
    }

    public Configured<Context> fromSettings(Settings settings, Reporter reporter) {
        Configured configured;
        if (settings.in().isEmpty()) {
            configured = Configured$.MODULE$.error(Feedback$.MODULE$.mustBeNonEmpty("in"));
        } else if (settings.out().isEmpty()) {
            configured = Configured$.MODULE$.error(Feedback$.MODULE$.mustBeNonEmpty("out"));
        } else if (settings.in().length() != settings.out().length()) {
            configured = Configured$.MODULE$.error(Feedback$.MODULE$.inputDifferentLengthOutput(settings.in(), settings.out()));
        } else {
            List errors = settings.outputByInput().iterator().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                AbsolutePath input = (AbsolutePath)tuple2._1();
                AbsolutePath output = (AbsolutePath)tuple2._2();
                return this.validateInputOutputPair(settings, input, output);
            }).toList();
            List list = (List)errors.flatten(Predef$.MODULE$.$conforms());
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                Context context = this.fromOptions(settings, reporter);
                settings.onLoad(reporter);
                configured = reporter.hasErrors() ? Configured$.MODULE$.error("Failed to load modifiers") : Configured$.MODULE$.ok((Object)context);
            } else {
                List errors2 = list;
                configured = ((ConfError)errors2.foldLeft((Object)ConfError$.MODULE$.empty(), (Function2 & Serializable)(_$2, _$3) -> _$2.combine(_$3))).notOk();
            }
        }
        return configured;
    }

    private boolean assumedRegularFile(Settings settings, AbsolutePath absPath) {
        String extension = PathIO$.MODULE$.extension(absPath.toNIO());
        return settings.markdownExtensions().toSet().contains((Object)extension);
    }

    private Option<ConfError> validateInputOutputPair(Settings settings, AbsolutePath input, AbsolutePath output) {
        Object object;
        if (!Files.exists(input.toNIO(), new LinkOption[0])) {
            object = Some$.MODULE$.apply((Object)ConfError$.MODULE$.fileDoesNotExist(input.toNIO()));
        } else {
            AbsolutePath absolutePath = input;
            AbsolutePath absolutePath2 = output;
            object = !(absolutePath != null ? !absolutePath.equals(absolutePath2) : absolutePath2 != null) ? Some$.MODULE$.apply((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.inputEqualOutput(input))) : (output.toNIO().startsWith(input.toNIO()) && !this.assumedRegularFile(settings, output) ? Some$.MODULE$.apply((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.outSubdirectoryOfIn(input.toNIO(), output.toNIO()))) : (input.isFile() && output.isDirectory() ? Some$.MODULE$.apply((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.outputCannotBeDirectory(input, output))) : (input.isDirectory() && output.isFile() ? Some$.MODULE$.apply((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.outputCannotBeRegularFile(input, output))) : None$.MODULE$)));
        }
        return object;
    }

    public Context fromCompiler(Settings options, Reporter reporter, MarkdownCompiler compiler) {
        return new Context(options, reporter, compiler, this.$lessinit$greater$default$4());
    }

    public Context fromOptions(Settings options, Reporter reporter) {
        MarkdownCompiler compiler = MarkdownBuilder$.MODULE$.fromClasspath(options.classpath(), options.scalacOptions());
        return this.fromCompiler(options, reporter, compiler);
    }

    public Reporter fromOptions$default$2() {
        return ConsoleReporter$.MODULE$.default();
    }

    public Context fromProduct(Product x$0) {
        return new Context((Settings)x$0.productElement(0), (Reporter)x$0.productElement(1), (MarkdownCompiler)x$0.productElement(2), (Map<Tuple2<Set<Dependency>, List<String>>, MarkdownCompiler>)((Map)x$0.productElement(3)));
    }
}

