/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import coursierapi.error.CoursierError;
import coursierapi.error.MultipleResolutionError;
import java.io.Serializable;
import mdoc.PostModifier;
import mdoc.PostModifierContext;
import mdoc.PostProcessContext;
import mdoc.PreModifier;
import mdoc.PreModifierContext;
import mdoc.StringModifier;
import mdoc.Variable;
import mdoc.document.Binder;
import mdoc.document.Statement;
import mdoc.internal.cli.Context;
import mdoc.internal.document.MdocExceptions$;
import mdoc.internal.markdown.CodeFence;
import mdoc.internal.markdown.EvaluatedDocument;
import mdoc.internal.markdown.EvaluatedSection;
import mdoc.internal.markdown.FenceInput;
import mdoc.internal.markdown.Instrumented;
import mdoc.internal.markdown.Instrumenter$;
import mdoc.internal.markdown.MarkdownBuilder$;
import mdoc.internal.markdown.MarkdownCompiler;
import mdoc.internal.markdown.MarkdownFile;
import mdoc.internal.markdown.MarkdownPart;
import mdoc.internal.markdown.MdocDialect$;
import mdoc.internal.markdown.Modifier;
import mdoc.internal.markdown.ModifierException;
import mdoc.internal.markdown.ParsedSource$;
import mdoc.internal.markdown.PositionedDependency;
import mdoc.internal.markdown.PreFenceInput;
import mdoc.internal.markdown.PreFenceInput$;
import mdoc.internal.markdown.Renderer$;
import mdoc.internal.markdown.ScalaFenceInput;
import mdoc.internal.markdown.ScalaFenceInput$;
import mdoc.internal.markdown.SectionInput;
import mdoc.internal.markdown.SectionInput$;
import mdoc.internal.markdown.StringFenceInput;
import mdoc.internal.markdown.StringFenceInput$;
import mdoc.internal.pos.PositionSyntax$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Builder;
import scala.meta.Source;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.io.RelativePath;
import scala.meta.parsers.Parse$;
import scala.meta.parsers.Parsed;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public class Processor {
    private final Context ctx;

    public Processor(Context ctx) {
        this.ctx = ctx;
    }

    public MarkdownFile processDocument(MarkdownFile doc) {
        Input docInput = doc.input();
        Tuple3<List<ScalaFenceInput>, List<StringFenceInput>, List<PreFenceInput>> tuple3 = this.collectFenceInputs(doc);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        List scalaInputs = (List)tuple3._1();
        List customInputs = (List)tuple3._2();
        List preInputs = (List)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)scalaInputs, (Object)customInputs, (Object)preInputs);
        List scalaInputs2 = (List)tuple32._1();
        List customInputs2 = (List)tuple32._2();
        List preInputs2 = (List)tuple32._3();
        String filename = PositionSyntax$.MODULE$.XtensionInputMdoc(docInput).toFilename(this.ctx.settings());
        RelativePath inputFile = doc.file().relpath();
        customInputs2.foreach((Function1)(JProcedure1 & Serializable)block -> this.processStringInput(doc, (StringFenceInput)block));
        preInputs2.foreach((Function1)(JProcedure1 & Serializable)block -> this.processPreInput(doc, (PreFenceInput)block));
        if (scalaInputs2.nonEmpty()) {
            this.processScalaInputs(doc, (List<ScalaFenceInput>)scalaInputs2, inputFile, filename);
        }
        if (preInputs2.nonEmpty()) {
            PostProcessContext post = new PostProcessContext(this.ctx.reporter(), doc.file(), this.ctx.settings());
            this.ctx.settings().preModifiers().foreach((Function1)(JProcedure1 & Serializable)pre -> this.runModifier(pre.name(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.appendChild(doc, pre.postProcess(post))));
        }
        return doc;
    }

    public void runModifier(String name, Function0<BoxedUnit> fn) {
        try {
            fn.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.ctx.reporter().error((Throwable)new ModifierException(name, e));
            }
            throw throwable;
        }
    }

    public void processPreInput(MarkdownFile doc, PreFenceInput custom) {
        Input input;
        CodeFence block;
        Modifier.Pre pre;
        block7: {
            PreFenceInput preFenceInput;
            block6: {
                preFenceInput = custom;
                if (preFenceInput == null) break block6;
                PreFenceInput preFenceInput2 = PreFenceInput$.MODULE$.unapply(preFenceInput);
                CodeFence codeFence = preFenceInput2._1();
                Input input2 = preFenceInput2._2();
                pre = preFenceInput2._3();
                block = codeFence;
                input = input2;
                if (pre != null) break block7;
            }
            throw new MatchError((Object)preFenceInput);
        }
        Modifier.Pre pre2 = Modifier.Pre$.MODULE$.unapply(pre);
        PreModifier preModifier = pre2._1();
        String string = pre2._2();
        PreModifier mod = preModifier;
        String info = string;
        Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)block, (Object)input, (Object)mod, (Object)info);
        CodeFence block2 = (CodeFence)tuple4._1();
        Input input3 = (Input)tuple4._2();
        PreModifier mod2 = (PreModifier)tuple4._3();
        String info2 = (String)tuple4._4();
        try {
            RelativePath inputFile = doc.file().relpath();
            PreModifierContext preCtx = new PreModifierContext(info2, input3, this.ctx.reporter(), doc.file(), this.ctx.settings());
            String out = mod2.process(preCtx);
            this.replaceNodeWithText(doc, block2, out);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                Position.Range pos = Position.Range$.MODULE$.apply(input3, 0, input3.chars().length);
                MdocExceptions$.MODULE$.trimStacktrace(e);
                ModifierException exception = new ModifierException(mod2.name(), e);
                this.ctx.reporter().error((Position)pos, (Throwable)exception);
            }
            throw throwable;
        }
    }

    public void processStringInput(MarkdownFile doc, StringFenceInput custom) {
        Input input;
        CodeFence block;
        Modifier.Str str;
        block7: {
            StringFenceInput stringFenceInput;
            block6: {
                stringFenceInput = custom;
                if (stringFenceInput == null) break block6;
                StringFenceInput stringFenceInput2 = StringFenceInput$.MODULE$.unapply(stringFenceInput);
                CodeFence codeFence = stringFenceInput2._1();
                Input input2 = stringFenceInput2._2();
                str = stringFenceInput2._3();
                block = codeFence;
                input = input2;
                if (str != null) break block7;
            }
            throw new MatchError((Object)stringFenceInput);
        }
        Modifier.Str str2 = Modifier.Str$.MODULE$.unapply(str);
        StringModifier stringModifier = str2._1();
        String string = str2._2();
        StringModifier mod = stringModifier;
        String info = string;
        Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)block, (Object)input, (Object)mod, (Object)info);
        CodeFence block2 = (CodeFence)tuple4._1();
        Input input3 = (Input)tuple4._2();
        StringModifier mod2 = (StringModifier)tuple4._3();
        String info2 = (String)tuple4._4();
        try {
            String newText = mod2.process(info2, input3, this.ctx.reporter());
            this.replaceNodeWithText(doc, block2, newText);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                Position.Range pos = Position.Range$.MODULE$.apply(input3, 0, input3.chars().length);
                MdocExceptions$.MODULE$.trimStacktrace(e);
                ModifierException exception = new ModifierException(mod2.name(), e);
                this.ctx.reporter().error((Position)pos, (Throwable)exception);
            }
            throw throwable;
        }
    }

    public void processScalaInputs(MarkdownFile doc, List<ScalaFenceInput> inputs, RelativePath relpath, String filename) {
        MarkdownCompiler markdownCompiler;
        List sectionInputs = inputs.map((Function1 & Serializable)x$1 -> {
            SectionInput sectionInput;
            Option option;
            ScalaFenceInput scalaFenceInput = x$1;
            if (scalaFenceInput == null) throw new MatchError((Object)scalaFenceInput);
            ScalaFenceInput scalaFenceInput2 = ScalaFenceInput$.MODULE$.unapply(scalaFenceInput);
            CodeFence codeFence = scalaFenceInput2._1();
            Input input = scalaFenceInput2._2();
            Modifier modifier = scalaFenceInput2._3();
            Input input2 = input;
            Modifier mod = modifier;
            Parsed parsed = scala.meta.package$.MODULE$.XtensionParseInputDialect(Tuple2$.MODULE$.apply((Object)input2, (Object)MdocDialect$.MODULE$.scala())).parse(Parse$.MODULE$.parseSource());
            if (parsed instanceof Parsed.Success && !(option = Parsed.Success$.MODULE$.unapply((Parsed.Success)parsed)).isEmpty()) {
                Source source;
                Source source2 = source = (Source)option.get();
                sectionInput = SectionInput$.MODULE$.apply(input2, ParsedSource$.MODULE$.apply(source2), mod);
                return sectionInput;
            } else {
                Option option2;
                if (!(parsed instanceof Parsed.Error) || (option2 = Parsed.Error$.MODULE$.unapply((Parsed.Error)parsed)).isEmpty()) throw new MatchError((Object)parsed);
                Tuple3 tuple3 = (Tuple3)option2.get();
                Position pos = (Position)tuple3._1();
                String msg = (String)tuple3._2();
                this.ctx.reporter().error(PositionSyntax$.MODULE$.XtensionPositionMdoc(pos).toUnslicedPosition(), msg);
                sectionInput = SectionInput$.MODULE$.apply(input2, ParsedSource$.MODULE$.empty(), mod);
            }
            return sectionInput;
        });
        Instrumented instrumented = Instrumenter$.MODULE$.instrument(doc.file(), (List<SectionInput>)sectionInputs, this.ctx.settings(), this.ctx.reporter());
        if (this.ctx.reporter().hasErrors()) {
            return;
        }
        if (this.ctx.settings().verbose()) {
            this.ctx.reporter().info(new StringBuilder(13).append("Instrumented ").append(filename).toString());
            this.ctx.reporter().println(instrumented.source());
        }
        try {
            markdownCompiler = this.ctx.compiler(instrumented);
        }
        catch (CoursierError e) {
            this.handleCoursierError(instrumented, e);
            markdownCompiler = this.ctx.compiler();
        }
        MarkdownCompiler compiler = markdownCompiler;
        this.processScalaInputs(doc, inputs, relpath, filename, (List<SectionInput>)sectionInputs, instrumented, compiler);
    }

    public void handleCoursierError(Instrumented instrumented, CoursierError e) {
        CoursierError coursierError = e;
        if (coursierError instanceof MultipleResolutionError) {
            MultipleResolutionError m = (MultipleResolutionError)coursierError;
            PositionSyntax$.MODULE$.ListHasAsScala(m.getErrors()).asScala().foreach((Function1)(JProcedure1 & Serializable)simpleError -> this.handleCoursierError(instrumented, (CoursierError)((Object)simpleError)));
        } else {
            Position pos = (Position)instrumented.positionedDependencies().collectFirst((PartialFunction)new Serializable(e){
                private final CoursierError e$1;
                {
                    this.e$1 = e$2;
                }

                public final boolean isDefinedAt(PositionedDependency x) {
                    PositionedDependency positionedDependency;
                    PositionedDependency dep = positionedDependency = x;
                    return this.e$1.getMessage().contains(dep.syntax());
                }

                public final Object applyOrElse(PositionedDependency x, Function1 function1) {
                    PositionedDependency positionedDependency;
                    PositionedDependency dep = positionedDependency = x;
                    return this.e$1.getMessage().contains(dep.syntax()) ? dep.pos() : function1.apply((Object)x);
                }
            }).orElse(() -> Processor.$anonfun$2(instrumented)).getOrElse(Processor::$anonfun$3);
            this.ctx.reporter().error(pos, e.getMessage());
        }
    }

    public void processScalaInputs(MarkdownFile doc, List<ScalaFenceInput> inputs, RelativePath relpath, String filename, List<SectionInput> sectionInputs, Instrumented instrumented, MarkdownCompiler markdownCompiler) {
        EvaluatedDocument rendered = MarkdownBuilder$.MODULE$.buildDocument(markdownCompiler, this.ctx.reporter(), sectionInputs, instrumented, filename);
        ((List)rendered.sections().zip(inputs)).foreach((Function1)(JProcedure1 & Serializable)x$13 -> {
            String string;
            Tuple2 tuple2 = x$13;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            ScalaFenceInput scalaFenceInput = (ScalaFenceInput)tuple2._2();
            EvaluatedSection section = (EvaluatedSection)tuple2._1();
            if (scalaFenceInput == null) throw new MatchError((Object)tuple2);
            ScalaFenceInput scalaFenceInput2 = ScalaFenceInput$.MODULE$.unapply(scalaFenceInput);
            CodeFence codeFence = scalaFenceInput2._1();
            Input input = scalaFenceInput2._2();
            Modifier modifier = scalaFenceInput2._3();
            CodeFence block = codeFence;
            Modifier mod = modifier;
            block.newInfo_$eq((Option<String>)Some$.MODULE$.apply((Object)"scala"));
            Modifier modifier2 = mod;
            if (modifier2 instanceof Modifier.Post) {
                Modifier.Post post = Modifier.Post$.MODULE$.unapply((Modifier.Post)modifier2);
                PostModifier postModifier = post._1();
                String string2 = post._2();
                PostModifier modifier3 = postModifier;
                String info = string2;
                List variables = ((List)((IterableOps)section.section().statements().zipWithIndex()).withFilter((Function1 & Serializable)x$1 -> {
                    boolean bl;
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Statement stat = (Statement)tuple2._1();
                        int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        Tuple2 $4$ = tuple2;
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Statement stat = (Statement)tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    Tuple2 $4$ = tuple2;
                    int n = section.section().statements().length();
                    return Tuple2$.MODULE$.apply((Object)$4$, (Object)BoxesRunTime.boxToInteger((int)n));
                })).flatMap((Function1 & Serializable)x$12 -> {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = x$12;
                    if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Statement stat = (Statement)tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    int n = BoxesRunTime.unboxToInt((Object)tuple22._2());
                    return ((List)((IterableOps)stat.binders().zipWithIndex()).withFilter((Function1 & Serializable)x$1 -> {
                        boolean bl;
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Binder binder = (Binder)tuple2._1();
                            int j = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            Tuple2 $5$ = tuple2;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        return bl;
                    }).map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Binder binder = (Binder)tuple2._1();
                        int j = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        Tuple2 $5$ = tuple2;
                        int m = stat.binders().length();
                        return Tuple2$.MODULE$.apply((Object)$5$, (Object)BoxesRunTime.boxToInteger((int)m));
                    })).map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2;
                        Tuple2 tuple22 = x$1;
                        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        Binder binder = (Binder)tuple2._1();
                        int j = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        int m = BoxesRunTime.unboxToInt((Object)tuple22._2());
                        return new Variable(binder.name(), binder.tpe().render(), binder.value(), PositionSyntax$.MODULE$.XtensionRangePositionMdoc(binder.pos()).toMeta(section), j, n, i, m, section.mod());
                    });
                });
                PostModifierContext postCtx = new PostModifierContext(info, section.input(), this.defaultRender$1(markdownCompiler, rendered, section), variables, this.ctx.reporter(), doc.file(), this.ctx.settings());
                String postRender = modifier3.process(postCtx);
                this.replaceNodeWithText(doc, block, postRender);
                return;
            }
            if (modifier2 instanceof Modifier.Builtin) {
                Modifier.Builtin m = (Modifier.Builtin)modifier2;
                if (m.isPassthrough()) {
                    this.replaceNodeWithText(doc, block, section.out());
                    return;
                } else if (m.isInvisible()) {
                    this.replaceNodeWithText(doc, block, "");
                    return;
                } else if (m.isCrash()) {
                    String stacktrace = Renderer$.MODULE$.renderCrashSection(section, this.ctx.reporter(), rendered.edit());
                    this.replaceNodeWithText(doc, block, stacktrace);
                    return;
                } else {
                    if (m.isSilent()) return;
                    block.newBody_$eq((Option<String>)Some$.MODULE$.apply((Object)this.defaultRender$1(markdownCompiler, rendered, section)));
                }
                return;
            }
            if (modifier2 instanceof Modifier.Str) {
                Modifier.Str c = (Modifier.Str)modifier2;
                throw new IllegalArgumentException(c.toString());
            }
            if (!(modifier2 instanceof Modifier.Pre)) throw new MatchError((Object)modifier2);
            Modifier.Pre c = (Modifier.Pre)modifier2;
            PreModifierContext preCtx = new PreModifierContext(c.info(), section.input(), this.ctx.reporter(), doc.file(), this.ctx.settings());
            try {
                string = c.mod().process(preCtx);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Option option;
                Throwable throwable3 = throwable;
                if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) throw throwable;
                Throwable e = throwable2 = (Throwable)option.get();
                this.ctx.reporter().error(e);
                string = e.getMessage();
            }
            String out = string;
            this.replaceNodeWithText(doc, block, out);
        });
    }

    public void appendChild(MarkdownFile doc, String text) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(text))) {
            doc.appendText(text);
        }
    }

    public void replaceNodeWithText(MarkdownFile doc, CodeFence toReplace, String text) {
        toReplace.newPart_$eq((Option<String>)Some$.MODULE$.apply((Object)text));
    }

    public Tuple3<List<ScalaFenceInput>, List<StringFenceInput>, List<PreFenceInput>> collectFenceInputs(MarkdownFile doc) {
        FenceInput InterestingCodeFence = new FenceInput(this.ctx, doc.input());
        Builder inputs = package$.MODULE$.List().newBuilder();
        Builder strings = package$.MODULE$.List().newBuilder();
        Builder pres = package$.MODULE$.List().newBuilder();
        doc.parts().foreach((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit;
            Option<ScalaFenceInput> option;
            MarkdownPart markdownPart = x$1;
            if (markdownPart instanceof CodeFence && !(option = InterestingCodeFence.unapply((CodeFence)markdownPart)).isEmpty()) {
                ScalaFenceInput scalaFenceInput = (ScalaFenceInput)option.get();
                ScalaFenceInput input = scalaFenceInput;
                Modifier modifier = input.mod();
                if (modifier instanceof Modifier.Str) {
                    Modifier.Str string = (Modifier.Str)modifier;
                    boxedUnit = (Builder)strings.$plus$eq((Object)StringFenceInput$.MODULE$.apply(input.block(), input.input(), string));
                } else if (modifier instanceof Modifier.Pre) {
                    Modifier.Pre pre = (Modifier.Pre)modifier;
                    boxedUnit = (Builder)pres.$plus$eq((Object)PreFenceInput$.MODULE$.apply(input.block(), input.input(), pre));
                } else {
                    boxedUnit = (Builder)inputs.$plus$eq((Object)input);
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return Tuple3$.MODULE$.apply(inputs.result(), strings.result(), pres.result());
    }

    private static final Option $anonfun$2(Instrumented instrumented$2) {
        return instrumented$2.dependencyImports().headOption().map((Function1 & Serializable)_$1 -> _$1.pos());
    }

    private static final Position.None$ $anonfun$3() {
        return Position.None$.MODULE$;
    }

    private final String defaultRender$1(MarkdownCompiler markdownCompiler$2, EvaluatedDocument rendered$2, EvaluatedSection section$1) {
        return Renderer$.MODULE$.renderEvaluatedSection(rendered$2, section$1, this.ctx.reporter(), (Function1<Variable, String>)this.ctx.settings().variablePrinter(), markdownCompiler$2);
    }
}

