/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import mdoc.Reporter;
import mdoc.Variable;
import mdoc.document.Binder;
import mdoc.document.CrashResult;
import mdoc.document.RangePosition;
import mdoc.document.Statement;
import mdoc.internal.cli.Context;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.Settings;
import mdoc.internal.document.FailSection;
import mdoc.internal.document.FailSection$;
import mdoc.internal.document.MdocExceptions$;
import mdoc.internal.markdown.EvaluatedDocument;
import mdoc.internal.markdown.EvaluatedSection;
import mdoc.internal.markdown.Instrumented;
import mdoc.internal.markdown.Instrumenter$;
import mdoc.internal.markdown.MarkdownBuilder$;
import mdoc.internal.markdown.MarkdownCompiler;
import mdoc.internal.markdown.Modifier;
import mdoc.internal.markdown.SectionInput;
import mdoc.internal.markdown.SectionInput$;
import mdoc.internal.pos.PositionSyntax$;
import mdoc.internal.pos.TokenEditDistance;
import mdoc.internal.pos.TokenEditDistance$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.meta.Tree;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class Renderer$
implements Serializable {
    public static final Renderer$ MODULE$ = new Renderer$();

    private Renderer$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Renderer$.class);
    }

    public String render(InputFile file, List<Input> sections, MarkdownCompiler compiler, Settings settings, Reporter reporter, String filename, Function1<Variable, String> printer, Context context) {
        List inputs = sections.map((Function1 & Serializable)s -> SectionInput$.MODULE$.apply((Input)s, Modifier.Default$.MODULE$.apply(), context));
        Instrumented instrumented = Instrumenter$.MODULE$.instrument(file, (List<SectionInput>)inputs, settings, reporter);
        EvaluatedDocument doc = MarkdownBuilder$.MODULE$.buildDocument(compiler, reporter, (List<SectionInput>)inputs, instrumented, filename);
        return doc.sections().map((Function1 & Serializable)s -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(53).append("```scala\n                   |").append(this.renderEvaluatedSection(doc, (EvaluatedSection)s, reporter, printer, compiler)).append("\n                   |```").toString()))).mkString("\n");
    }

    public String renderCrashSection(EvaluatedSection section, Reporter reporter, TokenEditDistance edit) {
        Object object;
        CrashResult.Crashed crashed;
        Predef$.MODULE$.require(section.mod().isCrash(), () -> this.renderCrashSection$$anonfun$1(section));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        ps.println("```scala");
        ps.println(section.source().pos().text());
        List crashes = section.section().statements().flatMap((Function1 & Serializable)statement -> (IterableOnce)statement.binders().withFilter((Function1 & Serializable)binder -> binder.value() instanceof CrashResult.Crashed).map((Function1 & Serializable)binder -> (CrashResult.Crashed)binder.value()));
        Option option = crashes.headOption();
        if (option instanceof Some && (crashed = (CrashResult.Crashed)((Some)option).value()) != null) {
            CrashResult.Crashed crashed2 = CrashResult.Crashed$.MODULE$.unapply(crashed);
            Throwable throwable = crashed2._1();
            RangePosition rangePosition = crashed2._2();
            Throwable e = throwable;
            MdocExceptions$.MODULE$.trimStacktrace(e);
            ByteArrayOutputStream stacktrace = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(stacktrace));
            this.appendFreshMultiline(ps, stacktrace.toString());
            object = ps.append('\n');
        } else if (None$.MODULE$.equals(option)) {
            Position mpos = PositionSyntax$.MODULE$.XtensionPositionMdoc(section.source().pos()).toUnslicedPosition();
            reporter.error(mpos, "Expected runtime exception but program completed successfully");
            object = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        ps.println("```");
        return out.toString();
    }

    public void appendMultiline(PrintStream sb, String string, int N) {
        PositionSyntax$.MODULE$.XtensionPrintStream(sb).appendMultiline(string, N);
    }

    public void appendFreshMultiline(PrintStream sb, String string) {
        int N = string.length() - (string.endsWith("\n") ? 1 : 0);
        sb.append("// ");
        PositionSyntax$.MODULE$.XtensionPrintStream(sb).appendMultiline(string, N);
    }

    public String renderEvaluatedSection(EvaluatedDocument doc, EvaluatedSection section, Reporter reporter, Function1<Variable, String> printer, MarkdownCompiler compiler) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream sb = new PrintStream(baos);
        Function1 stats = section.source().stats().lift();
        Input input = section.source().pos().input();
        int totalStats = section.source().stats().length();
        if (section.mod().isFailOrWarn()) {
            sb.print(section.input().text());
        }
        ((List)((StrictOptimizedIterableOps)section.section().statements().zip(section.source().stats())).zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
            int statementIndex;
            Statement statement;
            Tuple2 tuple2;
            Tuple2 tuple22 = x$12;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                int n;
                statement = (Statement)tuple2._1();
                Tree tree = (Tree)tuple2._2();
                statementIndex = BoxesRunTime.unboxToInt((Object)tuple22._2());
                Position pos = tree.pos();
                Option option = (Option)stats.apply((Object)BoxesRunTime.boxToInteger((int)(statementIndex - 1)));
                if (None$.MODULE$.equals(option)) {
                    n = 0;
                } else if (option instanceof Some) {
                    Tree previousStatement = (Tree)((Some)option).value();
                    n = previousStatement.pos().end();
                } else {
                    throw new MatchError((Object)option);
                }
                int leadingStart = n;
                Position.Range leadingTrivia = Position.Range$.MODULE$.apply(input, leadingStart, pos.start());
                if (!section.mod().isFailOrWarn()) {
                    sb.append(leadingTrivia.text());
                }
                Position.Range endOfLinePosition = Position.Range$.MODULE$.apply(pos.input(), pos.startLine(), pos.startColumn(), pos.endLine(), Integer.MAX_VALUE);
                if (!section.mod().isFailOrWarn()) {
                    sb.append(endOfLinePosition.text());
                }
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(statement.out()))) {
                    sb.append("\n");
                    this.appendFreshMultiline(sb, statement.out());
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            int N = statement.binders().length();
            ((List)statement.binders().zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
                PrintStream printStream;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Binder binder = (Binder)tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    Modifier modifier = section.mod();
                    if (modifier != null && (Modifier.Fail$.MODULE$.unapply(modifier) || Modifier.Warn$.MODULE$.unapply(modifier))) {
                        String compiled;
                        sb.append('\n');
                        Object object = binder.value();
                        if (object instanceof FailSection) {
                            FailSection failSection = FailSection$.MODULE$.unapply((FailSection)object);
                            String string = failSection._1();
                            int n = failSection._2();
                            int n2 = failSection._3();
                            int n3 = failSection._4();
                            int n4 = failSection._5();
                            String instrumented = string;
                            int startLine = n;
                            int startColumn = n2;
                            int endLine = n3;
                            int endColumn = n4;
                            Input.String input = package$.MODULE$.Input().String().apply(instrumented);
                            TokenEditDistance edit = TokenEditDistance$.MODULE$.fromInputs((Seq<Input>)doc.sections().map((Function1 & Serializable)_$1 -> _$1.source().pos().input()), (Input)input);
                            compiled = compiler.fail(edit, (Input)input, section.source().pos());
                            RangePosition tpos = new RangePosition(startLine, startColumn, endLine, endColumn);
                            Position pos = PositionSyntax$.MODULE$.XtensionRangePositionMdoc(tpos).toMeta(section);
                            if (section.mod().isWarn() && compiler.hasErrors()) {
                                reporter.error(pos, "Expected compile warnings but program failed to compile");
                            } else if (section.mod().isWarn() && !compiler.hasWarnings()) {
                                reporter.error(pos, "Expected compile warnings but program compiled successfully without warnings");
                            } else if (section.mod().isFail() && !compiler.hasErrors()) {
                                reporter.error(pos, "Expected compile errors but program compiled successfully without errors");
                            }
                        } else {
                            String obtained = binder.value() != null ? binder.value().toString() : "null";
                            throw new IllegalArgumentException(new StringBuilder(31).append("Expected FailSection. Obtained ").append(obtained).toString());
                        }
                        this.appendFreshMultiline(sb, compiled);
                        printStream = BoxedUnit.UNIT;
                    } else {
                        Position pos = PositionSyntax$.MODULE$.XtensionRangePositionMdoc(binder.pos()).toMeta(section);
                        Variable variable = new Variable(binder.name(), binder.tpe().render(), binder.value(), pos, i, N, statementIndex, totalStats, section.mod());
                        printStream = sb.append((CharSequence)printer.apply((Object)variable));
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                return printStream;
            });
        });
        return baos.toString().trim();
    }

    private final Modifier renderCrashSection$$anonfun$1(EvaluatedSection section$1) {
        return section$1.mod();
    }
}

