/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.Serializable;
import mdoc.internal.cli.Settings;
import mdoc.internal.io.IO$;
import mdoc.internal.markdown.DocumentLinks;
import mdoc.internal.markdown.Markdown$;
import mdoc.internal.markdown.MarkdownReference;
import mdoc.internal.markdown.MarkdownReference$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Builder;
import scala.deriving.Mirror;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.RelativePath;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.util.matching.Regex;

public final class DocumentLinks$
implements Mirror.Product,
Serializable {
    private static final Regex HtmlName;
    private static final Regex HtmlId;
    public static final DocumentLinks$ MODULE$;

    private DocumentLinks$() {
    }

    static {
        MODULE$ = new DocumentLinks$();
        HtmlName = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("name=\"([^\"]+)\""));
        HtmlId = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("id=\"([^\"]+)\""));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DocumentLinks$.class);
    }

    public DocumentLinks apply(RelativePath relpath, List<String> definitions, List<MarkdownReference> references) {
        return new DocumentLinks(relpath, definitions, references);
    }

    public DocumentLinks unapply(DocumentLinks x$1) {
        return x$1;
    }

    private String dashChars() {
        return " -_";
    }

    public List<DocumentLinks> fromGeneratedSite(Settings settings) {
        Builder links = package$.MODULE$.List().newBuilder();
        IO$.MODULE$.foreachOutput(settings, (Function2<AbsolutePath, RelativePath, BoxedUnit>)(JProcedure2 & Serializable)(abspath, relpath) -> {
            boolean isMarkdown;
            String string = PathIO$.MODULE$.extension(relpath.toNIO());
            String string2 = "md";
            boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (isMarkdown = false);
            if (isMarkdown) {
                Input.VirtualFile input = Input.VirtualFile$.MODULE$.apply(relpath.toString(), FileIO$.MODULE$.slurp(abspath, settings.charset()));
                links.$plus$eq((Object)this.fromMarkdown((Function1<String, String>)settings.headerIdGenerator(), (RelativePath)relpath, (Input)input));
                return;
            }
        });
        return (List)links.result();
    }

    public DocumentLinks fromMarkdown(Function1<String, String> headerIdGenerator, RelativePath relpath, Input input) {
        MutableDataSet markdownSettings = Markdown$.MODULE$.plainSettings();
        Parser parser = Parser.builder((DataHolder)markdownSettings).build();
        Document ast = parser.parse(input.text());
        Builder definitions = package$.MODULE$.List().newBuilder();
        Builder links = package$.MODULE$.List().newBuilder();
        Markdown$.MODULE$.foreach((Node)ast, (Function1<Node, BoxedUnit>)(JProcedure1 & Serializable)x$1 -> {
            HtmlInline h;
            Paragraph p;
            Node node = x$1;
            if (node instanceof Heading) {
                Heading heading = (Heading)node;
                definitions.$plus$eq(headerIdGenerator.apply((Object)heading.getText().toString()));
                return;
            }
            if (node instanceof Paragraph && (p = (Paragraph)node).getChars().startsWith((CharSequence)"<a name=")) {
                List list;
                Option option;
                String string = (String)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(p.getChars().toString())).next();
                if (string != null && !(option = HtmlName.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                    String string2;
                    String id = string2 = (String)list.apply(0);
                    definitions.$plus$eq((Object)id);
                    return;
                }
                return;
            }
            if (node instanceof HtmlInline && !(h = (HtmlInline)node).getChars().startsWith((CharSequence)"</")) {
                this.handleRegex$1(h, definitions, HtmlId);
                this.handleRegex$1(h, definitions, HtmlName);
                return;
            }
            if (node instanceof Link) {
                Link link = (Link)node;
                Position.Range pos = Position.Range$.MODULE$.apply(input, link.getStartOffset(), link.getEndOffset());
                links.$plus$eq((Object)MarkdownReference$.MODULE$.apply(link.getUrl().toString(), (Position)pos));
                return;
            }
            Node els = node;
        });
        return this.apply(relpath, (List<String>)((List)definitions.result()), (List<MarkdownReference>)((List)links.result()));
    }

    public DocumentLinks fromProduct(Product x$0) {
        return new DocumentLinks((RelativePath)x$0.productElement(0), (List<String>)((List)x$0.productElement(1)), (List<MarkdownReference>)((List)x$0.productElement(2)));
    }

    private final void handleRegex$1(HtmlInline h$1, Builder definitions$2, Regex r) {
        r.findAllMatchIn((CharSequence)h$1.getChars()).foreach((Function1 & Serializable)m -> (Builder)definitions$2.$plus$eq((Object)m.group(1)));
    }
}

