/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.worksheets;

import java.io.Serializable;
import mdoc.document.Binder;
import mdoc.document.Statement;
import mdoc.interfaces.RangePosition;
import mdoc.internal.cli.Context;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.InputFile$;
import mdoc.internal.cli.Settings;
import mdoc.internal.document.Printing$;
import mdoc.internal.io.StoreReporter;
import mdoc.internal.markdown.EvaluatedDocument;
import mdoc.internal.markdown.Instrumented;
import mdoc.internal.markdown.Instrumenter$;
import mdoc.internal.markdown.MarkdownBuilder$;
import mdoc.internal.markdown.MarkdownCompiler;
import mdoc.internal.markdown.Modifier;
import mdoc.internal.markdown.SectionInput;
import mdoc.internal.markdown.SectionInput$;
import mdoc.internal.pos.PositionSyntax$;
import mdoc.internal.worksheets.EvaluatedWorksheet;
import mdoc.internal.worksheets.EvaluatedWorksheet$;
import mdoc.internal.worksheets.EvaluatedWorksheetStatement;
import mdoc.internal.worksheets.EvaluatedWorksheetStatement$;
import mdoc.internal.worksheets.RenderSummaryResult;
import mdoc.internal.worksheets.RenderSummaryResult$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.meta.inputs.Input;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class WorksheetProvider {
    private final Settings settings;
    private final StoreReporter reporter;
    private final int minimumMargin;

    public WorksheetProvider(Settings settings) {
        this.settings = settings;
        this.reporter = new StoreReporter();
        this.minimumMargin = 20;
    }

    public EvaluatedWorksheet evaluateWorksheet(Input.VirtualFile input, Context ctx, Option<Modifier> modifier) {
        SectionInput sectionInput = SectionInput$.MODULE$.apply((Input)input, (Modifier)modifier.getOrElse(WorksheetProvider::$anonfun$1), ctx);
        List sectionInputs = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SectionInput[]{sectionInput}));
        InputFile file = InputFile$.MODULE$.fromRelativeFilename(input.path(), this.settings);
        Instrumented instrumented = Instrumenter$.MODULE$.instrument(file, (List<SectionInput>)sectionInputs, this.settings, this.reporter);
        MarkdownCompiler compiler = ctx.compiler(instrumented);
        EvaluatedDocument rendered = MarkdownBuilder$.MODULE$.buildDocument(compiler, this.reporter, (List<SectionInput>)sectionInputs, instrumented, input.path());
        Iterator decorations = rendered.sections().iterator().flatMap((Function1 & Serializable)section -> section.section().statements().map((Function1 & Serializable)statement -> this.renderDecoration((Statement)statement)));
        return EvaluatedWorksheet$.MODULE$.apply(PositionSyntax$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)this.reporter.diagnostics().map((Function1 & Serializable)d -> d)).toSeq()).asJava(), PositionSyntax$.MODULE$.SeqHasAsJava((Seq)decorations.filterNot((Function1 & Serializable)_$1 -> _$1.summary().isEmpty()).map((Function1 & Serializable)d -> d).toList()).asJava(), PositionSyntax$.MODULE$.SeqHasAsJava((Seq)instrumented.fileImports().map((Function1 & Serializable)_$2 -> _$2.toInterface())).asJava(), PositionSyntax$.MODULE$.SeqHasAsJava((Seq)instrumented.scalacOptionImports().map((Function1 & Serializable)_$3 -> _$3.value())).asJava(), PositionSyntax$.MODULE$.SeqHasAsJava(compiler.classpathEntries()).asJava(), PositionSyntax$.MODULE$.SeqHasAsJava((Seq)instrumented.dependencies().toSeq()).asJava(), PositionSyntax$.MODULE$.SeqHasAsJava((Seq)instrumented.repositories().toSeq()).asJava());
    }

    private EvaluatedWorksheetStatement renderDecoration(Statement statement) {
        mdoc.document.RangePosition pos = statement.position();
        mdoc.document.RangePosition range = new mdoc.document.RangePosition(pos.startLine(), pos.startColumn(), pos.endLine(), pos.endColumn());
        int margin = scala.math.package$.MODULE$.max(this.minimumMargin, this.settings.screenWidth() - statement.position().endColumn());
        boolean isEmptyValue = this.isUnitType(statement) || statement.binders().isEmpty();
        RenderSummaryResult renderSummaryResult = this.renderSummary(statement, margin, isEmptyValue);
        String details = this.renderDetails(statement, isEmptyValue);
        return EvaluatedWorksheetStatement$.MODULE$.apply((RangePosition)range, renderSummaryResult.summary(), details, renderSummaryResult.isSummaryComplete());
    }

    private String renderDetails(Statement statement, boolean isEmptyValue) {
        StringBuilder out = new StringBuilder();
        if (!isEmptyValue) {
            statement.binders().iterator().foreach((Function1 & Serializable)binder -> {
                out.append(out.nonEmpty() ? "\n" : "").append(binder.name()).append(": ").append(binder.tpeString()).append(" = ");
                return out.append(Printing$.MODULE$.inline$nullableToString((Object)binder.stringValue()));
            });
        }
        StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(statement.out())).foreach((Function1 & Serializable)line -> out.append(out.nonEmpty() ? "\n" : "").append("// ").append(line));
        return out.toString();
    }

    private RenderSummaryResult renderSummary(Statement statement, int margin, boolean isEmptyValue) {
        boolean bl;
        StringBuilder out = new StringBuilder();
        if (isEmptyValue) {
            if (!statement.out().isEmpty()) {
                Iterator lines = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(statement.out()));
                out.append((String)lines.next());
                bl = lines.hasNext() || out.length() > margin;
            } else {
                bl = false;
            }
        } else {
            boolean isSingle = statement.binders().lengthCompare(1) == 0;
            bl = BoxesRunTime.unboxToBoolean((Object)statement.binders().iterator().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable)(x$1, x$2) -> WorksheetProvider.$anonfun$3(isSingle, out, margin, BoxesRunTime.unboxToBoolean((Object)x$1), (Binder)x$2)));
        }
        boolean isOverMargin = bl;
        return RenderSummaryResult$.MODULE$.apply(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(out.result()), margin), !isOverMargin);
    }

    private boolean isUnitType(Statement statement) {
        List list = statement.binders();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            Binder head = (Binder)colon2.head();
            Nil$ nil$ = package$.MODULE$.Nil();
            List list3 = list2;
            if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = head.value();
                return !(boxedUnit != null ? !boxedUnit.equals(object) : object != null);
            }
        }
        return false;
    }

    private static final Modifier $anonfun$1() {
        return Modifier.Default$.MODULE$.apply();
    }

    private static final /* synthetic */ boolean $anonfun$3(boolean isSingle$1, StringBuilder out$3, int margin$1, boolean x$1, Binder x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)x$1), (Object)x$2);
        if (tuple2 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
            if (bl) {
                return true;
            }
            if (!bl) {
                Binder binder = (Binder)tuple2._2();
                if (!isSingle$1) {
                    out$3.append(out$3.isEmpty() ? "" : ", ").append(binder.name()).append(": ").append(binder.tpeString()).append(" = ");
                }
                if (isSingle$1) {
                    out$3.append(": ").append(binder.tpeString()).append(" = ");
                }
                int width$proxy1 = margin$1 - out$3.length();
                out$3.append(Printing$.MODULE$.inline$nullableToString((Object)binder.stringValue()).replace("\n", ""));
                return out$3.length() > margin$1;
            }
        }
        throw new MatchError((Object)tuple2);
    }
}

