/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import java.io.Serializable;
import java.net.URI;
import mdoc.Reporter;
import mdoc.internal.markdown.DeadLinkInfo;
import mdoc.internal.markdown.DeadLinkInfo$;
import mdoc.internal.markdown.DocumentLinks;
import metaconfig.internal.Levenshtein$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.package$;
import scala.meta.inputs.Position;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;

public final class LinkHygiene$
implements Serializable {
    public static final LinkHygiene$ MODULE$ = new LinkHygiene$();

    private LinkHygiene$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LinkHygiene$.class);
    }

    public List<DeadLinkInfo> lint(List<DocumentLinks> docs, boolean verbose) {
        Set isValidHeading = docs.iterator().flatMap((Function1 & Serializable)_$1 -> _$1.absoluteDefinitions()).toSet();
        return docs.map((Function1 & Serializable)doc -> {
            URI enclosingDocument = doc.relpath().toURI(false);
            return Tuple2$.MODULE$.apply(doc, (Object)enclosingDocument);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                DocumentLinks doc = (DocumentLinks)tuple2._1();
                URI enclosingDocument = (URI)tuple2._2();
                return doc.references().flatMap((Function1 & Serializable)reference -> MODULE$.resolve(enclosingDocument, reference.url()).withFilter((Function1 & Serializable)uri -> uri.getScheme() == null && uri.getHost() == null).withFilter((Function1 & Serializable)uri -> !isValidHeading.apply(uri)).map((Function1 & Serializable)uri -> {
                    String string;
                    String string2;
                    boolean isAbsolutePath = uri.getPath().startsWith("/");
                    if (verbose) {
                        String headings = ((IterableOnceOps)((IterableOnceOps)isValidHeading.map((Function1 & Serializable)_$2 -> _$2.toString())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n  ");
                        string2 = new StringBuilder(19).append("\nisValidHeading:\n  ").append(headings).toString();
                    } else {
                        string2 = "";
                    }
                    String debug = string2;
                    Seq candidates = ((IterableOnceOps)isValidHeading.map((Function1 & Serializable)_$3 -> _$3.toString())).toSeq();
                    Option<String> option = MODULE$.closestCandidate(uri.toString(), (Seq<String>)candidates);
                    if (None$.MODULE$.equals(option)) {
                        string = ".";
                    } else if (option instanceof Some) {
                        String similar = (String)((Some)option).value();
                        string = new StringBuilder(18).append(", did you mean '").append(similar).append("'?").toString();
                    } else {
                        throw new MatchError(option);
                    }
                    String help = string;
                    String hint = isAbsolutePath ? new StringBuilder(108).append(" To fix this problem, either make the link relative or turn it into complete URL such as http://example.com").append(uri).append(".").toString() : "";
                    return DeadLinkInfo$.MODULE$.apply(reference.pos(), new StringBuilder(15).append("Unknown link '").append(uri).append("'").append(help).append(hint).append(debug).toString());
                }));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void report(boolean asError, List<DeadLinkInfo> deadLinks, Reporter reporter) {
        if (asError) {
            deadLinks.foreach((Function1)(JProcedure1 & Serializable)deadLink -> this.printDeadLink$1((Function2)(JProcedure2 & Serializable)(pos, msg) -> reporter.error(pos, msg), (DeadLinkInfo)deadLink));
            return;
        }
        deadLinks.foreach((Function1)(JProcedure1 & Serializable)deadLink -> this.printDeadLink$1((Function2)(JProcedure2 & Serializable)(pos, msg) -> reporter.warning(pos, msg), (DeadLinkInfo)deadLink));
    }

    public Option<String> closestCandidate(String query, Seq<String> candidates) {
        if (candidates.isEmpty()) {
            return None$.MODULE$;
        }
        String candidate = (String)((IterableOps)candidates.sortBy((Function1 & Serializable)s2 -> Levenshtein$.MODULE$.distance(query, s2), (Ordering)Ordering.Int$.MODULE$)).head();
        int maxLength = query.length() + candidate.length();
        int minDifference = package$.MODULE$.abs(query.length() - candidate.length());
        double difference = (double)Levenshtein$.MODULE$.distance(candidate, query) - (double)minDifference;
        double ratio = ((double)maxLength - difference) / (double)maxLength;
        if (ratio > 0.9) {
            return Some$.MODULE$.apply((Object)candidate);
        }
        return None$.MODULE$;
    }

    private Option<URI> resolve(URI baseUri, String reference) {
        None$ none$;
        try {
            none$ = Some$.MODULE$.apply((Object)baseUri.resolve(reference).normalize());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private final void printDeadLink$1(Function2 print, DeadLinkInfo deadLink) {
        DeadLinkInfo deadLinkInfo = deadLink;
        if (deadLinkInfo == null) {
            throw new MatchError((Object)deadLinkInfo);
        }
        DeadLinkInfo deadLinkInfo2 = DeadLinkInfo$.MODULE$.unapply(deadLinkInfo);
        Position position = deadLinkInfo2._1();
        String string = deadLinkInfo2._2();
        Position pos = position;
        String msg = string;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)pos, (Object)msg);
        Position pos2 = (Position)tuple2._1();
        String msg2 = (String)tuple2._2();
        print.apply((Object)pos2, (Object)msg2);
    }
}

