/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.livereload;

import io.undertow.Undertow;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.Serializable;
import java.nio.file.Path;
import mdoc.Reporter;
import mdoc.internal.livereload.LiveReload;
import mdoc.internal.livereload.UndertowLiveReload$;
import org.xnio.ChannelListener;
import scala.Function0;
import scala.Function1;
import scala.Product;
import scala.collection.mutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class UndertowLiveReload
implements LiveReload,
Product,
Serializable {
    private final Undertow server;
    private final Reporter reporter;
    private final int port;
    private final String url;
    private final Set openChannels;

    public static UndertowLiveReload apply(Path path, String string, int n, Reporter reporter, Function0<String> function0) {
        return UndertowLiveReload$.MODULE$.apply(path, string, n, reporter, function0);
    }

    public static UndertowLiveReload fromProduct(Product product) {
        return UndertowLiveReload$.MODULE$.fromProduct(product);
    }

    public static UndertowLiveReload unapply(UndertowLiveReload undertowLiveReload) {
        return UndertowLiveReload$.MODULE$.unapply(undertowLiveReload);
    }

    public static String apply$default$2() {
        return UndertowLiveReload$.MODULE$.apply$default$2();
    }

    public static int apply$default$3() {
        return UndertowLiveReload$.MODULE$.apply$default$3();
    }

    public static Reporter apply$default$4() {
        return UndertowLiveReload$.MODULE$.apply$default$4();
    }

    public static Function0<String> apply$default$5() {
        return UndertowLiveReload$.MODULE$.apply$default$5();
    }

    public UndertowLiveReload(Undertow server, Reporter reporter, int port, String url, Set<WebSocketChannel> openChannels) {
        this.server = server;
        this.reporter = reporter;
        this.port = port;
        this.url = url;
        this.openChannels = openChannels;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)1520447593);
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.server()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.reporter()));
        n = Statics.mix((int)n, (int)this.port());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.url()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.openChannels()));
        return Statics.finalizeHash((int)n, (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof UndertowLiveReload)) return false;
        UndertowLiveReload undertowLiveReload = (UndertowLiveReload)object;
        if (this.port() != undertowLiveReload.port()) return false;
        Undertow undertow = this.server();
        Undertow undertow2 = undertowLiveReload.server();
        if (undertow == null) {
            if (undertow2 != null) {
                return false;
            }
        } else if (!undertow.equals(undertow2)) return false;
        Reporter reporter = this.reporter();
        Reporter reporter2 = undertowLiveReload.reporter();
        if (reporter == null) {
            if (reporter2 != null) {
                return false;
            }
        } else if (!reporter.equals(reporter2)) return false;
        String string = this.url();
        String string2 = undertowLiveReload.url();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Set<WebSocketChannel> set = this.openChannels();
        Set<WebSocketChannel> set2 = undertowLiveReload.openChannels();
        if (set == null) {
            if (set2 == null) return true;
            return false;
        } else {
            if (!set.equals(set2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof UndertowLiveReload;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "UndertowLiveReload";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this._3());
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "server";
            }
            case 1: {
                return "reporter";
            }
            case 2: {
                return "port";
            }
            case 3: {
                return "url";
            }
            case 4: {
                return "openChannels";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Undertow server() {
        return this.server;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public int port() {
        return this.port;
    }

    public String url() {
        return this.url;
    }

    public Set<WebSocketChannel> openChannels() {
        return this.openChannels;
    }

    @Override
    public void start() {
        this.reporter().info(new StringBuilder(30).append("LiveReload server started on ").append(this.url()).append("/").toString());
        this.server().start();
    }

    @Override
    public void stop() {
        this.server().stop();
    }

    public void reload(String path) {
        this.sendJson(new StringBuilder(45).append("{\"command\":\"reload\",\"path\":\"").append(path).append("\",\"liveCss\":true}").toString());
    }

    @Override
    public void reload(Path path) {
        this.reload(path.toString());
    }

    @Override
    public void alert(String message) {
        this.sendJson(new StringBuilder(32).append("{\"command\":\"alert\",\"message\":\"").append(message).append("\"}").toString());
    }

    private void sendJson(String json) {
        this.openChannels().foreach((Function1)(JProcedure1 & Serializable)channel -> WebSockets.sendTextBlocking((String)json, (WebSocketChannel)channel));
    }

    private UndertowLiveReload copy(Undertow server, Reporter reporter, int port, String url, Set<WebSocketChannel> openChannels) {
        return new UndertowLiveReload(server, reporter, port, url, openChannels);
    }

    private Undertow copy$default$1() {
        return this.server();
    }

    private Reporter copy$default$2() {
        return this.reporter();
    }

    private int copy$default$3() {
        return this.port();
    }

    private String copy$default$4() {
        return this.url();
    }

    private Set<WebSocketChannel> copy$default$5() {
        return this.openChannels();
    }

    public Undertow _1() {
        return this.server();
    }

    public Reporter _2() {
        return this.reporter();
    }

    public int _3() {
        return this.port();
    }

    public String _4() {
        return this.url();
    }

    public Set<WebSocketChannel> _5() {
        return this.openChannels();
    }

    public static final class LiveReloadConnectionCallback
    implements WebSocketConnectionCallback {
        public final Set<WebSocketChannel> mdoc$internal$livereload$UndertowLiveReload$LiveReloadConnectionCallback$$openChannels;

        public LiveReloadConnectionCallback(Set<WebSocketChannel> openChannels) {
            this.mdoc$internal$livereload$UndertowLiveReload$LiveReloadConnectionCallback$$openChannels = openChannels;
        }

        public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
            channel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(this){
                private final /* synthetic */ LiveReloadConnectionCallback $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void onClose(WebSocketChannel webSocketChannel, StreamSourceFrameChannel channel) {
                    this.$outer.mdoc$internal$livereload$UndertowLiveReload$LiveReloadConnectionCallback$$openChannels.remove((Object)webSocketChannel);
                    super.onClose(webSocketChannel, channel);
                }

                public void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) {
                    if (message.getData().contains("command\":\"hello")) {
                        String hello = "{\"command\":\"hello\",\"protocols\":[\"http://livereload.com/protocols/official-7\"],\"serverName\":\"mdoc\"}";
                        WebSockets.sendTextBlocking((String)hello, (WebSocketChannel)channel);
                        this.$outer.mdoc$internal$livereload$UndertowLiveReload$LiveReloadConnectionCallback$$openChannels.add((Object)channel);
                        return;
                    }
                }
            });
            channel.resumeReceives();
        }
    }
}

