/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.markdown;

import java.io.Serializable;
import mdoc.Reporter;
import mdoc.interfaces.ImportedScriptFile;
import mdoc.internal.cli.InputFile;
import mdoc.internal.markdown.FileImport$;
import mdoc.internal.markdown.MagicImport;
import mdoc.internal.markdown.Rename;
import mdoc.internal.pos.PositionSyntax$;
import mdoc.internal.pos.TokenEditDistance;
import mdoc.internal.pos.TokenEditDistance$;
import mdoc.internal.worksheets.ImportedScriptFile$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.meta.Importee;
import scala.meta.Importer;
import scala.meta.Importer$;
import scala.meta.Term;
import scala.meta.inputs.Input;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.hashing.MurmurHash3$;

public final class FileImport
implements Product,
Serializable {
    private final AbsolutePath path;
    private final MagicImport importName;
    private final String objectName;
    private final Option packageName;
    private final String source;
    private final List dependencies;
    private final List renames;
    private final String fullyQualifiedName;
    private final String prefix;
    private final Input toInput;
    private final Option edit;

    public static FileImport apply(AbsolutePath absolutePath, MagicImport magicImport, String string, Option<String> option, String string2, List<FileImport> list, List<Rename> list2) {
        return FileImport$.MODULE$.apply(absolutePath, magicImport, string, option, string2, list, list2);
    }

    public static FileImport fromProduct(Product product) {
        return FileImport$.MODULE$.fromProduct(product);
    }

    public static Option<FileImport> fromUsing(AbsolutePath absolutePath, MagicImport magicImport, Reporter reporter) {
        return FileImport$.MODULE$.fromUsing(absolutePath, magicImport, reporter);
    }

    public static FileImport unapply(FileImport fileImport) {
        return FileImport$.MODULE$.unapply(fileImport);
    }

    public FileImport(AbsolutePath path, MagicImport importName, String objectName, Option<String> packageName, String source, List<FileImport> dependencies, List<Rename> renames) {
        String string;
        this.path = path;
        this.importName = importName;
        this.objectName = objectName;
        this.packageName = packageName;
        this.source = source;
        this.dependencies = dependencies;
        this.renames = renames;
        this.fullyQualifiedName = new StringBuilder(1).append(packageName).append(".").append(objectName).toString();
        Option<String> option = packageName;
        if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(9).append("object ").append(objectName).append(" {").toString();
        } else if (option instanceof Some) {
            String name = (String)((Some)option).value();
            string = new StringBuilder(19).append("package ").append(name).append("; object ").append(objectName).append(" {").toString();
        } else {
            throw new MatchError(option);
        }
        this.prefix = string;
        StringBuilder out = new StringBuilder().append(this.prefix());
        IntRef i = IntRef.create((int)0);
        ((List)renames.sortBy((Function1 & Serializable)_$1 -> _$1.from().start(), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)rename -> {
            out.append(source, i$1.elem, rename.from().start()).append(rename.to());
            i$1.elem = rename.from().end();
        });
        out.append(source, i.elem, source.length()).append("\n}\n");
        this.toInput = Input.VirtualFile$.MODULE$.apply(path.syntax(), out.toString());
        this.edit = TokenEditDistance$.MODULE$.apply((Input)Input.VirtualFile$.MODULE$.apply(path.syntax(), source), this.toInput());
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -2015469844, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FileImport)) return false;
        FileImport fileImport = (FileImport)object;
        AbsolutePath absolutePath = this.path();
        AbsolutePath absolutePath2 = fileImport.path();
        if (absolutePath == null) {
            if (absolutePath2 != null) {
                return false;
            }
        } else if (!absolutePath.equals(absolutePath2)) return false;
        MagicImport magicImport = this.importName();
        MagicImport magicImport2 = fileImport.importName();
        if (magicImport == null) {
            if (magicImport2 != null) {
                return false;
            }
        } else if (!((Object)magicImport).equals(magicImport2)) return false;
        String string = this.objectName();
        String string2 = fileImport.objectName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<String> option = this.packageName();
        Option<String> option2 = fileImport.packageName();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        String string3 = this.source();
        String string4 = fileImport.source();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        List<FileImport> list = this.dependencies();
        List<FileImport> list2 = fileImport.dependencies();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        List<Rename> list3 = this.renames();
        List<Rename> list4 = fileImport.renames();
        if (list3 == null) {
            if (list4 == null) return true;
            return false;
        } else {
            if (!list3.equals(list4)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof FileImport;
    }

    public int productArity() {
        return 7;
    }

    public String productPrefix() {
        return "FileImport";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "path";
            }
            case 1: {
                return "importName";
            }
            case 2: {
                return "objectName";
            }
            case 3: {
                return "packageName";
            }
            case 4: {
                return "source";
            }
            case 5: {
                return "dependencies";
            }
            case 6: {
                return "renames";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public AbsolutePath path() {
        return this.path;
    }

    public MagicImport importName() {
        return this.importName;
    }

    public String objectName() {
        return this.objectName;
    }

    public Option<String> packageName() {
        return this.packageName;
    }

    public String source() {
        return this.source;
    }

    public List<FileImport> dependencies() {
        return this.dependencies;
    }

    public List<Rename> renames() {
        return this.renames;
    }

    public String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public String prefix() {
        return this.prefix;
    }

    public Input toInput() {
        return this.toInput;
    }

    public Option<TokenEditDistance> edit() {
        return this.edit;
    }

    public ImportedScriptFile toInterface() {
        return ImportedScriptFile$.MODULE$.apply(this.path().toNIO(), (String)this.packageName().getOrElse(FileImport::toInterface$$anonfun$1), this.objectName(), this.toInput().text(), this.source(), PositionSyntax$.MODULE$.SeqHasAsJava((Seq)this.dependencies().map((Function1 & Serializable)_$2 -> _$2.toInterface())).asJava());
    }

    public FileImport copy(AbsolutePath path, MagicImport importName, String objectName, Option<String> packageName, String source, List<FileImport> dependencies, List<Rename> renames) {
        return new FileImport(path, importName, objectName, packageName, source, dependencies, renames);
    }

    public AbsolutePath copy$default$1() {
        return this.path();
    }

    public MagicImport copy$default$2() {
        return this.importName();
    }

    public String copy$default$3() {
        return this.objectName();
    }

    public Option<String> copy$default$4() {
        return this.packageName();
    }

    public String copy$default$5() {
        return this.source();
    }

    public List<FileImport> copy$default$6() {
        return this.dependencies();
    }

    public List<Rename> copy$default$7() {
        return this.renames();
    }

    public AbsolutePath _1() {
        return this.path();
    }

    public MagicImport _2() {
        return this.importName();
    }

    public String _3() {
        return this.objectName();
    }

    public Option<String> _4() {
        return this.packageName();
    }

    public String _5() {
        return this.source();
    }

    public List<FileImport> _6() {
        return this.dependencies();
    }

    public List<Rename> _7() {
        return this.renames();
    }

    private static final String toInterface$$anonfun$1() {
        return "";
    }

    public static class Matcher {
        private final InputFile file;
        private final Reporter reporter;

        public Matcher(InputFile file, Reporter reporter) {
            this.file = file;
            this.reporter = reporter;
        }

        public Option<List<FileImport>> unapply(Importer importer) {
            Option option;
            Importer importer2 = importer;
            if (importer2 != null && !(option = Importer$.MODULE$.unapply(importer2)).isEmpty()) {
                Tuple2 tuple2 = (Tuple2)option.get();
                Term.Ref qual = (Term.Ref)tuple2._1();
                List importees = (List)tuple2._2();
                Importer importer3 = importer2;
                if (this.isFileQualifier((Term)qual)) {
                    List<Option<FileImport>> parsed = FileImport$.MODULE$.mdoc$internal$markdown$FileImport$$$fromImportees(this.file.inputFile(), (Term)qual, (List<Importee>)importees, this.reporter);
                    if (parsed.forall(FileImport$::mdoc$internal$markdown$FileImport$Matcher$$_$unapply$$anonfun$1)) {
                        return Some$.MODULE$.apply((Object)parsed.map(FileImport$::mdoc$internal$markdown$FileImport$Matcher$$_$unapply$$anonfun$2));
                    }
                    return None$.MODULE$;
                }
            }
            return None$.MODULE$;
        }

        private boolean isFileQualifier(Term qual) {
            while (true) {
                Term next;
                Option option;
                String string;
                Option option2;
                Term term;
                if ((term = qual) instanceof Term.Name && !(option2 = Term.Name$.MODULE$.unapply((Term.Name)term)).isEmpty() && "$file".equals(string = (String)option2.get())) {
                    return true;
                }
                if (!(term instanceof Term.Select) || (option = Term.Select$.MODULE$.unapply((Term.Select)term)).isEmpty()) break;
                Tuple2 tuple2 = (Tuple2)option.get();
                qual = next = (Term)tuple2._1();
            }
            return false;
        }
    }
}

