/*
 * Decompiled with CFR 0.152.
 */
package metabrowse.cli;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.zip.GZIPOutputStream;
import metabrowse.MetabrowseEnrichments;
import metabrowse.MetabrowseEnrichments$;
import metabrowse.cli.FingerprintOps$;
import metabrowse.cli.MetabrowseOptions;
import metabrowse.cli.Target;
import metabrowse.cli.TermDisplay;
import metabrowse.cli.TermDisplay$;
import metabrowse.schema.Position;
import metabrowse.schema.Ranges;
import metabrowse.schema.Ranges$;
import metabrowse.schema.SymbolIndex;
import metabrowse.schema.SymbolIndex$;
import metabrowse.schema.SymbolIndexes;
import metabrowse.schema.SymbolIndexes$;
import metabrowse.schema.Workspace;
import metabrowse.schema.Workspace$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.SetLike;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.mutable.ParArray;
import scala.collection.parallel.mutable.ParArray$;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.PathIO$;
import scala.meta.internal.metabrowse.ScalametaInternals$;
import scala.meta.internal.semanticdb.Range;
import scala.meta.internal.semanticdb.Scala;
import scala.meta.internal.semanticdb.Scala$;
import scala.meta.internal.semanticdb.SymbolOccurrence;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.internal.semanticdb.TextDocuments;
import scala.meta.internal.semanticdb.TextDocuments$;
import scala.meta.io.AbsolutePath;
import scala.meta.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import scalapb.UnknownFieldSet;
import scalapb.json4s.JsonFormat$;

@ScalaSignature(bytes="\u0006\u0001\t\u001dd\u0001\u0002\u0015*\u00019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\")A\u000b\u0001C\u0001+\"9\u0011\f\u0001b\u0001\n\u0017Q\u0006BB.\u0001A\u0003%!\tC\u0004]\u0001\t\u0007I\u0011\u0002.\t\ru\u0003\u0001\u0015!\u0003C\u0011)q\u0006\u0001%A\u0001\u0004\u0003\u0006Ia\u0018\u0005\bQ\u0002\u0011\r\u0011\"\u0001[\u0011\u0019I\u0007\u0001)A\u0005\u0005\"9!\u000e\u0001b\u0001\n\u0003Y\u0007B\u00027\u0001A\u0003%!\rC\u0004n\u0001\t\u0007I\u0011\u00028\t\rI\u0004\u0001\u0015!\u0003p\u0011\u001d\u0019\bA1A\u0005\nQDa\u0001\u001f\u0001!\u0002\u0013)\bbB=\u0001\u0005\u0004%I\u0001\u001e\u0005\u0007u\u0002\u0001\u000b\u0011B;\t\u000fm\u0004!\u0019!C\u0005y\"9\u0011q\u0004\u0001!\u0002\u0013i\b\"CA\u0011\u0001\t\u0007I\u0011BA\u0012\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005\u0015\u0002\"CA#\u0001\t\u0007I\u0011BA$\u0011!\t)\u0006\u0001Q\u0001\n\u0005%\u0003bBA,\u0001\u0011%\u0011\u0011\f\u0005\b\u0003\u007f\u0002A\u0011BAA\u0011\u001d\t\t\n\u0001C\u0005\u0003'+Q!!*\u0001\u0001\tDq!a*\u0001\t\u0013\tI\u000bC\u0004\u0002b\u0002!\t!a9\t\u000f\u0005e\b\u0001\"\u0003\u0002|\"9!q\u0002\u0001\u0005\n\tE\u0001b\u0002B\u000f\u0001\u0011\u0005!q\u0004\u0005\b\u0005c\u0001A\u0011\u0001B\u001a\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0005\u000bBqAa\u0012\u0001\t\u0013\u0011I\u0005C\u0004\u0003\\\u0001!IA!\u0018\t\u000f\t\r\u0004\u0001\"\u0001\u0003F!9!Q\r\u0001\u0005\u0002\t\u0015#!C\"mSJ+hN\\3s\u0015\tQ3&A\u0002dY&T\u0011\u0001L\u0001\u000b[\u0016$\u0018M\u0019:poN,7\u0001A\n\u0003\u0001=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a!\u00118z%\u00164\u0017!C2mCN\u001c\b/\u0019;i!\r9tH\u0011\b\u0003qur!!\u000f\u001f\u000e\u0003iR!aO\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0014B\u0001 2\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Q!\u0003\u0007M+\u0017O\u0003\u0002?cA\u00111)\u0013\b\u0003\t\u001es!\u0001O#\n\u0005\u0019\u000b\u0014\u0001B7fi\u0006L!A\u0010%\u000b\u0005\u0019\u000b\u0014B\u0001&L\u00051\t%m]8mkR,\u0007+\u0019;i\u0013\taUJA\u0004BY&\f7/Z:\u000b\u00059C\u0015AA5p\u0003\u001dy\u0007\u000f^5p]N\u0004\"!\u0015*\u000e\u0003%J!aU\u0015\u0003#5+G/\u00192s_^\u001cXm\u00149uS>t7/\u0001\u0004=S:LGO\u0010\u000b\u0004-^C\u0006CA)\u0001\u0011\u0015)4\u00011\u00017\u0011\u0015y5\u00011\u0001Q\u0003\r\u0019w\u000fZ\u000b\u0002\u0005\u0006!1m\u001e3!\u0003)\u0019x.\u001e:dKJ|w\u000e^\u0001\fg>,(oY3s_>$\b%A\u0002yIM\u0002B\u0001\r1CE&\u0011\u0011-\r\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007A\u001aW-\u0003\u0002ec\tIa)\u001e8di&|g\u000e\r\t\u0003a\u0019L!aZ\u0019\u0003\tUs\u0017\u000e^\u0001\u0007i\u0006\u0014x-\u001a;\u0002\u000fQ\f'oZ3uA\u00059qN\\\"m_N,W#\u00012\u0002\u0011=t7\t\\8tK\u0002\nq\u0001Z5ta2\f\u00170F\u0001p!\t\t\u0006/\u0003\u0002rS\tYA+\u001a:n\t&\u001c\b\u000f\\1z\u0003!!\u0017n\u001d9mCf\u0004\u0013AC:f[\u0006tG/[2eEV\tQ\u000f\u0005\u0002wo6\tQ*\u0003\u0002K\u001b\u0006Y1/Z7b]RL7\r\u001a2!\u0003)\u0019\u00180\u001c2pYJ{w\u000e^\u0001\fgfl'm\u001c7S_>$\b%A\u0005gS2,g.Y7fgV\tQ\u0010E\u0003\u007f\u0003\u0017\ty!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001B;uS2T!!!\u0003\u0002\t)\fg/Y\u0005\u0004\u0003\u001by(!F\"p]\u000e,(O]3oiN[\u0017\u000e\u001d'jgR\u001cV\r\u001e\t\u0005\u0003#\tIB\u0004\u0003\u0002\u0014\u0005U\u0001CA\u001d2\u0013\r\t9\"M\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0011Q\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]\u0011'\u0001\u0006gS2,g.Y7fg\u0002\nqa]=nE>d7/\u0006\u0002\u0002&A9a0a\n\u0002\u0010\u0005-\u0012bAA\u0015\u007f\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\r\u00055\u00121GA\u001c\u001b\t\tyCC\u0002\u00022}\fa!\u0019;p[&\u001c\u0017\u0002BA\u001b\u0003_\u0011q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011QH\u0016\u0002\rM\u001c\u0007.Z7b\u0013\u0011\t\t%a\u000f\u0003\u0017MKXNY8m\u0013:$W\r_\u0001\tgfl'm\u001c7tA\u0005yQ.\u00199qS:<g)\u001e8di&|g.\u0006\u0002\u0002JAA\u00111JA)\u0003\u001f\tY#\u0004\u0002\u0002N)!\u0011qJA\u0002\u0003!1WO\\2uS>t\u0017\u0002BA*\u0003\u001b\u0012\u0001BR;oGRLwN\\\u0001\u0011[\u0006\u0004\b/\u001b8h\rVt7\r^5p]\u0002\n\u0011b\u001c<fe^\u0014\u0018\u000e^3\u0015\u000b\u0015\fY&a\u001c\t\u000f\u0005u\u0013\u00041\u0001\u0002`\u0005\u0019q.\u001e;\u0011\t\u0005\u0005\u00141N\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005!a-\u001b7f\u0015\u0011\tI'a\u0002\u0002\u00079Lw.\u0003\u0003\u0002n\u0005\r$\u0001\u0002)bi\"Dq!!\u001d\u001a\u0001\u0004\t\u0019(A\u0003csR,7\u000fE\u00031\u0003k\nI(C\u0002\u0002xE\u0012Q!\u0011:sCf\u00042\u0001MA>\u0013\r\ti(\r\u0002\u0005\u0005f$X-A\u0007bI\u0012$UMZ5oSRLwN\u001c\u000b\u0006K\u0006\r\u0015q\u0011\u0005\b\u0003\u000bS\u0002\u0019AA\b\u0003\u0019\u0019\u00180\u001c2pY\"9\u0011\u0011\u0012\u000eA\u0002\u0005-\u0015\u0001\u00039pg&$\u0018n\u001c8\u0011\t\u0005e\u0012QR\u0005\u0005\u0003\u001f\u000bYD\u0001\u0005Q_NLG/[8o\u00031\tG\r\u001a*fM\u0016\u0014XM\\2f)\u001d)\u0017QSAM\u0003GCq!a&\u001c\u0001\u0004\ty!\u0001\u0005gS2,g.Y7f\u0011\u001d\tYj\u0007a\u0001\u0003;\u000bQA]1oO\u0016\u0004B!!\u000f\u0002 &!\u0011\u0011UA\u001e\u0005\u0015\u0011\u0016M\\4f\u0011\u001d\t)i\u0007a\u0001\u0003\u001f\u0011A\u0001V5dW\u0006)\u0001\u000f[1tKV!\u00111VAZ)\u0019\ti+a5\u0002XR!\u0011qVAc!\u0011\t\t,a-\r\u0001\u00119\u0011QW\u000fC\u0002\u0005]&!\u0001+\u0012\t\u0005e\u0016q\u0018\t\u0004a\u0005m\u0016bAA_c\t9aj\u001c;iS:<\u0007c\u0001\u0019\u0002B&\u0019\u00111Y\u0019\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002Hv\u0001\r!!3\u0002\u0003\u0019\u0004r\u0001MAf\u0003\u001f\fy+C\u0002\u0002NF\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007\u0005EG$D\u0001\u0001\u0011\u001d\t).\ba\u0001\u0003\u001f\tA\u0001^1tW\"9\u0011\u0011\\\u000fA\u0002\u0005m\u0017A\u00027f]\u001e$\b\u000eE\u00021\u0003;L1!a82\u0005\rIe\u000e^\u0001\u0010g\u000e\fgnU3nC:$\u0018n\u00193cgR\u0011\u0011Q\u001d\t\u0006\u0003O\f)PQ\u0007\u0003\u0003STA!a;\u0002n\u00069Q.\u001e;bE2,'\u0002BAx\u0003c\f\u0001\u0002]1sC2dW\r\u001c\u0006\u0004\u0003g\f\u0014AC2pY2,7\r^5p]&!\u0011q_Au\u0005!\u0001\u0016M]!se\u0006L\u0018AC;qI\u0006$X\rV3yiR!\u0011Q B\u0006!\u0011\tyPa\u0002\u000e\u0005\t\u0005!bA:\u0003\u0004)\u0019!Q\u0001%\u0002\u0011%tG/\u001a:oC2LAA!\u0003\u0003\u0002\taA+\u001a=u\t>\u001cW/\\3oi\"9!QB\u0010A\u0002\u0005u\u0018a\u00013pG\u0006i\u0001/\u0019:tK\u0012\u000bG/\u00192bg\u0016$BAa\u0005\u0003\u001aA!\u0011q B\u000b\u0013\u0011\u00119B!\u0001\u0003\u001bQ+\u0007\u0010\u001e#pGVlWM\u001c;t\u0011\u0019\u0011Y\u0002\ta\u0001\u0005\u0006!\u0001/\u0019;i\u0003A\u0011W/\u001b7e'fl'm\u001c7J]\u0012,\u0007\u0010F\u0003f\u0005C\u0011i\u0003C\u0004\u0003$\u0005\u0002\rA!\n\u0002\u000bA\fG\u000f[:\u0011\u000b\t\u001d\"\u0011\u0006\"\u000e\u0005\u0005E\u0018\u0002\u0002B\u0016\u0003c\u0014!cR3o)J\fg/\u001a:tC\ndWm\u00148dK\"9!qF\u0011A\u0002\u0005m\u0017a\u00017f]\u0006Y2/_7c_2Le\u000eZ3y\u0005f$v\u000e\u001d'fm\u0016d7+_7c_2,\"A!\u000e\u0011\u0011\t]\"\u0011HA\b\u0005{i!!a\u0001\n\t\tm\u00121\u0001\u0002\u0004\u001b\u0006\u0004\b#B\u001c\u0003@\u0005]\u0012b\u0001B!\u0003\n!A*[:u\u0003A9(/\u001b;f'fl'm\u001c7J]\u0012,\u0007\u0010F\u0001f\u0003])\b\u000fZ1uKJ+g-\u001a:f]\u000e,7OR8s)f\u0004X\r\u0006\u0004\u00028\t-#q\u000b\u0005\b\u0005\u001b\"\u0003\u0019\u0001B(\u0003)\u0019\u00180\u001c2pYNl\u0015\r\u001d\t\t\u0005#\u0012)&a\u0004\u0002,5\u0011!1\u000b\u0006\u0005\u0003\u0003\t\t0\u0003\u0003\u0003<\tM\u0003b\u0002B-I\u0001\u0007\u0011qG\u0001\fgfl'm\u001c7J]\u0012,\u00070\u0001\rva\u0012\fG/\u001a#fM&t\u0017\u000e^5p]N4uN\u001d+fe6$b!a\u000e\u0003`\t\u0005\u0004b\u0002B'K\u0001\u0007!q\n\u0005\b\u00053*\u0003\u0019AA\u001c\u000399(/\u001b;f/>\u00148n\u001d9bG\u0016\f1A];o\u0001")
public class CliRunner {
    private final Seq<AbsolutePath> classpath;
    private final AbsolutePath metabrowse$cli$CliRunner$$cwd;
    private final AbsolutePath sourceroot;
    private final /* synthetic */ Tuple2 x$3;
    private final AbsolutePath target;
    private final Function0<BoxedUnit> onClose;
    private final TermDisplay display;
    private final AbsolutePath semanticdb;
    private final AbsolutePath symbolRoot;
    private final ConcurrentSkipListSet<String> filenames;
    private final ConcurrentHashMap<String, AtomicReference<SymbolIndex>> symbols;
    private final Function<String, AtomicReference<SymbolIndex>> mappingFunction;

    public AbsolutePath metabrowse$cli$CliRunner$$cwd() {
        return this.metabrowse$cli$CliRunner$$cwd;
    }

    private AbsolutePath sourceroot() {
        return this.sourceroot;
    }

    public AbsolutePath target() {
        return this.target;
    }

    public Function0<BoxedUnit> onClose() {
        return this.onClose;
    }

    private TermDisplay display() {
        return this.display;
    }

    private AbsolutePath semanticdb() {
        return this.semanticdb;
    }

    private AbsolutePath symbolRoot() {
        return this.symbolRoot;
    }

    private ConcurrentSkipListSet<String> filenames() {
        return this.filenames;
    }

    private ConcurrentHashMap<String, AtomicReference<SymbolIndex>> symbols() {
        return this.symbols;
    }

    private Function<String, AtomicReference<SymbolIndex>> mappingFunction() {
        return this.mappingFunction;
    }

    private void overwrite(Path out, byte[] bytes) {
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty()) {
            return;
        }
        Path gzout = out.resolveSibling(new StringBuilder(3).append(((Object)out.getFileName()).toString()).append(".gz").toString());
        try (OutputStream fos = Files.newOutputStream(gzout, new OpenOption[0]);
             GZIPOutputStream gos = new GZIPOutputStream(fos, bytes.length);){
            gos.write(bytes);
            gos.finish();
        }
    }

    private void addDefinition(String symbol, Position position) {
        AtomicReference<SymbolIndex> value = this.symbols().computeIfAbsent(symbol, this.mappingFunction());
        value.getAndUpdate(new UnaryOperator<SymbolIndex>(null, position){
            private final Position position$1;

            public SymbolIndex apply(SymbolIndex t) {
                return (SymbolIndex)t.definition().fold((Function0 & Serializable & scala.Serializable)() -> {
                    Some x$1 = new Some((Object)$this.position$1);
                    String x$2 = t.copy$default$1();
                    scala.collection.immutable.Map x$3 = t.copy$default$3();
                    UnknownFieldSet x$4 = t.copy$default$4();
                    return t.copy(x$2, (Option)x$1, x$3, x$4);
                }, (Function1 & Serializable & scala.Serializable)x$4 -> t);
            }
            {
                this.position$1 = position$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(metabrowse.cli.CliRunner$$anon$1 metabrowse.schema.SymbolIndex ), $anonfun$apply$2(metabrowse.schema.SymbolIndex metabrowse.schema.Position )}, serializedLambda);
            }
        });
    }

    private void addReference(String filename, metabrowse.schema.Range range, String symbol) {
        AtomicReference<SymbolIndex> value = this.symbols().computeIfAbsent(symbol, this.mappingFunction());
        value.getAndUpdate(new UnaryOperator<SymbolIndex>(null, filename, range){
            private final String filename$1;
            private final metabrowse.schema.Range range$1;

            public SymbolIndex apply(SymbolIndex t) {
                scala.collection.immutable.Map newReferences;
                Ranges ranges = (Ranges)t.references().getOrElse((Object)this.filename$1, (Function0 & Serializable & scala.Serializable)() -> new Ranges(Ranges$.MODULE$.apply$default$1(), Ranges$.MODULE$.apply$default$2()));
                Ranges newRanges = ranges.copy((Seq)ranges.ranges().$colon$plus((Object)this.range$1, Seq$.MODULE$.canBuildFrom()), ranges.copy$default$2());
                scala.collection.immutable.Map x$1 = newReferences = t.references().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.filename$1), (Object)newRanges));
                String x$2 = t.copy$default$1();
                Option x$3 = t.copy$default$2();
                UnknownFieldSet x$4 = t.copy$default$4();
                return t.copy(x$2, x$3, x$1, x$4);
            }
            {
                this.filename$1 = filename$1;
                this.range$1 = range$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$3()}, serializedLambda);
            }
        });
    }

    private <T> T phase(String task, int length, Function1<Function0<BoxedUnit>, T> f) {
        this.display().startTask(task, new File("target"));
        this.display().taskLength(task, length, 0L);
        AtomicInteger counter = new AtomicInteger();
        JFunction0.mcV.sp & Serializable & scala.Serializable tick = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.display().taskProgress(task, counter.incrementAndGet());
        Object result = f.apply((Object)tick);
        this.display().completedTask(task, true);
        return (T)result;
    }

    public ParArray<AbsolutePath> scanSemanticdbs() {
        return (ParArray)this.phase("Scanning semanticdb files", this.classpath.length(), (Function1 & Serializable & scala.Serializable)tick -> {
            Combiner files = ParArray$.MODULE$.newBuilder();
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(this, files){
                private final /* synthetic */ CliRunner $outer;
                private final Combiner files$1;

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String filename = ((Object)file.getFileName()).toString();
                    Object object = filename.endsWith(".semanticdb") || filename.endsWith(".semanticdb.json") ? this.files$1.$plus$eq((Object)package$.MODULE$.AbsolutePath().apply(file, this.$outer.metabrowse$cli$CliRunner$$cwd())) : BoxedUnit.UNIT;
                    return FileVisitResult.CONTINUE;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.files$1 = files$1;
                }
            };
            $this.classpath.foreach((Function1 & Serializable & scala.Serializable)path -> {
                tick.apply$mcV$sp();
                return Files.isDirectory(path.toNIO(), new LinkOption[0]) ? Files.walkFileTree(path.toNIO(), visitor) : BoxedUnit.UNIT;
            });
            return (ParArray)files.result();
        });
    }

    private TextDocument updateText(TextDocument doc) {
        TextDocument textDocument;
        if (doc.text().isEmpty()) {
            AbsolutePath abspath = this.sourceroot().resolve(doc.uri());
            if (abspath.isFile()) {
                String md5;
                String text = FileIO$.MODULE$.slurp(abspath, StandardCharsets.UTF_8);
                String string = md5 = FingerprintOps$.MODULE$.md5(text);
                String string2 = doc.md5();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    System.err.println(new StringBuilder(45).append("error: md5 fingerprint mismatch for document ").append(doc.uri()).toString());
                }
                textDocument = doc.withText(text);
            } else {
                System.err.println(new StringBuilder(38).append("error: No file on disc for document '").append(abspath).append("'").toString());
                textDocument = doc;
            }
        } else {
            textDocument = doc;
        }
        return textDocument;
    }

    private TextDocuments parseDatabase(AbsolutePath path) {
        TextDocuments textDocuments;
        String filename = ((Object)path.toNIO().getFileName()).toString();
        byte[] bytes = path.readAllBytes();
        if (filename.endsWith(".semanticdb")) {
            textDocuments = (TextDocuments)TextDocuments$.MODULE$.parseFrom(bytes);
        } else if (filename.endsWith(".semanticdb.json")) {
            String string = new String(bytes, StandardCharsets.UTF_8);
            textDocuments = (TextDocuments)JsonFormat$.MODULE$.fromJsonString(string, TextDocuments$.MODULE$.messageCompanion());
        } else {
            throw new IllegalArgumentException(new StringBuilder(20).append("Unexpected filename ").append(filename).toString());
        }
        return textDocuments;
    }

    public void buildSymbolIndex(GenTraversableOnce<AbsolutePath> paths, int len) {
        this.phase("Building symbol index", len, (Function1 & Serializable & scala.Serializable)tick -> {
            paths.foreach((Function1 & Serializable & scala.Serializable)path -> {
                CliRunner.$anonfun$buildSymbolIndex$2($this, tick, path);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, List<SymbolIndex>> symbolIndexByTopLevelSymbol() {
        void var1_1;
        HashMap byToplevel = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.symbols()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String sym = (String)tuple2._1();
            AtomicReference ref = (AtomicReference)tuple2._2();
            String toplevel = MetabrowseEnrichments.XtensionSymbolString$.MODULE$.toplevelPackage$extension(MetabrowseEnrichments$.MODULE$.XtensionSymbolString(sym));
            List old = (List)byToplevel.getOrDefault(toplevel, Nil$.MODULE$);
            SymbolIndex symbolIndex = (SymbolIndex)ref.get();
            List list = byToplevel.put(toplevel, old.$colon$colon((Object)symbolIndex));
            return list;
        });
        return var1_1;
    }

    public void writeSymbolIndex() {
        this.phase("Writing symbol index", this.symbols().size(), (Function1 & Serializable & scala.Serializable)tick -> {
            CliRunner.$anonfun$writeSymbolIndex$1(this, tick);
            return BoxedUnit.UNIT;
        });
    }

    private SymbolIndex updateReferencesForType(scala.collection.concurrent.Map<String, AtomicReference<SymbolIndex>> symbolsMap, SymbolIndex symbolIndex) {
        SymbolIndex symbolIndex2;
        if (Scala$.MODULE$.ScalaSymbolOps(symbolIndex.symbol()).isType()) {
            try {
                Tuple2<String, Scala.Descriptor> tuple2 = ScalametaInternals$.MODULE$.ownerAndDesc(symbolIndex.symbol());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String owner = (String)tuple2._1();
                Scala.Descriptor desc = (Scala.Descriptor)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)owner, (Object)desc);
                Tuple2 tuple23 = tuple22;
                String owner2 = (String)tuple23._1();
                Scala.Descriptor desc2 = (Scala.Descriptor)tuple23._2();
                Option maybeTermInfo = symbolsMap.get((Object)Scala.Symbols$.MODULE$.Global(owner2, (Scala.Descriptor)new Scala.Descriptor$.Term(desc2.name().value()))).withFilter((Function1 & Serializable & scala.Serializable)syntheticObjRef -> BoxesRunTime.boxToBoolean((boolean)CliRunner.$anonfun$updateReferencesForType$1(syntheticObjRef))).map((Function1 & Serializable & scala.Serializable)syntheticObjRef -> {
                    scala.collection.immutable.Map x$1 = ((SymbolIndex)syntheticObjRef.get()).references();
                    String x$2 = symbolIndex.copy$default$1();
                    Option x$3 = symbolIndex.copy$default$2();
                    UnknownFieldSet x$4 = symbolIndex.copy$default$4();
                    return symbolIndex.copy(x$2, x$3, x$1, x$4);
                });
                symbolIndex2 = (SymbolIndex)maybeTermInfo.getOrElse((Function0 & Serializable & scala.Serializable)() -> symbolIndex);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                SymbolIndex symbolIndex3 = symbolIndex;
                symbolIndex2 = symbolIndex3;
            }
        } else {
            symbolIndex2 = symbolIndex;
        }
        return symbolIndex2;
    }

    private SymbolIndex updateDefinitionsForTerm(scala.collection.concurrent.Map<String, AtomicReference<SymbolIndex>> symbolsMap, SymbolIndex symbolIndex) {
        SymbolIndex symbolIndex2;
        if (Scala$.MODULE$.ScalaSymbolOps(symbolIndex.symbol()).isTerm()) {
            Tuple2<String, Scala.Descriptor> tuple2 = ScalametaInternals$.MODULE$.ownerAndDesc(symbolIndex.symbol());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String owner = (String)tuple2._1();
            Scala.Descriptor desc = (Scala.Descriptor)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)owner, (Object)desc);
            Tuple2 tuple23 = tuple22;
            String owner2 = (String)tuple23._1();
            Scala.Descriptor desc2 = (Scala.Descriptor)tuple23._2();
            Option maybeTypeInfo = symbolsMap.get((Object)Scala.Symbols$.MODULE$.Global(owner2, (Scala.Descriptor)new Scala.Descriptor$.Type(desc2.name().value()))).flatMap((Function1 & Serializable & scala.Serializable)typeRef -> ((SymbolIndex)typeRef.get()).definition().map((Function1 & Serializable & scala.Serializable)definition -> {
                Some x$1 = new Some(definition);
                String x$2 = symbolIndex.copy$default$1();
                scala.collection.immutable.Map x$3 = symbolIndex.copy$default$3();
                UnknownFieldSet x$4 = symbolIndex.copy$default$4();
                return symbolIndex.copy(x$2, (Option)x$1, x$3, x$4);
            }));
            symbolIndex2 = (SymbolIndex)maybeTypeInfo.getOrElse((Function0 & Serializable & scala.Serializable)() -> symbolIndex);
        } else {
            symbolIndex2 = symbolIndex;
        }
        return symbolIndex2;
    }

    public void writeWorkspace() {
        Workspace workspace = new Workspace(((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.filenames()).asScala()).toSeq(), Workspace$.MODULE$.apply$default$2());
        this.overwrite(this.target().resolve("index.workspace").toNIO(), workspace.toByteArray());
    }

    public void run() {
        try {
            this.display().init();
            Files.createDirectories(this.target().toNIO(), new FileAttribute[0]);
            ParArray<AbsolutePath> paths = this.scanSemanticdbs();
            this.buildSymbolIndex((GenTraversableOnce<AbsolutePath>)paths, paths.length());
            this.writeSymbolIndex();
            this.writeWorkspace();
        }
        finally {
            this.display().stop();
            this.onClose().apply$mcV$sp();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$buildSymbolIndex$4(CliRunner $this, TextDocument document$1, SymbolOccurrence x0$1) {
        String sym;
        SymbolOccurrence symbolOccurrence = x0$1;
        if (symbolOccurrence != null && !(sym = symbolOccurrence.symbol()).endsWith(".") && !sym.endsWith("#")) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (symbolOccurrence != null) {
            Option option = symbolOccurrence.range();
            String sym2 = symbolOccurrence.symbol();
            SymbolOccurrence.Role role = symbolOccurrence.role();
            if (option instanceof Some) {
                Some some = (Some)option;
                Range r = (Range)some.value();
                if (SymbolOccurrence.Role$.DEFINITION$.MODULE$.equals(role)) {
                    $this.addDefinition(sym2, MetabrowseEnrichments.XtensionSemanticdbRange$.MODULE$.toPosition$extension(MetabrowseEnrichments$.MODULE$.XtensionSemanticdbRange(r), document$1.uri()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (symbolOccurrence != null) {
            Option option = symbolOccurrence.range();
            String sym3 = symbolOccurrence.symbol();
            SymbolOccurrence.Role role = symbolOccurrence.role();
            if (option instanceof Some) {
                Some some = (Some)option;
                Range r = (Range)some.value();
                if (SymbolOccurrence.Role$.REFERENCE$.MODULE$.equals(role)) {
                    $this.addReference(document$1.uri(), MetabrowseEnrichments.XtensionSemanticdbRange$.MODULE$.toDocRange$extension(MetabrowseEnrichments$.MODULE$.XtensionSemanticdbRange(r)), sym3);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$buildSymbolIndex$3(CliRunner $this, TextDocument noTextDocument) {
        TextDocument document = $this.updateText(noTextDocument);
        document.occurrences().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CliRunner.$anonfun$buildSymbolIndex$4($this, document, x0$1);
            return BoxedUnit.UNIT;
        });
        AbsolutePath out = $this.semanticdb().resolve(document.uri());
        Files.createDirectories(out.toNIO().getParent(), new FileAttribute[0]);
        TextDocument textDocument = document;
        $this.overwrite(out.toNIO().resolveSibling(new StringBuilder(11).append(((Object)out.toNIO().getFileName()).toString()).append(".semanticdb").toString()), new TextDocuments((Seq)Nil$.MODULE$.$colon$colon((Object)textDocument)).toByteArray());
        return $this.filenames().add(document.uri());
    }

    public static final /* synthetic */ void $anonfun$buildSymbolIndex$2(CliRunner $this, Function0 tick$2, AbsolutePath path) {
        try {
            tick$2.apply$mcV$sp();
            TextDocuments db = $this.parseDatabase(path);
            db.documents().foreach((Function1 & Serializable & scala.Serializable)noTextDocument -> BoxesRunTime.boxToBoolean((boolean)CliRunner.$anonfun$buildSymbolIndex$3($this, noTextDocument)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                System.err.println(String.valueOf(path));
                StackTraceElement[] shortTrace = (StackTraceElement[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])e.getStackTrace())).take(10);
                e.setStackTrace(shortTrace);
                e.printStackTrace(new PrintStream(System.err));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$writeSymbolIndex$4(SymbolIndex x$7) {
        return x$7.definition().isDefined();
    }

    public static final /* synthetic */ void $anonfun$writeSymbolIndex$2(CliRunner $this, Function0 tick$3, scala.collection.concurrent.Map symbolsMap$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String sym = (String)tuple2._1();
            List indexes = (List)tuple2._2();
            tick$3.apply$mcV$sp();
            List actualIndexes = (List)indexes.map((Function1 & Serializable & scala.Serializable)symbolIndex -> {
                SymbolIndex symbolIndex2;
                Option option = symbolIndex.definition();
                if (option instanceof Some) {
                    symbolIndex2 = $this.updateReferencesForType((scala.collection.concurrent.Map<String, AtomicReference<SymbolIndex>>)symbolsMap$1, (SymbolIndex)symbolIndex);
                } else if (None$.MODULE$.equals(option)) {
                    symbolIndex2 = $this.updateDefinitionsForTerm((scala.collection.concurrent.Map<String, AtomicReference<SymbolIndex>>)symbolsMap$1, (SymbolIndex)symbolIndex);
                } else {
                    throw new MatchError((Object)option);
                }
                SymbolIndex actualIndex = symbolIndex2;
                return actualIndex;
            }, List$.MODULE$.canBuildFrom());
            SymbolIndexes symbolIndexes = new SymbolIndexes((Seq)actualIndexes.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CliRunner.$anonfun$writeSymbolIndex$4(x$7))), SymbolIndexes$.MODULE$.apply$default$2());
            if (symbolIndexes.indexes().nonEmpty()) {
                String filename = new StringOps(Predef$.MODULE$.augmentString(MetabrowseEnrichments.XtensionSymbolString$.MODULE$.symbolIndexPath$extension(MetabrowseEnrichments$.MODULE$.XtensionSymbolString(sym)))).stripSuffix(".gz");
                AbsolutePath out = $this.symbolRoot().resolve(filename);
                Files.createDirectories(out.toNIO().getParent(), new FileAttribute[0]);
                $this.overwrite(out.toNIO(), symbolIndexes.toByteArray());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$writeSymbolIndex$1(CliRunner $this, Function0 tick) {
        Files.createDirectory($this.symbolRoot().toNIO(), new FileAttribute[0]);
        scala.collection.concurrent.Map symbolsMap = (scala.collection.concurrent.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter($this.symbols()).asScala();
        scala.collection.mutable.Map byToplevel = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter($this.symbolIndexByTopLevelSymbol()).asScala();
        byToplevel.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CliRunner.$anonfun$writeSymbolIndex$2($this, tick, symbolsMap, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$updateReferencesForType$1(AtomicReference syntheticObjRef) {
        return ((SymbolIndex)syntheticObjRef.get()).definition().isEmpty();
    }

    public CliRunner(Seq<AbsolutePath> classpath, MetabrowseOptions options) {
        Target target;
        Target target2;
        this.classpath = classpath;
        this.metabrowse$cli$CliRunner$$cwd = (AbsolutePath)options.cwd().fold((Function0 & Serializable & scala.Serializable)() -> PathIO$.MODULE$.workingDirectory(), (Function1 & Serializable & scala.Serializable)x$1 -> package$.MODULE$.AbsolutePath().apply(x$1, this.metabrowse$cli$CliRunner$$cwd()));
        this.sourceroot = (AbsolutePath)options.sourceroot().fold((Function0 & Serializable & scala.Serializable)() -> PathIO$.MODULE$.workingDirectory(), (Function1 & Serializable & scala.Serializable)x$2 -> package$.MODULE$.AbsolutePath().apply(x$2, this.metabrowse$cli$CliRunner$$cwd()));
        if (options.zip()) {
            AbsolutePath out = options.targetPath().resolve("metabrowse.zip");
            Files.createDirectories(out.toNIO().getParent(), new FileAttribute[0]);
            URI uRI = URI.create(new StringBuilder(9).append("jar:file:").append(out.toURI().getPath()).toString());
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            FileSystem zipfs = FileSystems.newFileSystem(uRI, env);
            target2 = new Target(package$.MODULE$.AbsolutePath().apply(zipfs.getPath("/", new String[0]), this.metabrowse$cli$CliRunner$$cwd()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> zipfs.close());
        } else {
            target2 = target = new Target(options.targetPath(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
        }
        if (target == null) {
            throw new MatchError((Object)target);
        }
        AbsolutePath target3 = target.target();
        Function0<BoxedUnit> onClose = target.onClose();
        Tuple2 tuple2 = new Tuple2((Object)target3, onClose);
        this.x$3 = tuple2;
        this.target = (AbsolutePath)this.x$3._1();
        this.onClose = (Function0)this.x$3._2();
        this.display = new TermDisplay(new OutputStreamWriter(System.out), options.nonInteractive() || TermDisplay$.MODULE$.defaultFallbackMode());
        this.semanticdb = this.target().resolve("semanticdb");
        this.symbolRoot = this.target().resolve("symbol");
        this.filenames = new ConcurrentSkipListSet();
        this.symbols = new ConcurrentHashMap();
        this.mappingFunction = t -> new AtomicReference<SymbolIndex>(new SymbolIndex(t, SymbolIndex$.MODULE$.apply$default$2(), SymbolIndex$.MODULE$.apply$default$3(), SymbolIndex$.MODULE$.apply$default$4()));
    }
}

