/*
 * Decompiled with CFR 0.152.
 */
package metabrowse.server;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import metabrowse.schema.Position$;
import metabrowse.schema.SymbolIndex;
import metabrowse.schema.SymbolIndex$;
import metabrowse.schema.SymbolIndexes;
import metabrowse.schema.SymbolIndexes$;
import metabrowse.schema.Workspace;
import metabrowse.schema.Workspace$;
import metabrowse.server.MetabrowseServer$;
import metabrowse.server.MetabrowseServer$State$;
import metabrowse.server.Sourcepath;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map;
import scala.meta.Dialect;
import scala.meta.inputs.Input;
import scala.meta.interactive.InteractiveSemanticdb$;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.InputStreamIO$;
import scala.meta.internal.metals.EmptyReportContext$;
import scala.meta.internal.metals.ReportContext;
import scala.meta.internal.mtags.Mtags$;
import scala.meta.internal.mtags.MtagsEnrichments$;
import scala.meta.internal.mtags.OnDemandSymbolIndex;
import scala.meta.internal.mtags.OnDemandSymbolIndex$;
import scala.meta.internal.mtags.Symbol$;
import scala.meta.internal.mtags.SymbolDefinition;
import scala.meta.internal.semanticdb.SymbolOccurrence;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.internal.semanticdb.TextDocuments;
import scala.meta.internal.semanticdb.TextDocuments$;
import scala.meta.internal.semanticdb.scalac.AnnotationOps;
import scala.meta.internal.semanticdb.scalac.DiagnosticOps;
import scala.meta.internal.semanticdb.scalac.InputOps;
import scala.meta.internal.semanticdb.scalac.LanguageOps;
import scala.meta.internal.semanticdb.scalac.ParseOps;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$AnnotatedOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$Attachable$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$ClassOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$CompoundTypeTreeOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$ConstfoldOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$ExistentialTypeTreeOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$NewArrayOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$SelectOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$SelfTypeOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$SingletonTypeTreeOf$;
import scala.meta.internal.semanticdb.scalac.ReporterOps;
import scala.meta.internal.semanticdb.scalac.SemanticdbConfig;
import scala.meta.internal.semanticdb.scalac.SemanticdbOps;
import scala.meta.internal.semanticdb.scalac.SemanticdbReporter;
import scala.meta.internal.semanticdb.scalac.SymbolInformationOps;
import scala.meta.internal.semanticdb.scalac.SymbolOps;
import scala.meta.internal.semanticdb.scalac.SymbolOps$SemanticdbDecls$;
import scala.meta.internal.semanticdb.scalac.SymbolOpsCompat;
import scala.meta.internal.semanticdb.scalac.SyntheticOps;
import scala.meta.internal.semanticdb.scalac.TextDocumentOps;
import scala.meta.internal.semanticdb.scalac.TypeOps;
import scala.meta.internal.semanticdb.scalac.TypeOps$ByNameType$;
import scala.meta.internal.semanticdb.scalac.TypeOps$RepeatedType$;
import scala.meta.internal.semanticdb.scalac.VersionSpecificOps;
import scala.meta.internal.semanticdb.scalac.VersionSpecificOps$NamedApplyBlock$;
import scala.meta.internal.semanticdb.scalac.VersionSpecificOps$OriginalTreeOf$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.internal.AnnotationInfos;
import scala.reflect.internal.Names;
import scala.reflect.internal.Scopes;
import scala.reflect.internal.Symbols;
import scala.reflect.internal.Trees;
import scala.reflect.internal.Types;
import scala.reflect.internal.util.Position;
import scala.reflect.internal.util.SourceFile;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.tools.nsc.CompilationUnits;
import scala.tools.nsc.interactive.Global;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rug\u0001B'O\u0001MC\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"Aa\u000f\u0001B\u0001B\u0003%a\u000e\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003y\u0011!Y\bA!A!\u0002\u0013a\bbBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002:\u0001!\t!a\u000f\u0007\r\u0005]\u0004\u0001QA=\u0011)\t\u0019k\u0003BK\u0002\u0013\u0005\u0011Q\u0015\u0005\u000b\u0003k[!\u0011#Q\u0001\n\u0005\u001d\u0006BCA\\\u0017\tU\r\u0011\"\u0001\u0002:\"Q\u0011\u0011[\u0006\u0003\u0012\u0003\u0006I!a/\t\u0015\u0005M7B!f\u0001\n\u0003\t)\u000e\u0003\u0006\u0002X.\u0011\t\u0012)A\u0005\u0003'B!\"a\n\f\u0005+\u0007I\u0011AAm\u0011)\tYn\u0003B\tB\u0003%\u0011\u0011\u0006\u0005\b\u0003\u0013YA\u0011AAo\u0011)\tYo\u0003EC\u0002\u0013%\u0011Q\u001e\u0005\u000b\u0003k\\\u0001R1A\u0005\n\u0005]\b\"\u0003B\u0003\u0017\t\u0007I\u0011\u0002B\u0004\u0011!\u0011)c\u0003Q\u0001\n\t%\u0001b\u0002B\u0014\u0017\u0011%!\u0011\u0006\u0005\b\u0005_YA\u0011\u0001B\u0019\u0011\u001d\u00119d\u0003C\u0001\u0003cA\u0011B!\u000f\f\u0003\u0003%\tAa\u000f\t\u0013\t\u00153\"%A\u0005\u0002\t\u001d\u0003\"\u0003B/\u0017E\u0005I\u0011\u0001B0\u0011%\u0011\u0019gCI\u0001\n\u0003\u0011)\u0007C\u0005\u0003j-\t\n\u0011\"\u0001\u0003l!I!qN\u0006\u0002\u0002\u0013\u0005#\u0011\u000f\u0005\n\u0005oZ\u0011\u0011!C\u0001\u0005sB\u0011Ba\u001f\f\u0003\u0003%\tA! \t\u0013\t%5\"!A\u0005B\t-\u0005\"\u0003BM\u0017\u0005\u0005I\u0011\u0001BN\u0011%\u0011yjCA\u0001\n\u0003\u0012\t\u000bC\u0005\u0003$.\t\t\u0011\"\u0011\u0003&\"I!qU\u0006\u0002\u0002\u0013\u0005#\u0011V\u0004\n\u0005[\u0003\u0011\u0011!E\u0001\u0005_3\u0011\"a\u001e\u0001\u0003\u0003E\tA!-\t\u000f\u0005%!\u0006\"\u0001\u0003@\"I!1\u0015\u0016\u0002\u0002\u0013\u0015#Q\u0015\u0005\n\u0005\u0003T\u0013\u0011!CA\u0005\u0007D\u0011B!4+\u0003\u0003%\tIa4\t\u0013\tu\u0007A1A\u0005\n\t}\u0007\u0002\u0003Bw\u0001\u0001\u0006IA!9\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\"9\u00111\u001b\u0001\u0005\u0002\u0005U\u0007bBA\u0014\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005_\u0004A\u0011\u0002By\u0011%\u0019y\u0002\u0001b\u0001\n\u0013\u0019\t\u0003\u0003\u0005\u0004$\u0001\u0001\u000b\u0011BA>\u0011%\u0019)\u0003\u0001b\u0001\n\u0013\u00199\u0003\u0003\u0005\u00040\u0001\u0001\u000b\u0011BB\u0015\u0011!y\u0005A1A\u0005\n\r\u0005\u0003\u0002CB&\u0001\u0001\u0006Iaa\u0011\t\u000f\r5\u0003\u0001\"\u0003\u0004P!91q\r\u0001\u0005\n\r%\u0004bBB8\u0001\u0011%1\u0011\u000f\u0005\b\u0007\u007f\u0002A\u0011BBA\u0011\u001d\u0019\u0019\n\u0001C\u0005\u0007+Cqa!)\u0001\t\u0013\u0019\u0019kB\u0004\u0004(:C\ta!+\u0007\r5s\u0005\u0012ABV\u0011\u001d\tIA\u0011C\u0001\u0007[Cqaa,C\t\u0003\u0019\t\fC\u0004\u0004:\n#Iaa/\t\u000f\ru&\t\"\u0003\u0004<\"91q\u0018\"\u0005\n\r\u0005\u0007bBBb\u0005\u0012%1\u0011\u0019\u0005\n\u0007\u000b\u0014\u0015\u0013!C\u0001\u0007\u000fD\u0011ba3C#\u0003%\ta!4\t\u0013\rE')%A\u0005\u0002\rM\u0007\"CBl\u0005F\u0005I\u0011ABm\u0005AiU\r^1ce><8/Z*feZ,'O\u0003\u0002P!\u000611/\u001a:wKJT\u0011!U\u0001\u000b[\u0016$\u0018M\u0019:poN,7\u0001A\n\u0003\u0001Q\u0003\"!\u0016-\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u0013a!\u00118z%\u00164\u0017a\u00023jC2,7\r\u001e\t\u00039~k\u0011!\u0018\u0006\u0003=Z\u000bA!\\3uC&\u0011\u0001-\u0018\u0002\b\t&\fG.Z2u\u00035\u00198-\u00197bG>\u0003H/[8ogB\u00191m\u001b8\u000f\u0005\u0011LgBA3i\u001b\u00051'BA4S\u0003\u0019a$o\\8u}%\tq+\u0003\u0002k-\u00069\u0001/Y2lC\u001e,\u0017B\u00017n\u0005\u0011a\u0015n\u001d;\u000b\u0005)4\u0006CA8t\u001d\t\u0001\u0018\u000f\u0005\u0002f-&\u0011!OV\u0001\u0007!J,G-\u001a4\n\u0005Q,(AB*ue&twM\u0003\u0002s-\u0006!\u0001n\\:u\u0003\u0011\u0001xN\u001d;\u0011\u0005UK\u0018B\u0001>W\u0005\rIe\u000e^\u0001\u0007Y><w-\u001a:\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0006g24GG\u001b\u0006\u0003\u0003\u0007\t1a\u001c:h\u0013\r\t9A \u0002\u0007\u0019><w-\u001a:\u0002\rqJg.\u001b;?)1\ti!!\u0005\u0002\u0014\u0005U\u0011qCA\r!\r\ty\u0001A\u0007\u0002\u001d\")!L\u0002a\u00017\"9\u0011M\u0002I\u0001\u0002\u0004\u0011\u0007b\u0002<\u0007!\u0003\u0005\rA\u001c\u0005\bo\u001a\u0001\n\u00111\u0001y\u0011\u001dYh\u0001%AA\u0002q\fQa\u001d;beR$B!a\b\u0002&A\u0019Q+!\t\n\u0007\u0005\rbK\u0001\u0003V]&$\bbBA\u0014\u000f\u0001\u0007\u0011\u0011F\u0001\u000bg>,(oY3qCRD\u0007\u0003BA\b\u0003WI1!!\fO\u0005)\u0019v.\u001e:dKB\fG\u000f[\u0001\u0005gR|\u0007\u000f\u0006\u0002\u0002 \u0005\u0001\"/\u001a9mC\u000e,7\t\\1tgB\fG\u000f\u001b\u000b\u0005\u0003?\t9\u0004C\u0004\u0002(%\u0001\r!!\u000b\u0002\u0019U\u0014HNR8s'fl'm\u001c7\u0015\t\u0005u\u0012q\n\u000b\u0005\u0003\u007f\t)\u0005\u0005\u0003V\u0003\u0003r\u0017bAA\"-\n1q\n\u001d;j_:Dq!a\u0012\u000b\u0001\u0004\tI%\u0001\u0004ts6\u0014w\u000e\u001c\t\u0005\u0003\u0017\n9G\u0004\u0003\u0002N\u0005=C\u0002\u0001\u0005\b\u0003#R\u0001\u0019AA*\u0003!\u0019w.\u001c9jY\u0016\u0014\b\u0003BA+\u0003Gj!!a\u0016\u000b\t\u0005e\u00131L\u0001\fS:$XM]1di&4XM\u0003\u0003\u0002^\u0005}\u0013a\u00018tG*\u0019\u0011\u0011\r,\u0002\u000bQ|w\u000e\\:\n\t\u0005\u0015\u0014q\u000b\u0002\u0007\u000f2|'-\u00197\n\t\u0005%\u00141\u000e\u0002\u0007'fl'm\u001c7\n\t\u00055\u0014q\u000e\u0002\b'fl'm\u001c7t\u0015\u0011\t\t(a\u001d\u0002\u0011%tG/\u001a:oC2T1!!\u001eW\u0003\u001d\u0011XM\u001a7fGR\u0014Qa\u0015;bi\u0016\u001c\u0012bCA>\u0003\u0017\u000b9*!(\u0011\t\u0005u\u0014qQ\u0007\u0003\u0003\u007fRA!!!\u0002\u0004\u0006!A.\u00198h\u0015\t\t))\u0001\u0003kCZ\f\u0017\u0002BAE\u0003\u007f\u0012aa\u00142kK\u000e$\b\u0003BAG\u0003'k!!a$\u000b\t\u0005E\u00151Q\u0001\u0003S>LA!!&\u0002\u0010\nI1\t\\8tK\u0006\u0014G.\u001a\t\u0004+\u0006e\u0015bAAN-\n9\u0001K]8ek\u000e$\bcA+\u0002 &\u0019\u0011\u0011\u0015,\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b%tG-\u001a=\u0016\u0005\u0005\u001d\u0006\u0003BAU\u0003ck!!a+\u000b\t\u00055\u0016qV\u0001\u0006[R\fwm\u001d\u0006\u0004\u0003cj\u0016\u0002BAZ\u0003W\u00131c\u00148EK6\fg\u000eZ*z[\n|G.\u00138eKb\fa!\u001b8eKb\u0004\u0013!C2mCN\u001c\b+\u0019;i+\t\tY\fE\u0003d\u0003{\u000b\t-C\u0002\u0002@6\u00141aU3r!\u0011\t\u0019-!4\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0013\fAAZ5mK*!\u00111ZAB\u0003\rq\u0017n\\\u0005\u0005\u0003\u001f\f)M\u0001\u0003QCRD\u0017AC2mCN\u001c\b+\u0019;iA\u00051q\r\\8cC2,\"!a\u0015\u0002\u000f\u001ddwNY1mAU\u0011\u0011\u0011F\u0001\fg>,(oY3qCRD\u0007\u0005\u0006\u0006\u0002`\u0006\r\u0018Q]At\u0003S\u00042!!9\f\u001b\u0005\u0001\u0001bBAR)\u0001\u0007\u0011q\u0015\u0005\b\u0003o#\u0002\u0019AA^\u0011\u001d\t\u0019\u000e\u0006a\u0001\u0003'Bq!a\n\u0015\u0001\u0004\tI#A\u0003vg\u0016\u001cE.\u0006\u0002\u0002pB\u0019Q+!=\n\u0007\u0005MhKA\u0004C_>dW-\u00198\u0002\u0017\rd\u0017m]:M_\u0006$WM]\u000b\u0003\u0003s\u0004B!a?\u0003\u00025\u0011\u0011Q \u0006\u0005\u0003\u007f\f\u0019)A\u0002oKRLAAa\u0001\u0002~\nqQK\u0015'DY\u0006\u001c8\u000fT8bI\u0016\u0014\u0018\u0001\u0003>ja\u001aKG.Z:\u0016\u0005\t%\u0001\u0003\u0003B\u0006\u0005+\t\tM!\u0007\u000e\u0005\t5!\u0002\u0002B\b\u0005#\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\u0011\u0019\"a!\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005/\u0011iAA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004BAa\u0007\u0003\"5\u0011!Q\u0004\u0006\u0005\u0005?\u0011\t\"A\u0002{SBLAAa\t\u0003\u001e\t9!,\u001b9GS2,\u0017!\u0003>ja\u001aKG.Z:!\u0003\u001dQ\u0018\u000e\u001d$jY\u0016$BA!\u0007\u0003,!9!QF\rA\u0002\u0005\u0005\u0017\u0001\u00029bi\"\faa]8ve\u000e,G\u0003BA \u0005gAaA!\u000e\u001b\u0001\u0004q\u0017\u0001\u00028b[\u0016\fQa\u00197pg\u0016\fAaY8qsRQ\u0011q\u001cB\u001f\u0005\u007f\u0011\tEa\u0011\t\u0013\u0005\rF\u0004%AA\u0002\u0005\u001d\u0006\"CA\\9A\u0005\t\u0019AA^\u0011%\t\u0019\u000e\bI\u0001\u0002\u0004\t\u0019\u0006C\u0005\u0002(q\u0001\n\u00111\u0001\u0002*\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B%U\u0011\t9Ka\u0013,\u0005\t5\u0003\u0003\u0002B(\u00053j!A!\u0015\u000b\t\tM#QK\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0016W\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00057\u0012\tFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003b)\"\u00111\u0018B&\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"Aa\u001a+\t\u0005M#1J\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011iG\u000b\u0003\u0002*\t-\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003tA!\u0011Q\u0010B;\u0013\r!\u0018qP\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002q\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B@\u0005\u000b\u00032!\u0016BA\u0013\r\u0011\u0019I\u0016\u0002\u0004\u0003:L\b\u0002\u0003BDG\u0005\u0005\t\u0019\u0001=\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011i\t\u0005\u0004\u0003\u0010\nU%qP\u0007\u0003\u0005#S1Aa%W\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005/\u0013\tJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAx\u0005;C\u0011Ba\"&\u0003\u0003\u0005\rAa \u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001_\u0001\ti>\u001cFO]5oOR\u0011!1O\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005=(1\u0016\u0005\n\u0005\u000fC\u0013\u0011!a\u0001\u0005\u007f\nQa\u0015;bi\u0016\u00042!!9+'\u0015Q#1WAO!9\u0011)La/\u0002(\u0006m\u00161KA\u0015\u0003?l!Aa.\u000b\u0007\tef+A\u0004sk:$\u0018.\\3\n\t\tu&q\u0017\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DC\u0001BX\u0003\u0015\t\u0007\u000f\u001d7z))\tyN!2\u0003H\n%'1\u001a\u0005\b\u0003Gk\u0003\u0019AAT\u0011\u001d\t9,\fa\u0001\u0003wCq!a5.\u0001\u0004\t\u0019\u0006C\u0004\u0002(5\u0002\r!!\u000b\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u001bBm!\u0015)\u0016\u0011\tBj!-)&Q[AT\u0003w\u000b\u0019&!\u000b\n\u0007\t]gK\u0001\u0004UkBdW\r\u000e\u0005\n\u00057t\u0013\u0011!a\u0001\u0003?\f1\u0001\u001f\u00131\u0003\u0015\u0019H/\u0019;f+\t\u0011\t\u000f\u0005\u0004\u0003d\n%\u0018q\\\u0007\u0003\u0005KTAAa:\u0003\u000e\u00051\u0011\r^8nS\u000eLAAa;\u0003f\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW-\u0001\u0004ti\u0006$X\rI\u0001\u0010o&$\b.\u00138qkR\u001cFO]3b[V!!1\u001fB})\u0011\u0011)p!\u0006\u0015\t\t]8Q\u0001\t\u0005\u0003\u001b\u0012I\u0010B\u0004\u0003|R\u0012\rA!@\u0003\u0003Q\u000bBAa@\u0003\u0000A\u0019Qk!\u0001\n\u0007\r\raKA\u0004O_RD\u0017N\\4\t\u000f\r\u001dA\u00071\u0001\u0004\n\u0005\ta\rE\u0004V\u0007\u0017\u0019yAa>\n\u0007\r5aKA\u0005Gk:\u001cG/[8ocA!\u0011QRB\t\u0013\u0011\u0019\u0019\"a$\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\t\u0007/!D\u00111\u0001\u0004\u001a\u0005\u0011\u0011n\u001d\t\u0006+\u000em1qB\u0005\u0004\u0007;1&\u0001\u0003\u001fcs:\fW.\u001a \u0002\t1|7m[\u000b\u0003\u0003w\nQ\u0001\\8dW\u0002\n1\u0002\u001b;ua\"\u000bg\u000e\u001a7feV\u00111\u0011\u0006\n\u0007\u0007W\tYh!\r\u0007\r\r5\u0002\bAB\u0015\u00051a$/\u001a4j]\u0016lWM\u001c;?\u00031AG\u000f\u001e9IC:$G.\u001a:!!\u0011\u0019\u0019d!\u0010\u000e\u0005\rU\"bA(\u00048)!1\u0011HB\u001e\u0003!)h\u000eZ3si><(BAAI\u0013\u0011\u0019yd!\u000e\u0003\u0017!#H\u000f\u001d%b]\u0012dWM]\u000b\u0003\u0007\u0007\u0002Ba!\u0012\u0004H5\u00111qG\u0005\u0005\u0007\u0013\u001a9D\u0001\u0005V]\u0012,'\u000f^8x\u0003\u001d\u0019XM\u001d<fe\u0002\n\u0001bZ3u\u0005f$Xm\u001d\u000b\u0005\u0007#\u001ai\u0006E\u0003V\u0007'\u001a9&C\u0002\u0004VY\u0013Q!\u0011:sCf\u00042!VB-\u0013\r\u0019YF\u0016\u0002\u0005\u0005f$X\rC\u0004\u0004`m\u0002\ra!\u0019\u0002\u0011\u0015D8\r[1oO\u0016\u0004Baa\r\u0004d%!1QMB\u001b\u0005IAE\u000f\u001e9TKJ4XM]#yG\"\fgnZ3\u0002\u0017\u001dT\u0018\u000e\u001d#fM2\fG/\u001a\u000b\u0005\u0007#\u001aY\u0007C\u0004\u0004nq\u0002\ra!\u0015\u0002\u000b\tLH/Z:\u0002\u0019\u001d,GoV8sWN\u0004\u0018mY3\u0016\u0005\rM\u0004\u0003BB;\u0007wj!aa\u001e\u000b\u0007\re\u0004+\u0001\u0004tG\",W.Y\u0005\u0005\u0007{\u001a9HA\u0005X_J\\7\u000f]1dK\u0006iq-\u001a;TK6\fg\u000e^5dI\n$Baa!\u0004\u0010B!1QQBF\u001b\t\u00199I\u0003\u0003\u0004\n\u0006=\u0016AC:f[\u0006tG/[2eE&!1QRBD\u00055!V\r\u001f;E_\u000e,X.\u001a8ug\"11\u0011\u0013 A\u00029\f\u0001BZ5mK:\fW.Z\u0001\nO\u0016$8+_7c_2$Baa&\u0004\u001eB!1QOBM\u0013\u0011\u0019Yja\u001e\u0003\u001bMKXNY8m\u0013:$W\r_3t\u0011\u0019\u0019yj\u0010a\u0001]\u0006\u00191/_7\u0002\u0017\r|g\u000e^3oiRK\b/\u001a\u000b\u0004]\u000e\u0015\u0006B\u0002B\u0017\u0001\u0002\u0007a.\u0001\tNKR\f'M]8xg\u0016\u001cVM\u001d<feB\u0019\u0011q\u0002\"\u0014\u0005\t#FCABU\u0003\u0011i\u0017-\u001b8\u0015\t\u0005}11\u0017\u0005\b\u0007k#\u0005\u0019AB\\\u0003%\t'O]1z\u0003J<7\u000f\u0005\u0003V\u0007'r\u0017!D7bGJ|\u0007+\u0019:bI&\u001cX-\u0006\u0002\u0002B\u0006i1.\u001b8e!J|'.Z2u_J\f\u0001c]2bY\u00064U\u000f\u001c7WKJ\u001c\u0018n\u001c8\u0016\u00039\f!c]2bY\u0006\u0014\u0015N\\1ssZ+'o]5p]\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"a!3+\u0007\t\u0014Y%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0007\u001fT3A\u001cB&\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\u001b\u0016\u0004q\n-\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0004\\*\u001aAPa\u0013")
public class MetabrowseServer {
    private volatile MetabrowseServer$State$ State$module;
    private final Dialect dialect;
    private final List<String> scalacOptions;
    public final Logger metabrowse$server$MetabrowseServer$$logger;
    private final AtomicReference<State> state;
    private final Object metabrowse$server$MetabrowseServer$$lock;
    private final HttpHandler httpHandler;
    private final Undertow server;

    public static Logger $lessinit$greater$default$5() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$3();
    }

    public static List<String> $lessinit$greater$default$2() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$2();
    }

    public static void main(String[] stringArray) {
        MetabrowseServer$.MODULE$.main(stringArray);
    }

    public MetabrowseServer$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public void start(Sourcepath sourcepath) {
        this.replaceClasspath(sourcepath);
        this.server().start();
    }

    public void stop() {
        this.server().stop();
        this.global().askShutdown();
        Option$.MODULE$.apply((Object)this.state().get()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public void replaceClasspath(Sourcepath sourcepath) {
        Object object = this.metabrowse$server$MetabrowseServer$$lock();
        synchronized (object) {
            State prevState = this.state().get();
            if (prevState != null) {
                this.global().askShutdown();
                prevState.close();
            }
            State newState = new State(this, OnDemandSymbolIndex$.MODULE$.empty(OnDemandSymbolIndex$.MODULE$.empty$default$1(), OnDemandSymbolIndex$.MODULE$.empty$default$2(), (ReportContext)EmptyReportContext$.MODULE$), (Seq<Path>)sourcepath.sources(), InteractiveSemanticdb$.MODULE$.newCompiler(sourcepath.classpath().mkString(File.pathSeparator), this.scalacOptions), sourcepath);
            this.state().set(newState);
            sourcepath.sources().foreach((Function1 & Serializable & scala.Serializable)jar -> this.index().addSourceJar(AbsolutePath$.MODULE$.apply(jar, AbsolutePath$.MODULE$.workingDirectory()), $this.dialect));
        }
    }

    public Option<String> urlForSymbol(Global compiler, Symbols.Symbol symbol) {
        Symbols.Symbol symbol2 = symbol;
        LazyRef semanticdbOps$lzy = new LazyRef();
        ObjectRef compilerSymbol = ObjectRef.create((Object)compiler.rootMirror().RootPackage());
        symbol2.ownerChain().reverse().drop(1).foreach((Function1 & Serializable & scala.Serializable)owner -> {
            MetabrowseServer.$anonfun$urlForSymbol$1(compiler, compilerSymbol, owner);
            return BoxedUnit.UNIT;
        });
        String semanticdbSymbol = MetabrowseServer.semanticdbOps$1(semanticdbOps$lzy, compiler).XtensionGSymbolMSymbol((Symbols.Symbol)compilerSymbol.elem).toSemantic();
        return this.getSymbol(semanticdbSymbol).indexes().headOption().flatMap((Function1 & Serializable & scala.Serializable)symbolIndex -> symbolIndex.definition().map((Function1 & Serializable & scala.Serializable)position -> new StringBuilder(4).append("#").append(position.filename()).append("#L").append(position.startLine()).append("C").append(position.startCharacter()).toString()));
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    public OnDemandSymbolIndex index() {
        return this.state().get().index();
    }

    public Global global() {
        return this.state().get().global();
    }

    public Sourcepath sourcepath() {
        return this.state().get().sourcepath();
    }

    public <T> T metabrowse$server$MetabrowseServer$$withInputStream(Function0<InputStream> is, Function1<InputStream, T> f) {
        Object object;
        try (InputStream is0 = null;){
            is0 = (InputStream)is.apply();
            object = f.apply((Object)is0);
        }
        return (T)object;
    }

    public Object metabrowse$server$MetabrowseServer$$lock() {
        return this.metabrowse$server$MetabrowseServer$$lock;
    }

    private HttpHandler httpHandler() {
        return this.httpHandler;
    }

    private Undertow server() {
        return this.server;
    }

    public byte[] metabrowse$server$MetabrowseServer$$getBytes(HttpServerExchange exchange) {
        String path = new StringOps(Predef$.MODULE$.augmentString(exchange.getRequestPath())).stripSuffix(".gz");
        if (path.endsWith("index.workspace")) {
            return this.getWorkspace().toByteArray();
        }
        if (path.endsWith(".symbolindexes")) {
            HeaderValues header = exchange.getRequestHeaders().get("Metabrowse-Symbol");
            if (header.isEmpty()) {
                this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(29).append("no Metabrowse-Symbol header: ").append(exchange).toString());
                return Array$.MODULE$.emptyByteArray();
            }
            return this.getSymbol(header.getFirst()).toByteArray();
        }
        if (path.endsWith(".semanticdb")) {
            return this.getSemanticdb(path).toByteArray();
        }
        if (path.endsWith(".map")) {
            return Array$.MODULE$.emptyByteArray();
        }
        String string = path;
        String string2 = "/";
        String actualPath = !(string != null ? !string.equals(string2) : string2 != null) ? "/index.html" : path;
        return (byte[])this.metabrowse$server$MetabrowseServer$$withInputStream((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> Thread.currentThread().getContextClassLoader().getResourceAsStream(new StringBuilder(25).append("metabrowse/server/assets/").append(new StringOps(Predef$.MODULE$.augmentString(actualPath)).stripPrefix("/")).toString()), (Function1 & Serializable & scala.Serializable)is -> {
            if (is == null) {
                $this.metabrowse$server$MetabrowseServer$$logger.warn(new StringBuilder(14).append("no such file: ").append(path).toString());
                return Array$.MODULE$.emptyByteArray();
            }
            return InputStreamIO$.MODULE$.readBytes(is);
        });
    }

    public byte[] metabrowse$server$MetabrowseServer$$gzipDeflate(byte[] bytes) {
        byte[] byArray;
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty()) {
            return bytes;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gos = new GZIPOutputStream((OutputStream)baos, bytes.length);){
            gos.write(bytes);
            gos.finish();
            byArray = baos.toByteArray();
        }
        return byArray;
    }

    private Workspace getWorkspace() {
        Builder filenames = ArrayBuffer$.MODULE$.newBuilder();
        this.sourcepath().sources().foreach((Function1 & Serializable & scala.Serializable)sourcesJar -> {
            FileIO$.MODULE$.withJarFileSystem(AbsolutePath$.MODULE$.apply(sourcesJar, AbsolutePath$.MODULE$.workingDirectory()), false, false, (Function1 & Serializable & scala.Serializable)root -> {
                MetabrowseServer.$anonfun$getWorkspace$2(filenames$1, root);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return new Workspace(((SeqLike)filenames.result()).toSeq(), Workspace$.MODULE$.apply$default$2());
    }

    private TextDocuments getSemanticdb(String filename) {
        String path = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(filename)).stripPrefix("/semanticdb/"))).stripPrefix("/"))).stripSuffix(".semanticdb");
        this.metabrowse$server$MetabrowseServer$$logger.info(path);
        return (TextDocuments)this.state().get().source(path).orElse((Function0 & Serializable & scala.Serializable)() -> {
            $this.metabrowse$server$MetabrowseServer$$logger.warn(new StringBuilder(16).append("no source file: ").append(path).toString());
            return None$.MODULE$;
        }).flatMap((Function1 & Serializable & scala.Serializable)text -> this.liftedTree1$1(path, (String)text, filename).map((Function1 & Serializable & scala.Serializable)doc -> new TextDocuments((Seq)new .colon.colon((Object)doc.withText(text), (List)Nil$.MODULE$)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new TextDocuments(TextDocuments$.MODULE$.apply$default$1()));
    }

    private SymbolIndexes getSymbol(String sym) {
        Option definition = this.index().definition(Symbol$.MODULE$.apply(sym)).orElse((Function0 & Serializable & scala.Serializable)() -> {
            $this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(28).append("no definition for symbol: '").append(sym).append("'").toString());
            return None$.MODULE$;
        }).map((Function1 & Serializable & scala.Serializable)defn -> {
            Input.VirtualFile input;
            Input.VirtualFile x$1 = input = MtagsEnrichments$.MODULE$.XtensionAbsolutePath(defn.path()).toInput();
            Dialect x$2 = $this.dialect;
            ReportContext x$3 = Mtags$.MODULE$.index$default$3(x$1, x$2);
            TextDocument doc = Mtags$.MODULE$.index(x$1, x$2, x$3);
            return new Tuple3(defn, (Object)input, (Object)doc);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple3 tuple3 = x$7;
            if (tuple3 != null) {
                SymbolDefinition defn = (SymbolDefinition)tuple3._1();
                TextDocument doc = (TextDocument)tuple3._3();
                return doc.occurrences().find((Function1 & Serializable & scala.Serializable)occ -> BoxesRunTime.boxToBoolean((boolean)MetabrowseServer.$anonfun$getSymbol$4(defn, occ))).orElse((Function0 & Serializable & scala.Serializable)() -> {
                    $this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(26).append("no definition occurrence: ").append(defn).toString());
                    return None$.MODULE$;
                }).flatMap((Function1 & Serializable & scala.Serializable)occ -> occ.range().orElse((Function0 & Serializable & scala.Serializable)() -> {
                    $this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(10).append("no range: ").append(occ).toString());
                    return None$.MODULE$;
                }).map((Function1 & Serializable & scala.Serializable)range -> new metabrowse.schema.Position(defn.path().toString(), range.startLine(), range.startCharacter(), range.endLine(), range.endCharacter(), Position$.MODULE$.apply$default$6())));
            }
            throw new MatchError((Object)tuple3);
        });
        return new SymbolIndexes((Seq)new .colon.colon((Object)new SymbolIndex(sym, definition, SymbolIndex$.MODULE$.apply$default$3(), SymbolIndex$.MODULE$.apply$default$4()), (List)Nil$.MODULE$), SymbolIndexes$.MODULE$.apply$default$2());
    }

    public String metabrowse$server$MetabrowseServer$$contentType(String path) {
        if (path.endsWith(".js")) {
            return "application/javascript";
        }
        if (path.endsWith(".css")) {
            return "text/css";
        }
        if (path.endsWith(".html")) {
            return "text/html";
        }
        return "";
    }

    private final void State$lzycompute$1() {
        MetabrowseServer metabrowseServer = this;
        synchronized (metabrowseServer) {
            if (this.State$module == null) {
                this.State$module = new MetabrowseServer$State$(this);
            }
        }
    }

    private static final /* synthetic */ SemanticdbOps semanticdbOps$lzycompute$1(LazyRef semanticdbOps$lzy$1, Global compiler$1) {
        SemanticdbOps semanticdbOps;
        LazyRef lazyRef = semanticdbOps$lzy$1;
        synchronized (lazyRef) {
            semanticdbOps = semanticdbOps$lzy$1.initialized() ? (SemanticdbOps)semanticdbOps$lzy$1.value() : (SemanticdbOps)semanticdbOps$lzy$1.initialize((Object)new SemanticdbOps(null, compiler$1){
                private final Global global;
                private SemanticdbConfig config;
                private volatile TypeOps$ByNameType$ ByNameType$module;
                private volatile TypeOps$RepeatedType$ RepeatedType$module;
                private HashMap<Symbols.Symbol, String> symbolCache;
                private volatile SymbolOps$SemanticdbDecls$ SemanticdbDecls$module;
                private HashMap<String, Object> idCache;
                private HashMap<Object, Symbols.Symbol> pointsCache;
                private Global g;
                private boolean isDocCompiler;
                private boolean isReplCompiler;
                private boolean isInteractiveCompiler;
                private boolean isSupportedCompiler;
                private volatile ReflectionToolkit$Attachable$ Attachable$module;
                private volatile ReflectionToolkit$ConstfoldOf$ ConstfoldOf$module;
                private volatile ReflectionToolkit$ClassOf$ ClassOf$module;
                private volatile ReflectionToolkit$NewArrayOf$ NewArrayOf$module;
                private volatile ReflectionToolkit$SingletonTypeTreeOf$ SingletonTypeTreeOf$module;
                private volatile ReflectionToolkit$CompoundTypeTreeOf$ CompoundTypeTreeOf$module;
                private volatile ReflectionToolkit$ExistentialTypeTreeOf$ ExistentialTypeTreeOf$module;
                private volatile ReflectionToolkit$AnnotatedOf$ AnnotatedOf$module;
                private volatile ReflectionToolkit$SelfTypeOf$ SelfTypeOf$module;
                private volatile ReflectionToolkit$SelectOf$ SelectOf$module;
                private final Option<SemanticdbReporter> semanticdbReporter;
                private final Map<CompilationUnits.CompilationUnit, Object> scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath;
                private String language;
                private Map<SourceFile, Input> gSourceFileInputCache;
                private volatile VersionSpecificOps$OriginalTreeOf$ OriginalTreeOf$module;
                private volatile VersionSpecificOps$NamedApplyBlock$ NamedApplyBlock$module;
                private volatile int bitmap$0;

                public TypeOps.XtensionGTypeSType XtensionGTypeSType(Types.Type gtpe) {
                    return TypeOps.XtensionGTypeSType$((TypeOps)this, (Types.Type)gtpe);
                }

                public TypeOps.XtensionGType XtensionGType(Types.Type gtpe) {
                    return TypeOps.XtensionGType$((TypeOps)this, (Types.Type)gtpe);
                }

                public SyntheticOps.XtensionGTreeSTree XtensionGTreeSTree(Trees.Tree gTree) {
                    return SyntheticOps.XtensionGTreeSTree$((SyntheticOps)this, (Trees.Tree)gTree);
                }

                public SymbolOpsCompat.XtensionGSymbolCompat XtensionGSymbolCompat(Symbols.Symbol sym) {
                    return SymbolOpsCompat.XtensionGSymbolCompat$((SymbolOpsCompat)this, (Symbols.Symbol)sym);
                }

                public SymbolOps.XtensionGSymbolMSymbol XtensionGSymbolMSymbol(Symbols.Symbol sym) {
                    return SymbolOps.XtensionGSymbolMSymbol$((SymbolOps)this, (Symbols.Symbol)sym);
                }

                public SymbolOps.XtensionGSymbolMSpec XtensionGSymbolMSpec(Symbols.Symbol sym) {
                    return SymbolOps.XtensionGSymbolMSpec$((SymbolOps)this, (Symbols.Symbol)sym);
                }

                public SymbolOps.XtensionGScopeMSpec XtensionGScopeMSpec(Scopes.Scope scope) {
                    return SymbolOps.XtensionGScopeMSpec$((SymbolOps)this, (Scopes.Scope)scope);
                }

                public SymbolOps.XtensionGSymbolsMSpec XtensionGSymbolsMSpec(List<Symbols.Symbol> syms) {
                    return SymbolOps.XtensionGSymbolsMSpec$((SymbolOps)this, syms);
                }

                public SymbolOps.XtensionGSymbol XtensionGSymbol(Symbols.Symbol sym) {
                    return SymbolOps.XtensionGSymbol$((SymbolOps)this, (Symbols.Symbol)sym);
                }

                public <T> ReflectionToolkit.XtensionAttachable<T> XtensionAttachable(T carrier, ReflectionToolkit.Attachable<T> evidence$4) {
                    return ReflectionToolkit.XtensionAttachable$((ReflectionToolkit)this, carrier, evidence$4);
                }

                public <T> ReflectionToolkit.XtensionMetadataAttachable<T> XtensionMetadataAttachable(T carrier, ReflectionToolkit.Attachable<T> evidence$6) {
                    return ReflectionToolkit.XtensionMetadataAttachable$((ReflectionToolkit)this, carrier, evidence$6);
                }

                public ReflectionToolkit.XtensionCompilationUnitCache XtensionCompilationUnitCache(CompilationUnits.CompilationUnit unit) {
                    return ReflectionToolkit.XtensionCompilationUnitCache$((ReflectionToolkit)this, (CompilationUnits.CompilationUnit)unit);
                }

                public <T> ReflectionToolkit.XtensionDesugarings<T> XtensionDesugarings(T carrier, ReflectionToolkit.Attachable<T> evidence$10) {
                    return ReflectionToolkit.XtensionDesugarings$((ReflectionToolkit)this, carrier, evidence$10);
                }

                public ReporterOps.XtensionCompilationUnitReporter XtensionCompilationUnitReporter(CompilationUnits.CompilationUnit unit) {
                    return ReporterOps.XtensionCompilationUnitReporter$((ReporterOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public ParseOps.XtensionCompilationUnitSource XtensionCompilationUnitSource(CompilationUnits.CompilationUnit unit) {
                    return ParseOps.XtensionCompilationUnitSource$((ParseOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public DiagnosticOps.XtensionCompilationUnitDiagnostics XtensionCompilationUnitDiagnostics(CompilationUnits.CompilationUnit unit) {
                    return DiagnosticOps.XtensionCompilationUnitDiagnostics$((DiagnosticOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public InputOps.XtensionGSourceFileInput XtensionGSourceFileInput(SourceFile gsource) {
                    return InputOps.XtensionGSourceFileInput$((InputOps)this, (SourceFile)gsource);
                }

                public InputOps.XtensionGPositionMPosition XtensionGPositionMPosition(Position pos) {
                    return InputOps.XtensionGPositionMPosition$((InputOps)this, (Position)pos);
                }

                public void validateCompilerState() {
                    TextDocumentOps.validateCompilerState$((TextDocumentOps)this);
                }

                public TextDocumentOps.XtensionCompilationUnitDocument XtensionCompilationUnitDocument(CompilationUnits.CompilationUnit unit) {
                    return TextDocumentOps.XtensionCompilationUnitDocument$((TextDocumentOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public SymbolInformationOps.XtensionGSymbolMSymbolInformation XtensionGSymbolMSymbolInformation(Symbols.Symbol gsym0) {
                    return SymbolInformationOps.XtensionGSymbolMSymbolInformation$((SymbolInformationOps)this, (Symbols.Symbol)gsym0);
                }

                public AnnotationOps.XtensionAnnotationInfo XtensionAnnotationInfo(AnnotationInfos.AnnotationInfo gann) {
                    return AnnotationOps.XtensionAnnotationInfo$((AnnotationOps)this, (AnnotationInfos.AnnotationInfo)gann);
                }

                public SemanticdbConfig config() {
                    return this.config;
                }

                public void config_$eq(SemanticdbConfig x$1) {
                    this.config = x$1;
                }

                public TypeOps$ByNameType$ ByNameType() {
                    if (this.ByNameType$module == null) {
                        this.ByNameType$lzycompute$1();
                    }
                    return this.ByNameType$module;
                }

                public TypeOps$RepeatedType$ RepeatedType() {
                    if (this.RepeatedType$module == null) {
                        this.RepeatedType$lzycompute$1();
                    }
                    return this.RepeatedType$module;
                }

                private HashMap<Symbols.Symbol, String> symbolCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 1) == 0) {
                            this.symbolCache = SymbolOps.symbolCache$((SymbolOps)this);
                            this.bitmap$0 |= 1;
                        }
                    }
                    return this.symbolCache;
                }

                public HashMap<Symbols.Symbol, String> symbolCache() {
                    if ((this.bitmap$0 & 1) == 0) {
                        return this.symbolCache$lzycompute();
                    }
                    return this.symbolCache;
                }

                public SymbolOps$SemanticdbDecls$ SemanticdbDecls() {
                    if (this.SemanticdbDecls$module == null) {
                        this.SemanticdbDecls$lzycompute$1();
                    }
                    return this.SemanticdbDecls$module;
                }

                private HashMap<String, Object> idCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 2) == 0) {
                            this.idCache = SymbolOps.idCache$((SymbolOps)this);
                            this.bitmap$0 |= 2;
                        }
                    }
                    return this.idCache;
                }

                public HashMap<String, Object> idCache() {
                    if ((this.bitmap$0 & 2) == 0) {
                        return this.idCache$lzycompute();
                    }
                    return this.idCache;
                }

                private HashMap<Object, Symbols.Symbol> pointsCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 4) == 0) {
                            this.pointsCache = SymbolOps.pointsCache$((SymbolOps)this);
                            this.bitmap$0 |= 4;
                        }
                    }
                    return this.pointsCache;
                }

                public HashMap<Object, Symbols.Symbol> pointsCache() {
                    if ((this.bitmap$0 & 4) == 0) {
                        return this.pointsCache$lzycompute();
                    }
                    return this.pointsCache;
                }

                private Global g$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 8) == 0) {
                            this.g = (Global)ReflectionToolkit.g$((ReflectionToolkit)this);
                            this.bitmap$0 |= 8;
                        }
                    }
                    return this.g;
                }

                public Global g() {
                    if ((this.bitmap$0 & 8) == 0) {
                        return this.g$lzycompute();
                    }
                    return this.g;
                }

                private boolean isDocCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x10) == 0) {
                            this.isDocCompiler = ReflectionToolkit.isDocCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x10;
                        }
                    }
                    return this.isDocCompiler;
                }

                public boolean isDocCompiler() {
                    if ((this.bitmap$0 & 0x10) == 0) {
                        return this.isDocCompiler$lzycompute();
                    }
                    return this.isDocCompiler;
                }

                private boolean isReplCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x20) == 0) {
                            this.isReplCompiler = ReflectionToolkit.isReplCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x20;
                        }
                    }
                    return this.isReplCompiler;
                }

                public boolean isReplCompiler() {
                    if ((this.bitmap$0 & 0x20) == 0) {
                        return this.isReplCompiler$lzycompute();
                    }
                    return this.isReplCompiler;
                }

                private boolean isInteractiveCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x40) == 0) {
                            this.isInteractiveCompiler = ReflectionToolkit.isInteractiveCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x40;
                        }
                    }
                    return this.isInteractiveCompiler;
                }

                public boolean isInteractiveCompiler() {
                    if ((this.bitmap$0 & 0x40) == 0) {
                        return this.isInteractiveCompiler$lzycompute();
                    }
                    return this.isInteractiveCompiler;
                }

                private boolean isSupportedCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x80) == 0) {
                            this.isSupportedCompiler = ReflectionToolkit.isSupportedCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x80;
                        }
                    }
                    return this.isSupportedCompiler;
                }

                public boolean isSupportedCompiler() {
                    if ((this.bitmap$0 & 0x80) == 0) {
                        return this.isSupportedCompiler$lzycompute();
                    }
                    return this.isSupportedCompiler;
                }

                public ReflectionToolkit$Attachable$ Attachable() {
                    if (this.Attachable$module == null) {
                        this.Attachable$lzycompute$1();
                    }
                    return this.Attachable$module;
                }

                public ReflectionToolkit$ConstfoldOf$ ConstfoldOf() {
                    if (this.ConstfoldOf$module == null) {
                        this.ConstfoldOf$lzycompute$1();
                    }
                    return this.ConstfoldOf$module;
                }

                public ReflectionToolkit$ClassOf$ ClassOf() {
                    if (this.ClassOf$module == null) {
                        this.ClassOf$lzycompute$1();
                    }
                    return this.ClassOf$module;
                }

                public ReflectionToolkit$NewArrayOf$ NewArrayOf() {
                    if (this.NewArrayOf$module == null) {
                        this.NewArrayOf$lzycompute$1();
                    }
                    return this.NewArrayOf$module;
                }

                public ReflectionToolkit$SingletonTypeTreeOf$ SingletonTypeTreeOf() {
                    if (this.SingletonTypeTreeOf$module == null) {
                        this.SingletonTypeTreeOf$lzycompute$1();
                    }
                    return this.SingletonTypeTreeOf$module;
                }

                public ReflectionToolkit$CompoundTypeTreeOf$ CompoundTypeTreeOf() {
                    if (this.CompoundTypeTreeOf$module == null) {
                        this.CompoundTypeTreeOf$lzycompute$1();
                    }
                    return this.CompoundTypeTreeOf$module;
                }

                public ReflectionToolkit$ExistentialTypeTreeOf$ ExistentialTypeTreeOf() {
                    if (this.ExistentialTypeTreeOf$module == null) {
                        this.ExistentialTypeTreeOf$lzycompute$1();
                    }
                    return this.ExistentialTypeTreeOf$module;
                }

                public ReflectionToolkit$AnnotatedOf$ AnnotatedOf() {
                    if (this.AnnotatedOf$module == null) {
                        this.AnnotatedOf$lzycompute$1();
                    }
                    return this.AnnotatedOf$module;
                }

                public ReflectionToolkit$SelfTypeOf$ SelfTypeOf() {
                    if (this.SelfTypeOf$module == null) {
                        this.SelfTypeOf$lzycompute$1();
                    }
                    return this.SelfTypeOf$module;
                }

                public ReflectionToolkit$SelectOf$ SelectOf() {
                    if (this.SelectOf$module == null) {
                        this.SelectOf$lzycompute$1();
                    }
                    return this.SelectOf$module;
                }

                public Option<SemanticdbReporter> semanticdbReporter() {
                    return this.semanticdbReporter;
                }

                public Map<CompilationUnits.CompilationUnit, Object> scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath() {
                    return this.scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath;
                }

                public void scala$meta$internal$semanticdb$scalac$ReporterOps$_setter_$semanticdbReporter_$eq(Option<SemanticdbReporter> x$1) {
                    this.semanticdbReporter = x$1;
                }

                public final void scala$meta$internal$semanticdb$scalac$ReporterOps$_setter_$scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath_$eq(Map<CompilationUnits.CompilationUnit, Object> x$1) {
                    this.scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath = x$1;
                }

                private String language$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x100) == 0) {
                            this.language = LanguageOps.language$((LanguageOps)this);
                            this.bitmap$0 |= 0x100;
                        }
                    }
                    return this.language;
                }

                public String language() {
                    if ((this.bitmap$0 & 0x100) == 0) {
                        return this.language$lzycompute();
                    }
                    return this.language;
                }

                private Map<SourceFile, Input> gSourceFileInputCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x200) == 0) {
                            this.gSourceFileInputCache = InputOps.gSourceFileInputCache$((InputOps)this);
                            this.bitmap$0 |= 0x200;
                        }
                    }
                    return this.gSourceFileInputCache;
                }

                public Map<SourceFile, Input> gSourceFileInputCache() {
                    if ((this.bitmap$0 & 0x200) == 0) {
                        return this.gSourceFileInputCache$lzycompute();
                    }
                    return this.gSourceFileInputCache;
                }

                public VersionSpecificOps$OriginalTreeOf$ OriginalTreeOf() {
                    if (this.OriginalTreeOf$module == null) {
                        this.OriginalTreeOf$lzycompute$1();
                    }
                    return this.OriginalTreeOf$module;
                }

                public VersionSpecificOps$NamedApplyBlock$ NamedApplyBlock() {
                    if (this.NamedApplyBlock$module == null) {
                        this.NamedApplyBlock$lzycompute$1();
                    }
                    return this.NamedApplyBlock$module;
                }

                public Global global() {
                    return this.global;
                }

                private final void ByNameType$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ByNameType$module == null) {
                            this.ByNameType$module = new TypeOps$ByNameType$((SemanticdbOps)this);
                        }
                    }
                }

                private final void RepeatedType$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.RepeatedType$module == null) {
                            this.RepeatedType$module = new TypeOps$RepeatedType$((SemanticdbOps)this);
                        }
                    }
                }

                private final void SemanticdbDecls$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SemanticdbDecls$module == null) {
                            this.SemanticdbDecls$module = new SymbolOps$SemanticdbDecls$((SemanticdbOps)this);
                        }
                    }
                }

                private final void Attachable$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.Attachable$module == null) {
                            this.Attachable$module = new ReflectionToolkit$Attachable$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void ConstfoldOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ConstfoldOf$module == null) {
                            this.ConstfoldOf$module = new ReflectionToolkit$ConstfoldOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void ClassOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ClassOf$module == null) {
                            this.ClassOf$module = new ReflectionToolkit$ClassOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void NewArrayOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.NewArrayOf$module == null) {
                            this.NewArrayOf$module = new ReflectionToolkit$NewArrayOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void SingletonTypeTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SingletonTypeTreeOf$module == null) {
                            this.SingletonTypeTreeOf$module = new ReflectionToolkit$SingletonTypeTreeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void CompoundTypeTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.CompoundTypeTreeOf$module == null) {
                            this.CompoundTypeTreeOf$module = new ReflectionToolkit$CompoundTypeTreeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void ExistentialTypeTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ExistentialTypeTreeOf$module == null) {
                            this.ExistentialTypeTreeOf$module = new ReflectionToolkit$ExistentialTypeTreeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void AnnotatedOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.AnnotatedOf$module == null) {
                            this.AnnotatedOf$module = new ReflectionToolkit$AnnotatedOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void SelfTypeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SelfTypeOf$module == null) {
                            this.SelfTypeOf$module = new ReflectionToolkit$SelfTypeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void SelectOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SelectOf$module == null) {
                            this.SelectOf$module = new ReflectionToolkit$SelectOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void OriginalTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.OriginalTreeOf$module == null) {
                            this.OriginalTreeOf$module = new VersionSpecificOps$OriginalTreeOf$((SemanticdbOps)this);
                        }
                    }
                }

                private final void NamedApplyBlock$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.NamedApplyBlock$module == null) {
                            this.NamedApplyBlock$module = new VersionSpecificOps$NamedApplyBlock$((SemanticdbOps)this);
                        }
                    }
                }
                {
                    AnnotationOps.$init$((AnnotationOps)this);
                    VersionSpecificOps.$init$((VersionSpecificOps)this);
                    SymbolInformationOps.$init$((SymbolInformationOps)this);
                    TextDocumentOps.$init$((TextDocumentOps)this);
                    InputOps.$init$((InputOps)this);
                    LanguageOps.$init$((LanguageOps)this);
                    DiagnosticOps.$init$((DiagnosticOps)this);
                    ParseOps.$init$((ParseOps)this);
                    ReporterOps.$init$((ReporterOps)this);
                    ReflectionToolkit.$init$((ReflectionToolkit)this);
                    SymbolOps.$init$((SymbolOps)this);
                    SymbolOpsCompat.$init$((SymbolOpsCompat)this);
                    SyntheticOps.$init$((SyntheticOps)this);
                    TypeOps.$init$((TypeOps)this);
                    SemanticdbOps.$init$((SemanticdbOps)this);
                    this.global = compiler$1;
                }
            });
        }
        return semanticdbOps;
    }

    private static final SemanticdbOps semanticdbOps$1(LazyRef semanticdbOps$lzy$1, Global compiler$1) {
        if (semanticdbOps$lzy$1.initialized()) {
            return (SemanticdbOps)semanticdbOps$lzy$1.value();
        }
        return MetabrowseServer.semanticdbOps$lzycompute$1(semanticdbOps$lzy$1, compiler$1);
    }

    public static final /* synthetic */ void $anonfun$urlForSymbol$1(Global compiler$1, ObjectRef compilerSymbol$1, Symbols.Symbol owner) {
        Names.TermName name = owner.name().isTermName() || owner.hasPackageFlag() ? compiler$1.TermName().apply(owner.nameString()) : compiler$1.TypeName().apply(owner.nameString());
        compilerSymbol$1.elem = ((Symbols.Symbol)compilerSymbol$1.elem).info().member((Names.Name)name);
    }

    public static final /* synthetic */ boolean $anonfun$getWorkspace$3(AbsolutePath x$6) {
        return !MtagsEnrichments$.MODULE$.XtensionAbsolutePath(x$6).toLanguage().isUnknownLanguage();
    }

    public static final /* synthetic */ void $anonfun$getWorkspace$2(Builder filenames$1, AbsolutePath root) {
        ((IterableLike)FileIO$.MODULE$.listAllFilesRecursively(root).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetabrowseServer.$anonfun$getWorkspace$3(x$6)))).foreach((Function1 & Serializable & scala.Serializable)path -> filenames$1.$plus$eq((Object)new StringOps(Predef$.MODULE$.augmentString(((Object)path.toNIO()).toString())).stripPrefix("/")));
    }

    private final /* synthetic */ Option liftedTree1$1(String path$2, String text$1, String filename$1) {
        Some some;
        try {
            TextDocument textDocument;
            long timeout = TimeUnit.SECONDS.toMillis(10L);
            if (path$2.endsWith(".java")) {
                Input.VirtualFile input;
                Input.VirtualFile x$1 = input = new Input.VirtualFile(path$2, text$1);
                Dialect x$2 = this.dialect;
                ReportContext x$3 = Mtags$.MODULE$.index$default$3(x$1, x$2);
                textDocument = Mtags$.MODULE$.index(x$1, x$2, x$3);
            } else {
                textDocument = InteractiveSemanticdb$.MODULE$.toTextDocument(this.global(), text$1, filename$1, timeout, (List)new .colon.colon((Object)"-P:semanticdb:synthetics:on", (List)new .colon.colon((Object)"-P:semanticdb:symbols:none", (List)Nil$.MODULE$)));
            }
            TextDocument textDocument2 = textDocument;
            some = new Some((Object)textDocument2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(15).append("compile error: ").append(filename$1).toString(), e);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getSymbol$4(SymbolDefinition defn$1, SymbolOccurrence occ) {
        if (!occ.role().isDefinition()) return false;
        if (!occ.range().isDefined()) return false;
        String string = occ.symbol();
        String string2 = defn$1.definitionSymbol().value();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public MetabrowseServer(Dialect dialect, List<String> scalacOptions, String host, int port, Logger logger) {
        this.dialect = dialect;
        this.scalacOptions = scalacOptions;
        this.metabrowse$server$MetabrowseServer$$logger = logger;
        this.state = new AtomicReference();
        this.metabrowse$server$MetabrowseServer$$lock = new Object();
        this.httpHandler = new HttpHandler(this){
            private final /* synthetic */ MetabrowseServer $outer;

            public void handleRequest(HttpServerExchange exchange) {
                byte[] byArray;
                try {
                    Object object = this.$outer.metabrowse$server$MetabrowseServer$$lock();
                    synchronized (object) {
                        byte[] byArray2 = this.$outer.metabrowse$server$MetabrowseServer$$getBytes(exchange);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var4_2
                        byArray = byArray2;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.$outer.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(18).append("unexpected error: ").append(exchange).toString(), e);
                        byArray = Array$.MODULE$.emptyByteArray();
                    }
                    throw throwable;
                }
                byte[] bytes = byArray;
                byte[] compressed = this.$outer.metabrowse$server$MetabrowseServer$$gzipDeflate(bytes);
                ByteBuffer buffer = ByteBuffer.wrap(compressed);
                exchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, "gzip");
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.$outer.metabrowse$server$MetabrowseServer$$contentType(exchange.getRequestPath()));
                exchange.getResponseSender().send(buffer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.server = Undertow.builder().addHttpListener(port, host).setHandler(this.httpHandler()).build();
    }

    public class State
    implements Closeable,
    Product,
    scala.Serializable {
        private boolean useCl;
        private URLClassLoader classLoader;
        private final OnDemandSymbolIndex index;
        private final Seq<Path> classPath;
        private final Global global;
        private final Sourcepath sourcepath;
        private final ConcurrentHashMap<Path, ZipFile> zipFiles;
        private volatile byte bitmap$0;
        public final /* synthetic */ MetabrowseServer $outer;

        public OnDemandSymbolIndex index() {
            return this.index;
        }

        public Seq<Path> classPath() {
            return this.classPath;
        }

        public Global global() {
            return this.global;
        }

        public Sourcepath sourcepath() {
            return this.sourcepath;
        }

        private boolean useCl$lzycompute() {
            State state = this;
            synchronized (state) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.useCl = Boolean.getBoolean("metabrowse.ucl");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.useCl;
        }

        private boolean useCl() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.useCl$lzycompute();
            }
            return this.useCl;
        }

        private URLClassLoader classLoader$lzycompute() {
            State state = this;
            synchronized (state) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.classLoader = new URLClassLoader((URL[])((TraversableOnce)this.sourcepath().sources().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toUri().toURL(), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(URL.class)));
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.classLoader;
        }

        private URLClassLoader classLoader() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.classLoader$lzycompute();
            }
            return this.classLoader;
        }

        private ConcurrentHashMap<Path, ZipFile> zipFiles() {
            return this.zipFiles;
        }

        private ZipFile zipFile(Path path) {
            ZipFile zf = this.zipFiles().get(path);
            if (zf == null) {
                try (ZipFile zf0 = null;){
                    zf0 = new ZipFile(path.toFile());
                    ZipFile prev = this.zipFiles().putIfAbsent(path, zf0);
                    if (prev == null) {
                        zf = zf0;
                        zf0 = null;
                    } else {
                        zf = prev;
                    }
                }
            }
            return zf;
        }

        public Option<String> source(String name) {
            Option option;
            if (this.useCl()) {
                option = (Option)this.metabrowse$server$MetabrowseServer$State$$$outer().metabrowse$server$MetabrowseServer$$withInputStream((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> this.classLoader().getResourceAsStream(name), (Function1 & Serializable & scala.Serializable)is -> {
                    if (is == null) {
                        return None$.MODULE$;
                    }
                    return new Some((Object)InputStreamIO$.MODULE$.readBytes(is));
                });
            } else {
                Iterator it = this.classPath().iterator().map((Function1 & Serializable & scala.Serializable)path -> {
                    ZipFile zf = this.zipFile((Path)path);
                    return new Tuple2(path, (Object)zf);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
                    Tuple2 tuple2 = x$4;
                    if (tuple2 != null) {
                        ZipFile zf = (ZipFile)tuple2._2();
                        return Option$.MODULE$.apply((Object)zf.getEntry(name)).iterator().map((Function1 & Serializable & scala.Serializable)entry -> (byte[])this.metabrowse$server$MetabrowseServer$State$$$outer().metabrowse$server$MetabrowseServer$$withInputStream((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> zf.getInputStream((ZipEntry)entry), (Function1 & Serializable & scala.Serializable)x$3 -> InputStreamIO$.MODULE$.readBytes(x$3)));
                    }
                    throw new MatchError((Object)tuple2);
                });
                option = it.toStream().headOption();
            }
            Option bytesOpt = option;
            return bytesOpt.map((Function1 & Serializable & scala.Serializable)x$5 -> new String((byte[])x$5, StandardCharsets.UTF_8));
        }

        @Override
        public void close() {
            ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.zipFiles().entrySet()).asScala()).toVector().foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)State.$anonfun$close$1(this, entry)));
        }

        public State copy(OnDemandSymbolIndex index, Seq<Path> classPath, Global global, Sourcepath sourcepath) {
            return new State(this.metabrowse$server$MetabrowseServer$State$$$outer(), index, classPath, global, sourcepath);
        }

        public OnDemandSymbolIndex copy$default$1() {
            return this.index();
        }

        public Seq<Path> copy$default$2() {
            return this.classPath();
        }

        public Global copy$default$3() {
            return this.global();
        }

        public Sourcepath copy$default$4() {
            return this.sourcepath();
        }

        public String productPrefix() {
            return "State";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.index();
                }
                case 1: {
                    return this.classPath();
                }
                case 2: {
                    return this.global();
                }
                case 3: {
                    return this.sourcepath();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            if (((State)object).metabrowse$server$MetabrowseServer$State$$$outer() != this.metabrowse$server$MetabrowseServer$State$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            OnDemandSymbolIndex onDemandSymbolIndex = this.index();
            OnDemandSymbolIndex onDemandSymbolIndex2 = state.index();
            if (onDemandSymbolIndex == null) {
                if (onDemandSymbolIndex2 != null) {
                    return false;
                }
            } else if (!onDemandSymbolIndex.equals(onDemandSymbolIndex2)) return false;
            Seq<Path> seq = this.classPath();
            Seq<Path> seq2 = state.classPath();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Global global = this.global();
            Global global2 = state.global();
            if (global == null) {
                if (global2 != null) {
                    return false;
                }
            } else if (!global.equals(global2)) return false;
            Sourcepath sourcepath = this.sourcepath();
            Sourcepath sourcepath2 = state.sourcepath();
            if (sourcepath == null) {
                if (sourcepath2 != null) {
                    return false;
                }
            } else if (!((Object)sourcepath).equals(sourcepath2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MetabrowseServer metabrowse$server$MetabrowseServer$State$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$close$1(State $this, Map.Entry entry) {
            ((ZipFile)entry.getValue()).close();
            return $this.zipFiles().remove(entry.getKey(), entry.getValue());
        }

        public State(MetabrowseServer $outer, OnDemandSymbolIndex index, Seq<Path> classPath, Global global, Sourcepath sourcepath) {
            this.index = index;
            this.classPath = classPath;
            this.global = global;
            this.sourcepath = sourcepath;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
            this.zipFiles = new ConcurrentHashMap();
        }
    }
}

