/*
 * Decompiled with CFR 0.152.
 */
package metabrowse.server;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;
import metabrowse.schema.SymbolIndex;
import metabrowse.schema.SymbolIndex$;
import metabrowse.schema.SymbolIndexes;
import metabrowse.schema.Workspace;
import metabrowse.server.MetabrowseServer$;
import metabrowse.server.MetabrowseServer$State$;
import metabrowse.server.Sourcepath;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map;
import scala.meta.inputs.Input;
import scala.meta.interactive.InteractiveSemanticdb$;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.InputStreamIO$;
import scala.meta.internal.mtags.Mtags$;
import scala.meta.internal.mtags.MtagsEnrichments$;
import scala.meta.internal.mtags.OnDemandSymbolIndex;
import scala.meta.internal.mtags.OnDemandSymbolIndex$;
import scala.meta.internal.mtags.Symbol$;
import scala.meta.internal.mtags.SymbolDefinition;
import scala.meta.internal.semanticdb.SymbolOccurrence;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.internal.semanticdb.TextDocuments;
import scala.meta.internal.semanticdb.TextDocuments$;
import scala.meta.internal.semanticdb.scalac.AnnotationOps;
import scala.meta.internal.semanticdb.scalac.DiagnosticOps;
import scala.meta.internal.semanticdb.scalac.InputOps;
import scala.meta.internal.semanticdb.scalac.LanguageOps;
import scala.meta.internal.semanticdb.scalac.ParseOps;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$AnnotatedOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$Attachable$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$ClassOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$CompoundTypeTreeOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$ConstfoldOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$ExistentialTypeTreeOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$NewArrayOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$SelectOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$SelfTypeOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$SingletonTypeTreeOf$;
import scala.meta.internal.semanticdb.scalac.ReporterOps;
import scala.meta.internal.semanticdb.scalac.SemanticdbConfig;
import scala.meta.internal.semanticdb.scalac.SemanticdbOps;
import scala.meta.internal.semanticdb.scalac.SymbolInformationOps;
import scala.meta.internal.semanticdb.scalac.SymbolOps;
import scala.meta.internal.semanticdb.scalac.SymbolOps$SemanticdbDecls$;
import scala.meta.internal.semanticdb.scalac.SyntheticOps;
import scala.meta.internal.semanticdb.scalac.TextDocumentOps;
import scala.meta.internal.semanticdb.scalac.TypeOps;
import scala.meta.internal.semanticdb.scalac.TypeOps$ByNameType$;
import scala.meta.internal.semanticdb.scalac.TypeOps$RepeatedType$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.internal.AnnotationInfos;
import scala.reflect.internal.Names;
import scala.reflect.internal.Scopes;
import scala.reflect.internal.Symbols;
import scala.reflect.internal.Trees;
import scala.reflect.internal.Types;
import scala.reflect.internal.util.Position;
import scala.reflect.internal.util.SourceFile;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.tools.nsc.CompilationUnits;
import scala.tools.nsc.interactive.Global;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\rd\u0001B\u0001\u0003\u0001\u001d\u0011\u0001#T3uC\n\u0014xn^:f'\u0016\u0014h/\u001a:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003)iW\r^1ce><8/Z\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001f\u0001\u0011\t\u0011)A\u0005!\u0005i1oY1mC\u000e|\u0005\u000f^5p]N\u00042!E\r\u001d\u001d\t\u0011rC\u0004\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u00051AH]8pizJ\u0011aC\u0005\u00031)\tq\u0001]1dW\u0006<W-\u0003\u0002\u001b7\t!A*[:u\u0015\tA\"\u0002\u0005\u0002\u001eC9\u0011ad\b\t\u0003')I!\u0001\t\u0006\u0002\rA\u0013X\rZ3g\u0013\t\u00113E\u0001\u0004TiJLgn\u001a\u0006\u0003A)A\u0001\"\n\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0005Q>\u001cH\u000f\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0003\u0011\u0001xN\u001d;\u0011\u0005%I\u0013B\u0001\u0016\u000b\u0005\rIe\u000e\u001e\u0005\tY\u0001\u0011\t\u0011)A\u0005[\u00051An\\4hKJ\u0004\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\u000bMdg\r\u000e6\u000b\u0003I\n1a\u001c:h\u0013\t!tF\u0001\u0004M_\u001e<WM\u001d\u0005\u0006m\u0001!\taN\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000baR4\bP\u001f\u0011\u0005e\u0002Q\"\u0001\u0002\t\u000f=)\u0004\u0013!a\u0001!!9Q%\u000eI\u0001\u0002\u0004a\u0002bB\u00146!\u0003\u0005\r\u0001\u000b\u0005\bYU\u0002\n\u00111\u0001.\u0011\u0015y\u0004\u0001\"\u0001A\u0003\u0015\u0019H/\u0019:u)\t\tE\t\u0005\u0002\n\u0005&\u00111I\u0003\u0002\u0005+:LG\u000fC\u0003F}\u0001\u0007a)\u0001\u0006t_V\u00148-\u001a9bi\"\u0004\"!O$\n\u0005!\u0013!AC*pkJ\u001cW\r]1uQ\")!\n\u0001C\u0001\u0017\u0006!1\u000f^8q)\u0005\t\u0005\"B'\u0001\t\u0003q\u0015\u0001\u0005:fa2\f7-Z\"mCN\u001c\b/\u0019;i)\t\tu\nC\u0003F\u0019\u0002\u0007a\tC\u0003R\u0001\u0011\u0005!+\u0001\u0007ve24uN]*z[\n|G\u000e\u0006\u0002T9R\u0011Ak\u0016\t\u0004\u0013Uc\u0012B\u0001,\u000b\u0005\u0019y\u0005\u000f^5p]\")\u0001\f\u0015a\u00013\u000611/_7c_2\u0004\"A\u00175\u000f\u0005mcF\u0002\u0001\u0005\u0006;B\u0003\rAX\u0001\tG>l\u0007/\u001b7feB\u0011qLZ\u0007\u0002A*\u0011\u0011MY\u0001\fS:$XM]1di&4XM\u0003\u0002dI\u0006\u0019an]2\u000b\u0005\u0015T\u0011!\u0002;p_2\u001c\u0018BA4a\u0005\u00199En\u001c2bY&\u0011\u0011N\u001b\u0002\u0007'fl'm\u001c7\n\u0005-d'aB*z[\n|Gn\u001d\u0006\u0003[:\f\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003_*\tqA]3gY\u0016\u001cGO\u0002\u0003r\u0001\u0001\u0013(!B*uCR,7\u0003\u00029\tgZ\u0004\"!\u0003;\n\u0005UT!a\u0002)s_\u0012,8\r\u001e\t\u0003\u0013]L!\u0001\u001f\u0006\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011i\u0004(Q3A\u0005\u0002m\fQ!\u001b8eKb,\u0012\u0001 \t\u0004{\u0006\u001dQ\"\u0001@\u000b\u0007}\f\t!A\u0003ni\u0006<7OC\u0002n\u0003\u0007Q1!!\u0002\u000b\u0003\u0011iW\r^1\n\u0007\u0005%aPA\nP]\u0012+W.\u00198e'fl'm\u001c7J]\u0012,\u0007\u0010C\u0005\u0002\u000eA\u0014\t\u0012)A\u0005y\u00061\u0011N\u001c3fq\u0002B!\"!\u0005q\u0005+\u0007I\u0011AA\n\u0003-\u0019G.Y:t\u0019>\fG-\u001a:\u0016\u0005\u0005U\u0001\u0003BA\f\u0003Ci!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0004]\u0016$(BAA\u0010\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0012\u0011\u0004\u0002\u000f+Jc5\t\\1tg2{\u0017\rZ3s\u0011)\t9\u0003\u001dB\tB\u0003%\u0011QC\u0001\rG2\f7o\u001d'pC\u0012,'\u000f\t\u0005\u000b\u0003W\u0001(Q3A\u0005\u0002\u00055\u0012AB4m_\n\fG.F\u0001_\u0011%\t\t\u0004\u001dB\tB\u0003%a,A\u0004hY>\u0014\u0017\r\u001c\u0011\t\u0013\u0015\u0003(Q3A\u0005\u0002\u0005UR#\u0001$\t\u0013\u0005e\u0002O!E!\u0002\u00131\u0015aC:pkJ\u001cW\r]1uQ\u0002BaA\u000e9\u0005\u0002\u0005uBCCA \u0003\u0007\n)%a\u0012\u0002JA\u0019\u0011\u0011\t9\u000e\u0003\u0001AaA_A\u001e\u0001\u0004a\b\u0002CA\t\u0003w\u0001\r!!\u0006\t\u000f\u0005-\u00121\ba\u0001=\"1Q)a\u000fA\u0002\u0019C\u0011\"!\u0014q\u0003\u0003%\t!a\u0014\u0002\t\r|\u0007/\u001f\u000b\u000b\u0003\u007f\t\t&a\u0015\u0002V\u0005]\u0003\u0002\u0003>\u0002LA\u0005\t\u0019\u0001?\t\u0015\u0005E\u00111\nI\u0001\u0002\u0004\t)\u0002C\u0005\u0002,\u0005-\u0003\u0013!a\u0001=\"AQ)a\u0013\u0011\u0002\u0003\u0007a\tC\u0005\u0002\\A\f\n\u0011\"\u0001\u0002^\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA0U\ra\u0018\u0011M\u0016\u0003\u0003G\u0002B!!\u001a\u0002p5\u0011\u0011q\r\u0006\u0005\u0003S\nY'A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u000e\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002r\u0005\u001d$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\u000f9\u0012\u0002\u0013\u0005\u0011qO\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tIH\u000b\u0003\u0002\u0016\u0005\u0005\u0004\"CA?aF\u0005I\u0011AA@\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!!+\u0007y\u000b\t\u0007C\u0005\u0002\u0006B\f\n\u0011\"\u0001\u0002\b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAAEU\r1\u0015\u0011\r\u0005\n\u0003\u001b\u0003\u0018\u0011!C!\u0003\u001f\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAI!\u0011\t\u0019*!'\u000e\u0005\u0005U%\u0002BAL\u0003;\tA\u0001\\1oO&\u0019!%!&\t\u0013\u0005u\u0005/!A\u0005\u0002\u0005}\u0015\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001\u0015\t\u0013\u0005\r\u0006/!A\u0005\u0002\u0005\u0015\u0016A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003O\u000bi\u000bE\u0002\n\u0003SK1!a+\u000b\u0005\r\te.\u001f\u0005\n\u0003_\u000b\t+!AA\u0002!\n1\u0001\u001f\u00132\u0011%\t\u0019\f]A\u0001\n\u0003\n),A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\f\u0005\u0004\u0002:\u0006}\u0016qU\u0007\u0003\u0003wS1!!0\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0003\fYL\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t)\r]A\u0001\n\u0003\t9-\u0001\u0005dC:,\u0015/^1m)\u0011\tI-a4\u0011\u0007%\tY-C\u0002\u0002N*\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u00020\u0006\r\u0017\u0011!a\u0001\u0003OC\u0011\"a5q\u0003\u0003%\t%!6\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001\u000b\u0005\n\u00033\u0004\u0018\u0011!C!\u00037\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003#C\u0011\"a8q\u0003\u0003%\t%!9\u0002\r\u0015\fX/\u00197t)\u0011\tI-a9\t\u0015\u0005=\u0016Q\\A\u0001\u0002\u0004\t9kB\u0005\u0002h\u0002\t\t\u0011#\u0001\u0002j\u0006)1\u000b^1uKB!\u0011\u0011IAv\r!\t\b!!A\t\u0002\u000558#BAv\u0003_4\bcCAy\u0003od\u0018Q\u00030G\u0003\u007fi!!a=\u000b\u0007\u0005U(\"A\u0004sk:$\u0018.\\3\n\t\u0005e\u00181\u001f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004b\u0002\u001c\u0002l\u0012\u0005\u0011Q \u000b\u0003\u0003SD!\"!7\u0002l\u0006\u0005IQIAn\u0011)\u0011\u0019!a;\u0002\u0002\u0013\u0005%QA\u0001\u0006CB\u0004H.\u001f\u000b\u000b\u0003\u007f\u00119A!\u0003\u0003\f\t5\u0001B\u0002>\u0003\u0002\u0001\u0007A\u0010\u0003\u0005\u0002\u0012\t\u0005\u0001\u0019AA\u000b\u0011\u001d\tYC!\u0001A\u0002yCa!\u0012B\u0001\u0001\u00041\u0005B\u0003B\t\u0003W\f\t\u0011\"!\u0003\u0014\u00059QO\\1qa2LH\u0003\u0002B\u000b\u0005;\u0001B!C+\u0003\u0018AA\u0011B!\u0007}\u0003+qf)C\u0002\u0003\u001c)\u0011a\u0001V;qY\u0016$\u0004B\u0003B\u0010\u0005\u001f\t\t\u00111\u0001\u0002@\u0005\u0019\u0001\u0010\n\u0019\t\u0013\t\r\u0002A1A\u0005\n\t\u0015\u0012!B:uCR,WC\u0001B\u0014!\u0019\u0011ICa\u000e\u0002@5\u0011!1\u0006\u0006\u0005\u0005[\u0011y#\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0005c\u0011\u0019$\u0001\u0006d_:\u001cWO\u001d:f]RTAA!\u000e\u0002\u001e\u0005!Q\u000f^5m\u0013\u0011\u0011IDa\u000b\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016D\u0001B!\u0010\u0001A\u0003%!qE\u0001\u0007gR\fG/\u001a\u0011\t\u000bi\u0004A\u0011A>\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002BB#\u0001\t\u0003\t)\u0004C\u0005\u0003J\u0001\u0011\r\u0011\"\u0003\u0003L\u0005!An\\2l+\t\u0011i\u0005\u0005\u0003\u0002\u0014\n=\u0013\u0002\u0002B)\u0003+\u0013aa\u00142kK\u000e$\b\u0002\u0003B+\u0001\u0001\u0006IA!\u0014\u0002\u000b1|7m\u001b\u0011\t\u0013\te\u0003A1A\u0005\n\tm\u0013AB1tg\u0016$8/\u0006\u0002\u0003^A!!q\fB3\u001b\t\u0011\tG\u0003\u0003\u0003d\u0005\r\u0011AA5p\u0013\u0011\u00119G!\u0019\u0003\u0019\u0005\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5\t\u0011\t-\u0004\u0001)A\u0005\u0005;\nq!Y:tKR\u001c\b\u0005C\u0005\u0003p\u0001\u0011\r\u0011\"\u0003\u0003r\u0005Y\u0001\u000e\u001e;q\u0011\u0006tG\r\\3s+\t\u0011\u0019H\u0005\u0004\u0003v\t5#Q\u0010\u0004\b\u0005o\u0012I\b\u0001B:\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0011!\u0011Y\b\u0001Q\u0001\n\tM\u0014\u0001\u00045uiBD\u0015M\u001c3mKJ\u0004\u0003\u0003\u0002B@\u0005\u0013k!A!!\u000b\u0007\r\u0011\u0019I\u0003\u0003\u0003\u0006\n\u001d\u0015\u0001C;oI\u0016\u0014Ho\\<\u000b\u0005\t\r\u0014\u0002\u0002BF\u0005\u0003\u00131\u0002\u0013;ua\"\u000bg\u000e\u001a7fe\"A1\u0001\u0001b\u0001\n\u0013\u0011y)\u0006\u0002\u0003\u0012B!!1\u0013BK\u001b\t\u0011\u0019)\u0003\u0003\u0003\u0018\n\r%\u0001C+oI\u0016\u0014Ho\\<\t\u0011\tm\u0005\u0001)A\u0005\u0005#\u000bqa]3sm\u0016\u0014\b\u0005C\u0004\u0003 \u0002!IA!)\u0002\u0011\u001d,GOQ=uKN$BAa)\u00030B)\u0011B!*\u0003*&\u0019!q\u0015\u0006\u0003\u000b\u0005\u0013(/Y=\u0011\u0007%\u0011Y+C\u0002\u0003.*\u0011AAQ=uK\"A!\u0011\u0017BO\u0001\u0004\u0011\u0019,\u0001\u0005fq\u000eD\u0017M\\4f!\u0011\u0011yH!.\n\t\t]&\u0011\u0011\u0002\u0013\u0011R$\boU3sm\u0016\u0014X\t_2iC:<W\rC\u0004\u0003<\u0002!IA!0\u0002\u0017\u001dT\u0018\u000e\u001d#fM2\fG/\u001a\u000b\u0005\u0005G\u0013y\f\u0003\u0005\u0003B\ne\u0006\u0019\u0001BR\u0003\u0015\u0011\u0017\u0010^3t\u0011\u001d\u0011)\r\u0001C\u0005\u0005\u000f\fAbZ3u/>\u00148n\u001d9bG\u0016,\"A!3\u0011\t\t-'\u0011[\u0007\u0003\u0005\u001bT1Aa4\u0005\u0003\u0019\u00198\r[3nC&!!1\u001bBg\u0005%9vN]6ta\u0006\u001cW\rC\u0004\u0003X\u0002!IA!7\u0002\u001b\u001d,GoU3nC:$\u0018n\u00193c)\u0011\u0011YNa:\u0011\t\tu'1]\u0007\u0003\u0005?TAA!9\u0002\u0002\u0005Q1/Z7b]RL7\r\u001a2\n\t\t\u0015(q\u001c\u0002\u000e)\u0016DH\u000fR8dk6,g\u000e^:\t\u000f\t%(Q\u001ba\u00019\u0005Aa-\u001b7f]\u0006lW\rC\u0004\u0003n\u0002!IAa<\u0002\u0013\u001d,GoU=nE>dG\u0003\u0002By\u0005o\u0004BAa3\u0003t&!!Q\u001fBg\u00055\u0019\u00160\u001c2pY&sG-\u001a=fg\"9!\u0011 Bv\u0001\u0004a\u0012aA:z[\"9!Q \u0001\u0005\n\t}\u0018aC2p]R,g\u000e\u001e+za\u0016$2\u0001HB\u0001\u0011\u001d\u0019\u0019Aa?A\u0002q\tA\u0001]1uQ\u001e91q\u0001\u0002\t\u0002\r%\u0011\u0001E'fi\u0006\u0014'o\\<tKN+'O^3s!\rI41\u0002\u0004\u0007\u0003\tA\ta!\u0004\u0014\u0007\r-\u0001\u0002C\u00047\u0007\u0017!\ta!\u0005\u0015\u0005\r%\u0001\u0002CB\u000b\u0007\u0017!\taa\u0006\u0002\t5\f\u0017N\u001c\u000b\u0004\u0003\u000ee\u0001\u0002CB\u000e\u0007'\u0001\ra!\b\u0002\u0013\u0005\u0014(/Y=Be\u001e\u001c\b\u0003B\u0005\u0003&rA\u0001b!\t\u0004\f\u0011%11E\u0001\u000e[\u0006\u001c'o\u001c)be\u0006$\u0017n]3\u0016\u0005\r\u0015\u0002\u0003BB\u0014\u0007ci!a!\u000b\u000b\t\r-2QF\u0001\u0005M&dWM\u0003\u0003\u00040\u0005u\u0011a\u00018j_&!11GB\u0015\u0005\u0011\u0001\u0016\r\u001e5\t\u0011\r]21\u0002C\u0005\u0007G\tQb[5oIB\u0013xN[3di>\u0014\b\u0002CB\u001e\u0007\u0017!Ia!\u0010\u0002!M\u001c\u0017\r\\1Gk2dg+\u001a:tS>tW#\u0001\u000f\t\u0011\r\u000531\u0002C\u0005\u0007{\t!c]2bY\u0006\u0014\u0015N\\1ssZ+'o]5p]\"Q1QIB\u0006#\u0003%\taa\u0012\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019IEK\u0002\u0011\u0003CB!b!\u0014\u0004\fE\u0005I\u0011AB(\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111\u0011\u000b\u0016\u00049\u0005\u0005\u0004BCB+\u0007\u0017\t\n\u0011\"\u0001\u0004X\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"a!\u0017+\u0007!\n\t\u0007\u0003\u0006\u0004^\r-\u0011\u0013!C\u0001\u0007?\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAB1U\ri\u0013\u0011\r")
public class MetabrowseServer {
    private volatile MetabrowseServer$State$ State$module;
    private final List<String> scalacOptions;
    public final Logger metabrowse$server$MetabrowseServer$$logger;
    private final AtomicReference<State> state;
    private final Object metabrowse$server$MetabrowseServer$$lock;
    private final AbsolutePath assets;
    private final HttpHandler httpHandler;
    private final Undertow server;

    public static Logger $lessinit$greater$default$4() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$2() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$2();
    }

    public static List<String> $lessinit$greater$default$1() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$1();
    }

    public static void main(String[] stringArray) {
        MetabrowseServer$.MODULE$.main(stringArray);
    }

    public MetabrowseServer$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public void start(Sourcepath sourcepath) {
        this.replaceClasspath(sourcepath);
        this.server().start();
    }

    public void stop() {
        this.server().stop();
        this.global().askShutdown();
    }

    public void replaceClasspath(Sourcepath sourcepath) {
        Object object = this.metabrowse$server$MetabrowseServer$$lock();
        synchronized (object) {
            if (this.state().get() != null) {
                this.global().askShutdown();
            }
            State newState = new State(this, new OnDemandSymbolIndex(OnDemandSymbolIndex$.MODULE$.apply$default$1(), OnDemandSymbolIndex$.MODULE$.apply$default$2(), OnDemandSymbolIndex$.MODULE$.apply$default$3()), new URLClassLoader((URL[])((TraversableOnce)sourcepath.sources().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toUri().toURL(), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(URL.class))), InteractiveSemanticdb$.MODULE$.newCompiler(sourcepath.classpath().mkString(File.pathSeparator), this.scalacOptions), sourcepath);
            this.state().set(newState);
            sourcepath.sources().foreach((Function1 & Serializable & scala.Serializable)jar -> {
                MetabrowseServer.$anonfun$replaceClasspath$2(this, jar);
                return BoxedUnit.UNIT;
            });
        }
    }

    public Option<String> urlForSymbol(Global compiler, Symbols.Symbol symbol) {
        Symbols.Symbol symbol2 = symbol;
        LazyRef semanticdbOps$lzy = new LazyRef();
        ObjectRef compilerSymbol = ObjectRef.create((Object)compiler.rootMirror().RootPackage());
        symbol2.ownerChain().reverse().drop(1).foreach((Function1 & Serializable & scala.Serializable)owner -> {
            MetabrowseServer.$anonfun$urlForSymbol$1(compiler, compilerSymbol, owner);
            return BoxedUnit.UNIT;
        });
        String semanticdbSymbol = MetabrowseServer.semanticdbOps$1(compiler, semanticdbOps$lzy).XtensionGSymbolMSymbol((Symbols.Symbol)compilerSymbol.elem).toSemantic();
        return this.getSymbol(semanticdbSymbol).indexes().headOption().flatMap((Function1 & Serializable & scala.Serializable)symbolIndex -> symbolIndex.definition().map((Function1 & Serializable & scala.Serializable)position -> new StringBuilder(4).append("#").append(position.filename()).append("#L").append(position.startLine()).append("C").append(position.startCharacter()).toString()));
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    public OnDemandSymbolIndex index() {
        return this.state().get().index();
    }

    public URLClassLoader classLoader() {
        return this.state().get().classLoader();
    }

    public Global global() {
        return this.state().get().global();
    }

    public Sourcepath sourcepath() {
        return this.state().get().sourcepath();
    }

    public Object metabrowse$server$MetabrowseServer$$lock() {
        return this.metabrowse$server$MetabrowseServer$$lock;
    }

    private AbsolutePath assets() {
        return this.assets;
    }

    private HttpHandler httpHandler() {
        return this.httpHandler;
    }

    private Undertow server() {
        return this.server;
    }

    public byte[] metabrowse$server$MetabrowseServer$$getBytes(HttpServerExchange exchange) {
        byte[] byArray;
        String path = new StringOps(Predef$.MODULE$.augmentString(exchange.getRequestPath())).stripSuffix(".gz");
        if (path.endsWith("index.workspace")) {
            byArray = this.getWorkspace().toByteArray();
        } else if (path.endsWith(".symbolindexes")) {
            HeaderValues header = exchange.getRequestHeaders().get("Metabrowse-Symbol");
            if (header.isEmpty()) {
                this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(29).append("no Metabrowse-Symbol header: ").append(exchange).toString());
                byArray = Array$.MODULE$.emptyByteArray();
            } else {
                byArray = this.getSymbol(header.getFirst()).toByteArray();
            }
        } else if (path.endsWith(".semanticdb")) {
            byArray = this.getSemanticdb(path).toByteArray();
        } else if (path.endsWith(".map")) {
            byArray = Array$.MODULE$.emptyByteArray();
        } else {
            String string = path;
            String string2 = "/";
            String actualPath = !(string != null ? !string.equals(string2) : string2 != null) ? "/index.html" : path;
            AbsolutePath file = this.assets().resolve(actualPath);
            if (file.isFile()) {
                byArray = file.readAllBytes();
            } else {
                this.metabrowse$server$MetabrowseServer$$logger.warn(new StringBuilder(14).append("no such file: ").append(file).toString());
                byArray = Array$.MODULE$.emptyByteArray();
            }
        }
        return byArray;
    }

    public byte[] metabrowse$server$MetabrowseServer$$gzipDeflate(byte[] bytes) {
        byte[] byArray;
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty()) {
            byArray = bytes;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GZIPOutputStream gos = new GZIPOutputStream((OutputStream)baos, bytes.length);){
                gos.write(bytes);
                gos.finish();
                byArray = baos.toByteArray();
            }
        }
        return byArray;
    }

    private Workspace getWorkspace() {
        Builder filenames = ArrayBuffer$.MODULE$.newBuilder();
        this.sourcepath().sources().foreach((Function1 & Serializable & scala.Serializable)sourcesJar -> {
            FileIO$.MODULE$.withJarFileSystem(AbsolutePath$.MODULE$.apply(sourcesJar, AbsolutePath$.MODULE$.workingDirectory()), false, false, (Function1 & Serializable & scala.Serializable)root -> {
                MetabrowseServer.$anonfun$getWorkspace$2(filenames$1, root);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return new Workspace((Seq)filenames.result());
    }

    private TextDocuments getSemanticdb(String filename) {
        String path = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(filename)).stripPrefix("/semanticdb/"))).stripPrefix("/"))).stripSuffix(".semanticdb");
        this.metabrowse$server$MetabrowseServer$$logger.info(path);
        return (TextDocuments)Option$.MODULE$.apply((Object)this.classLoader().getResourceAsStream(path)).orElse((Function0 & Serializable & scala.Serializable)() -> {
            $this.metabrowse$server$MetabrowseServer$$logger.warn(new StringBuilder(16).append("no source file: ").append(path).toString());
            return None$.MODULE$;
        }).map((Function1 & Serializable & scala.Serializable)in -> {
            String text = new String(InputStreamIO$.MODULE$.readBytes(in), StandardCharsets.UTF_8);
            return new Tuple2(in, (Object)text);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String text = (String)tuple2._2();
            Option option = this.liftedTree1$1(filename, path, text).map((Function1 & Serializable & scala.Serializable)doc -> new TextDocuments((Seq)new .colon.colon((Object)doc.withText(text), (List)Nil$.MODULE$)));
            return option;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new TextDocuments(TextDocuments$.MODULE$.apply$default$1()));
    }

    private SymbolIndexes getSymbol(String sym) {
        Option definition = this.index().definition(Symbol$.MODULE$.apply(sym)).orElse((Function0 & Serializable & scala.Serializable)() -> {
            $this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(28).append("no definition for symbol: '").append(sym).append("'").toString());
            return None$.MODULE$;
        }).map((Function1 & Serializable & scala.Serializable)defn -> {
            Input.VirtualFile input = MtagsEnrichments$.MODULE$.XtensionAbsolutePathMetals(defn.path()).toInput();
            TextDocument doc = Mtags$.MODULE$.index(input);
            return new Tuple3(defn, (Object)input, (Object)doc);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple3 tuple3 = x$4;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            SymbolDefinition defn = (SymbolDefinition)tuple3._1();
            TextDocument doc = (TextDocument)tuple3._3();
            Option option = doc.occurrences().find((Function1 & Serializable & scala.Serializable)occ -> BoxesRunTime.boxToBoolean((boolean)MetabrowseServer.$anonfun$getSymbol$4(defn, occ))).orElse((Function0 & Serializable & scala.Serializable)() -> {
                $this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(26).append("no definition occurrence: ").append(defn).toString());
                return None$.MODULE$;
            }).flatMap((Function1 & Serializable & scala.Serializable)occ -> occ.range().orElse((Function0 & Serializable & scala.Serializable)() -> {
                $this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(10).append("no range: ").append(occ).toString());
                return None$.MODULE$;
            }).map((Function1 & Serializable & scala.Serializable)range -> new metabrowse.schema.Position(defn.path().toString(), range.startLine(), range.startCharacter(), range.endLine(), range.endCharacter())));
            return option;
        });
        return new SymbolIndexes((Seq)new .colon.colon((Object)new SymbolIndex(sym, definition, SymbolIndex$.MODULE$.apply$default$3()), (List)Nil$.MODULE$));
    }

    public String metabrowse$server$MetabrowseServer$$contentType(String path) {
        return path.endsWith(".js") ? "application/javascript" : (path.endsWith(".css") ? "text/css" : (path.endsWith(".html") ? "text/html" : ""));
    }

    private final void State$lzycompute$1() {
        MetabrowseServer metabrowseServer = this;
        synchronized (metabrowseServer) {
            if (this.State$module == null) {
                this.State$module = new MetabrowseServer$State$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$replaceClasspath$2(MetabrowseServer $this, Path jar) {
        $this.index().addSourceJar(AbsolutePath$.MODULE$.apply(jar, AbsolutePath$.MODULE$.workingDirectory()));
    }

    private static final /* synthetic */ SemanticdbOps semanticdbOps$lzycompute$1(Global compiler$1, LazyRef semanticdbOps$lzy$1) {
        SemanticdbOps semanticdbOps;
        LazyRef lazyRef = semanticdbOps$lzy$1;
        synchronized (lazyRef) {
            semanticdbOps = semanticdbOps$lzy$1.initialized() ? (SemanticdbOps)semanticdbOps$lzy$1.value() : (SemanticdbOps)semanticdbOps$lzy$1.initialize((Object)new SemanticdbOps(null, compiler$1){
                private final Global global;
                private SemanticdbConfig config;
                private volatile TypeOps$ByNameType$ ByNameType$module;
                private volatile TypeOps$RepeatedType$ RepeatedType$module;
                private HashMap<Symbols.Symbol, String> symbolCache;
                private volatile SymbolOps$SemanticdbDecls$ SemanticdbDecls$module;
                private HashMap<String, Object> idCache;
                private Global g;
                private boolean isDocCompiler;
                private boolean isReplCompiler;
                private boolean isInteractiveCompiler;
                private boolean isSupportedCompiler;
                private volatile ReflectionToolkit$Attachable$ Attachable$module;
                private volatile ReflectionToolkit$ConstfoldOf$ ConstfoldOf$module;
                private volatile ReflectionToolkit$ClassOf$ ClassOf$module;
                private volatile ReflectionToolkit$NewArrayOf$ NewArrayOf$module;
                private volatile ReflectionToolkit$SingletonTypeTreeOf$ SingletonTypeTreeOf$module;
                private volatile ReflectionToolkit$CompoundTypeTreeOf$ CompoundTypeTreeOf$module;
                private volatile ReflectionToolkit$ExistentialTypeTreeOf$ ExistentialTypeTreeOf$module;
                private volatile ReflectionToolkit$AnnotatedOf$ AnnotatedOf$module;
                private volatile ReflectionToolkit$SelfTypeOf$ SelfTypeOf$module;
                private volatile ReflectionToolkit$SelectOf$ SelectOf$module;
                private final Map<CompilationUnits.CompilationUnit, Object> scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath;
                private String language;
                private Map<SourceFile, Input> gSourceFileInputCache;
                private volatile int bitmap$0;

                public TypeOps.XtensionGTypeSType XtensionGTypeSType(Types.Type gtpe) {
                    return TypeOps.XtensionGTypeSType$((TypeOps)this, (Types.Type)gtpe);
                }

                public TypeOps.XtensionGType XtensionGType(Types.Type gtpe) {
                    return TypeOps.XtensionGType$((TypeOps)this, (Types.Type)gtpe);
                }

                public SyntheticOps.XtensionGTreeSTree XtensionGTreeSTree(Trees.Tree gTree) {
                    return SyntheticOps.XtensionGTreeSTree$((SyntheticOps)this, (Trees.Tree)gTree);
                }

                public SymbolOps.XtensionGSymbolMSymbol XtensionGSymbolMSymbol(Symbols.Symbol sym) {
                    return SymbolOps.XtensionGSymbolMSymbol$((SymbolOps)this, (Symbols.Symbol)sym);
                }

                public SymbolOps.XtensionGSymbolMSpec XtensionGSymbolMSpec(Symbols.Symbol sym) {
                    return SymbolOps.XtensionGSymbolMSpec$((SymbolOps)this, (Symbols.Symbol)sym);
                }

                public SymbolOps.XtensionGScopeMSpec XtensionGScopeMSpec(Scopes.Scope scope) {
                    return SymbolOps.XtensionGScopeMSpec$((SymbolOps)this, (Scopes.Scope)scope);
                }

                public SymbolOps.XtensionGSymbolsMSpec XtensionGSymbolsMSpec(List<Symbols.Symbol> syms) {
                    return SymbolOps.XtensionGSymbolsMSpec$((SymbolOps)this, syms);
                }

                public SymbolOps.XtensionGSymbol XtensionGSymbol(Symbols.Symbol sym) {
                    return SymbolOps.XtensionGSymbol$((SymbolOps)this, (Symbols.Symbol)sym);
                }

                public <T> ReflectionToolkit.XtensionAttachable<T> XtensionAttachable(T carrier, ReflectionToolkit.Attachable<T> evidence$4) {
                    return ReflectionToolkit.XtensionAttachable$((ReflectionToolkit)this, carrier, evidence$4);
                }

                public <T> ReflectionToolkit.XtensionMetadataAttachable<T> XtensionMetadataAttachable(T carrier, ReflectionToolkit.Attachable<T> evidence$6) {
                    return ReflectionToolkit.XtensionMetadataAttachable$((ReflectionToolkit)this, carrier, evidence$6);
                }

                public ReflectionToolkit.XtensionCompilationUnitCache XtensionCompilationUnitCache(CompilationUnits.CompilationUnit unit) {
                    return ReflectionToolkit.XtensionCompilationUnitCache$((ReflectionToolkit)this, (CompilationUnits.CompilationUnit)unit);
                }

                public <T> ReflectionToolkit.XtensionDesugarings<T> XtensionDesugarings(T carrier, ReflectionToolkit.Attachable<T> evidence$10) {
                    return ReflectionToolkit.XtensionDesugarings$((ReflectionToolkit)this, carrier, evidence$10);
                }

                public ReporterOps.XtensionCompilationUnitReporter XtensionCompilationUnitReporter(CompilationUnits.CompilationUnit unit) {
                    return ReporterOps.XtensionCompilationUnitReporter$((ReporterOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public ParseOps.XtensionCompilationUnitSource XtensionCompilationUnitSource(CompilationUnits.CompilationUnit unit) {
                    return ParseOps.XtensionCompilationUnitSource$((ParseOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public DiagnosticOps.XtensionCompilationUnitDiagnostics XtensionCompilationUnitDiagnostics(CompilationUnits.CompilationUnit unit) {
                    return DiagnosticOps.XtensionCompilationUnitDiagnostics$((DiagnosticOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public InputOps.XtensionGSourceFileInput XtensionGSourceFileInput(SourceFile gsource) {
                    return InputOps.XtensionGSourceFileInput$((InputOps)this, (SourceFile)gsource);
                }

                public InputOps.XtensionGPositionMPosition XtensionGPositionMPosition(Position pos) {
                    return InputOps.XtensionGPositionMPosition$((InputOps)this, (Position)pos);
                }

                public void validateCompilerState() {
                    TextDocumentOps.validateCompilerState$((TextDocumentOps)this);
                }

                public TextDocumentOps.XtensionCompilationUnitDocument XtensionCompilationUnitDocument(CompilationUnits.CompilationUnit unit) {
                    return TextDocumentOps.XtensionCompilationUnitDocument$((TextDocumentOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public SymbolInformationOps.XtensionGSymbolMSymbolInformation XtensionGSymbolMSymbolInformation(Symbols.Symbol gsym0) {
                    return SymbolInformationOps.XtensionGSymbolMSymbolInformation$((SymbolInformationOps)this, (Symbols.Symbol)gsym0);
                }

                public AnnotationOps.XtensionAnnotationInfo XtensionAnnotationInfo(AnnotationInfos.AnnotationInfo gann) {
                    return AnnotationOps.XtensionAnnotationInfo$((AnnotationOps)this, (AnnotationInfos.AnnotationInfo)gann);
                }

                public SemanticdbConfig config() {
                    return this.config;
                }

                public void config_$eq(SemanticdbConfig x$1) {
                    this.config = x$1;
                }

                public TypeOps$ByNameType$ ByNameType() {
                    if (this.ByNameType$module == null) {
                        this.ByNameType$lzycompute$1();
                    }
                    return this.ByNameType$module;
                }

                public TypeOps$RepeatedType$ RepeatedType() {
                    if (this.RepeatedType$module == null) {
                        this.RepeatedType$lzycompute$1();
                    }
                    return this.RepeatedType$module;
                }

                private HashMap<Symbols.Symbol, String> symbolCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 1) == 0) {
                            this.symbolCache = SymbolOps.symbolCache$((SymbolOps)this);
                            this.bitmap$0 |= 1;
                        }
                    }
                    return this.symbolCache;
                }

                public HashMap<Symbols.Symbol, String> symbolCache() {
                    return (this.bitmap$0 & 1) == 0 ? this.symbolCache$lzycompute() : this.symbolCache;
                }

                public SymbolOps$SemanticdbDecls$ SemanticdbDecls() {
                    if (this.SemanticdbDecls$module == null) {
                        this.SemanticdbDecls$lzycompute$1();
                    }
                    return this.SemanticdbDecls$module;
                }

                private HashMap<String, Object> idCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 2) == 0) {
                            this.idCache = SymbolOps.idCache$((SymbolOps)this);
                            this.bitmap$0 |= 2;
                        }
                    }
                    return this.idCache;
                }

                public HashMap<String, Object> idCache() {
                    return (this.bitmap$0 & 2) == 0 ? this.idCache$lzycompute() : this.idCache;
                }

                private Global g$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 4) == 0) {
                            this.g = (Global)ReflectionToolkit.g$((ReflectionToolkit)this);
                            this.bitmap$0 |= 4;
                        }
                    }
                    return this.g;
                }

                public Global g() {
                    return (this.bitmap$0 & 4) == 0 ? this.g$lzycompute() : this.g;
                }

                private boolean isDocCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 8) == 0) {
                            this.isDocCompiler = ReflectionToolkit.isDocCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 8;
                        }
                    }
                    return this.isDocCompiler;
                }

                public boolean isDocCompiler() {
                    return (this.bitmap$0 & 8) == 0 ? this.isDocCompiler$lzycompute() : this.isDocCompiler;
                }

                private boolean isReplCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x10) == 0) {
                            this.isReplCompiler = ReflectionToolkit.isReplCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x10;
                        }
                    }
                    return this.isReplCompiler;
                }

                public boolean isReplCompiler() {
                    return (this.bitmap$0 & 0x10) == 0 ? this.isReplCompiler$lzycompute() : this.isReplCompiler;
                }

                private boolean isInteractiveCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x20) == 0) {
                            this.isInteractiveCompiler = ReflectionToolkit.isInteractiveCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x20;
                        }
                    }
                    return this.isInteractiveCompiler;
                }

                public boolean isInteractiveCompiler() {
                    return (this.bitmap$0 & 0x20) == 0 ? this.isInteractiveCompiler$lzycompute() : this.isInteractiveCompiler;
                }

                private boolean isSupportedCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x40) == 0) {
                            this.isSupportedCompiler = ReflectionToolkit.isSupportedCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x40;
                        }
                    }
                    return this.isSupportedCompiler;
                }

                public boolean isSupportedCompiler() {
                    return (this.bitmap$0 & 0x40) == 0 ? this.isSupportedCompiler$lzycompute() : this.isSupportedCompiler;
                }

                public ReflectionToolkit$Attachable$ Attachable() {
                    if (this.Attachable$module == null) {
                        this.Attachable$lzycompute$1();
                    }
                    return this.Attachable$module;
                }

                public ReflectionToolkit$ConstfoldOf$ ConstfoldOf() {
                    if (this.ConstfoldOf$module == null) {
                        this.ConstfoldOf$lzycompute$1();
                    }
                    return this.ConstfoldOf$module;
                }

                public ReflectionToolkit$ClassOf$ ClassOf() {
                    if (this.ClassOf$module == null) {
                        this.ClassOf$lzycompute$1();
                    }
                    return this.ClassOf$module;
                }

                public ReflectionToolkit$NewArrayOf$ NewArrayOf() {
                    if (this.NewArrayOf$module == null) {
                        this.NewArrayOf$lzycompute$1();
                    }
                    return this.NewArrayOf$module;
                }

                public ReflectionToolkit$SingletonTypeTreeOf$ SingletonTypeTreeOf() {
                    if (this.SingletonTypeTreeOf$module == null) {
                        this.SingletonTypeTreeOf$lzycompute$1();
                    }
                    return this.SingletonTypeTreeOf$module;
                }

                public ReflectionToolkit$CompoundTypeTreeOf$ CompoundTypeTreeOf() {
                    if (this.CompoundTypeTreeOf$module == null) {
                        this.CompoundTypeTreeOf$lzycompute$1();
                    }
                    return this.CompoundTypeTreeOf$module;
                }

                public ReflectionToolkit$ExistentialTypeTreeOf$ ExistentialTypeTreeOf() {
                    if (this.ExistentialTypeTreeOf$module == null) {
                        this.ExistentialTypeTreeOf$lzycompute$1();
                    }
                    return this.ExistentialTypeTreeOf$module;
                }

                public ReflectionToolkit$AnnotatedOf$ AnnotatedOf() {
                    if (this.AnnotatedOf$module == null) {
                        this.AnnotatedOf$lzycompute$1();
                    }
                    return this.AnnotatedOf$module;
                }

                public ReflectionToolkit$SelfTypeOf$ SelfTypeOf() {
                    if (this.SelfTypeOf$module == null) {
                        this.SelfTypeOf$lzycompute$1();
                    }
                    return this.SelfTypeOf$module;
                }

                public ReflectionToolkit$SelectOf$ SelectOf() {
                    if (this.SelectOf$module == null) {
                        this.SelectOf$lzycompute$1();
                    }
                    return this.SelectOf$module;
                }

                public Map<CompilationUnits.CompilationUnit, Object> scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath() {
                    return this.scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath;
                }

                public final void scala$meta$internal$semanticdb$scalac$ReporterOps$_setter_$scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath_$eq(Map<CompilationUnits.CompilationUnit, Object> x$1) {
                    this.scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath = x$1;
                }

                private String language$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x80) == 0) {
                            this.language = LanguageOps.language$((LanguageOps)this);
                            this.bitmap$0 |= 0x80;
                        }
                    }
                    return this.language;
                }

                public String language() {
                    return (this.bitmap$0 & 0x80) == 0 ? this.language$lzycompute() : this.language;
                }

                private Map<SourceFile, Input> gSourceFileInputCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x100) == 0) {
                            this.gSourceFileInputCache = InputOps.gSourceFileInputCache$((InputOps)this);
                            this.bitmap$0 |= 0x100;
                        }
                    }
                    return this.gSourceFileInputCache;
                }

                public Map<SourceFile, Input> gSourceFileInputCache() {
                    return (this.bitmap$0 & 0x100) == 0 ? this.gSourceFileInputCache$lzycompute() : this.gSourceFileInputCache;
                }

                public Global global() {
                    return this.global;
                }

                private final void ByNameType$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ByNameType$module == null) {
                            this.ByNameType$module = new TypeOps$ByNameType$((SemanticdbOps)this);
                        }
                    }
                }

                private final void RepeatedType$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.RepeatedType$module == null) {
                            this.RepeatedType$module = new TypeOps$RepeatedType$((SemanticdbOps)this);
                        }
                    }
                }

                private final void SemanticdbDecls$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SemanticdbDecls$module == null) {
                            this.SemanticdbDecls$module = new SymbolOps$SemanticdbDecls$((SemanticdbOps)this);
                        }
                    }
                }

                private final void Attachable$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.Attachable$module == null) {
                            this.Attachable$module = new ReflectionToolkit$Attachable$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void ConstfoldOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ConstfoldOf$module == null) {
                            this.ConstfoldOf$module = new ReflectionToolkit$ConstfoldOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void ClassOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ClassOf$module == null) {
                            this.ClassOf$module = new ReflectionToolkit$ClassOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void NewArrayOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.NewArrayOf$module == null) {
                            this.NewArrayOf$module = new ReflectionToolkit$NewArrayOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void SingletonTypeTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SingletonTypeTreeOf$module == null) {
                            this.SingletonTypeTreeOf$module = new ReflectionToolkit$SingletonTypeTreeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void CompoundTypeTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.CompoundTypeTreeOf$module == null) {
                            this.CompoundTypeTreeOf$module = new ReflectionToolkit$CompoundTypeTreeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void ExistentialTypeTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ExistentialTypeTreeOf$module == null) {
                            this.ExistentialTypeTreeOf$module = new ReflectionToolkit$ExistentialTypeTreeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void AnnotatedOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.AnnotatedOf$module == null) {
                            this.AnnotatedOf$module = new ReflectionToolkit$AnnotatedOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void SelfTypeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SelfTypeOf$module == null) {
                            this.SelfTypeOf$module = new ReflectionToolkit$SelfTypeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void SelectOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SelectOf$module == null) {
                            this.SelectOf$module = new ReflectionToolkit$SelectOf$((ReflectionToolkit)this);
                        }
                    }
                }
                {
                    AnnotationOps.$init$((AnnotationOps)this);
                    SymbolInformationOps.$init$((SymbolInformationOps)this);
                    TextDocumentOps.$init$((TextDocumentOps)this);
                    InputOps.$init$((InputOps)this);
                    LanguageOps.$init$((LanguageOps)this);
                    DiagnosticOps.$init$((DiagnosticOps)this);
                    ParseOps.$init$((ParseOps)this);
                    ReporterOps.$init$((ReporterOps)this);
                    ReflectionToolkit.$init$((ReflectionToolkit)this);
                    SymbolOps.$init$((SymbolOps)this);
                    SyntheticOps.$init$((SyntheticOps)this);
                    TypeOps.$init$((TypeOps)this);
                    SemanticdbOps.$init$((SemanticdbOps)this);
                    this.global = compiler$1;
                }
            });
        }
        return semanticdbOps;
    }

    private static final SemanticdbOps semanticdbOps$1(Global compiler$1, LazyRef semanticdbOps$lzy$1) {
        return semanticdbOps$lzy$1.initialized() ? (SemanticdbOps)semanticdbOps$lzy$1.value() : MetabrowseServer.semanticdbOps$lzycompute$1(compiler$1, semanticdbOps$lzy$1);
    }

    public static final /* synthetic */ void $anonfun$urlForSymbol$1(Global compiler$1, ObjectRef compilerSymbol$1, Symbols.Symbol owner) {
        Names.TermName name = owner.name().isTermName() || owner.hasPackageFlag() ? compiler$1.TermName().apply(owner.nameString()) : compiler$1.TypeName().apply(owner.nameString());
        compilerSymbol$1.elem = ((Symbols.Symbol)compilerSymbol$1.elem).info().member((Names.Name)name);
    }

    public static final /* synthetic */ boolean $anonfun$getWorkspace$3(AbsolutePath x$2) {
        return !MtagsEnrichments$.MODULE$.XtensionAbsolutePathMetals(x$2).toLanguage().isUnknownLanguage();
    }

    public static final /* synthetic */ void $anonfun$getWorkspace$2(Builder filenames$1, AbsolutePath root) {
        ((IterableLike)FileIO$.MODULE$.listAllFilesRecursively(root).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetabrowseServer.$anonfun$getWorkspace$3(x$2)))).foreach((Function1 & Serializable & scala.Serializable)path -> filenames$1.$plus$eq((Object)new StringOps(Predef$.MODULE$.augmentString(((Object)path.toNIO()).toString())).stripPrefix("/")));
    }

    private final Option liftedTree1$1(String filename$1, String path$1, String text$1) {
        Some some;
        try {
            TextDocument textDocument;
            long timeout = TimeUnit.SECONDS.toMillis(10L);
            if (path$1.endsWith(".java")) {
                Input.VirtualFile input = new Input.VirtualFile(path$1, text$1);
                textDocument = Mtags$.MODULE$.index(input);
            } else {
                textDocument = InteractiveSemanticdb$.MODULE$.toTextDocument(this.global(), text$1, filename$1, timeout, (List)new .colon.colon((Object)"-P:semanticdb:symbols:none", (List)Nil$.MODULE$));
            }
            TextDocument textDocument2 = textDocument;
            some = new Some((Object)textDocument2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(15).append("compile error: ").append(filename$1).toString(), e);
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getSymbol$4(SymbolDefinition defn$1, SymbolOccurrence occ) {
        if (!occ.role().isDefinition()) return false;
        if (!occ.range().isDefined()) return false;
        String string = occ.symbol();
        String string2 = defn$1.definitionSymbol().value();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public MetabrowseServer(List<String> scalacOptions, String host, int port, Logger logger) {
        this.scalacOptions = scalacOptions;
        this.metabrowse$server$MetabrowseServer$$logger = logger;
        this.state = new AtomicReference();
        this.metabrowse$server$MetabrowseServer$$lock = new Object();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("metabrowse-assets.zip");
        Path out = Files.createTempDirectory("metabrowse", new FileAttribute[0]).resolve("assets.zip");
        Files.copy(in, out, new CopyOption[0]);
        this.assets = FileIO$.MODULE$.jarRootPath(AbsolutePath$.MODULE$.apply(out, AbsolutePath$.MODULE$.workingDirectory()));
        this.httpHandler = new HttpHandler(this){
            private final /* synthetic */ MetabrowseServer $outer;

            public void handleRequest(HttpServerExchange exchange) {
                byte[] byArray;
                try {
                    Object object = this.$outer.metabrowse$server$MetabrowseServer$$lock();
                    synchronized (object) {
                        byte[] byArray2 = this.$outer.metabrowse$server$MetabrowseServer$$getBytes(exchange);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var4_2
                        byArray = byArray2;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.$outer.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(18).append("unexpected error: ").append(exchange).toString(), e);
                    byte[] byArray3 = Array$.MODULE$.emptyByteArray();
                    byArray = byArray3;
                }
                byte[] bytes = byArray;
                byte[] compressed = this.$outer.metabrowse$server$MetabrowseServer$$gzipDeflate(bytes);
                ByteBuffer buffer = ByteBuffer.wrap(compressed);
                exchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, "gzip");
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.$outer.metabrowse$server$MetabrowseServer$$contentType(exchange.getRequestPath()));
                exchange.getResponseSender().send(buffer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.server = Undertow.builder().addHttpListener(port, host).setHandler(this.httpHandler()).build();
    }

    public class State
    implements Product,
    scala.Serializable {
        private final OnDemandSymbolIndex index;
        private final URLClassLoader classLoader;
        private final Global global;
        private final Sourcepath sourcepath;
        public final /* synthetic */ MetabrowseServer $outer;

        public OnDemandSymbolIndex index() {
            return this.index;
        }

        public URLClassLoader classLoader() {
            return this.classLoader;
        }

        public Global global() {
            return this.global;
        }

        public Sourcepath sourcepath() {
            return this.sourcepath;
        }

        public State copy(OnDemandSymbolIndex index, URLClassLoader classLoader, Global global, Sourcepath sourcepath) {
            return new State(this.metabrowse$server$MetabrowseServer$State$$$outer(), index, classLoader, global, sourcepath);
        }

        public OnDemandSymbolIndex copy$default$1() {
            return this.index();
        }

        public URLClassLoader copy$default$2() {
            return this.classLoader();
        }

        public Global copy$default$3() {
            return this.global();
        }

        public Sourcepath copy$default$4() {
            return this.sourcepath();
        }

        public String productPrefix() {
            return "State";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.index();
                    break;
                }
                case 1: {
                    object = this.classLoader();
                    break;
                }
                case 2: {
                    object = this.global();
                    break;
                }
                case 3: {
                    object = this.sourcepath();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            if (((State)object).metabrowse$server$MetabrowseServer$State$$$outer() != this.metabrowse$server$MetabrowseServer$State$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            OnDemandSymbolIndex onDemandSymbolIndex = this.index();
            OnDemandSymbolIndex onDemandSymbolIndex2 = state.index();
            if (onDemandSymbolIndex == null) {
                if (onDemandSymbolIndex2 != null) {
                    return false;
                }
            } else if (!onDemandSymbolIndex.equals(onDemandSymbolIndex2)) return false;
            URLClassLoader uRLClassLoader = this.classLoader();
            URLClassLoader uRLClassLoader2 = state.classLoader();
            if (uRLClassLoader == null) {
                if (uRLClassLoader2 != null) {
                    return false;
                }
            } else if (!uRLClassLoader.equals(uRLClassLoader2)) return false;
            Global global = this.global();
            Global global2 = state.global();
            if (global == null) {
                if (global2 != null) {
                    return false;
                }
            } else if (!global.equals(global2)) return false;
            Sourcepath sourcepath = this.sourcepath();
            Sourcepath sourcepath2 = state.sourcepath();
            if (sourcepath == null) {
                if (sourcepath2 != null) {
                    return false;
                }
            } else if (!((Object)sourcepath).equals(sourcepath2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MetabrowseServer metabrowse$server$MetabrowseServer$State$$$outer() {
            return this.$outer;
        }

        public State(MetabrowseServer $outer, OnDemandSymbolIndex index, URLClassLoader classLoader, Global global, Sourcepath sourcepath) {
            this.index = index;
            this.classLoader = classLoader;
            this.global = global;
            this.sourcepath = sourcepath;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

