/*
 * Decompiled with CFR 0.152.
 */
package metabrowse.server;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;
import metabrowse.schema.SymbolIndex;
import metabrowse.schema.SymbolIndex$;
import metabrowse.schema.SymbolIndexes;
import metabrowse.schema.Workspace;
import metabrowse.server.MetabrowseServer$;
import metabrowse.server.MetabrowseServer$State$;
import metabrowse.server.Sourcepath;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map;
import scala.meta.inputs.Input;
import scala.meta.interactive.InteractiveSemanticdb$;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.InputStreamIO$;
import scala.meta.internal.mtags.Mtags$;
import scala.meta.internal.mtags.MtagsEnrichments$;
import scala.meta.internal.mtags.OnDemandSymbolIndex;
import scala.meta.internal.mtags.OnDemandSymbolIndex$;
import scala.meta.internal.mtags.Symbol$;
import scala.meta.internal.mtags.SymbolDefinition;
import scala.meta.internal.semanticdb.SymbolOccurrence;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.internal.semanticdb.TextDocuments;
import scala.meta.internal.semanticdb.TextDocuments$;
import scala.meta.internal.semanticdb.scalac.AnnotationOps;
import scala.meta.internal.semanticdb.scalac.DiagnosticOps;
import scala.meta.internal.semanticdb.scalac.InputOps;
import scala.meta.internal.semanticdb.scalac.LanguageOps;
import scala.meta.internal.semanticdb.scalac.ParseOps;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$AnnotatedOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$Attachable$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$ClassOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$CompoundTypeTreeOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$ConstfoldOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$ExistentialTypeTreeOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$NewArrayOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$SelectOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$SelfTypeOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$SingletonTypeTreeOf$;
import scala.meta.internal.semanticdb.scalac.ReporterOps;
import scala.meta.internal.semanticdb.scalac.SemanticdbConfig;
import scala.meta.internal.semanticdb.scalac.SemanticdbOps;
import scala.meta.internal.semanticdb.scalac.SymbolInformationOps;
import scala.meta.internal.semanticdb.scalac.SymbolOps;
import scala.meta.internal.semanticdb.scalac.SymbolOps$SemanticdbDecls$;
import scala.meta.internal.semanticdb.scalac.SyntheticOps;
import scala.meta.internal.semanticdb.scalac.TextDocumentOps;
import scala.meta.internal.semanticdb.scalac.TypeOps;
import scala.meta.internal.semanticdb.scalac.TypeOps$ByNameType$;
import scala.meta.internal.semanticdb.scalac.TypeOps$RepeatedType$;
import scala.meta.internal.semanticdb.scalac.VersionSpecificOps;
import scala.meta.internal.semanticdb.scalac.VersionSpecificOps$NamedApplyBlock$;
import scala.meta.internal.semanticdb.scalac.VersionSpecificOps$OriginalTreeOf$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.internal.AnnotationInfos;
import scala.reflect.internal.Names;
import scala.reflect.internal.Scopes;
import scala.reflect.internal.Symbols;
import scala.reflect.internal.Trees;
import scala.reflect.internal.Types;
import scala.reflect.internal.util.Position;
import scala.reflect.internal.util.SourceFile;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.tools.nsc.CompilationUnits;
import scala.tools.nsc.interactive.Global;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\rd\u0001B$I\u00015C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\tS\u0002\u0011\t\u0011)A\u0005C\"A!\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003p\u0011\u00159\b\u0001\"\u0001y\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001bBA\f\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003;\u0001A\u0011AA\u0010\r\u0019\tY\u0006\u0001!\u0002^!Q\u00111\u000e\u0006\u0003\u0016\u0004%\t!!\u001c\t\u0015\u0005\u0005%B!E!\u0002\u0013\ty\u0007\u0003\u0006\u0002\u0004*\u0011)\u001a!C\u0001\u0003\u000bC!\"a&\u000b\u0005#\u0005\u000b\u0011BAD\u0011)\tIJ\u0003BK\u0002\u0013\u0005\u00111\u0014\u0005\u000b\u0003;S!\u0011#Q\u0001\n\u0005]\u0002BCA\u0006\u0015\tU\r\u0011\"\u0001\u0002 \"Q\u0011\u0011\u0015\u0006\u0003\u0012\u0003\u0006I!!\u0004\t\r]TA\u0011AAR\u0011%\t\tLCA\u0001\n\u0003\t\u0019\fC\u0005\u0002>*\t\n\u0011\"\u0001\u0002@\"I\u0011Q\u001b\u0006\u0012\u0002\u0013\u0005\u0011q\u001b\u0005\n\u00037T\u0011\u0013!C\u0001\u0003;D\u0011\"!9\u000b#\u0003%\t!a9\t\u0013\u0005\u001d(\"!A\u0005B\u0005%\b\"CA{\u0015\u0005\u0005I\u0011AA|\u0011%\tIPCA\u0001\n\u0003\tY\u0010C\u0005\u0003\b)\t\t\u0011\"\u0011\u0003\n!I!q\u0003\u0006\u0002\u0002\u0013\u0005!\u0011\u0004\u0005\n\u0005GQ\u0011\u0011!C!\u0005KA\u0011Ba\n\u000b\u0003\u0003%\tE!\u000b\t\u0013\t-\"\"!A\u0005B\t5r!\u0003B\u0019\u0001\u0005\u0005\t\u0012\u0001B\u001a\r%\tY\u0006AA\u0001\u0012\u0003\u0011)\u0004\u0003\u0004xE\u0011\u0005!1\t\u0005\n\u0005O\u0011\u0013\u0011!C#\u0005SA\u0011B!\u0012#\u0003\u0003%\tIa\u0012\t\u0013\tE#%!A\u0005\u0002\nM\u0003\"\u0003B1\u0001\t\u0007I\u0011\u0002B2\u0011!\u0011I\b\u0001Q\u0001\n\t\u0015\u0004bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!a\u0003\u0001\t\u0003\ty\nC\u0005\u0003|\u0001\u0011\r\u0011\"\u0003\u0003~!A!Q\u0011\u0001!\u0002\u0013\u0011y\bC\u0005\u0003\b\u0002\u0011\r\u0011\"\u0003\u0003\n\"A!q\u0013\u0001!\u0002\u0013\u0011Y\tC\u0005\u0003\u001a\u0002\u0011\r\u0011\"\u0003\u0003\u001c\"A!1\u0015\u0001!\u0002\u0013\u0011i\n\u0003\u0005J\u0001\t\u0007I\u0011\u0002B[\u0011!\u0011y\f\u0001Q\u0001\n\t]\u0006b\u0002Ba\u0001\u0011%!1\u0019\u0005\b\u00057\u0004A\u0011\u0002Bo\u0011\u001d\u0011\u0019\u000f\u0001C\u0005\u0005KDqAa=\u0001\t\u0013\u0011)\u0010C\u0004\u0004\b\u0001!Ia!\u0003\t\u000f\rU\u0001\u0001\"\u0003\u0004\u0018\u001d91Q\u0004%\t\u0002\r}aAB$I\u0011\u0003\u0019\t\u0003\u0003\u0004xy\u0011\u000511\u0005\u0005\b\u0007KaD\u0011AB\u0014\u0011\u001d\u0019y\u0003\u0010C\u0005\u0007cAqaa\u0011=\t\u0013\u0019\t\u0004C\u0004\u0004Fq\"Iaa\u0012\t\u000f\r%C\b\"\u0003\u0004H!I11\n\u001f\u0012\u0002\u0013\u00051Q\n\u0005\n\u0007#b\u0014\u0013!C\u0001\u0007'B\u0011ba\u0016=#\u0003%\ta!\u0017\t\u0013\ruC(%A\u0005\u0002\r}#\u0001E'fi\u0006\u0014'o\\<tKN+'O^3s\u0015\tI%*\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0017\u0006QQ.\u001a;bEJ|wo]3\u0004\u0001M\u0011\u0001A\u0014\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0002#\u0006)1oY1mC&\u00111\u000b\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\u001bM\u001c\u0017\r\\1d\u001fB$\u0018n\u001c8t!\r1f,\u0019\b\u0003/rs!\u0001W.\u000e\u0003eS!A\u0017'\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0016BA/Q\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00181\u0003\t1K7\u000f\u001e\u0006\u0003;B\u0003\"A\u00194\u000f\u0005\r$\u0007C\u0001-Q\u0013\t)\u0007+\u0001\u0004Qe\u0016$WMZ\u0005\u0003O\"\u0014aa\u0015;sS:<'BA3Q\u0003\u0011Awn\u001d;\u0002\tA|'\u000f\u001e\t\u0003\u001f2L!!\u001c)\u0003\u0007%sG/\u0001\u0004m_\u001e<WM\u001d\t\u0003aVl\u0011!\u001d\u0006\u0003eN\fQa\u001d7gi)T\u0011\u0001^\u0001\u0004_J<\u0017B\u0001<r\u0005\u0019aunZ4fe\u00061A(\u001b8jiz\"R!_>}{z\u0004\"A\u001f\u0001\u000e\u0003!Cq\u0001V\u0003\u0011\u0002\u0003\u0007Q\u000bC\u0004j\u000bA\u0005\t\u0019A1\t\u000f),\u0001\u0013!a\u0001W\"9a.\u0002I\u0001\u0002\u0004y\u0017!B:uCJ$H\u0003BA\u0002\u0003\u0013\u00012aTA\u0003\u0013\r\t9\u0001\u0015\u0002\u0005+:LG\u000fC\u0004\u0002\f\u0019\u0001\r!!\u0004\u0002\u0015M|WO]2fa\u0006$\b\u000eE\u0002{\u0003\u001fI1!!\u0005I\u0005)\u0019v.\u001e:dKB\fG\u000f[\u0001\u0005gR|\u0007\u000f\u0006\u0002\u0002\u0004\u0005\u0001\"/\u001a9mC\u000e,7\t\\1tgB\fG\u000f\u001b\u000b\u0005\u0003\u0007\tY\u0002C\u0004\u0002\f!\u0001\r!!\u0004\u0002\u0019U\u0014HNR8s'fl'm\u001c7\u0015\t\u0005\u0005\u00121\u0007\u000b\u0005\u0003G\tI\u0003\u0005\u0003P\u0003K\t\u0017bAA\u0014!\n1q\n\u001d;j_:Dq!a\u000b\n\u0001\u0004\ti#\u0001\u0004ts6\u0014w\u000e\u001c\t\u0005\u0003_\tYE\u0004\u0003\u00022\u0005MB\u0002\u0001\u0005\b\u0003kI\u0001\u0019AA\u001c\u0003!\u0019w.\u001c9jY\u0016\u0014\b\u0003BA\u001d\u0003\u000fj!!a\u000f\u000b\t\u0005u\u0012qH\u0001\fS:$XM]1di&4XM\u0003\u0003\u0002B\u0005\r\u0013a\u00018tG*\u0019\u0011Q\t)\u0002\u000bQ|w\u000e\\:\n\t\u0005%\u00131\b\u0002\u0007\u000f2|'-\u00197\n\t\u00055\u0013q\n\u0002\u0007'fl'm\u001c7\n\t\u0005E\u00131\u000b\u0002\b'fl'm\u001c7t\u0015\u0011\t)&a\u0016\u0002\u0011%tG/\u001a:oC2T1!!\u0017Q\u0003\u001d\u0011XM\u001a7fGR\u0014Qa\u0015;bi\u0016\u001cbA\u0003(\u0002`\u0005\u0015\u0004cA(\u0002b%\u0019\u00111\r)\u0003\u000fA\u0013x\u000eZ;diB\u0019q*a\u001a\n\u0007\u0005%\u0004K\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003j]\u0012,\u00070\u0006\u0002\u0002pA!\u0011\u0011OA?\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014!B7uC\u001e\u001c(\u0002BA+\u0003sR1!a\u001fQ\u0003\u0011iW\r^1\n\t\u0005}\u00141\u000f\u0002\u0014\u001f:$U-\\1oINKXNY8m\u0013:$W\r_\u0001\u0007S:$W\r\u001f\u0011\u0002\u0017\rd\u0017m]:M_\u0006$WM]\u000b\u0003\u0003\u000f\u0003B!!#\u0002\u00146\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)A\u0002oKRT!!!%\u0002\t)\fg/Y\u0005\u0005\u0003+\u000bYI\u0001\bV%2\u001bE.Y:t\u0019>\fG-\u001a:\u0002\u0019\rd\u0017m]:M_\u0006$WM\u001d\u0011\u0002\r\u001ddwNY1m+\t\t9$A\u0004hY>\u0014\u0017\r\u001c\u0011\u0016\u0005\u00055\u0011aC:pkJ\u001cW\r]1uQ\u0002\"\"\"!*\u0002*\u0006-\u0016QVAX!\r\t9KC\u0007\u0002\u0001!9\u00111N\nA\u0002\u0005=\u0004bBAB'\u0001\u0007\u0011q\u0011\u0005\b\u00033\u001b\u0002\u0019AA\u001c\u0011\u001d\tYa\u0005a\u0001\u0003\u001b\tAaY8qsRQ\u0011QUA[\u0003o\u000bI,a/\t\u0013\u0005-D\u0003%AA\u0002\u0005=\u0004\"CAB)A\u0005\t\u0019AAD\u0011%\tI\n\u0006I\u0001\u0002\u0004\t9\u0004C\u0005\u0002\fQ\u0001\n\u00111\u0001\u0002\u000e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAaU\u0011\ty'a1,\u0005\u0005\u0015\u0007\u0003BAd\u0003#l!!!3\u000b\t\u0005-\u0017QZ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a4Q\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\fIMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002Z*\"\u0011qQAb\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a8+\t\u0005]\u00121Y\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\t)O\u000b\u0003\u0002\u000e\u0005\r\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002lB!\u0011Q^Az\u001b\t\tyO\u0003\u0003\u0002r\u0006=\u0015\u0001\u00027b]\u001eL1aZAx\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005Y\u0017A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003{\u0014\u0019\u0001E\u0002P\u0003\u007fL1A!\u0001Q\u0005\r\te.\u001f\u0005\t\u0005\u000bY\u0012\u0011!a\u0001W\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0003\u0011\r\t5!1CA\u007f\u001b\t\u0011yAC\u0002\u0003\u0012A\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Ba\u0004\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u00057\u0011\t\u0003E\u0002P\u0005;I1Aa\bQ\u0005\u001d\u0011un\u001c7fC:D\u0011B!\u0002\u001e\u0003\u0003\u0005\r!!@\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a[\u0001\ti>\u001cFO]5oOR\u0011\u00111^\u0001\u0007KF,\u0018\r\\:\u0015\t\tm!q\u0006\u0005\n\u0005\u000b\u0001\u0013\u0011!a\u0001\u0003{\fQa\u0015;bi\u0016\u00042!a*#'\u0015\u0011#qGA3!9\u0011IDa\u0010\u0002p\u0005\u001d\u0015qGA\u0007\u0003Kk!Aa\u000f\u000b\u0007\tu\u0002+A\u0004sk:$\u0018.\\3\n\t\t\u0005#1\b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DC\u0001B\u001a\u0003\u0015\t\u0007\u000f\u001d7z))\t)K!\u0013\u0003L\t5#q\n\u0005\b\u0003W*\u0003\u0019AA8\u0011\u001d\t\u0019)\na\u0001\u0003\u000fCq!!'&\u0001\u0004\t9\u0004C\u0004\u0002\f\u0015\u0002\r!!\u0004\u0002\u000fUt\u0017\r\u001d9msR!!Q\u000bB/!\u0015y\u0015Q\u0005B,!-y%\u0011LA8\u0003\u000f\u000b9$!\u0004\n\u0007\tm\u0003K\u0001\u0004UkBdW\r\u000e\u0005\n\u0005?2\u0013\u0011!a\u0001\u0003K\u000b1\u0001\u001f\u00131\u0003\u0015\u0019H/\u0019;f+\t\u0011)\u0007\u0005\u0004\u0003h\tU\u0014QU\u0007\u0003\u0005SRAAa\u001b\u0003n\u00051\u0011\r^8nS\u000eTAAa\u001c\u0003r\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\tM\u0014qR\u0001\u0005kRLG.\u0003\u0003\u0003x\t%$aD!u_6L7MU3gKJ,gnY3\u0002\rM$\u0018\r^3!\u0003\u0011awnY6\u0016\u0005\t}\u0004\u0003BAw\u0005\u0003KAAa!\u0002p\n1qJ\u00196fGR\fQ\u0001\\8dW\u0002\na!Y:tKR\u001cXC\u0001BF!\u0011\u0011iIa%\u000e\u0005\t=%\u0002\u0002BI\u0003s\n!![8\n\t\tU%q\u0012\u0002\r\u0003\n\u001cx\u000e\\;uKB\u000bG\u000f[\u0001\bCN\u001cX\r^:!\u0003-AG\u000f\u001e9IC:$G.\u001a:\u0016\u0005\tu%C\u0002BP\u0005\u007f\u0012)K\u0002\u0004\u0003\"J\u0002!Q\u0014\u0002\ryI,g-\u001b8f[\u0016tGOP\u0001\rQR$\b\u000fS1oI2,'\u000f\t\t\u0005\u0005O\u0013\t,\u0004\u0002\u0003**\u0019\u0011Ja+\u000b\t\t5&qV\u0001\tk:$WM\u001d;po*\u0011!\u0011S\u0005\u0005\u0005g\u0013IKA\u0006IiR\u0004\b*\u00198eY\u0016\u0014XC\u0001B\\!\u0011\u0011ILa/\u000e\u0005\t-\u0016\u0002\u0002B_\u0005W\u0013\u0001\"\u00168eKJ$xn^\u0001\bg\u0016\u0014h/\u001a:!\u0003!9W\r\u001e\"zi\u0016\u001cH\u0003\u0002Bc\u0005#\u0004Ra\u0014Bd\u0005\u0017L1A!3Q\u0005\u0015\t%O]1z!\ry%QZ\u0005\u0004\u0005\u001f\u0004&\u0001\u0002\"zi\u0016DqAa56\u0001\u0004\u0011).\u0001\u0005fq\u000eD\u0017M\\4f!\u0011\u00119Ka6\n\t\te'\u0011\u0016\u0002\u0013\u0011R$\boU3sm\u0016\u0014X\t_2iC:<W-A\u0006hu&\u0004H)\u001a4mCR,G\u0003\u0002Bc\u0005?DqA!97\u0001\u0004\u0011)-A\u0003csR,7/\u0001\u0007hKR<vN]6ta\u0006\u001cW-\u0006\u0002\u0003hB!!\u0011\u001eBx\u001b\t\u0011YOC\u0002\u0003n*\u000baa]2iK6\f\u0017\u0002\u0002By\u0005W\u0014\u0011bV8sWN\u0004\u0018mY3\u0002\u001b\u001d,GoU3nC:$\u0018n\u00193c)\u0011\u00119pa\u0001\u0011\t\te(q`\u0007\u0003\u0005wTAA!@\u0002x\u0005Q1/Z7b]RL7\r\u001a2\n\t\r\u0005!1 \u0002\u000e)\u0016DH\u000fR8dk6,g\u000e^:\t\r\r\u0015\u0001\b1\u0001b\u0003!1\u0017\u000e\\3oC6,\u0017!C4fiNKXNY8m)\u0011\u0019Ya!\u0005\u0011\t\t%8QB\u0005\u0005\u0007\u001f\u0011YOA\u0007Ts6\u0014w\u000e\\%oI\u0016DXm\u001d\u0005\u0007\u0007'I\u0004\u0019A1\u0002\u0007MLX.A\u0006d_:$XM\u001c;UsB,GcA1\u0004\u001a!111\u0004\u001eA\u0002\u0005\fA\u0001]1uQ\u0006\u0001R*\u001a;bEJ|wo]3TKJ4XM\u001d\t\u0003ur\u001a\"\u0001\u0010(\u0015\u0005\r}\u0011\u0001B7bS:$B!a\u0001\u0004*!911\u0006 A\u0002\r5\u0012!C1se\u0006L\u0018I]4t!\u0011y%qY1\u0002\u001b5\f7M]8QCJ\fG-[:f+\t\u0019\u0019\u0004\u0005\u0003\u00046\r}RBAB\u001c\u0015\u0011\u0019Ida\u000f\u0002\t\u0019LG.\u001a\u0006\u0005\u0007{\ty)A\u0002oS>LAa!\u0011\u00048\t!\u0001+\u0019;i\u00035Y\u0017N\u001c3Qe>TWm\u0019;pe\u0006\u00012oY1mC\u001a+H\u000e\u001c,feNLwN\\\u000b\u0002C\u0006\u00112oY1mC\nKg.\u0019:z-\u0016\u00148/[8o\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u00111q\n\u0016\u0004+\u0006\r\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0004V)\u001a\u0011-a1\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019YFK\u0002l\u0003\u0007\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAB1U\ry\u00171\u0019")
public class MetabrowseServer {
    private volatile MetabrowseServer$State$ State$module;
    private final List<String> scalacOptions;
    public final Logger metabrowse$server$MetabrowseServer$$logger;
    private final AtomicReference<State> state;
    private final Object metabrowse$server$MetabrowseServer$$lock;
    private final AbsolutePath assets;
    private final HttpHandler httpHandler;
    private final Undertow server;

    public static Logger $lessinit$greater$default$4() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$2() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$2();
    }

    public static List<String> $lessinit$greater$default$1() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$1();
    }

    public static void main(String[] stringArray) {
        MetabrowseServer$.MODULE$.main(stringArray);
    }

    public MetabrowseServer$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public void start(Sourcepath sourcepath) {
        this.replaceClasspath(sourcepath);
        this.server().start();
    }

    public void stop() {
        this.server().stop();
        this.global().askShutdown();
    }

    public void replaceClasspath(Sourcepath sourcepath) {
        Object object = this.metabrowse$server$MetabrowseServer$$lock();
        synchronized (object) {
            if (this.state().get() != null) {
                this.global().askShutdown();
            }
            State newState = new State(this, new OnDemandSymbolIndex(OnDemandSymbolIndex$.MODULE$.apply$default$1(), OnDemandSymbolIndex$.MODULE$.apply$default$2(), OnDemandSymbolIndex$.MODULE$.apply$default$3()), new URLClassLoader((URL[])((TraversableOnce)sourcepath.sources().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toUri().toURL(), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(URL.class))), InteractiveSemanticdb$.MODULE$.newCompiler(sourcepath.classpath().mkString(File.pathSeparator), this.scalacOptions), sourcepath);
            this.state().set(newState);
            sourcepath.sources().foreach((Function1 & Serializable & scala.Serializable)jar -> {
                MetabrowseServer.$anonfun$replaceClasspath$2(this, jar);
                return BoxedUnit.UNIT;
            });
        }
    }

    public Option<String> urlForSymbol(Global compiler, Symbols.Symbol symbol) {
        Symbols.Symbol symbol2 = symbol;
        LazyRef semanticdbOps$lzy = new LazyRef();
        ObjectRef compilerSymbol = ObjectRef.create((Object)compiler.rootMirror().RootPackage());
        symbol2.ownerChain().reverse().drop(1).foreach((Function1 & Serializable & scala.Serializable)owner -> {
            MetabrowseServer.$anonfun$urlForSymbol$1(compiler, compilerSymbol, owner);
            return BoxedUnit.UNIT;
        });
        String semanticdbSymbol = MetabrowseServer.semanticdbOps$1(semanticdbOps$lzy, compiler).XtensionGSymbolMSymbol((Symbols.Symbol)compilerSymbol.elem).toSemantic();
        return this.getSymbol(semanticdbSymbol).indexes().headOption().flatMap((Function1 & Serializable & scala.Serializable)symbolIndex -> symbolIndex.definition().map((Function1 & Serializable & scala.Serializable)position -> new StringBuilder(4).append("#").append(position.filename()).append("#L").append(position.startLine()).append("C").append(position.startCharacter()).toString()));
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    public OnDemandSymbolIndex index() {
        return this.state().get().index();
    }

    public URLClassLoader classLoader() {
        return this.state().get().classLoader();
    }

    public Global global() {
        return this.state().get().global();
    }

    public Sourcepath sourcepath() {
        return this.state().get().sourcepath();
    }

    public Object metabrowse$server$MetabrowseServer$$lock() {
        return this.metabrowse$server$MetabrowseServer$$lock;
    }

    private AbsolutePath assets() {
        return this.assets;
    }

    private HttpHandler httpHandler() {
        return this.httpHandler;
    }

    private Undertow server() {
        return this.server;
    }

    public byte[] metabrowse$server$MetabrowseServer$$getBytes(HttpServerExchange exchange) {
        byte[] byArray;
        String path = new StringOps(Predef$.MODULE$.augmentString(exchange.getRequestPath())).stripSuffix(".gz");
        if (path.endsWith("index.workspace")) {
            byArray = this.getWorkspace().toByteArray();
        } else if (path.endsWith(".symbolindexes")) {
            HeaderValues header = exchange.getRequestHeaders().get("Metabrowse-Symbol");
            if (header.isEmpty()) {
                this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(29).append("no Metabrowse-Symbol header: ").append(exchange).toString());
                byArray = Array$.MODULE$.emptyByteArray();
            } else {
                byArray = this.getSymbol(header.getFirst()).toByteArray();
            }
        } else if (path.endsWith(".semanticdb")) {
            byArray = this.getSemanticdb(path).toByteArray();
        } else if (path.endsWith(".map")) {
            byArray = Array$.MODULE$.emptyByteArray();
        } else {
            String string = path;
            String string2 = "/";
            String actualPath = !(string != null ? !string.equals(string2) : string2 != null) ? "/index.html" : path;
            AbsolutePath file = this.assets().resolve(actualPath);
            if (file.isFile()) {
                byArray = file.readAllBytes();
            } else {
                this.metabrowse$server$MetabrowseServer$$logger.warn(new StringBuilder(14).append("no such file: ").append(file).toString());
                byArray = Array$.MODULE$.emptyByteArray();
            }
        }
        return byArray;
    }

    public byte[] metabrowse$server$MetabrowseServer$$gzipDeflate(byte[] bytes) {
        byte[] byArray;
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty()) {
            byArray = bytes;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GZIPOutputStream gos = new GZIPOutputStream((OutputStream)baos, bytes.length);){
                gos.write(bytes);
                gos.finish();
                byArray = baos.toByteArray();
            }
        }
        return byArray;
    }

    private Workspace getWorkspace() {
        Builder filenames = ArrayBuffer$.MODULE$.newBuilder();
        this.sourcepath().sources().foreach((Function1 & Serializable & scala.Serializable)sourcesJar -> {
            FileIO$.MODULE$.withJarFileSystem(AbsolutePath$.MODULE$.apply(sourcesJar, AbsolutePath$.MODULE$.workingDirectory()), false, false, (Function1 & Serializable & scala.Serializable)root -> {
                MetabrowseServer.$anonfun$getWorkspace$2(filenames$1, root);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return new Workspace(((SeqLike)filenames.result()).toSeq());
    }

    private TextDocuments getSemanticdb(String filename) {
        String path = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(filename)).stripPrefix("/semanticdb/"))).stripPrefix("/"))).stripSuffix(".semanticdb");
        this.metabrowse$server$MetabrowseServer$$logger.info(path);
        return (TextDocuments)Option$.MODULE$.apply((Object)this.classLoader().getResourceAsStream(path)).orElse((Function0 & Serializable & scala.Serializable)() -> {
            $this.metabrowse$server$MetabrowseServer$$logger.warn(new StringBuilder(16).append("no source file: ").append(path).toString());
            return None$.MODULE$;
        }).map((Function1 & Serializable & scala.Serializable)in -> {
            String text = new String(InputStreamIO$.MODULE$.readBytes(in), StandardCharsets.UTF_8);
            return new Tuple2(in, (Object)text);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String text = (String)tuple2._2();
            Option option = this.liftedTree1$1(path, text, filename).map((Function1 & Serializable & scala.Serializable)doc -> new TextDocuments((Seq)new .colon.colon((Object)doc.withText(text), (List)Nil$.MODULE$)));
            return option;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new TextDocuments(TextDocuments$.MODULE$.apply$default$1()));
    }

    private SymbolIndexes getSymbol(String sym) {
        Option definition = this.index().definition(Symbol$.MODULE$.apply(sym)).orElse((Function0 & Serializable & scala.Serializable)() -> {
            $this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(28).append("no definition for symbol: '").append(sym).append("'").toString());
            return None$.MODULE$;
        }).map((Function1 & Serializable & scala.Serializable)defn -> {
            Input.VirtualFile input = MtagsEnrichments$.MODULE$.XtensionAbsolutePathMetals(defn.path()).toInput();
            TextDocument doc = Mtags$.MODULE$.index(input);
            return new Tuple3(defn, (Object)input, (Object)doc);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple3 tuple3 = x$4;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            SymbolDefinition defn = (SymbolDefinition)tuple3._1();
            TextDocument doc = (TextDocument)tuple3._3();
            Option option = doc.occurrences().find((Function1 & Serializable & scala.Serializable)occ -> BoxesRunTime.boxToBoolean((boolean)MetabrowseServer.$anonfun$getSymbol$4(defn, occ))).orElse((Function0 & Serializable & scala.Serializable)() -> {
                $this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(26).append("no definition occurrence: ").append(defn).toString());
                return None$.MODULE$;
            }).flatMap((Function1 & Serializable & scala.Serializable)occ -> occ.range().orElse((Function0 & Serializable & scala.Serializable)() -> {
                $this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(10).append("no range: ").append(occ).toString());
                return None$.MODULE$;
            }).map((Function1 & Serializable & scala.Serializable)range -> new metabrowse.schema.Position(defn.path().toString(), range.startLine(), range.startCharacter(), range.endLine(), range.endCharacter())));
            return option;
        });
        return new SymbolIndexes((Seq)new .colon.colon((Object)new SymbolIndex(sym, definition, SymbolIndex$.MODULE$.apply$default$3()), (List)Nil$.MODULE$));
    }

    public String metabrowse$server$MetabrowseServer$$contentType(String path) {
        return path.endsWith(".js") ? "application/javascript" : (path.endsWith(".css") ? "text/css" : (path.endsWith(".html") ? "text/html" : ""));
    }

    private final void State$lzycompute$1() {
        MetabrowseServer metabrowseServer = this;
        synchronized (metabrowseServer) {
            if (this.State$module == null) {
                this.State$module = new MetabrowseServer$State$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$replaceClasspath$2(MetabrowseServer $this, Path jar) {
        $this.index().addSourceJar(AbsolutePath$.MODULE$.apply(jar, AbsolutePath$.MODULE$.workingDirectory()));
    }

    private static final /* synthetic */ SemanticdbOps semanticdbOps$lzycompute$1(LazyRef semanticdbOps$lzy$1, Global compiler$1) {
        SemanticdbOps semanticdbOps;
        LazyRef lazyRef = semanticdbOps$lzy$1;
        synchronized (lazyRef) {
            semanticdbOps = semanticdbOps$lzy$1.initialized() ? (SemanticdbOps)semanticdbOps$lzy$1.value() : (SemanticdbOps)semanticdbOps$lzy$1.initialize((Object)new SemanticdbOps(null, compiler$1){
                private final Global global;
                private SemanticdbConfig config;
                private volatile TypeOps$ByNameType$ ByNameType$module;
                private volatile TypeOps$RepeatedType$ RepeatedType$module;
                private HashMap<Symbols.Symbol, String> symbolCache;
                private volatile SymbolOps$SemanticdbDecls$ SemanticdbDecls$module;
                private HashMap<String, Object> idCache;
                private HashMap<Object, Symbols.Symbol> pointsCache;
                private Global g;
                private boolean isDocCompiler;
                private boolean isReplCompiler;
                private boolean isInteractiveCompiler;
                private boolean isSupportedCompiler;
                private volatile ReflectionToolkit$Attachable$ Attachable$module;
                private volatile ReflectionToolkit$ConstfoldOf$ ConstfoldOf$module;
                private volatile ReflectionToolkit$ClassOf$ ClassOf$module;
                private volatile ReflectionToolkit$NewArrayOf$ NewArrayOf$module;
                private volatile ReflectionToolkit$SingletonTypeTreeOf$ SingletonTypeTreeOf$module;
                private volatile ReflectionToolkit$CompoundTypeTreeOf$ CompoundTypeTreeOf$module;
                private volatile ReflectionToolkit$ExistentialTypeTreeOf$ ExistentialTypeTreeOf$module;
                private volatile ReflectionToolkit$AnnotatedOf$ AnnotatedOf$module;
                private volatile ReflectionToolkit$SelfTypeOf$ SelfTypeOf$module;
                private volatile ReflectionToolkit$SelectOf$ SelectOf$module;
                private final Map<CompilationUnits.CompilationUnit, Object> scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath;
                private String language;
                private Map<SourceFile, Input> gSourceFileInputCache;
                private volatile VersionSpecificOps$OriginalTreeOf$ OriginalTreeOf$module;
                private volatile VersionSpecificOps$NamedApplyBlock$ NamedApplyBlock$module;
                private volatile int bitmap$0;

                public TypeOps.XtensionGTypeSType XtensionGTypeSType(Types.Type gtpe) {
                    return TypeOps.XtensionGTypeSType$((TypeOps)this, (Types.Type)gtpe);
                }

                public TypeOps.XtensionGType XtensionGType(Types.Type gtpe) {
                    return TypeOps.XtensionGType$((TypeOps)this, (Types.Type)gtpe);
                }

                public SyntheticOps.XtensionGTreeSTree XtensionGTreeSTree(Trees.Tree gTree) {
                    return SyntheticOps.XtensionGTreeSTree$((SyntheticOps)this, (Trees.Tree)gTree);
                }

                public SymbolOps.XtensionGSymbolMSymbol XtensionGSymbolMSymbol(Symbols.Symbol sym) {
                    return SymbolOps.XtensionGSymbolMSymbol$((SymbolOps)this, (Symbols.Symbol)sym);
                }

                public SymbolOps.XtensionGSymbolMSpec XtensionGSymbolMSpec(Symbols.Symbol sym) {
                    return SymbolOps.XtensionGSymbolMSpec$((SymbolOps)this, (Symbols.Symbol)sym);
                }

                public SymbolOps.XtensionGScopeMSpec XtensionGScopeMSpec(Scopes.Scope scope) {
                    return SymbolOps.XtensionGScopeMSpec$((SymbolOps)this, (Scopes.Scope)scope);
                }

                public SymbolOps.XtensionGSymbolsMSpec XtensionGSymbolsMSpec(List<Symbols.Symbol> syms) {
                    return SymbolOps.XtensionGSymbolsMSpec$((SymbolOps)this, syms);
                }

                public SymbolOps.XtensionGSymbol XtensionGSymbol(Symbols.Symbol sym) {
                    return SymbolOps.XtensionGSymbol$((SymbolOps)this, (Symbols.Symbol)sym);
                }

                public <T> ReflectionToolkit.XtensionAttachable<T> XtensionAttachable(T carrier, ReflectionToolkit.Attachable<T> evidence$4) {
                    return ReflectionToolkit.XtensionAttachable$((ReflectionToolkit)this, carrier, evidence$4);
                }

                public <T> ReflectionToolkit.XtensionMetadataAttachable<T> XtensionMetadataAttachable(T carrier, ReflectionToolkit.Attachable<T> evidence$6) {
                    return ReflectionToolkit.XtensionMetadataAttachable$((ReflectionToolkit)this, carrier, evidence$6);
                }

                public ReflectionToolkit.XtensionCompilationUnitCache XtensionCompilationUnitCache(CompilationUnits.CompilationUnit unit) {
                    return ReflectionToolkit.XtensionCompilationUnitCache$((ReflectionToolkit)this, (CompilationUnits.CompilationUnit)unit);
                }

                public <T> ReflectionToolkit.XtensionDesugarings<T> XtensionDesugarings(T carrier, ReflectionToolkit.Attachable<T> evidence$10) {
                    return ReflectionToolkit.XtensionDesugarings$((ReflectionToolkit)this, carrier, evidence$10);
                }

                public ReporterOps.XtensionCompilationUnitReporter XtensionCompilationUnitReporter(CompilationUnits.CompilationUnit unit) {
                    return ReporterOps.XtensionCompilationUnitReporter$((ReporterOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public ParseOps.XtensionCompilationUnitSource XtensionCompilationUnitSource(CompilationUnits.CompilationUnit unit) {
                    return ParseOps.XtensionCompilationUnitSource$((ParseOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public DiagnosticOps.XtensionCompilationUnitDiagnostics XtensionCompilationUnitDiagnostics(CompilationUnits.CompilationUnit unit) {
                    return DiagnosticOps.XtensionCompilationUnitDiagnostics$((DiagnosticOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public InputOps.XtensionGSourceFileInput XtensionGSourceFileInput(SourceFile gsource) {
                    return InputOps.XtensionGSourceFileInput$((InputOps)this, (SourceFile)gsource);
                }

                public InputOps.XtensionGPositionMPosition XtensionGPositionMPosition(Position pos) {
                    return InputOps.XtensionGPositionMPosition$((InputOps)this, (Position)pos);
                }

                public void validateCompilerState() {
                    TextDocumentOps.validateCompilerState$((TextDocumentOps)this);
                }

                public TextDocumentOps.XtensionCompilationUnitDocument XtensionCompilationUnitDocument(CompilationUnits.CompilationUnit unit) {
                    return TextDocumentOps.XtensionCompilationUnitDocument$((TextDocumentOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public SymbolInformationOps.XtensionGSymbolMSymbolInformation XtensionGSymbolMSymbolInformation(Symbols.Symbol gsym0) {
                    return SymbolInformationOps.XtensionGSymbolMSymbolInformation$((SymbolInformationOps)this, (Symbols.Symbol)gsym0);
                }

                public AnnotationOps.XtensionAnnotationInfo XtensionAnnotationInfo(AnnotationInfos.AnnotationInfo gann) {
                    return AnnotationOps.XtensionAnnotationInfo$((AnnotationOps)this, (AnnotationInfos.AnnotationInfo)gann);
                }

                public SemanticdbConfig config() {
                    return this.config;
                }

                public void config_$eq(SemanticdbConfig x$1) {
                    this.config = x$1;
                }

                public TypeOps$ByNameType$ ByNameType() {
                    if (this.ByNameType$module == null) {
                        this.ByNameType$lzycompute$1();
                    }
                    return this.ByNameType$module;
                }

                public TypeOps$RepeatedType$ RepeatedType() {
                    if (this.RepeatedType$module == null) {
                        this.RepeatedType$lzycompute$1();
                    }
                    return this.RepeatedType$module;
                }

                private HashMap<Symbols.Symbol, String> symbolCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 1) == 0) {
                            this.symbolCache = SymbolOps.symbolCache$((SymbolOps)this);
                            this.bitmap$0 |= 1;
                        }
                    }
                    return this.symbolCache;
                }

                public HashMap<Symbols.Symbol, String> symbolCache() {
                    return (this.bitmap$0 & 1) == 0 ? this.symbolCache$lzycompute() : this.symbolCache;
                }

                public SymbolOps$SemanticdbDecls$ SemanticdbDecls() {
                    if (this.SemanticdbDecls$module == null) {
                        this.SemanticdbDecls$lzycompute$1();
                    }
                    return this.SemanticdbDecls$module;
                }

                private HashMap<String, Object> idCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 2) == 0) {
                            this.idCache = SymbolOps.idCache$((SymbolOps)this);
                            this.bitmap$0 |= 2;
                        }
                    }
                    return this.idCache;
                }

                public HashMap<String, Object> idCache() {
                    return (this.bitmap$0 & 2) == 0 ? this.idCache$lzycompute() : this.idCache;
                }

                private HashMap<Object, Symbols.Symbol> pointsCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 4) == 0) {
                            this.pointsCache = SymbolOps.pointsCache$((SymbolOps)this);
                            this.bitmap$0 |= 4;
                        }
                    }
                    return this.pointsCache;
                }

                public HashMap<Object, Symbols.Symbol> pointsCache() {
                    return (this.bitmap$0 & 4) == 0 ? this.pointsCache$lzycompute() : this.pointsCache;
                }

                private Global g$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 8) == 0) {
                            this.g = (Global)ReflectionToolkit.g$((ReflectionToolkit)this);
                            this.bitmap$0 |= 8;
                        }
                    }
                    return this.g;
                }

                public Global g() {
                    return (this.bitmap$0 & 8) == 0 ? this.g$lzycompute() : this.g;
                }

                private boolean isDocCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x10) == 0) {
                            this.isDocCompiler = ReflectionToolkit.isDocCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x10;
                        }
                    }
                    return this.isDocCompiler;
                }

                public boolean isDocCompiler() {
                    return (this.bitmap$0 & 0x10) == 0 ? this.isDocCompiler$lzycompute() : this.isDocCompiler;
                }

                private boolean isReplCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x20) == 0) {
                            this.isReplCompiler = ReflectionToolkit.isReplCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x20;
                        }
                    }
                    return this.isReplCompiler;
                }

                public boolean isReplCompiler() {
                    return (this.bitmap$0 & 0x20) == 0 ? this.isReplCompiler$lzycompute() : this.isReplCompiler;
                }

                private boolean isInteractiveCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x40) == 0) {
                            this.isInteractiveCompiler = ReflectionToolkit.isInteractiveCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x40;
                        }
                    }
                    return this.isInteractiveCompiler;
                }

                public boolean isInteractiveCompiler() {
                    return (this.bitmap$0 & 0x40) == 0 ? this.isInteractiveCompiler$lzycompute() : this.isInteractiveCompiler;
                }

                private boolean isSupportedCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x80) == 0) {
                            this.isSupportedCompiler = ReflectionToolkit.isSupportedCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x80;
                        }
                    }
                    return this.isSupportedCompiler;
                }

                public boolean isSupportedCompiler() {
                    return (this.bitmap$0 & 0x80) == 0 ? this.isSupportedCompiler$lzycompute() : this.isSupportedCompiler;
                }

                public ReflectionToolkit$Attachable$ Attachable() {
                    if (this.Attachable$module == null) {
                        this.Attachable$lzycompute$1();
                    }
                    return this.Attachable$module;
                }

                public ReflectionToolkit$ConstfoldOf$ ConstfoldOf() {
                    if (this.ConstfoldOf$module == null) {
                        this.ConstfoldOf$lzycompute$1();
                    }
                    return this.ConstfoldOf$module;
                }

                public ReflectionToolkit$ClassOf$ ClassOf() {
                    if (this.ClassOf$module == null) {
                        this.ClassOf$lzycompute$1();
                    }
                    return this.ClassOf$module;
                }

                public ReflectionToolkit$NewArrayOf$ NewArrayOf() {
                    if (this.NewArrayOf$module == null) {
                        this.NewArrayOf$lzycompute$1();
                    }
                    return this.NewArrayOf$module;
                }

                public ReflectionToolkit$SingletonTypeTreeOf$ SingletonTypeTreeOf() {
                    if (this.SingletonTypeTreeOf$module == null) {
                        this.SingletonTypeTreeOf$lzycompute$1();
                    }
                    return this.SingletonTypeTreeOf$module;
                }

                public ReflectionToolkit$CompoundTypeTreeOf$ CompoundTypeTreeOf() {
                    if (this.CompoundTypeTreeOf$module == null) {
                        this.CompoundTypeTreeOf$lzycompute$1();
                    }
                    return this.CompoundTypeTreeOf$module;
                }

                public ReflectionToolkit$ExistentialTypeTreeOf$ ExistentialTypeTreeOf() {
                    if (this.ExistentialTypeTreeOf$module == null) {
                        this.ExistentialTypeTreeOf$lzycompute$1();
                    }
                    return this.ExistentialTypeTreeOf$module;
                }

                public ReflectionToolkit$AnnotatedOf$ AnnotatedOf() {
                    if (this.AnnotatedOf$module == null) {
                        this.AnnotatedOf$lzycompute$1();
                    }
                    return this.AnnotatedOf$module;
                }

                public ReflectionToolkit$SelfTypeOf$ SelfTypeOf() {
                    if (this.SelfTypeOf$module == null) {
                        this.SelfTypeOf$lzycompute$1();
                    }
                    return this.SelfTypeOf$module;
                }

                public ReflectionToolkit$SelectOf$ SelectOf() {
                    if (this.SelectOf$module == null) {
                        this.SelectOf$lzycompute$1();
                    }
                    return this.SelectOf$module;
                }

                public Map<CompilationUnits.CompilationUnit, Object> scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath() {
                    return this.scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath;
                }

                public final void scala$meta$internal$semanticdb$scalac$ReporterOps$_setter_$scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath_$eq(Map<CompilationUnits.CompilationUnit, Object> x$1) {
                    this.scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath = x$1;
                }

                private String language$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x100) == 0) {
                            this.language = LanguageOps.language$((LanguageOps)this);
                            this.bitmap$0 |= 0x100;
                        }
                    }
                    return this.language;
                }

                public String language() {
                    return (this.bitmap$0 & 0x100) == 0 ? this.language$lzycompute() : this.language;
                }

                private Map<SourceFile, Input> gSourceFileInputCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x200) == 0) {
                            this.gSourceFileInputCache = InputOps.gSourceFileInputCache$((InputOps)this);
                            this.bitmap$0 |= 0x200;
                        }
                    }
                    return this.gSourceFileInputCache;
                }

                public Map<SourceFile, Input> gSourceFileInputCache() {
                    return (this.bitmap$0 & 0x200) == 0 ? this.gSourceFileInputCache$lzycompute() : this.gSourceFileInputCache;
                }

                public VersionSpecificOps$OriginalTreeOf$ OriginalTreeOf() {
                    if (this.OriginalTreeOf$module == null) {
                        this.OriginalTreeOf$lzycompute$1();
                    }
                    return this.OriginalTreeOf$module;
                }

                public VersionSpecificOps$NamedApplyBlock$ NamedApplyBlock() {
                    if (this.NamedApplyBlock$module == null) {
                        this.NamedApplyBlock$lzycompute$1();
                    }
                    return this.NamedApplyBlock$module;
                }

                public Global global() {
                    return this.global;
                }

                private final void ByNameType$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ByNameType$module == null) {
                            this.ByNameType$module = new TypeOps$ByNameType$((SemanticdbOps)this);
                        }
                    }
                }

                private final void RepeatedType$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.RepeatedType$module == null) {
                            this.RepeatedType$module = new TypeOps$RepeatedType$((SemanticdbOps)this);
                        }
                    }
                }

                private final void SemanticdbDecls$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SemanticdbDecls$module == null) {
                            this.SemanticdbDecls$module = new SymbolOps$SemanticdbDecls$((SemanticdbOps)this);
                        }
                    }
                }

                private final void Attachable$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.Attachable$module == null) {
                            this.Attachable$module = new ReflectionToolkit$Attachable$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void ConstfoldOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ConstfoldOf$module == null) {
                            this.ConstfoldOf$module = new ReflectionToolkit$ConstfoldOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void ClassOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ClassOf$module == null) {
                            this.ClassOf$module = new ReflectionToolkit$ClassOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void NewArrayOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.NewArrayOf$module == null) {
                            this.NewArrayOf$module = new ReflectionToolkit$NewArrayOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void SingletonTypeTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SingletonTypeTreeOf$module == null) {
                            this.SingletonTypeTreeOf$module = new ReflectionToolkit$SingletonTypeTreeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void CompoundTypeTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.CompoundTypeTreeOf$module == null) {
                            this.CompoundTypeTreeOf$module = new ReflectionToolkit$CompoundTypeTreeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void ExistentialTypeTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ExistentialTypeTreeOf$module == null) {
                            this.ExistentialTypeTreeOf$module = new ReflectionToolkit$ExistentialTypeTreeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void AnnotatedOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.AnnotatedOf$module == null) {
                            this.AnnotatedOf$module = new ReflectionToolkit$AnnotatedOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void SelfTypeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SelfTypeOf$module == null) {
                            this.SelfTypeOf$module = new ReflectionToolkit$SelfTypeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void SelectOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SelectOf$module == null) {
                            this.SelectOf$module = new ReflectionToolkit$SelectOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void OriginalTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.OriginalTreeOf$module == null) {
                            this.OriginalTreeOf$module = new VersionSpecificOps$OriginalTreeOf$((SemanticdbOps)this);
                        }
                    }
                }

                private final void NamedApplyBlock$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.NamedApplyBlock$module == null) {
                            this.NamedApplyBlock$module = new VersionSpecificOps$NamedApplyBlock$((SemanticdbOps)this);
                        }
                    }
                }
                {
                    AnnotationOps.$init$((AnnotationOps)this);
                    VersionSpecificOps.$init$((VersionSpecificOps)this);
                    SymbolInformationOps.$init$((SymbolInformationOps)this);
                    TextDocumentOps.$init$((TextDocumentOps)this);
                    InputOps.$init$((InputOps)this);
                    LanguageOps.$init$((LanguageOps)this);
                    DiagnosticOps.$init$((DiagnosticOps)this);
                    ParseOps.$init$((ParseOps)this);
                    ReporterOps.$init$((ReporterOps)this);
                    ReflectionToolkit.$init$((ReflectionToolkit)this);
                    SymbolOps.$init$((SymbolOps)this);
                    SyntheticOps.$init$((SyntheticOps)this);
                    TypeOps.$init$((TypeOps)this);
                    SemanticdbOps.$init$((SemanticdbOps)this);
                    this.global = compiler$1;
                }
            });
        }
        return semanticdbOps;
    }

    private static final SemanticdbOps semanticdbOps$1(LazyRef semanticdbOps$lzy$1, Global compiler$1) {
        return semanticdbOps$lzy$1.initialized() ? (SemanticdbOps)semanticdbOps$lzy$1.value() : MetabrowseServer.semanticdbOps$lzycompute$1(semanticdbOps$lzy$1, compiler$1);
    }

    public static final /* synthetic */ void $anonfun$urlForSymbol$1(Global compiler$1, ObjectRef compilerSymbol$1, Symbols.Symbol owner) {
        Names.TermName name = owner.name().isTermName() || owner.hasPackageFlag() ? compiler$1.TermName().apply(owner.nameString()) : compiler$1.TypeName().apply(owner.nameString());
        compilerSymbol$1.elem = ((Symbols.Symbol)compilerSymbol$1.elem).info().member((Names.Name)name);
    }

    public static final /* synthetic */ boolean $anonfun$getWorkspace$3(AbsolutePath x$2) {
        return !MtagsEnrichments$.MODULE$.XtensionAbsolutePathMetals(x$2).toLanguage().isUnknownLanguage();
    }

    public static final /* synthetic */ void $anonfun$getWorkspace$2(Builder filenames$1, AbsolutePath root) {
        ((IterableLike)FileIO$.MODULE$.listAllFilesRecursively(root).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetabrowseServer.$anonfun$getWorkspace$3(x$2)))).foreach((Function1 & Serializable & scala.Serializable)path -> filenames$1.$plus$eq((Object)new StringOps(Predef$.MODULE$.augmentString(((Object)path.toNIO()).toString())).stripPrefix("/")));
    }

    private final Option liftedTree1$1(String path$1, String text$1, String filename$1) {
        Some some;
        try {
            TextDocument textDocument;
            long timeout = TimeUnit.SECONDS.toMillis(10L);
            if (path$1.endsWith(".java")) {
                Input.VirtualFile input = new Input.VirtualFile(path$1, text$1);
                textDocument = Mtags$.MODULE$.index(input);
            } else {
                textDocument = InteractiveSemanticdb$.MODULE$.toTextDocument(this.global(), text$1, filename$1, timeout, (List)new .colon.colon((Object)"-P:semanticdb:synthetics:on", (List)new .colon.colon((Object)"-P:semanticdb:symbols:none", (List)Nil$.MODULE$)));
            }
            TextDocument textDocument2 = textDocument;
            some = new Some((Object)textDocument2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(15).append("compile error: ").append(filename$1).toString(), e);
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getSymbol$4(SymbolDefinition defn$1, SymbolOccurrence occ) {
        if (!occ.role().isDefinition()) return false;
        if (!occ.range().isDefined()) return false;
        String string = occ.symbol();
        String string2 = defn$1.definitionSymbol().value();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public MetabrowseServer(List<String> scalacOptions, String host, int port, Logger logger) {
        this.scalacOptions = scalacOptions;
        this.metabrowse$server$MetabrowseServer$$logger = logger;
        this.state = new AtomicReference();
        this.metabrowse$server$MetabrowseServer$$lock = new Object();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("metabrowse-assets.zip");
        Path out = Files.createTempDirectory("metabrowse", new FileAttribute[0]).resolve("assets.zip");
        Files.copy(in, out, new CopyOption[0]);
        this.assets = FileIO$.MODULE$.jarRootPath(AbsolutePath$.MODULE$.apply(out, AbsolutePath$.MODULE$.workingDirectory()));
        this.httpHandler = new HttpHandler(this){
            private final /* synthetic */ MetabrowseServer $outer;

            public void handleRequest(HttpServerExchange exchange) {
                byte[] byArray;
                try {
                    Object object = this.$outer.metabrowse$server$MetabrowseServer$$lock();
                    synchronized (object) {
                        byte[] byArray2 = this.$outer.metabrowse$server$MetabrowseServer$$getBytes(exchange);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var4_2
                        byArray = byArray2;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.$outer.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(18).append("unexpected error: ").append(exchange).toString(), e);
                    byte[] byArray3 = Array$.MODULE$.emptyByteArray();
                    byArray = byArray3;
                }
                byte[] bytes = byArray;
                byte[] compressed = this.$outer.metabrowse$server$MetabrowseServer$$gzipDeflate(bytes);
                ByteBuffer buffer = ByteBuffer.wrap(compressed);
                exchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, "gzip");
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.$outer.metabrowse$server$MetabrowseServer$$contentType(exchange.getRequestPath()));
                exchange.getResponseSender().send(buffer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.server = Undertow.builder().addHttpListener(port, host).setHandler(this.httpHandler()).build();
    }

    public class State
    implements Product,
    scala.Serializable {
        private final OnDemandSymbolIndex index;
        private final URLClassLoader classLoader;
        private final Global global;
        private final Sourcepath sourcepath;
        public final /* synthetic */ MetabrowseServer $outer;

        public OnDemandSymbolIndex index() {
            return this.index;
        }

        public URLClassLoader classLoader() {
            return this.classLoader;
        }

        public Global global() {
            return this.global;
        }

        public Sourcepath sourcepath() {
            return this.sourcepath;
        }

        public State copy(OnDemandSymbolIndex index, URLClassLoader classLoader, Global global, Sourcepath sourcepath) {
            return new State(this.metabrowse$server$MetabrowseServer$State$$$outer(), index, classLoader, global, sourcepath);
        }

        public OnDemandSymbolIndex copy$default$1() {
            return this.index();
        }

        public URLClassLoader copy$default$2() {
            return this.classLoader();
        }

        public Global copy$default$3() {
            return this.global();
        }

        public Sourcepath copy$default$4() {
            return this.sourcepath();
        }

        public String productPrefix() {
            return "State";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.index();
                    break;
                }
                case 1: {
                    object = this.classLoader();
                    break;
                }
                case 2: {
                    object = this.global();
                    break;
                }
                case 3: {
                    object = this.sourcepath();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            if (((State)object).metabrowse$server$MetabrowseServer$State$$$outer() != this.metabrowse$server$MetabrowseServer$State$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            OnDemandSymbolIndex onDemandSymbolIndex = this.index();
            OnDemandSymbolIndex onDemandSymbolIndex2 = state.index();
            if (onDemandSymbolIndex == null) {
                if (onDemandSymbolIndex2 != null) {
                    return false;
                }
            } else if (!onDemandSymbolIndex.equals(onDemandSymbolIndex2)) return false;
            URLClassLoader uRLClassLoader = this.classLoader();
            URLClassLoader uRLClassLoader2 = state.classLoader();
            if (uRLClassLoader == null) {
                if (uRLClassLoader2 != null) {
                    return false;
                }
            } else if (!uRLClassLoader.equals(uRLClassLoader2)) return false;
            Global global = this.global();
            Global global2 = state.global();
            if (global == null) {
                if (global2 != null) {
                    return false;
                }
            } else if (!global.equals(global2)) return false;
            Sourcepath sourcepath = this.sourcepath();
            Sourcepath sourcepath2 = state.sourcepath();
            if (sourcepath == null) {
                if (sourcepath2 != null) {
                    return false;
                }
            } else if (!((Object)sourcepath).equals(sourcepath2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MetabrowseServer metabrowse$server$MetabrowseServer$State$$$outer() {
            return this.$outer;
        }

        public State(MetabrowseServer $outer, OnDemandSymbolIndex index, URLClassLoader classLoader, Global global, Sourcepath sourcepath) {
            this.index = index;
            this.classLoader = classLoader;
            this.global = global;
            this.sourcepath = sourcepath;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

