/*
 * Decompiled with CFR 0.152.
 */
package metabrowse.server;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import metabrowse.schema.Position$;
import metabrowse.schema.SymbolIndex;
import metabrowse.schema.SymbolIndex$;
import metabrowse.schema.SymbolIndexes;
import metabrowse.schema.SymbolIndexes$;
import metabrowse.schema.Workspace;
import metabrowse.schema.Workspace$;
import metabrowse.server.MetabrowseServer$;
import metabrowse.server.MetabrowseServer$State$;
import metabrowse.server.Sourcepath;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.meta.Dialect;
import scala.meta.inputs.Input;
import scala.meta.interactive.InteractiveSemanticdb$;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.InputStreamIO$;
import scala.meta.internal.metals.EmptyReportContext$;
import scala.meta.internal.metals.ReportContext;
import scala.meta.internal.mtags.JavaMtags$;
import scala.meta.internal.mtags.MtagsEnrichments$;
import scala.meta.internal.mtags.OnDemandSymbolIndex;
import scala.meta.internal.mtags.OnDemandSymbolIndex$;
import scala.meta.internal.mtags.ScalaMtags$;
import scala.meta.internal.mtags.Symbol$;
import scala.meta.internal.mtags.SymbolDefinition;
import scala.meta.internal.semanticdb.SymbolOccurrence;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.internal.semanticdb.TextDocuments;
import scala.meta.internal.semanticdb.TextDocuments$;
import scala.meta.internal.semanticdb.scalac.AnnotationOps;
import scala.meta.internal.semanticdb.scalac.DiagnosticOps;
import scala.meta.internal.semanticdb.scalac.InputOps;
import scala.meta.internal.semanticdb.scalac.LanguageOps;
import scala.meta.internal.semanticdb.scalac.ParseOps;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$AnnotatedOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$Attachable$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$ClassOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$CompoundTypeTreeOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$ConstfoldOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$ExistentialTypeTreeOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$NewArrayOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$SelectOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$SelfTypeOf$;
import scala.meta.internal.semanticdb.scalac.ReflectionToolkit$SingletonTypeTreeOf$;
import scala.meta.internal.semanticdb.scalac.ReporterOps;
import scala.meta.internal.semanticdb.scalac.SemanticdbConfig;
import scala.meta.internal.semanticdb.scalac.SemanticdbOps;
import scala.meta.internal.semanticdb.scalac.SymbolInformationOps;
import scala.meta.internal.semanticdb.scalac.SymbolOps;
import scala.meta.internal.semanticdb.scalac.SymbolOps$SemanticdbDecls$;
import scala.meta.internal.semanticdb.scalac.SymbolOpsCompat;
import scala.meta.internal.semanticdb.scalac.SyntheticOps;
import scala.meta.internal.semanticdb.scalac.TextDocumentOps;
import scala.meta.internal.semanticdb.scalac.TypeOps;
import scala.meta.internal.semanticdb.scalac.TypeOps$ByNameType$;
import scala.meta.internal.semanticdb.scalac.TypeOps$RepeatedType$;
import scala.meta.internal.semanticdb.scalac.VersionSpecificOps;
import scala.meta.internal.semanticdb.scalac.VersionSpecificOps$NamedApplyBlock$;
import scala.meta.internal.semanticdb.scalac.VersionSpecificOps$OriginalTreeOf$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.internal.AnnotationInfos;
import scala.reflect.internal.Names;
import scala.reflect.internal.Scopes;
import scala.reflect.internal.Symbols;
import scala.reflect.internal.Trees;
import scala.reflect.internal.Types;
import scala.reflect.internal.util.Position;
import scala.reflect.internal.util.SourceFile;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.tools.nsc.CompilationUnits;
import scala.tools.nsc.interactive.Global;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r%h\u0001\u0002(P\u0001QC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005G\"Aq\u000f\u0001B\u0001B\u0003%q\u000e\u0003\u0005y\u0001\t\u0005\t\u0015!\u0003z\u0011!a\bA!A!\u0002\u0013i\bbBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002<\u0001!\t!!\u0010\u0007\r\u0005e\u0004\u0001QA>\u0011)\t)k\u0003BK\u0002\u0013\u0005\u0011q\u0015\u0005\u000b\u0003o[!\u0011#Q\u0001\n\u0005%\u0006BCA]\u0017\tU\r\u0011\"\u0001\u0002<\"Q\u00111[\u0006\u0003\u0012\u0003\u0006I!!0\t\u0015\u0005U7B!f\u0001\n\u0003\t9\u000e\u0003\u0006\u0002Z.\u0011\t\u0012)A\u0005\u0003+B!\"!\u000b\f\u0005+\u0007I\u0011AAn\u0011)\tin\u0003B\tB\u0003%\u00111\u0006\u0005\b\u0003\u0017YA\u0011AAp\u0011)\tio\u0003EC\u0002\u0013%\u0011q\u001e\u0005\u000b\u0003o\\\u0001R1A\u0005\n\u0005e\b\"\u0003B\u0004\u0017\t\u0007I\u0011\u0002B\u0005\u0011!\u00119c\u0003Q\u0001\n\t-\u0001b\u0002B\u0015\u0017\u0011%!1\u0006\u0005\b\u0005cYA\u0011\u0001B\u001a\u0011\u001d\u0011Id\u0003C\u0001\u0003gA\u0011Ba\u000f\f\u0003\u0003%\tA!\u0010\t\u0013\t\u001d3\"%A\u0005\u0002\t%\u0003\"\u0003B0\u0017E\u0005I\u0011\u0001B1\u0011%\u0011)gCI\u0001\n\u0003\u00119\u0007C\u0005\u0003l-\t\n\u0011\"\u0001\u0003n!I!\u0011O\u0006\u0002\u0002\u0013\u0005#1\u000f\u0005\n\u0005sZ\u0011\u0011!C\u0001\u0005wB\u0011B! \f\u0003\u0003%\tAa \t\u0013\t-5\"!A\u0005B\t5\u0005\"\u0003BN\u0017\u0005\u0005I\u0011\u0001BO\u0011%\u0011\tkCA\u0001\n\u0003\u0012\u0019\u000bC\u0005\u0003(.\t\t\u0011\"\u0011\u0003*\"I!1V\u0006\u0002\u0002\u0013\u0005#Q\u0016\u0005\n\u0005_[\u0011\u0011!C!\u0005c;\u0011B!.\u0001\u0003\u0003E\tAa.\u0007\u0013\u0005e\u0004!!A\t\u0002\te\u0006bBA\u0006W\u0011\u0005!1\u001a\u0005\n\u0005W[\u0013\u0011!C#\u0005[C\u0011B!4,\u0003\u0003%\tIa4\t\u0013\te7&!A\u0005\u0002\nm\u0007\"\u0003Bu\u0001\t\u0007I\u0011\u0002Bv\u0011!\u0011I\u0010\u0001Q\u0001\n\t5\bbBAS\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003+\u0004A\u0011AAl\u0011\u001d\tI\u0003\u0001C\u0001\u00037DqAa?\u0001\t\u0013\u0011i\u0010C\u0005\u0004,\u0001\u0011\r\u0011\"\u0003\u0004.!A1q\u0006\u0001!\u0002\u0013\ti\bC\u0005\u00042\u0001\u0011\r\u0011\"\u0003\u00044!A11\b\u0001!\u0002\u0013\u0019)\u0004\u0003\u0005Q\u0001\t\u0007I\u0011BB'\u0011!\u00199\u0006\u0001Q\u0001\n\r=\u0003bBB-\u0001\u0011%11\f\u0005\b\u0007g\u0002A\u0011BB;\u0011\u001d\u0019Y\b\u0001C\u0005\u0007{Bqaa#\u0001\t\u0013\u0019i\tC\u0004\u0004 \u0002!Ia!)\t\u000f\r5\u0006\u0001\"\u0003\u00040\u001e911W(\t\u0002\rUfA\u0002(P\u0011\u0003\u00199\fC\u0004\u0002\f\r#\ta!/\t\u000f\rm6\t\"\u0001\u0004>\"91QY\"\u0005\n\r\u001d\u0007bBBe\u0007\u0012%1q\u0019\u0005\b\u0007\u0017\u001cE\u0011BBg\u0011\u001d\u0019ym\u0011C\u0005\u0007\u001bD\u0011b!5D#\u0003%\taa5\t\u0013\r]7)%A\u0005\u0002\re\u0007\"CBo\u0007F\u0005I\u0011ABp\u0011%\u0019\u0019oQI\u0001\n\u0003\u0019)O\u0001\tNKR\f'M]8xg\u0016\u001cVM\u001d<fe*\u0011\u0001+U\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003I\u000b!\"\\3uC\n\u0014xn^:f\u0007\u0001\u0019\"\u0001A+\u0011\u0005YKV\"A,\u000b\u0003a\u000bQa]2bY\u0006L!AW,\u0003\r\u0005s\u0017PU3g\u0003\u001d!\u0017.\u00197fGR\u0004\"!\u00181\u000e\u0003yS!aX,\u0002\t5,G/Y\u0005\u0003Cz\u0013q\u0001R5bY\u0016\u001cG/A\u0007tG\u0006d\u0017mY(qi&|gn\u001d\t\u0004I2|gBA3k\u001d\t1\u0017.D\u0001h\u0015\tA7+\u0001\u0004=e>|GOP\u0005\u00021&\u00111nV\u0001\ba\u0006\u001c7.Y4f\u0013\tigN\u0001\u0003MSN$(BA6X!\t\u0001HO\u0004\u0002reB\u0011amV\u0005\u0003g^\u000ba\u0001\u0015:fI\u00164\u0017BA;w\u0005\u0019\u0019FO]5oO*\u00111oV\u0001\u0005Q>\u001cH/\u0001\u0003q_J$\bC\u0001,{\u0013\tYxKA\u0002J]R\fa\u0001\\8hO\u0016\u0014\bc\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011!B:mMRR'BAA\u0003\u0003\ry'oZ\u0005\u0004\u0003\u0013y(A\u0002'pO\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\r\u0003\u001f\t\u0019\"!\u0006\u0002\u0018\u0005e\u00111\u0004\t\u0004\u0003#\u0001Q\"A(\t\u000bm3\u0001\u0019\u0001/\t\u000f\t4\u0001\u0013!a\u0001G\"9qO\u0002I\u0001\u0002\u0004y\u0007b\u0002=\u0007!\u0003\u0005\r!\u001f\u0005\by\u001a\u0001\n\u00111\u0001~\u0003\u0015\u0019H/\u0019:u)\u0011\t\t#a\n\u0011\u0007Y\u000b\u0019#C\u0002\u0002&]\u0013A!\u00168ji\"9\u0011\u0011F\u0004A\u0002\u0005-\u0012AC:pkJ\u001cW\r]1uQB!\u0011\u0011CA\u0017\u0013\r\tyc\u0014\u0002\u000b'>,(oY3qCRD\u0017\u0001B:u_B$\"!!\t\u0002!I,\u0007\u000f\\1dK\u000ec\u0017m]:qCRDG\u0003BA\u0011\u0003sAq!!\u000b\n\u0001\u0004\tY#\u0001\u0007ve24uN]*z[\n|G\u000e\u0006\u0003\u0002@\u0005EC\u0003BA!\u0003\u000f\u0002BAVA\"_&\u0019\u0011QI,\u0003\r=\u0003H/[8o\u0011\u001d\tIE\u0003a\u0001\u0003\u0017\naa]=nE>d\u0007\u0003BA'\u0003SrA!a\u0014\u0002R1\u0001\u0001bBA*\u0015\u0001\u0007\u0011QK\u0001\tG>l\u0007/\u001b7feB!\u0011qKA3\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013aC5oi\u0016\u0014\u0018m\u0019;jm\u0016TA!a\u0018\u0002b\u0005\u0019an]2\u000b\u0007\u0005\rt+A\u0003u_>d7/\u0003\u0003\u0002h\u0005e#AB$m_\n\fG.\u0003\u0003\u0002l\u00055$AB*z[\n|G.\u0003\u0003\u0002p\u0005E$aB*z[\n|Gn\u001d\u0006\u0005\u0003g\n)(\u0001\u0005j]R,'O\\1m\u0015\r\t9hV\u0001\be\u00164G.Z2u\u0005\u0015\u0019F/\u0019;f'%Y\u0011QPAG\u00033\u000by\n\u0005\u0003\u0002\u0000\u0005%UBAAA\u0015\u0011\t\u0019)!\"\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000f\u000bAA[1wC&!\u00111RAA\u0005\u0019y%M[3diB!\u0011qRAK\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006\u0015\u0015AA5p\u0013\u0011\t9*!%\u0003\u0013\rcwn]3bE2,\u0007c\u0001,\u0002\u001c&\u0019\u0011QT,\u0003\u000fA\u0013x\u000eZ;diB\u0019A-!)\n\u0007\u0005\rfN\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003j]\u0012,\u00070\u0006\u0002\u0002*B!\u00111VAZ\u001b\t\tiK\u0003\u0003\u00020\u0006E\u0016!B7uC\u001e\u001c(bAA:=&!\u0011QWAW\u0005Mye\u000eR3nC:$7+_7c_2Le\u000eZ3y\u0003\u0019Ig\u000eZ3yA\u0005I1\r\\1tgB\u000bG\u000f[\u000b\u0003\u0003{\u0003R\u0001ZA`\u0003\u0007L1!!1o\u0005\r\u0019V-\u001d\t\u0005\u0003\u000b\fy-\u0004\u0002\u0002H*!\u0011\u0011ZAf\u0003\u00111\u0017\u000e\\3\u000b\t\u00055\u0017QQ\u0001\u0004]&|\u0017\u0002BAi\u0003\u000f\u0014A\u0001U1uQ\u0006Q1\r\\1tgB\u000bG\u000f\u001b\u0011\u0002\r\u001ddwNY1m+\t\t)&A\u0004hY>\u0014\u0017\r\u001c\u0011\u0016\u0005\u0005-\u0012aC:pkJ\u001cW\r]1uQ\u0002\"\"\"!9\u0002f\u0006\u001d\u0018\u0011^Av!\r\t\u0019oC\u0007\u0002\u0001!9\u0011Q\u0015\u000bA\u0002\u0005%\u0006bBA])\u0001\u0007\u0011Q\u0018\u0005\b\u0003+$\u0002\u0019AA+\u0011\u001d\tI\u0003\u0006a\u0001\u0003W\tQ!^:f\u00072,\"!!=\u0011\u0007Y\u000b\u00190C\u0002\u0002v^\u0013qAQ8pY\u0016\fg.A\u0006dY\u0006\u001c8\u000fT8bI\u0016\u0014XCAA~!\u0011\tiPa\u0001\u000e\u0005\u0005}(\u0002\u0002B\u0001\u0003\u000b\u000b1A\\3u\u0013\u0011\u0011)!a@\u0003\u001dU\u0013Fj\u00117bgNdu.\u00193fe\u0006A!0\u001b9GS2,7/\u0006\u0002\u0003\fAA!Q\u0002B\f\u0003\u0007\u0014Y\"\u0004\u0002\u0003\u0010)!!\u0011\u0003B\n\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0005+\t))\u0001\u0003vi&d\u0017\u0002\u0002B\r\u0005\u001f\u0011\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\u0011\u0011iBa\t\u000e\u0005\t}!\u0002\u0002B\u0011\u0005'\t1A_5q\u0013\u0011\u0011)Ca\b\u0003\u000fiK\u0007OR5mK\u0006I!0\u001b9GS2,7\u000fI\u0001\bu&\u0004h)\u001b7f)\u0011\u0011YB!\f\t\u000f\t=\u0012\u00041\u0001\u0002D\u0006!\u0001/\u0019;i\u0003\u0019\u0019x.\u001e:dKR!\u0011\u0011\tB\u001b\u0011\u0019\u00119D\u0007a\u0001_\u0006!a.Y7f\u0003\u0015\u0019Gn\\:f\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005\u0005(q\bB!\u0005\u0007\u0012)\u0005C\u0005\u0002&r\u0001\n\u00111\u0001\u0002*\"I\u0011\u0011\u0018\u000f\u0011\u0002\u0003\u0007\u0011Q\u0018\u0005\n\u0003+d\u0002\u0013!a\u0001\u0003+B\u0011\"!\u000b\u001d!\u0003\u0005\r!a\u000b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\n\u0016\u0005\u0003S\u0013ie\u000b\u0002\u0003PA!!\u0011\u000bB.\u001b\t\u0011\u0019F\u0003\u0003\u0003V\t]\u0013!C;oG\",7m[3e\u0015\r\u0011IfV\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B/\u0005'\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa\u0019+\t\u0005u&QJ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011IG\u000b\u0003\u0002V\t5\u0013AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005_RC!a\u000b\u0003N\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u001e\u0011\t\u0005}$qO\u0005\u0004k\u0006\u0005\u0015\u0001\u00049s_\u0012,8\r^!sSRLX#A=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\u0011BD!\r1&1Q\u0005\u0004\u0005\u000b;&aA!os\"A!\u0011R\u0012\u0002\u0002\u0003\u0007\u00110A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u001f\u0003bA!%\u0003\u0018\n\u0005UB\u0001BJ\u0015\r\u0011)jV\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BM\u0005'\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011\u001fBP\u0011%\u0011I)JA\u0001\u0002\u0004\u0011\t)\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B;\u0005KC\u0001B!#'\u0003\u0003\u0005\r!_\u0001\tQ\u0006\u001c\bnQ8eKR\t\u00110\u0001\u0005u_N#(/\u001b8h)\t\u0011)(\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003c\u0014\u0019\fC\u0005\u0003\n&\n\t\u00111\u0001\u0003\u0002\u0006)1\u000b^1uKB\u0019\u00111]\u0016\u0014\u000b-\u0012YLa2\u0011\u001d\tu&1YAU\u0003{\u000b)&a\u000b\u0002b6\u0011!q\u0018\u0006\u0004\u0005\u0003<\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005\u000b\u0014yLA\tBEN$(/Y2u\rVt7\r^5p]R\u0002B!a$\u0003J&!\u00111UAI)\t\u00119,A\u0003baBd\u0017\u0010\u0006\u0006\u0002b\nE'1\u001bBk\u0005/Dq!!*/\u0001\u0004\tI\u000bC\u0004\u0002::\u0002\r!!0\t\u000f\u0005Ug\u00061\u0001\u0002V!9\u0011\u0011\u0006\u0018A\u0002\u0005-\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0005;\u0014)\u000fE\u0003W\u0003\u0007\u0012y\u000eE\u0006W\u0005C\fI+!0\u0002V\u0005-\u0012b\u0001Br/\n1A+\u001e9mKRB\u0011Ba:0\u0003\u0003\u0005\r!!9\u0002\u0007a$\u0003'A\u0003ti\u0006$X-\u0006\u0002\u0003nB1!q\u001eB{\u0003Cl!A!=\u000b\t\tM(qB\u0001\u0007CR|W.[2\n\t\t](\u0011\u001f\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dK\u000611\u000f^1uK\u0002\nqb^5uQ&s\u0007/\u001e;TiJ,\u0017-\\\u000b\u0005\u0005\u007f\u001c)\u0001\u0006\u0003\u0004\u0002\r\u0005B\u0003BB\u0002\u0007#\u0001B!a\u0014\u0004\u0006\u001191qA\u001bC\u0002\r%!!\u0001+\u0012\t\r-!\u0011\u0011\t\u0004-\u000e5\u0011bAB\b/\n9aj\u001c;iS:<\u0007bBB\nk\u0001\u00071QC\u0001\u0002MB9aka\u0006\u0004\u001c\r\r\u0011bAB\r/\nIa)\u001e8di&|g.\r\t\u0005\u0003\u001f\u001bi\"\u0003\u0003\u0004 \u0005E%aC%oaV$8\u000b\u001e:fC6D\u0001ba\t6\t\u0003\u00071QE\u0001\u0003SN\u0004RAVB\u0014\u00077I1a!\u000bX\u0005!a$-\u001f8b[\u0016t\u0014\u0001\u00027pG.,\"!! \u0002\u000b1|7m\u001b\u0011\u0002\u0017!$H\u000f\u001d%b]\u0012dWM]\u000b\u0003\u0007k\u0011baa\u000e\u0002~\rubABB\u001ds\u0001\u0019)D\u0001\u0007=e\u00164\u0017N\\3nK:$h(\u0001\u0007iiR\u0004\b*\u00198eY\u0016\u0014\b\u0005\u0005\u0003\u0004@\r%SBAB!\u0015\r\u000161\t\u0006\u0005\u0007\u000b\u001a9%\u0001\u0005v]\u0012,'\u000f^8x\u0015\t\t\u0019*\u0003\u0003\u0004L\r\u0005#a\u0003%uiBD\u0015M\u001c3mKJ,\"aa\u0014\u0011\t\rE31K\u0007\u0003\u0007\u0007JAa!\u0016\u0004D\tAQK\u001c3feR|w/A\u0004tKJ4XM\u001d\u0011\u0002\u0011\u001d,GOQ=uKN$Ba!\u0018\u0004jA)aka\u0018\u0004d%\u00191\u0011M,\u0003\u000b\u0005\u0013(/Y=\u0011\u0007Y\u001b)'C\u0002\u0004h]\u0013AAQ=uK\"911\u000e\u001fA\u0002\r5\u0014\u0001C3yG\"\fgnZ3\u0011\t\r}2qN\u0005\u0005\u0007c\u001a\tE\u0001\nIiR\u00048+\u001a:wKJ,\u0005p\u00195b]\u001e,\u0017aC4{SB$UM\u001a7bi\u0016$Ba!\u0018\u0004x!91\u0011P\u001fA\u0002\ru\u0013!\u00022zi\u0016\u001c\u0018\u0001D4fi^{'o[:qC\u000e,WCAB@!\u0011\u0019\tia\"\u000e\u0005\r\r%bABC#\u000611o\u00195f[\u0006LAa!#\u0004\u0004\nIqk\u001c:lgB\f7-Z\u0001\u000eO\u0016$8+Z7b]RL7\r\u001a2\u0015\t\r=51\u0014\t\u0005\u0007#\u001b9*\u0004\u0002\u0004\u0014*!1QSAY\u0003)\u0019X-\\1oi&\u001cGMY\u0005\u0005\u00073\u001b\u0019JA\u0007UKb$Hi\\2v[\u0016tGo\u001d\u0005\u0007\u0007;{\u0004\u0019A8\u0002\u0011\u0019LG.\u001a8b[\u0016\f\u0011bZ3u'fl'm\u001c7\u0015\t\r\r6\u0011\u0016\t\u0005\u0007\u0003\u001b)+\u0003\u0003\u0004(\u000e\r%!D*z[\n|G.\u00138eKb,7\u000f\u0003\u0004\u0004,\u0002\u0003\ra\\\u0001\u0004gfl\u0017aC2p]R,g\u000e\u001e+za\u0016$2a\\BY\u0011\u0019\u0011y#\u0011a\u0001_\u0006\u0001R*\u001a;bEJ|wo]3TKJ4XM\u001d\t\u0004\u0003#\u00195CA\"V)\t\u0019),\u0001\u0003nC&tG\u0003BA\u0011\u0007\u007fCqa!1F\u0001\u0004\u0019\u0019-A\u0005beJ\f\u00170\u0011:hgB!aka\u0018p\u00035i\u0017m\u0019:p!\u0006\u0014\u0018\rZ5tKV\u0011\u00111Y\u0001\u000eW&tG\r\u0015:pU\u0016\u001cGo\u001c:\u0002!M\u001c\u0017\r\\1Gk2dg+\u001a:tS>tW#A8\u0002%M\u001c\u0017\r\\1CS:\f'/\u001f,feNLwN\\\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\rU'fA2\u0003N\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"aa7+\u0007=\u0014i%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007CT3!\u001fB'\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u00111q\u001d\u0016\u0004{\n5\u0003")
public class MetabrowseServer {
    private volatile MetabrowseServer$State$ State$module;
    private final Dialect dialect;
    private final List<String> scalacOptions;
    public final Logger metabrowse$server$MetabrowseServer$$logger;
    private final AtomicReference<State> state;
    private final Object metabrowse$server$MetabrowseServer$$lock;
    private final HttpHandler httpHandler;
    private final Undertow server;

    public static Logger $lessinit$greater$default$5() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$3();
    }

    public static List<String> $lessinit$greater$default$2() {
        return MetabrowseServer$.MODULE$.$lessinit$greater$default$2();
    }

    public static void main(String[] arrayArgs) {
        MetabrowseServer$.MODULE$.main(arrayArgs);
    }

    public MetabrowseServer$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public void start(Sourcepath sourcepath) {
        this.replaceClasspath(sourcepath);
        this.server().start();
    }

    public void stop() {
        this.server().stop();
        this.global().askShutdown();
        Option$.MODULE$.apply((Object)this.state().get()).foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public void replaceClasspath(Sourcepath sourcepath) {
        Object object = this.metabrowse$server$MetabrowseServer$$lock();
        synchronized (object) {
            State prevState = this.state().get();
            if (prevState != null) {
                this.global().askShutdown();
                prevState.close();
            }
            State newState = new State(this, OnDemandSymbolIndex$.MODULE$.empty(OnDemandSymbolIndex$.MODULE$.empty$default$1(), OnDemandSymbolIndex$.MODULE$.empty$default$2(), (ReportContext)EmptyReportContext$.MODULE$), (Seq<Path>)sourcepath.sources(), InteractiveSemanticdb$.MODULE$.newCompiler(sourcepath.classpath().mkString(File.pathSeparator), this.scalacOptions), sourcepath);
            this.state().set(newState);
            sourcepath.sources().foreach((Function1 & Serializable)jar -> this.index().addSourceJar(AbsolutePath$.MODULE$.apply(jar, AbsolutePath$.MODULE$.workingDirectory()), $this.dialect));
        }
    }

    public Option<String> urlForSymbol(Global compiler, Symbols.Symbol symbol) {
        Symbols.Symbol symbol2 = symbol;
        LazyRef semanticdbOps$lzy = new LazyRef();
        ObjectRef compilerSymbol = ObjectRef.create((Object)compiler.rootMirror().RootPackage());
        ((List)symbol2.ownerChain().reverse().drop(1)).foreach((Function1 & Serializable)owner -> {
            MetabrowseServer.$anonfun$urlForSymbol$1(compiler, compilerSymbol, owner);
            return BoxedUnit.UNIT;
        });
        String semanticdbSymbol = MetabrowseServer.semanticdbOps$1(semanticdbOps$lzy, compiler).XtensionGSymbolMSymbol((Symbols.Symbol)compilerSymbol.elem).toSemantic();
        return this.getSymbol(semanticdbSymbol).indexes().headOption().flatMap((Function1 & Serializable)symbolIndex -> symbolIndex.definition().map((Function1 & Serializable)position -> new StringBuilder(4).append("#").append(position.filename()).append("#L").append(position.startLine()).append("C").append(position.startCharacter()).toString()));
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    public OnDemandSymbolIndex index() {
        return this.state().get().index();
    }

    public Global global() {
        return this.state().get().global();
    }

    public Sourcepath sourcepath() {
        return this.state().get().sourcepath();
    }

    public <T> T metabrowse$server$MetabrowseServer$$withInputStream(Function0<InputStream> is, Function1<InputStream, T> f) {
        Object object;
        try (InputStream is0 = null;){
            is0 = (InputStream)is.apply();
            object = f.apply((Object)is0);
        }
        return (T)object;
    }

    public Object metabrowse$server$MetabrowseServer$$lock() {
        return this.metabrowse$server$MetabrowseServer$$lock;
    }

    private HttpHandler httpHandler() {
        return this.httpHandler;
    }

    private Undertow server() {
        return this.server;
    }

    public byte[] metabrowse$server$MetabrowseServer$$getBytes(HttpServerExchange exchange) {
        String path = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(exchange.getRequestPath()), ".gz");
        if (path.endsWith("index.workspace")) {
            return this.getWorkspace().toByteArray();
        }
        if (path.endsWith(".symbolindexes")) {
            HeaderValues header = exchange.getRequestHeaders().get("Metabrowse-Symbol");
            if (header.isEmpty()) {
                this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(29).append("no Metabrowse-Symbol header: ").append(exchange).toString());
                return Array$.MODULE$.emptyByteArray();
            }
            return this.getSymbol(header.getFirst()).toByteArray();
        }
        if (path.endsWith(".semanticdb")) {
            return this.getSemanticdb(path).toByteArray();
        }
        if (path.endsWith(".map")) {
            return Array$.MODULE$.emptyByteArray();
        }
        String string = path;
        String string2 = "/";
        String actualPath = !(string != null ? !string.equals(string2) : string2 != null) ? "/index.html" : path;
        return (byte[])this.metabrowse$server$MetabrowseServer$$withInputStream((Function0<InputStream>)(Function0 & Serializable)() -> Thread.currentThread().getContextClassLoader().getResourceAsStream(new StringBuilder(25).append("metabrowse/server/assets/").append(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(actualPath), "/")).toString()), (Function1 & Serializable)is -> {
            if (is == null) {
                $this.metabrowse$server$MetabrowseServer$$logger.warn(new StringBuilder(14).append("no such file: ").append(path).toString());
                return Array$.MODULE$.emptyByteArray();
            }
            return InputStreamIO$.MODULE$.readBytes(is);
        });
    }

    public byte[] metabrowse$server$MetabrowseServer$$gzipDeflate(byte[] bytes) {
        byte[] byArray;
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(bytes))) {
            return bytes;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gos = new GZIPOutputStream((OutputStream)baos, bytes.length);){
            gos.write(bytes);
            gos.finish();
            byArray = baos.toByteArray();
        }
        return byArray;
    }

    private Workspace getWorkspace() {
        Builder filenames = ArrayBuffer$.MODULE$.newBuilder();
        this.sourcepath().sources().foreach((Function1 & Serializable)sourcesJar -> {
            FileIO$.MODULE$.withJarFileSystem(AbsolutePath$.MODULE$.apply(sourcesJar, AbsolutePath$.MODULE$.workingDirectory()), false, false, (Function1 & Serializable)root -> {
                MetabrowseServer.$anonfun$getWorkspace$2(filenames$1, root);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return new Workspace(((IterableOnceOps)filenames.result()).toSeq(), Workspace$.MODULE$.apply$default$2());
    }

    private TextDocuments getSemanticdb(String filename) {
        String path = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(filename), "/semanticdb/")), "/")), ".semanticdb");
        this.metabrowse$server$MetabrowseServer$$logger.info(path);
        return (TextDocuments)this.state().get().source(path).orElse((Function0 & Serializable)() -> {
            $this.metabrowse$server$MetabrowseServer$$logger.warn(new StringBuilder(16).append("no source file: ").append(path).toString());
            return None$.MODULE$;
        }).flatMap((Function1 & Serializable)text -> {
            Some some;
            try {
                TextDocument textDocument;
                long timeout = TimeUnit.SECONDS.toMillis(10L);
                if (path.endsWith(".java")) {
                    Input.VirtualFile input = new Input.VirtualFile(path, text);
                    textDocument = JavaMtags$.MODULE$.index(input, true).index();
                } else {
                    textDocument = InteractiveSemanticdb$.MODULE$.toTextDocument(this.global(), text, filename, timeout, (List)new .colon.colon((Object)"-P:semanticdb:synthetics:on", (List)new .colon.colon((Object)"-P:semanticdb:symbols:none", (List)Nil$.MODULE$)));
                }
                TextDocument textDocument2 = textDocument;
                some = new Some((Object)textDocument2);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    $this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(15).append("compile error: ").append(filename).toString(), e);
                    some = None$.MODULE$;
                }
                throw throwable;
            }
            return some.map((Function1 & Serializable)doc -> new TextDocuments((Seq)new .colon.colon((Object)doc.withText(text), (List)Nil$.MODULE$)));
        }).getOrElse((Function0 & Serializable)() -> new TextDocuments(TextDocuments$.MODULE$.apply$default$1()));
    }

    private SymbolIndexes getSymbol(String sym) {
        Option definition = this.index().definition(Symbol$.MODULE$.apply(sym)).orElse((Function0 & Serializable)() -> {
            $this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(28).append("no definition for symbol: '").append(sym).append("'").toString());
            return None$.MODULE$;
        }).map((Function1 & Serializable)defn -> {
            Input.VirtualFile input = MtagsEnrichments$.MODULE$.XtensionAbsolutePath(defn.path()).toInput();
            TextDocument doc = input.path().endsWith(".java") ? JavaMtags$.MODULE$.index(input, true).index() : ScalaMtags$.MODULE$.index(input, $this.dialect).index();
            return new Tuple3(defn, (Object)input, (Object)doc);
        }).flatMap((Function1 & Serializable)x$8 -> {
            Tuple3 tuple3 = x$8;
            if (tuple3 != null) {
                SymbolDefinition defn = (SymbolDefinition)tuple3._1();
                TextDocument doc = (TextDocument)tuple3._3();
                return doc.occurrences().find((Function1 & Serializable)occ -> BoxesRunTime.boxToBoolean((boolean)MetabrowseServer.$anonfun$getSymbol$4(defn, occ))).orElse((Function0 & Serializable)() -> {
                    $this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(26).append("no definition occurrence: ").append(defn).toString());
                    return None$.MODULE$;
                }).flatMap((Function1 & Serializable)occ -> occ.range().orElse((Function0 & Serializable)() -> {
                    $this.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(10).append("no range: ").append(occ).toString());
                    return None$.MODULE$;
                }).map((Function1 & Serializable)range -> new metabrowse.schema.Position(defn.path().toString(), range.startLine(), range.startCharacter(), range.endLine(), range.endCharacter(), Position$.MODULE$.apply$default$6())));
            }
            throw new MatchError((Object)tuple3);
        });
        return new SymbolIndexes((Seq)new .colon.colon((Object)new SymbolIndex(sym, definition, SymbolIndex$.MODULE$.apply$default$3(), SymbolIndex$.MODULE$.apply$default$4()), (List)Nil$.MODULE$), SymbolIndexes$.MODULE$.apply$default$2());
    }

    public String metabrowse$server$MetabrowseServer$$contentType(String path) {
        if (path.endsWith(".js")) {
            return "application/javascript";
        }
        if (path.endsWith(".css")) {
            return "text/css";
        }
        if (path.endsWith(".html")) {
            return "text/html";
        }
        return "";
    }

    private final void State$lzycompute$1() {
        MetabrowseServer metabrowseServer = this;
        synchronized (metabrowseServer) {
            if (this.State$module == null) {
                this.State$module = new MetabrowseServer$State$(this);
            }
        }
    }

    private static final /* synthetic */ SemanticdbOps semanticdbOps$lzycompute$1(LazyRef semanticdbOps$lzy$1, Global compiler$1) {
        SemanticdbOps semanticdbOps;
        LazyRef lazyRef = semanticdbOps$lzy$1;
        synchronized (lazyRef) {
            semanticdbOps = semanticdbOps$lzy$1.initialized() ? (SemanticdbOps)semanticdbOps$lzy$1.value() : (SemanticdbOps)semanticdbOps$lzy$1.initialize((Object)new SemanticdbOps(null, compiler$1){
                private final Global global;
                private SemanticdbConfig config;
                private volatile TypeOps$ByNameType$ ByNameType$module;
                private volatile TypeOps$RepeatedType$ RepeatedType$module;
                private HashMap<Symbols.Symbol, String> symbolCache;
                private volatile SymbolOps$SemanticdbDecls$ SemanticdbDecls$module;
                private HashMap<String, Object> idCache;
                private HashMap<Object, Symbols.Symbol> pointsCache;
                private Global g;
                private boolean isDocCompiler;
                private boolean isReplCompiler;
                private boolean isInteractiveCompiler;
                private boolean isSupportedCompiler;
                private volatile ReflectionToolkit$Attachable$ Attachable$module;
                private volatile ReflectionToolkit$ConstfoldOf$ ConstfoldOf$module;
                private volatile ReflectionToolkit$ClassOf$ ClassOf$module;
                private volatile ReflectionToolkit$NewArrayOf$ NewArrayOf$module;
                private volatile ReflectionToolkit$SingletonTypeTreeOf$ SingletonTypeTreeOf$module;
                private volatile ReflectionToolkit$CompoundTypeTreeOf$ CompoundTypeTreeOf$module;
                private volatile ReflectionToolkit$ExistentialTypeTreeOf$ ExistentialTypeTreeOf$module;
                private volatile ReflectionToolkit$AnnotatedOf$ AnnotatedOf$module;
                private volatile ReflectionToolkit$SelfTypeOf$ SelfTypeOf$module;
                private volatile ReflectionToolkit$SelectOf$ SelectOf$module;
                private final Map<CompilationUnits.CompilationUnit, Object> scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath;
                private String language;
                private Map<SourceFile, Input> gSourceFileInputCache;
                private volatile VersionSpecificOps$OriginalTreeOf$ OriginalTreeOf$module;
                private volatile VersionSpecificOps$NamedApplyBlock$ NamedApplyBlock$module;
                private volatile int bitmap$0;

                public TypeOps.XtensionGTypeSType XtensionGTypeSType(Types.Type gtpe) {
                    return TypeOps.XtensionGTypeSType$((TypeOps)this, (Types.Type)gtpe);
                }

                public TypeOps.XtensionGType XtensionGType(Types.Type gtpe) {
                    return TypeOps.XtensionGType$((TypeOps)this, (Types.Type)gtpe);
                }

                public SyntheticOps.XtensionGTreeSTree XtensionGTreeSTree(Trees.Tree gTree) {
                    return SyntheticOps.XtensionGTreeSTree$((SyntheticOps)this, (Trees.Tree)gTree);
                }

                public SymbolOpsCompat.XtensionGSymbolCompat XtensionGSymbolCompat(Symbols.Symbol sym) {
                    return SymbolOpsCompat.XtensionGSymbolCompat$((SymbolOpsCompat)this, (Symbols.Symbol)sym);
                }

                public SymbolOps.XtensionGSymbolMSymbol XtensionGSymbolMSymbol(Symbols.Symbol sym) {
                    return SymbolOps.XtensionGSymbolMSymbol$((SymbolOps)this, (Symbols.Symbol)sym);
                }

                public SymbolOps.XtensionGSymbolMSpec XtensionGSymbolMSpec(Symbols.Symbol sym) {
                    return SymbolOps.XtensionGSymbolMSpec$((SymbolOps)this, (Symbols.Symbol)sym);
                }

                public SymbolOps.XtensionGScopeMSpec XtensionGScopeMSpec(Scopes.Scope scope) {
                    return SymbolOps.XtensionGScopeMSpec$((SymbolOps)this, (Scopes.Scope)scope);
                }

                public SymbolOps.XtensionGSymbolsMSpec XtensionGSymbolsMSpec(List<Symbols.Symbol> syms) {
                    return SymbolOps.XtensionGSymbolsMSpec$((SymbolOps)this, syms);
                }

                public SymbolOps.XtensionGSymbol XtensionGSymbol(Symbols.Symbol sym) {
                    return SymbolOps.XtensionGSymbol$((SymbolOps)this, (Symbols.Symbol)sym);
                }

                public <T> ReflectionToolkit.XtensionAttachable<T> XtensionAttachable(T carrier, ReflectionToolkit.Attachable<T> evidence$4) {
                    return ReflectionToolkit.XtensionAttachable$((ReflectionToolkit)this, carrier, evidence$4);
                }

                public <T> ReflectionToolkit.XtensionMetadataAttachable<T> XtensionMetadataAttachable(T carrier, ReflectionToolkit.Attachable<T> evidence$6) {
                    return ReflectionToolkit.XtensionMetadataAttachable$((ReflectionToolkit)this, carrier, evidence$6);
                }

                public ReflectionToolkit.XtensionCompilationUnitCache XtensionCompilationUnitCache(CompilationUnits.CompilationUnit unit) {
                    return ReflectionToolkit.XtensionCompilationUnitCache$((ReflectionToolkit)this, (CompilationUnits.CompilationUnit)unit);
                }

                public <T> ReflectionToolkit.XtensionDesugarings<T> XtensionDesugarings(T carrier, ReflectionToolkit.Attachable<T> evidence$10) {
                    return ReflectionToolkit.XtensionDesugarings$((ReflectionToolkit)this, carrier, evidence$10);
                }

                public ReporterOps.XtensionCompilationUnitReporter XtensionCompilationUnitReporter(CompilationUnits.CompilationUnit unit) {
                    return ReporterOps.XtensionCompilationUnitReporter$((ReporterOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public ParseOps.XtensionCompilationUnitSource XtensionCompilationUnitSource(CompilationUnits.CompilationUnit unit) {
                    return ParseOps.XtensionCompilationUnitSource$((ParseOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public DiagnosticOps.XtensionCompilationUnitDiagnostics XtensionCompilationUnitDiagnostics(CompilationUnits.CompilationUnit unit) {
                    return DiagnosticOps.XtensionCompilationUnitDiagnostics$((DiagnosticOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public InputOps.XtensionGSourceFileInput XtensionGSourceFileInput(SourceFile gsource) {
                    return InputOps.XtensionGSourceFileInput$((InputOps)this, (SourceFile)gsource);
                }

                public InputOps.XtensionGPositionMPosition XtensionGPositionMPosition(Position pos) {
                    return InputOps.XtensionGPositionMPosition$((InputOps)this, (Position)pos);
                }

                public void validateCompilerState() {
                    TextDocumentOps.validateCompilerState$((TextDocumentOps)this);
                }

                public TextDocumentOps.XtensionCompilationUnitDocument XtensionCompilationUnitDocument(CompilationUnits.CompilationUnit unit) {
                    return TextDocumentOps.XtensionCompilationUnitDocument$((TextDocumentOps)this, (CompilationUnits.CompilationUnit)unit);
                }

                public SymbolInformationOps.XtensionGSymbolMSymbolInformation XtensionGSymbolMSymbolInformation(Symbols.Symbol gsym0) {
                    return SymbolInformationOps.XtensionGSymbolMSymbolInformation$((SymbolInformationOps)this, (Symbols.Symbol)gsym0);
                }

                public AnnotationOps.XtensionAnnotationInfo XtensionAnnotationInfo(AnnotationInfos.AnnotationInfo gann) {
                    return AnnotationOps.XtensionAnnotationInfo$((AnnotationOps)this, (AnnotationInfos.AnnotationInfo)gann);
                }

                public SemanticdbConfig config() {
                    return this.config;
                }

                public void config_$eq(SemanticdbConfig x$1) {
                    this.config = x$1;
                }

                public TypeOps$ByNameType$ ByNameType() {
                    if (this.ByNameType$module == null) {
                        this.ByNameType$lzycompute$1();
                    }
                    return this.ByNameType$module;
                }

                public TypeOps$RepeatedType$ RepeatedType() {
                    if (this.RepeatedType$module == null) {
                        this.RepeatedType$lzycompute$1();
                    }
                    return this.RepeatedType$module;
                }

                private HashMap<Symbols.Symbol, String> symbolCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 1) == 0) {
                            this.symbolCache = SymbolOps.symbolCache$((SymbolOps)this);
                            this.bitmap$0 |= 1;
                        }
                    }
                    return this.symbolCache;
                }

                public HashMap<Symbols.Symbol, String> symbolCache() {
                    if ((this.bitmap$0 & 1) == 0) {
                        return this.symbolCache$lzycompute();
                    }
                    return this.symbolCache;
                }

                public SymbolOps$SemanticdbDecls$ SemanticdbDecls() {
                    if (this.SemanticdbDecls$module == null) {
                        this.SemanticdbDecls$lzycompute$1();
                    }
                    return this.SemanticdbDecls$module;
                }

                private HashMap<String, Object> idCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 2) == 0) {
                            this.idCache = SymbolOps.idCache$((SymbolOps)this);
                            this.bitmap$0 |= 2;
                        }
                    }
                    return this.idCache;
                }

                public HashMap<String, Object> idCache() {
                    if ((this.bitmap$0 & 2) == 0) {
                        return this.idCache$lzycompute();
                    }
                    return this.idCache;
                }

                private HashMap<Object, Symbols.Symbol> pointsCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 4) == 0) {
                            this.pointsCache = SymbolOps.pointsCache$((SymbolOps)this);
                            this.bitmap$0 |= 4;
                        }
                    }
                    return this.pointsCache;
                }

                public HashMap<Object, Symbols.Symbol> pointsCache() {
                    if ((this.bitmap$0 & 4) == 0) {
                        return this.pointsCache$lzycompute();
                    }
                    return this.pointsCache;
                }

                private Global g$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 8) == 0) {
                            this.g = (Global)ReflectionToolkit.g$((ReflectionToolkit)this);
                            this.bitmap$0 |= 8;
                        }
                    }
                    return this.g;
                }

                public Global g() {
                    if ((this.bitmap$0 & 8) == 0) {
                        return this.g$lzycompute();
                    }
                    return this.g;
                }

                private boolean isDocCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x10) == 0) {
                            this.isDocCompiler = ReflectionToolkit.isDocCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x10;
                        }
                    }
                    return this.isDocCompiler;
                }

                public boolean isDocCompiler() {
                    if ((this.bitmap$0 & 0x10) == 0) {
                        return this.isDocCompiler$lzycompute();
                    }
                    return this.isDocCompiler;
                }

                private boolean isReplCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x20) == 0) {
                            this.isReplCompiler = ReflectionToolkit.isReplCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x20;
                        }
                    }
                    return this.isReplCompiler;
                }

                public boolean isReplCompiler() {
                    if ((this.bitmap$0 & 0x20) == 0) {
                        return this.isReplCompiler$lzycompute();
                    }
                    return this.isReplCompiler;
                }

                private boolean isInteractiveCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x40) == 0) {
                            this.isInteractiveCompiler = ReflectionToolkit.isInteractiveCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x40;
                        }
                    }
                    return this.isInteractiveCompiler;
                }

                public boolean isInteractiveCompiler() {
                    if ((this.bitmap$0 & 0x40) == 0) {
                        return this.isInteractiveCompiler$lzycompute();
                    }
                    return this.isInteractiveCompiler;
                }

                private boolean isSupportedCompiler$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x80) == 0) {
                            this.isSupportedCompiler = ReflectionToolkit.isSupportedCompiler$((ReflectionToolkit)this);
                            this.bitmap$0 |= 0x80;
                        }
                    }
                    return this.isSupportedCompiler;
                }

                public boolean isSupportedCompiler() {
                    if ((this.bitmap$0 & 0x80) == 0) {
                        return this.isSupportedCompiler$lzycompute();
                    }
                    return this.isSupportedCompiler;
                }

                public ReflectionToolkit$Attachable$ Attachable() {
                    if (this.Attachable$module == null) {
                        this.Attachable$lzycompute$1();
                    }
                    return this.Attachable$module;
                }

                public ReflectionToolkit$ConstfoldOf$ ConstfoldOf() {
                    if (this.ConstfoldOf$module == null) {
                        this.ConstfoldOf$lzycompute$1();
                    }
                    return this.ConstfoldOf$module;
                }

                public ReflectionToolkit$ClassOf$ ClassOf() {
                    if (this.ClassOf$module == null) {
                        this.ClassOf$lzycompute$1();
                    }
                    return this.ClassOf$module;
                }

                public ReflectionToolkit$NewArrayOf$ NewArrayOf() {
                    if (this.NewArrayOf$module == null) {
                        this.NewArrayOf$lzycompute$1();
                    }
                    return this.NewArrayOf$module;
                }

                public ReflectionToolkit$SingletonTypeTreeOf$ SingletonTypeTreeOf() {
                    if (this.SingletonTypeTreeOf$module == null) {
                        this.SingletonTypeTreeOf$lzycompute$1();
                    }
                    return this.SingletonTypeTreeOf$module;
                }

                public ReflectionToolkit$CompoundTypeTreeOf$ CompoundTypeTreeOf() {
                    if (this.CompoundTypeTreeOf$module == null) {
                        this.CompoundTypeTreeOf$lzycompute$1();
                    }
                    return this.CompoundTypeTreeOf$module;
                }

                public ReflectionToolkit$ExistentialTypeTreeOf$ ExistentialTypeTreeOf() {
                    if (this.ExistentialTypeTreeOf$module == null) {
                        this.ExistentialTypeTreeOf$lzycompute$1();
                    }
                    return this.ExistentialTypeTreeOf$module;
                }

                public ReflectionToolkit$AnnotatedOf$ AnnotatedOf() {
                    if (this.AnnotatedOf$module == null) {
                        this.AnnotatedOf$lzycompute$1();
                    }
                    return this.AnnotatedOf$module;
                }

                public ReflectionToolkit$SelfTypeOf$ SelfTypeOf() {
                    if (this.SelfTypeOf$module == null) {
                        this.SelfTypeOf$lzycompute$1();
                    }
                    return this.SelfTypeOf$module;
                }

                public ReflectionToolkit$SelectOf$ SelectOf() {
                    if (this.SelectOf$module == null) {
                        this.SelectOf$lzycompute$1();
                    }
                    return this.SelectOf$module;
                }

                public Map<CompilationUnits.CompilationUnit, Object> scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath() {
                    return this.scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath;
                }

                public final void scala$meta$internal$semanticdb$scalac$ReporterOps$_setter_$scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath_$eq(Map<CompilationUnits.CompilationUnit, Object> x$1) {
                    this.scala$meta$internal$semanticdb$scalac$ReporterOps$$returnedMessagesByPath = x$1;
                }

                private String language$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x100) == 0) {
                            this.language = LanguageOps.language$((LanguageOps)this);
                            this.bitmap$0 |= 0x100;
                        }
                    }
                    return this.language;
                }

                public String language() {
                    if ((this.bitmap$0 & 0x100) == 0) {
                        return this.language$lzycompute();
                    }
                    return this.language;
                }

                private Map<SourceFile, Input> gSourceFileInputCache$lzycompute() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 0x200) == 0) {
                            this.gSourceFileInputCache = InputOps.gSourceFileInputCache$((InputOps)this);
                            this.bitmap$0 |= 0x200;
                        }
                    }
                    return this.gSourceFileInputCache;
                }

                public Map<SourceFile, Input> gSourceFileInputCache() {
                    if ((this.bitmap$0 & 0x200) == 0) {
                        return this.gSourceFileInputCache$lzycompute();
                    }
                    return this.gSourceFileInputCache;
                }

                public VersionSpecificOps$OriginalTreeOf$ OriginalTreeOf() {
                    if (this.OriginalTreeOf$module == null) {
                        this.OriginalTreeOf$lzycompute$1();
                    }
                    return this.OriginalTreeOf$module;
                }

                public VersionSpecificOps$NamedApplyBlock$ NamedApplyBlock() {
                    if (this.NamedApplyBlock$module == null) {
                        this.NamedApplyBlock$lzycompute$1();
                    }
                    return this.NamedApplyBlock$module;
                }

                public Global global() {
                    return this.global;
                }

                private final void ByNameType$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ByNameType$module == null) {
                            this.ByNameType$module = new TypeOps$ByNameType$((SemanticdbOps)this);
                        }
                    }
                }

                private final void RepeatedType$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.RepeatedType$module == null) {
                            this.RepeatedType$module = new TypeOps$RepeatedType$((SemanticdbOps)this);
                        }
                    }
                }

                private final void SemanticdbDecls$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SemanticdbDecls$module == null) {
                            this.SemanticdbDecls$module = new SymbolOps$SemanticdbDecls$((SemanticdbOps)this);
                        }
                    }
                }

                private final void Attachable$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.Attachable$module == null) {
                            this.Attachable$module = new ReflectionToolkit$Attachable$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void ConstfoldOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ConstfoldOf$module == null) {
                            this.ConstfoldOf$module = new ReflectionToolkit$ConstfoldOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void ClassOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ClassOf$module == null) {
                            this.ClassOf$module = new ReflectionToolkit$ClassOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void NewArrayOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.NewArrayOf$module == null) {
                            this.NewArrayOf$module = new ReflectionToolkit$NewArrayOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void SingletonTypeTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SingletonTypeTreeOf$module == null) {
                            this.SingletonTypeTreeOf$module = new ReflectionToolkit$SingletonTypeTreeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void CompoundTypeTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.CompoundTypeTreeOf$module == null) {
                            this.CompoundTypeTreeOf$module = new ReflectionToolkit$CompoundTypeTreeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void ExistentialTypeTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.ExistentialTypeTreeOf$module == null) {
                            this.ExistentialTypeTreeOf$module = new ReflectionToolkit$ExistentialTypeTreeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void AnnotatedOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.AnnotatedOf$module == null) {
                            this.AnnotatedOf$module = new ReflectionToolkit$AnnotatedOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void SelfTypeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SelfTypeOf$module == null) {
                            this.SelfTypeOf$module = new ReflectionToolkit$SelfTypeOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void SelectOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.SelectOf$module == null) {
                            this.SelectOf$module = new ReflectionToolkit$SelectOf$((ReflectionToolkit)this);
                        }
                    }
                }

                private final void OriginalTreeOf$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.OriginalTreeOf$module == null) {
                            this.OriginalTreeOf$module = new VersionSpecificOps$OriginalTreeOf$((SemanticdbOps)this);
                        }
                    }
                }

                private final void NamedApplyBlock$lzycompute$1() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.NamedApplyBlock$module == null) {
                            this.NamedApplyBlock$module = new VersionSpecificOps$NamedApplyBlock$((SemanticdbOps)this);
                        }
                    }
                }
                {
                    AnnotationOps.$init$((AnnotationOps)this);
                    VersionSpecificOps.$init$((VersionSpecificOps)this);
                    SymbolInformationOps.$init$((SymbolInformationOps)this);
                    TextDocumentOps.$init$((TextDocumentOps)this);
                    InputOps.$init$((InputOps)this);
                    LanguageOps.$init$((LanguageOps)this);
                    DiagnosticOps.$init$((DiagnosticOps)this);
                    ParseOps.$init$((ParseOps)this);
                    ReporterOps.$init$((ReporterOps)this);
                    ReflectionToolkit.$init$((ReflectionToolkit)this);
                    SymbolOps.$init$((SymbolOps)this);
                    SymbolOpsCompat.$init$((SymbolOpsCompat)this);
                    SyntheticOps.$init$((SyntheticOps)this);
                    TypeOps.$init$((TypeOps)this);
                    SemanticdbOps.$init$((SemanticdbOps)this);
                    this.global = compiler$1;
                    Statics.releaseFence();
                }
            });
        }
        return semanticdbOps;
    }

    private static final SemanticdbOps semanticdbOps$1(LazyRef semanticdbOps$lzy$1, Global compiler$1) {
        if (semanticdbOps$lzy$1.initialized()) {
            return (SemanticdbOps)semanticdbOps$lzy$1.value();
        }
        return MetabrowseServer.semanticdbOps$lzycompute$1(semanticdbOps$lzy$1, compiler$1);
    }

    public static final /* synthetic */ void $anonfun$urlForSymbol$1(Global compiler$1, ObjectRef compilerSymbol$1, Symbols.Symbol owner) {
        Names.TermName name = owner.name().isTermName() || owner.hasPackageFlag() ? compiler$1.TermName().apply(owner.nameString()) : compiler$1.TypeName().apply(owner.nameString());
        compilerSymbol$1.elem = ((Symbols.Symbol)compilerSymbol$1.elem).info().member((Names.Name)name);
    }

    public static final /* synthetic */ boolean $anonfun$getWorkspace$3(AbsolutePath x$7) {
        return !MtagsEnrichments$.MODULE$.XtensionAbsolutePath(x$7).toLanguage().isUnknownLanguage();
    }

    public static final /* synthetic */ void $anonfun$getWorkspace$2(Builder filenames$1, AbsolutePath root) {
        ((IterableOnceOps)FileIO$.MODULE$.listAllFilesRecursively(root).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MetabrowseServer.$anonfun$getWorkspace$3(x$7)))).foreach((Function1 & Serializable)path -> (Builder)filenames$1.$plus$eq((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(((Object)path.toNIO()).toString()), "/")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getSymbol$4(SymbolDefinition defn$1, SymbolOccurrence occ) {
        if (!occ.role().isDefinition()) return false;
        if (!occ.range().isDefined()) return false;
        String string = occ.symbol();
        String string2 = defn$1.definitionSymbol().value();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public MetabrowseServer(Dialect dialect, List<String> scalacOptions, String host, int port, Logger logger) {
        this.dialect = dialect;
        this.scalacOptions = scalacOptions;
        this.metabrowse$server$MetabrowseServer$$logger = logger;
        this.state = new AtomicReference();
        this.metabrowse$server$MetabrowseServer$$lock = new Object();
        this.httpHandler = new HttpHandler(this){
            private final /* synthetic */ MetabrowseServer $outer;

            public void handleRequest(HttpServerExchange exchange) {
                byte[] byArray;
                try {
                    Object object = this.$outer.metabrowse$server$MetabrowseServer$$lock();
                    synchronized (object) {
                        byte[] byArray2 = this.$outer.metabrowse$server$MetabrowseServer$$getBytes(exchange);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var4_2
                        byArray = byArray2;
                    }
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.$outer.metabrowse$server$MetabrowseServer$$logger.error(new StringBuilder(18).append("unexpected error: ").append(exchange).toString(), e);
                        byArray = Array$.MODULE$.emptyByteArray();
                    }
                    throw throwable;
                }
                byte[] bytes = byArray;
                byte[] compressed = this.$outer.metabrowse$server$MetabrowseServer$$gzipDeflate(bytes);
                ByteBuffer buffer = ByteBuffer.wrap(compressed);
                exchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, "gzip");
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.$outer.metabrowse$server$MetabrowseServer$$contentType(exchange.getRequestPath()));
                exchange.getResponseSender().send(buffer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.server = Undertow.builder().addHttpListener(port, host).setHandler(this.httpHandler()).build();
    }

    public class State
    implements Closeable,
    Product,
    Serializable {
        private boolean useCl;
        private URLClassLoader classLoader;
        private final OnDemandSymbolIndex index;
        private final Seq<Path> classPath;
        private final Global global;
        private final Sourcepath sourcepath;
        private final ConcurrentHashMap<Path, ZipFile> zipFiles;
        private volatile byte bitmap$0;
        public final /* synthetic */ MetabrowseServer $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public OnDemandSymbolIndex index() {
            return this.index;
        }

        public Seq<Path> classPath() {
            return this.classPath;
        }

        public Global global() {
            return this.global;
        }

        public Sourcepath sourcepath() {
            return this.sourcepath;
        }

        private boolean useCl$lzycompute() {
            State state = this;
            synchronized (state) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.useCl = Boolean.getBoolean("metabrowse.ucl");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.useCl;
        }

        private boolean useCl() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.useCl$lzycompute();
            }
            return this.useCl;
        }

        private URLClassLoader classLoader$lzycompute() {
            State state = this;
            synchronized (state) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.classLoader = new URLClassLoader((URL[])this.sourcepath().sources().map((Function1 & Serializable)x$2 -> x$2.toUri().toURL()).toArray(ClassTag$.MODULE$.apply(URL.class)));
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.classLoader;
        }

        private URLClassLoader classLoader() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.classLoader$lzycompute();
            }
            return this.classLoader;
        }

        private ConcurrentHashMap<Path, ZipFile> zipFiles() {
            return this.zipFiles;
        }

        private ZipFile zipFile(Path path) {
            ZipFile zf = this.zipFiles().get(path);
            if (zf == null) {
                try (ZipFile zf0 = null;){
                    zf0 = new ZipFile(path.toFile());
                    ZipFile prev = this.zipFiles().putIfAbsent(path, zf0);
                    if (prev == null) {
                        zf = zf0;
                        zf0 = null;
                    } else {
                        zf = prev;
                    }
                }
            }
            return zf;
        }

        public Option<String> source(String name) {
            Option option;
            if (this.useCl()) {
                option = (Option)this.metabrowse$server$MetabrowseServer$State$$$outer().metabrowse$server$MetabrowseServer$$withInputStream((Function0<InputStream>)(Function0 & Serializable)() -> this.classLoader().getResourceAsStream(name), (Function1 & Serializable)is -> {
                    if (is == null) {
                        return None$.MODULE$;
                    }
                    return new Some((Object)InputStreamIO$.MODULE$.readBytes(is));
                });
            } else {
                Iterator it = this.classPath().iterator().map((Function1 & Serializable)path -> {
                    ZipFile zf = this.zipFile((Path)path);
                    return new Tuple2(path, (Object)zf);
                }).flatMap((Function1 & Serializable)x$4 -> {
                    Tuple2 tuple2 = x$4;
                    if (tuple2 != null) {
                        ZipFile zf = (ZipFile)tuple2._2();
                        return Option$.MODULE$.apply((Object)zf.getEntry(name)).iterator().map((Function1 & Serializable)entry -> (byte[])this.metabrowse$server$MetabrowseServer$State$$$outer().metabrowse$server$MetabrowseServer$$withInputStream((Function0<InputStream>)(Function0 & Serializable)() -> zf.getInputStream((ZipEntry)entry), (Function1 & Serializable)x$3 -> InputStreamIO$.MODULE$.readBytes(x$3)));
                    }
                    throw new MatchError((Object)tuple2);
                });
                option = it.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)State.$anonfun$source$8(x$5)));
            }
            Option bytesOpt = option;
            return bytesOpt.map((Function1 & Serializable)x$6 -> new String((byte[])x$6, StandardCharsets.UTF_8));
        }

        @Override
        public void close() {
            CollectionConverters$.MODULE$.SetHasAsScala(this.zipFiles().entrySet()).asScala().toVector().foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)State.$anonfun$close$1(this, entry)));
        }

        public State copy(OnDemandSymbolIndex index, Seq<Path> classPath, Global global, Sourcepath sourcepath) {
            return new State(this.metabrowse$server$MetabrowseServer$State$$$outer(), index, classPath, global, sourcepath);
        }

        public OnDemandSymbolIndex copy$default$1() {
            return this.index();
        }

        public Seq<Path> copy$default$2() {
            return this.classPath();
        }

        public Global copy$default$3() {
            return this.global();
        }

        public Sourcepath copy$default$4() {
            return this.sourcepath();
        }

        public String productPrefix() {
            return "State";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.index();
                }
                case 1: {
                    return this.classPath();
                }
                case 2: {
                    return this.global();
                }
                case 3: {
                    return this.sourcepath();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "index";
                }
                case 1: {
                    return "classPath";
                }
                case 2: {
                    return "global";
                }
                case 3: {
                    return "sourcepath";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            if (((State)object).metabrowse$server$MetabrowseServer$State$$$outer() != this.metabrowse$server$MetabrowseServer$State$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            OnDemandSymbolIndex onDemandSymbolIndex = this.index();
            OnDemandSymbolIndex onDemandSymbolIndex2 = state.index();
            if (onDemandSymbolIndex == null) {
                if (onDemandSymbolIndex2 != null) {
                    return false;
                }
            } else if (!onDemandSymbolIndex.equals(onDemandSymbolIndex2)) return false;
            Seq<Path> seq = this.classPath();
            Seq<Path> seq2 = state.classPath();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Global global = this.global();
            Global global2 = state.global();
            if (global == null) {
                if (global2 != null) {
                    return false;
                }
            } else if (!global.equals(global2)) return false;
            Sourcepath sourcepath = this.sourcepath();
            Sourcepath sourcepath2 = state.sourcepath();
            if (sourcepath == null) {
                if (sourcepath2 != null) {
                    return false;
                }
            } else if (!((Object)sourcepath).equals(sourcepath2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MetabrowseServer metabrowse$server$MetabrowseServer$State$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$source$8(byte[] x$5) {
            return true;
        }

        public static final /* synthetic */ boolean $anonfun$close$1(State $this, Map.Entry entry) {
            ((ZipFile)entry.getValue()).close();
            return $this.zipFiles().remove(entry.getKey(), entry.getValue());
        }

        public State(MetabrowseServer $outer, OnDemandSymbolIndex index, Seq<Path> classPath, Global global, Sourcepath sourcepath) {
            this.index = index;
            this.classPath = classPath;
            this.global = global;
            this.sourcepath = sourcepath;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
            this.zipFiles = new ConcurrentHashMap();
        }
    }
}

