/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.metals.mtags;

import com.thoughtworks.qdox.parser.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.langmeta.inputs.Input;
import org.langmeta.internal.io.FileIO$;
import org.langmeta.internal.io.PathIO$;
import org.langmeta.internal.semanticdb.schema.Database;
import org.langmeta.internal.semanticdb.schema.Document;
import org.langmeta.internal.semanticdb.schema.ResolvedName;
import org.langmeta.internal.semanticdb.schema.ResolvedSymbol;
import org.langmeta.io.AbsolutePath;
import org.langmeta.io.Fragment;
import org.langmeta.io.RelativePath;
import org.langmeta.io.RelativePath$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.mutable.ParArray;
import scala.collection.parallel.mutable.ParArray$;
import scala.math.Ordering;
import scala.meta.metals.mtags.JavaMtags$;
import scala.meta.metals.mtags.MtagsIndexer;
import scala.meta.metals.mtags.ScalaMtags$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Sorting$;
import scala.util.control.NonFatal$;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;

public final class Mtags$ {
    public static Mtags$ MODULE$;

    static {
        new Mtags$();
    }

    public void index(List<AbsolutePath> classpath, Function1<RelativePath, Object> shouldIndex, Function1<Document, BoxedUnit> callback) {
        ParArray<Fragment> fragments = this.allClasspathFragments(classpath, shouldIndex);
        AtomicInteger totalIndexedFiles = new AtomicInteger();
        AtomicInteger totalIndexedLines = new AtomicInteger();
        long start = System.nanoTime();
        DecimalFormat decimal = new DecimalFormat("###,###");
        int N = fragments.length();
        scribe.package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Indexing ", " source files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)N)})), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/metals/mtags/Mtags.scala", "scala.meta.metals.mtags.Mtags", (Option)new Some((Object)"index"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)82)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)16)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
        fragments.foreach((Function1 & java.io.Serializable & Serializable)fragment -> {
            Mtags$.$anonfun$index$3(this, shouldIndex, callback, fragments, totalIndexedFiles, totalIndexedLines, start, decimal, N, fragment);
            return BoxedUnit.UNIT;
        });
        Mtags$.reportProgress$1(totalIndexedFiles.get(), fragments, totalIndexedLines, start, decimal, N);
        scribe.package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed indexing ", " files with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{decimal.format(totalIndexedFiles.get())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"total ", " lines of code"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{decimal.format(totalIndexedLines.get())})), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/metals/mtags/Mtags.scala", "scala.meta.metals.mtags.Mtags", (Option)new Some((Object)"index"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)101)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)16)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
    }

    public Database indexDatabase(List<AbsolutePath> classpath, Function1<RelativePath, Object> shouldIndex) {
        Builder buffer = List$.MODULE$.newBuilder();
        this.index(classpath, shouldIndex, (Function1<Document, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)doc -> {
            buffer.$plus$eq((Object)doc);
            return BoxedUnit.UNIT;
        });
        return new Database((Seq)buffer.result());
    }

    public Document index(String filename, String contents) {
        return this.index(new Input.VirtualFile(filename, contents));
    }

    public Document index(Fragment fragment) {
        String base = ((Object)fragment.base().toNIO().getFileName()).toString();
        URI uri = this.isZip(base) || this.isJar(base) ? new URI(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jar:", "!/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fragment.base().toURI().normalize(), fragment.name().toString().replace('\\', '/')}))) : fragment.uri();
        String contents = new String(FileIO$.MODULE$.readAllBytes(uri), StandardCharsets.UTF_8);
        return this.index(new Input.VirtualFile(uri.toString(), contents));
    }

    public Document index(Input.VirtualFile input) {
        MtagsIndexer mtagsIndexer;
        scribe.package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Trace$.MODULE$, Level.Trace$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Indexing ", " with length ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input.path(), BoxesRunTime.boxToInteger((int)input.value().length())})), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/metals/mtags/Mtags.scala", "scala.meta.metals.mtags.Mtags", (Option)new Some((Object)"index"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)139)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)17)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
        if (this.isScala(input.path())) {
            mtagsIndexer = ScalaMtags$.MODULE$.index(input);
        } else if (this.isJava(input.path())) {
            mtagsIndexer = JavaMtags$.MODULE$.index(input);
        } else {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown file extension ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input.path()})));
        }
        MtagsIndexer indexer = mtagsIndexer;
        Tuple2<List<ResolvedName>, List<ResolvedSymbol>> tuple2 = indexer.index();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List names = (List)tuple2._1();
        List symbols = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)names, (Object)symbols);
        Tuple2 tuple23 = tuple22;
        List names2 = (List)tuple23._1();
        List symbols2 = (List)tuple23._2();
        return new Document(input.path(), input.value(), indexer.language(), (Seq)names2, (Seq)Nil$.MODULE$, (Seq)symbols2, (Seq)Nil$.MODULE$);
    }

    public Function1<RelativePath, Object> index$default$2() {
        return (Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Mtags$.$anonfun$index$default$2$1(x$1));
    }

    public Function1<RelativePath, Object> indexDatabase$default$2() {
        return (Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Mtags$.$anonfun$indexDatabase$default$2$1(x$2));
    }

    private boolean canIndex(String path) {
        return this.isScala(path) || this.isJava(path);
    }

    private boolean canUnzip(String path) {
        return this.isJar(path) || this.isZip(path);
    }

    private boolean isJar(String path) {
        return path.endsWith(".jar");
    }

    private boolean isZip(String path) {
        return path.endsWith(".zip");
    }

    private boolean isJava(String path) {
        return path.endsWith(".java");
    }

    private boolean isScala(String path) {
        return path.endsWith(".scala");
    }

    public boolean scala$meta$metals$mtags$Mtags$$isScala(Path path) {
        String string = PathIO$.MODULE$.extension(path);
        String string2 = "scala";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private ParArray<Fragment> allClasspathFragments(List<AbsolutePath> classpath, Function1<RelativePath, Object> shouldIndex) {
        Combiner buf = ParArray$.MODULE$.newBuilder();
        classpath.foreach((Function1 & java.io.Serializable & Serializable)base -> {
            Path path;
            if (base.isDirectory()) {
                path = Files.walkFileTree(base.toNIO(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(shouldIndex, buf, base){
                    private final Function1 shouldIndex$2;
                    private final Combiner buf$1;
                    private final AbsolutePath base$1;

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        block0: {
                            if (!Mtags$.MODULE$.scala$meta$metals$mtags$Mtags$$isScala(file)) break block0;
                            Mtags$.scala$meta$metals$mtags$Mtags$$add$1(new Fragment(this.base$1, RelativePath$.MODULE$.apply(this.base$1.toNIO().relativize(file))), this.shouldIndex$2, this.buf$1);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    {
                        this.shouldIndex$2 = shouldIndex$2;
                        this.buf$1 = buf$1;
                        this.base$1 = base$1;
                    }
                });
                return path;
            } else if (base.isFile()) {
                if (!MODULE$.canUnzip(base.toString())) throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Obtained non-jar file ", ". Expected directory or *.jar file."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base})));
                Mtags$.exploreJar$1(base, shouldIndex, buf);
                path = BoxedUnit.UNIT;
                return path;
            } else {
                scribe.package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base})), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/metals/mtags/Mtags.scala", "scala.meta.metals.mtags.Mtags", (Option)new Some((Object)"allClasspathFragments"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)236)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)20)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                path = BoxedUnit.UNIT;
            }
            return path;
        });
        ParArray result = (ParArray)buf.result();
        Sorting$.MODULE$.stableSort((Seq)result.arrayseq(), (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(Fragment.class)), package$.MODULE$.Ordering().by((Function1 & java.io.Serializable & Serializable)fragment -> BoxesRunTime.boxToInteger((int)Mtags$.$anonfun$allClasspathFragments$4(fragment)), (Ordering)Ordering.Int$.MODULE$));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private int countLines(String string) {
        void var3_3;
        int lines = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            ++lines;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final long elapsed$1(long start$1) {
        void var2_1;
        long result = TimeUnit.SECONDS.convert(System.nanoTime() - start$1, TimeUnit.NANOSECONDS);
        return result == 0L ? 1L : var2_1;
    }

    private final void updateTotalLines$1(Document doc, AtomicInteger totalIndexedLines$1) {
        totalIndexedLines$1.addAndGet(this.countLines(doc.contents()));
    }

    private static final void reportProgress$1(int indexedFiles, ParArray fragments$1, AtomicInteger totalIndexedLines$1, long start$1, DecimalFormat decimal$1, int N$1) {
        if (indexedFiles < 100) {
            return;
        }
        int percentage = (int)((double)indexedFiles / (double)N$1 * (double)100);
        String loc = decimal$1.format((long)totalIndexedLines$1.get() / Mtags$.elapsed$1(start$1));
        scribe.package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Progress ", "%, ", " files indexed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)percentage), decimal$1.format(indexedFiles)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"out of total ", " (", " loc/s)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{decimal$1.format(fragments$1.length()), loc})), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/metals/mtags/Mtags.scala", "scala.meta.metals.mtags.Mtags.index", (Option)new Some((Object)"reportProgress"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)77)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)18)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
    }

    public static final /* synthetic */ void $anonfun$index$3(Mtags$ $this, Function1 shouldIndex$1, Function1 callback$1, ParArray fragments$1, AtomicInteger totalIndexedFiles$1, AtomicInteger totalIndexedLines$1, long start$1, DecimalFormat decimal$1, int N$1, Fragment fragment) {
        try {
            int indexedFiles = totalIndexedFiles$1.incrementAndGet();
            if (indexedFiles % 200 == 0) {
                Mtags$.reportProgress$1(indexedFiles, fragments$1, totalIndexedLines$1, start$1, decimal$1, N$1);
            }
            if (BoxesRunTime.unboxToBoolean((Object)shouldIndex$1.apply((Object)fragment.name()))) {
                Document doc = MODULE$.index(fragment);
                $this.updateTotalLines$1(doc, totalIndexedLines$1);
                callback$1.apply((Object)doc);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof scala.meta.parsers.ParseException ? true : throwable2 instanceof ParseException;
            if (bl) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                scribe.package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error indexing ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fragment.name()})), (Loggable)Loggable.StringLoggable$.MODULE$, Option$.MODULE$.apply((Object)e), "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/metals/mtags/Mtags.scala", "scala.meta.metals.mtags.Mtags", (Option)new Some((Object)"index"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)97)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)23)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$index$default$2$1(RelativePath x$1) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$indexDatabase$default$2$1(RelativePath x$2) {
        return true;
    }

    public static final void scala$meta$metals$mtags$Mtags$$add$1(Fragment fragment, Function1 shouldIndex$2, Combiner buf$1) {
        block0: {
            if (!BoxesRunTime.unboxToBoolean((Object)shouldIndex$2.apply((Object)fragment.name()))) break block0;
            buf$1.$plus$eq((Object)fragment);
        }
    }

    private static final void exploreJar$1(AbsolutePath base, Function1 shouldIndex$2, Combiner buf$1) {
        try (InputStream stream = Files.newInputStream(base.toNIO(), new OpenOption[0]);){
            try (ZipInputStream zip = new ZipInputStream(stream);){
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    if (!entry.getName().endsWith("/") && MODULE$.canIndex(entry.getName())) {
                        Mtags$.scala$meta$metals$mtags$Mtags$$add$1(new Fragment(base, RelativePath$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(entry.getName())).stripPrefix("/"))), shouldIndex$2, buf$1);
                    }
                    entry = zip.getNextEntry();
                }
            }
            catch (IOException ex) {
                scribe.package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> ex.getMessage(), (Loggable)Loggable.StringLoggable$.MODULE$, Option$.MODULE$.apply((Object)ex), "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/metals/mtags/Mtags.scala", "scala.meta.metals.mtags.Mtags.$anonfun", (Option)new Some((Object)"exploreJar"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)207)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)25)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            }
        }
    }

    public static final /* synthetic */ int $anonfun$allClasspathFragments$4(Fragment fragment) {
        String string = PathIO$.MODULE$.extension(fragment.name().toNIO());
        int n = "scala".equals(string) ? 1 : ("java".equals(string) ? 2 : 3);
        return n;
    }

    private Mtags$() {
        MODULE$ = this;
    }
}

