/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.metals.sbtserver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.CancelableFuture;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import org.langmeta.io.AbsolutePath;
import org.scalasbt.ipcsocket.UnixDomainSocket;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.meta.jsonrpc.BaseProtocolMessage$;
import scala.meta.jsonrpc.Endpoint;
import scala.meta.jsonrpc.JsonRpcClient;
import scala.meta.jsonrpc.LanguageClient;
import scala.meta.jsonrpc.LanguageServer;
import scala.meta.jsonrpc.Services;
import scala.meta.jsonrpc.Services$;
import scala.meta.lsp.PublishDiagnostics;
import scala.meta.lsp.TextDocument$;
import scala.meta.lsp.Window$;
import scala.meta.metals.ActiveJson$;
import scala.meta.metals.Configuration;
import scala.meta.metals.MissingActiveJson;
import scala.meta.metals.SbtInitializeParams;
import scala.meta.metals.SbtInitializeParams$;
import scala.meta.metals.sbtserver.Sbt$;
import scala.meta.metals.sbtserver.SbtServer;
import scala.meta.metals.sbtserver.SbtServer$ActiveJson$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.Logger$;
import scribe.LoggerSupport;

public final class SbtServer$
implements Serializable {
    public static SbtServer$ MODULE$;

    static {
        new SbtServer$();
    }

    private Task<Left<String, Nothing$>> fail(String message) {
        return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)message));
    }

    public Option<String> readVersion(AbsolutePath cwd) {
        Properties props = new Properties();
        AbsolutePath path = cwd.resolve("project").resolve("build.properties");
        if (path.isFile()) {
            try (InputStream input = Files.newInputStream(path.toNIO(), new OpenOption[0]);){
                props.load(input);
            }
        }
        return Option$.MODULE$.apply((Object)props.getProperty("sbt.version"));
    }

    public Task<Either<String, SbtServer>> connect(AbsolutePath cwd, Services services, Scheduler scheduler) {
        return Task$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> MODULE$.openSocketConnection(cwd)).flatMap((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            boolean bl = false;
            Left left = null;
            Either either = x0$1;
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                Throwable err = (Throwable)left.value();
                if (err instanceof MissingActiveJson) {
                    MissingActiveJson missingActiveJson = (MissingActiveJson)err;
                    return MODULE$.fail(missingActiveJson.getMessage());
                }
            }
            if (bl && left.value() instanceof IOException) {
                return MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to establish connection with sbt server. "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do you have an active sbt 1.1+ session?"})).s((Seq)Nil$.MODULE$));
            }
            if (bl) {
                Throwable err = (Throwable)left.value();
                String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected error opening connection to sbt server"})).s((Seq)Nil$.MODULE$);
                scribe.package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> msg, (Loggable)Loggable.StringLoggable$.MODULE$, Option$.MODULE$.apply((Object)err), "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/metals/sbtserver/SbtServer.scala", "scala.meta.metals.sbtserver.SbtServer", (Option)new Some((Object)"connect"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)100)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)21)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                return MODULE$.fail(msg + ". Check .metals/metals.log");
            }
            if (!(either instanceof Right)) throw new MatchError((Object)either);
            Right right = (Right)either;
            UnixDomainSocket socket = (UnixDomainSocket)right.value();
            LanguageClient client = new LanguageClient(socket.getOutputStream(), (LoggerSupport)Logger$.MODULE$.root());
            Observable messages = BaseProtocolMessage$.MODULE$.fromInputStream(socket.getInputStream(), (LoggerSupport)Logger$.MODULE$.root());
            LanguageServer server = new LanguageServer(messages, client, services, scheduler, (LoggerSupport)Logger$.MODULE$.root());
            CancelableFuture runningServer = server.startTask().doOnCancel(Task$.MODULE$.eval((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> socket.close())).runAsync(scheduler);
            Task initialize = client.request((Endpoint)Sbt$.MODULE$.initialize(), (Object)new SbtInitializeParams(SbtInitializeParams$.MODULE$.apply$default$1()));
            return initialize.map((Function1 & java.io.Serializable & Serializable)x$1 -> package$.MODULE$.Right().apply((Object)new SbtServer((JsonRpcClient)client, (CancelableFuture<BoxedUnit>)runningServer)));
        });
    }

    public Services forwardingServices(JsonRpcClient editorClient, Function0<Configuration> config) {
        return Services$.MODULE$.empty((LoggerSupport)Logger$.MODULE$.root()).notification((Endpoint)Window$.MODULE$.logMessage(), (Function1 & java.io.Serializable & Serializable)msg -> {
            editorClient.notify((Endpoint)Window$.MODULE$.logMessage(), (Object)msg);
            return BoxedUnit.UNIT;
        }).notification(TextDocument$.MODULE$.publishDiagnostics(), (Function1 & java.io.Serializable & Serializable)msg -> {
            SbtServer$.$anonfun$forwardingServices$2(editorClient, config, msg);
            return BoxedUnit.UNIT;
        });
    }

    public Either<Throwable, UnixDomainSocket> openSocketConnection(AbsolutePath cwd) {
        AbsolutePath path = SbtServer$ActiveJson$.MODULE$.apply(cwd);
        return (path.isFile() ? package$.MODULE$.Right().apply((Object)Files.readAllBytes(path.toNIO())) : package$.MODULE$.Left().apply((Object)new MissingActiveJson(path))).flatMap((Function1 & java.io.Serializable & Serializable)bytes -> io.circe.jawn.package$.MODULE$.parseByteBuffer(ByteBuffer.wrap(bytes)).flatMap((Function1 & java.io.Serializable & Serializable)parsed -> parsed.as(ActiveJson$.MODULE$.decodeActiveJson()).flatMap((Function1 & java.io.Serializable & Serializable)activeJson -> Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> URI.create(activeJson.uri())).toEither().flatMap((Function1 & java.io.Serializable & Serializable)uri -> {
            Left left;
            String string = uri.getScheme();
            if ("local".equals(string)) {
                scribe.package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connecting to sbt server socket ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri.getPath()})), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/metals/sbtserver/SbtServer.scala", "scala.meta.metals.sbtserver.SbtServer.$anonfun", (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)179)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)22)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                left = Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> new UnixDomainSocket(uri.getPath())).toEither();
            } else {
                left = package$.MODULE$.Left().apply((Object)new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported scheme ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string}))));
            }
            return left.map((Function1 & java.io.Serializable & Serializable)socket -> socket);
        }))));
    }

    public SbtServer apply(JsonRpcClient client, CancelableFuture<BoxedUnit> runningServer) {
        return new SbtServer(client, runningServer);
    }

    public Option<Tuple2<JsonRpcClient, CancelableFuture<BoxedUnit>>> unapply(SbtServer x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.client(), x$0.runningServer()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$forwardingServices$2(JsonRpcClient editorClient$1, Function0 config$1, PublishDiagnostics msg) {
        block0: {
            if (!((Configuration)config$1.apply()).sbt().diagnostics().enabled()) break block0;
            editorClient$1.notify(TextDocument$.MODULE$.publishDiagnostics(), (Object)msg);
        }
    }

    private SbtServer$() {
        MODULE$ = this;
    }
}

