/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.builds;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.meta.inputs.Input;
import scala.meta.internal.builds.SbtBuildTool;
import scala.meta.internal.builds.SbtBuildTool$PluginDetails$;
import scala.meta.internal.metals.AdjustLspData;
import scala.meta.internal.metals.AdjustedLspData$;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.UserConfiguration;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxesRunTime;

public final class SbtBuildTool$
implements Serializable {
    public static SbtBuildTool$ MODULE$;
    private final String name;
    private final String firstVersionWithBsp;

    static {
        new SbtBuildTool$();
    }

    public String name() {
        return this.name;
    }

    public String firstVersionWithBsp() {
        return this.firstVersionWithBsp;
    }

    public void writeSinglePlugin(AbsolutePath projectDir, SbtBuildTool.PluginDetails plugin) {
        block0: {
            boolean pluginFileShouldChange;
            byte[] bytes = this.sbtPlugin(plugin).getBytes(StandardCharsets.UTF_8);
            projectDir.toFile().mkdirs();
            AbsolutePath metalsPluginFile = projectDir.resolve("metals.sbt");
            boolean bl = pluginFileShouldChange = !metalsPluginFile.isFile() || !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(metalsPluginFile.readAllBytes())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(bytes));
            if (!pluginFileShouldChange) break block0;
            Files.write(metalsPluginFile.toNIO(), bytes, new OpenOption[0]);
        }
    }

    public void writeSbtMetalsPlugins(AbsolutePath workspace) {
        AbsolutePath mainMeta = workspace.resolve("project");
        AbsolutePath metaMeta = workspace.resolve("project").resolve("project");
        this.writeSinglePlugin(mainMeta, this.metalsPluginDetails());
        this.writeSinglePlugin(metaMeta, this.jdiToolsPluginDetails());
    }

    public SbtBuildTool.PluginDetails scala$meta$internal$builds$SbtBuildTool$$bloopPluginDetails(String version) {
        None$ resolver = this.isSnapshotVersion(version) ? new Some((Object)"Resolver.bintrayRepo(\"scalacenter\", \"releases\")") : None$.MODULE$;
        return SbtBuildTool$PluginDetails$.MODULE$.apply((Seq<String>)((Seq)new .colon.colon((Object)"This file enables sbt-bloop to create bloop config files.", (List)Nil$.MODULE$)), new StringBuilder(34).append("\"ch.epfl.scala\" % \"sbt-bloop\" % \"").append(version).append("\"").toString(), (Option<String>)resolver);
    }

    private SbtBuildTool.PluginDetails metalsPluginDetails() {
        None$ resolver = this.isSnapshotVersion(BuildInfo$.MODULE$.metalsVersion()) ? new Some((Object)"\"Sonatype OSS Snapshots\" at \"https://oss.sonatype.org/content/repositories/snapshots\"") : None$.MODULE$;
        return SbtBuildTool$PluginDetails$.MODULE$.apply((Seq<String>)((Seq)new .colon.colon((Object)"This file enables semantic information to be produced by sbt.", (List)new .colon.colon((Object)"It also adds support for debugging using the Debug Adapter Protocol", (List)Nil$.MODULE$))), new StringBuilder(35).append("\"org.scalameta\" % \"sbt-metals\" % \"").append(BuildInfo$.MODULE$.metalsVersion()).append("\"").toString(), (Option<String>)resolver);
    }

    private SbtBuildTool.PluginDetails jdiToolsPluginDetails() {
        return SbtBuildTool$PluginDetails$.MODULE$.apply((Seq<String>)((Seq)new .colon.colon((Object)"This file makes sure that the JDI tools are in the sbt classpath.", (List)new .colon.colon((Object)"JDI tools are used by the debug adapter server.", (List)Nil$.MODULE$))), new StringBuilder(43).append("\"org.scala-debugger\" % \"sbt-jdi-tools\" % \"").append(BuildInfo$.MODULE$.sbtJdiToolsVersion()).append("\"").toString(), (Option<String>)None$.MODULE$);
    }

    private boolean isSnapshotVersion(String version) {
        return version.contains("+");
    }

    private String sbtPlugin(SbtBuildTool.PluginDetails plugin) {
        String resolvers = (String)plugin.resolver().map((Function1 & java.io.Serializable & Serializable)r -> new StringBuilder(13).append("resolvers += ").append((String)r).toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
        String description = plugin.description().mkString("// ", "\n// ", "");
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("|// DO NOT EDIT! This file is auto-generated.\n        |").append(description).append("\n        |").append(resolvers).append("\n        |addSbtPlugin(").append(plugin.artifact()).append(")\n        |").toString())).stripMargin();
    }

    public boolean isSbtRelatedPath(AbsolutePath workspace, AbsolutePath path) {
        String filename;
        Path project = workspace.toNIO().resolve("project");
        Set isToplevel = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{workspace.toNIO(), project, project.resolve("project")}));
        return isToplevel.apply((Object)path.toNIO().getParent()) && ((filename = ((Object)path.toNIO().getFileName()).toString()).endsWith("build.properties") || filename.endsWith(".sbt") || filename.endsWith(".scala"));
    }

    public SbtBuildTool apply(AbsolutePath workspace, Function0<UserConfiguration> userConfig) {
        Option version = this.loadVersion(workspace).map((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.toString());
        return new SbtBuildTool((Option<String>)version, userConfig);
    }

    public Option<String> loadVersion(AbsolutePath workspace) {
        None$ none$;
        Properties props = new Properties();
        AbsolutePath buildproperties = workspace.resolve("project").resolve("build.properties");
        if (!buildproperties.isFile()) {
            none$ = None$.MODULE$;
        } else {
            try (InputStream in = Files.newInputStream(buildproperties.toNIO(), new OpenOption[0]);){
                props.load(in);
            }
            none$ = Option$.MODULE$.apply((Object)props.getProperty("sbt.version"));
        }
        return none$;
    }

    public Tuple3<Input.VirtualFile, Position, AdjustLspData> sbtInputPosAdjustment(Input.VirtualFile originInput, Seq<String> autoImports, String uri, Position position) {
        int appendLineSize = autoImports.size();
        String x$1 = this.prependAutoImports(originInput.value(), autoImports);
        String x$2 = originInput.copy$default$1();
        Input.VirtualFile modifiedInput = originInput.copy(x$2, x$1);
        Position pos2 = new Position(appendLineSize + position.getLine(), position.getCharacter());
        AdjustLspData adjustLspData = AdjustedLspData$.MODULE$.create((Function1<Position, Position>)(Function1 & java.io.Serializable & Serializable)pos -> new Position(pos.getLine() - appendLineSize, pos.getCharacter()), (Function1<Location, Object>)(Function1 & java.io.Serializable & Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)SbtBuildTool$.$anonfun$sbtInputPosAdjustment$2(loc)));
        return new Tuple3((Object)modifiedInput, (Object)pos2, (Object)adjustLspData);
    }

    public String prependAutoImports(String text, Seq<String> autoImports) {
        String prepend = autoImports.mkString("", "\n", "\n");
        return new StringBuilder(0).append(prepend).append(text).toString();
    }

    public SbtBuildTool apply(Option<String> workspaceVersion, Function0<UserConfiguration> userConfig) {
        return new SbtBuildTool(workspaceVersion, userConfig);
    }

    public Option<Tuple2<Option<String>, Function0<UserConfiguration>>> unapply(SbtBuildTool x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.workspaceVersion(), x$0.userConfig()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$sbtInputPosAdjustment$2(Location loc) {
        return !MetalsEnrichments$.MODULE$.XtensionStringDoc(loc.getUri()).isSbt();
    }

    private SbtBuildTool$() {
        MODULE$ = this;
        this.name = "sbt";
        this.firstVersionWithBsp = "1.4.1";
    }
}

