/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.watcher.hashing;

import java.math.BigInteger;
import java.util.zip.Checksum;

public class Murmur3F
implements Checksum {
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;
    private final long seed;
    private long h1;
    private long h2;
    private int length;
    private int partialPos;
    private long partialK1;
    private long partialK2;
    private boolean finished;
    private long finishedH1;
    private long finishedH2;

    public Murmur3F() {
        this.seed = 0L;
    }

    public Murmur3F(int n) {
        this.h1 = this.h2 = (this.seed = (long)n & 0xFFFFFFFFL);
    }

    @Override
    public void update(int n) {
        this.finished = false;
        switch (this.partialPos) {
            case 0: {
                this.partialK1 = 0xFF & n;
                break;
            }
            case 1: {
                this.partialK1 |= (long)((0xFF & n) << 8);
                break;
            }
            case 2: {
                this.partialK1 |= (long)((0xFF & n) << 16);
                break;
            }
            case 3: {
                this.partialK1 |= (0xFFL & (long)n) << 24;
                break;
            }
            case 4: {
                this.partialK1 |= (0xFFL & (long)n) << 32;
                break;
            }
            case 5: {
                this.partialK1 |= (0xFFL & (long)n) << 40;
                break;
            }
            case 6: {
                this.partialK1 |= (0xFFL & (long)n) << 48;
                break;
            }
            case 7: {
                this.partialK1 |= (0xFFL & (long)n) << 56;
                break;
            }
            case 8: {
                this.partialK2 = 0xFF & n;
                break;
            }
            case 9: {
                this.partialK2 |= (long)((0xFF & n) << 8);
                break;
            }
            case 10: {
                this.partialK2 |= (long)((0xFF & n) << 16);
                break;
            }
            case 11: {
                this.partialK2 |= (0xFFL & (long)n) << 24;
                break;
            }
            case 12: {
                this.partialK2 |= (0xFFL & (long)n) << 32;
                break;
            }
            case 13: {
                this.partialK2 |= (0xFFL & (long)n) << 40;
                break;
            }
            case 14: {
                this.partialK2 |= (0xFFL & (long)n) << 48;
                break;
            }
            case 15: {
                this.partialK2 |= (0xFFL & (long)n) << 56;
            }
        }
        ++this.partialPos;
        if (this.partialPos == 16) {
            this.applyKs(this.partialK1, this.partialK2);
            this.partialPos = 0;
        }
        ++this.length;
    }

    @Override
    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3;
        this.finished = false;
        while (this.partialPos != 0 && n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
        int n4 = n2 & 0xF;
        int n5 = n + n2 - n4;
        for (n3 = n; n3 < n5; n3 += 16) {
            long l = this.getLongLE(byArray, n3);
            long l2 = this.getLongLE(byArray, n3 + 8);
            this.applyKs(l, l2);
        }
        this.length += n5 - n;
        for (n3 = 0; n3 < n4; ++n3) {
            this.update(byArray[n5 + n3]);
        }
    }

    private void applyKs(long l, long l2) {
        l *= -8663945395140668459L;
        l = Long.rotateLeft(l, 31);
        this.h1 ^= (l *= 5545529020109919103L);
        this.h1 = Long.rotateLeft(this.h1, 27);
        this.h1 += this.h2;
        this.h1 = this.h1 * 5L + 1390208809L;
        l2 *= 5545529020109919103L;
        l2 = Long.rotateLeft(l2, 33);
        this.h2 ^= (l2 *= -8663945395140668459L);
        this.h2 = Long.rotateLeft(this.h2, 31);
        this.h2 += this.h1;
        this.h2 = this.h2 * 5L + 944331445L;
    }

    private void checkFinished() {
        if (!this.finished) {
            this.finished = true;
            this.finishedH1 = this.h1;
            this.finishedH2 = this.h2;
            if (this.partialPos > 0) {
                long l;
                if (this.partialPos > 8) {
                    l = this.partialK2 * 5545529020109919103L;
                    l = Long.rotateLeft(l, 33);
                    this.finishedH2 ^= (l *= -8663945395140668459L);
                }
                l = this.partialK1 * -8663945395140668459L;
                l = Long.rotateLeft(l, 31);
                this.finishedH1 ^= (l *= 5545529020109919103L);
            }
            this.finishedH1 ^= (long)this.length;
            this.finishedH2 ^= (long)this.length;
            this.finishedH1 += this.finishedH2;
            this.finishedH2 += this.finishedH1;
            this.finishedH1 = this.fmix64(this.finishedH1);
            this.finishedH2 = this.fmix64(this.finishedH2);
            this.finishedH1 += this.finishedH2;
            this.finishedH2 += this.finishedH1;
        }
    }

    private long fmix64(long l) {
        l ^= l >>> 33;
        l *= -49064778989728563L;
        l ^= l >>> 33;
        l *= -4265267296055464877L;
        l ^= l >>> 33;
        return l;
    }

    @Override
    public long getValue() {
        this.checkFinished();
        return this.finishedH1;
    }

    public long getValueHigh() {
        this.checkFinished();
        return this.finishedH2;
    }

    public BigInteger getValueBigInteger() {
        byte[] byArray = this.getValueBytesBigEndian();
        return new BigInteger(1, byArray);
    }

    public String getValueHexString() {
        this.checkFinished();
        return this.getPaddedHexString(this.finishedH2) + this.getPaddedHexString(this.finishedH1);
    }

    private String getPaddedHexString(long l) {
        String string = Long.toHexString(l);
        while (string.length() < 16) {
            string = '0' + string;
        }
        return string;
    }

    public byte[] getValueBytesBigEndian() {
        int n;
        this.checkFinished();
        byte[] byArray = new byte[16];
        for (n = 0; n < 8; ++n) {
            byArray[n] = (byte)(this.finishedH2 >>> 56 - n * 8 & 0xFFL);
        }
        for (n = 0; n < 8; ++n) {
            byArray[8 + n] = (byte)(this.finishedH1 >>> 56 - n * 8 & 0xFFL);
        }
        return byArray;
    }

    public byte[] getValueBytesLittleEndian() {
        int n;
        this.checkFinished();
        byte[] byArray = new byte[16];
        for (n = 0; n < 8; ++n) {
            byArray[n] = (byte)(this.finishedH1 >>> n * 8 & 0xFFL);
        }
        for (n = 0; n < 8; ++n) {
            byArray[8 + n] = (byte)(this.finishedH2 >>> n * 8 & 0xFFL);
        }
        return byArray;
    }

    @Override
    public void reset() {
        this.h1 = this.h2 = this.seed;
        this.length = 0;
        this.partialPos = 0;
        this.finished = false;
        this.partialK2 = 0L;
        this.partialK1 = 0L;
        this.finishedH2 = 0L;
        this.finishedH1 = 0L;
    }

    private long getLongLE(byte[] byArray, int n) {
        return (long)(byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16) | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | (long)byArray[n + 7] << 56;
    }
}

