/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileWriter;
import java.net.URLEncoder;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.meta.internal.metals.Buffers;
import scala.meta.internal.metals.ClientCommands$;
import scala.meta.internal.metals.DefinitionProvider;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.HtmlBuilder;
import scala.meta.internal.metals.Icons;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ServerCommands$;
import scala.meta.internal.metals.StacktraceAnalyzer$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001\u0002\u000f\u001e\u0001\u0019B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\"B\"\u0001\t\u0003!\u0005\"B&\u0001\t\u0003a\u0005\"\u0002/\u0001\t\u0003i\u0006\"\u00021\u0001\t\u0003\t\u0007\"\u0002:\u0001\t\u0013\u0019\bbBA\u0002\u0001\u0011%\u0011Q\u0001\u0005\b\u0003C\u0001A\u0011BA\u0012\u0011\u0019\u0001\u0007\u0001\"\u0001\u00026!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA%\u0001\u0011%\u00111\n\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\ty\u0007\u0001C\u0005\u0003cBq!a\u001e\u0001\t\u0013\tI\bC\u0004\u0002~\u0001!I!a \t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u0011Q\u0012\u0001\u0005\n\u0005=\u0005bBAJ\u0001\u0011%\u0011Q\u0013\u0005\b\u0003;\u0003A\u0011BAP\u000f\u001d\t\u0019+\bE\u0001\u0003K3a\u0001H\u000f\t\u0002\u0005\u001d\u0006BB\"\u001a\t\u0003\tI\u000bC\u0004\u0002,f!\t!!,\u0003%M#\u0018mY6ue\u0006\u001cW-\u00118bYfTXM\u001d\u0006\u0003=}\ta!\\3uC2\u001c(B\u0001\u0011\"\u0003!Ig\u000e^3s]\u0006d'B\u0001\u0012$\u0003\u0011iW\r^1\u000b\u0003\u0011\nQa]2bY\u0006\u001c\u0001a\u0005\u0002\u0001OA\u0011\u0001&K\u0007\u0002G%\u0011!f\t\u0002\u0007\u0003:L(+\u001a4\u0002\u0013]|'o[:qC\u000e,\u0007CA\u00171\u001b\u0005q#BA\u0018\"\u0003\tIw.\u0003\u00022]\ta\u0011IY:pYV$X\rU1uQ\u00069!-\u001e4gKJ\u001c\bC\u0001\u001b6\u001b\u0005i\u0012B\u0001\u001c\u001e\u0005\u001d\u0011UO\u001a4feN\f!\u0003Z3gS:LG/[8o!J|g/\u001b3feB\u0011A'O\u0005\u0003uu\u0011!\u0003R3gS:LG/[8o!J|g/\u001b3fe\u0006)\u0011nY8ogB\u0011A'P\u0005\u0003}u\u0011Q!S2p]N\fqcY8n[\u0006tGm]%o\u0011RlGnU;qa>\u0014H/\u001a3\u0011\u0005!\n\u0015B\u0001\"$\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDCB#G\u000f\"K%\n\u0005\u00025\u0001!)1F\u0002a\u0001Y!)!G\u0002a\u0001g!)qG\u0002a\u0001q!)1H\u0002a\u0001y!)qH\u0002a\u0001\u0001\u0006q\u0011M\\1msj,7i\\7nC:$GCA'[!\rAc\nU\u0005\u0003\u001f\u000e\u0012aa\u00149uS>t\u0007CA)Y\u001b\u0005\u0011&BA*U\u0003\u0015a7\u000f\u001d\u001bk\u0015\t)f+A\u0004fG2L\u0007o]3\u000b\u0003]\u000b1a\u001c:h\u0013\tI&K\u0001\u000bFq\u0016\u001cW\u000f^3D_6l\u0017M\u001c3QCJ\fWn\u001d\u0005\u00067\u001e\u0001\r\u0001U\u0001\u000eG>lW.\u00198e!\u0006\u0014\u0018-\\:\u0002!%\u001c8\u000b^1dWR\u0013\u0018mY3GS2,GC\u0001!_\u0011\u0015y\u0006\u00021\u0001-\u0003\u0011\u0001\u0018\r\u001e5\u0002!M$\u0018mY6ue\u0006\u001cW\rT3og\u0016\u001cHC\u00012r!\r\u00197N\u001c\b\u0003I&t!!\u001a5\u000e\u0003\u0019T!aZ\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0013B\u00016$\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001\\7\u0003\u0007M+\u0017O\u0003\u0002kGA\u0011\u0011k\\\u0005\u0003aJ\u0013\u0001bQ8eK2+gn\u001d\u0005\u0006?&\u0001\r\u0001L\u0001\u0013e\u0016\fGm\u0015;bG.$(/Y2f\r&dW\rF\u0002u\u0003\u0003\u00012\u0001\u000b(v!\r\u0019g\u000f_\u0005\u0003o6\u0014A\u0001T5tiB\u0011\u00110 \b\u0003un\u0004\"!Z\u0012\n\u0005q\u001c\u0013A\u0002)sK\u0012,g-\u0003\u0002\u007f\u007f\n11\u000b\u001e:j]\u001eT!\u0001`\u0012\t\u000b}S\u0001\u0019\u0001\u0017\u0002\u001dM,G\u000fV8MS:,7\u000b^1siR1\u0011qAA\u0007\u0003/\u00012\u0001KA\u0005\u0013\r\tYa\t\u0002\u0005+:LG\u000fC\u0004\u0002\u0010-\u0001\r!!\u0005\u0002\u00151Lg.\u001a(v[\n,'\u000fE\u0002)\u0003'I1!!\u0006$\u0005\rIe\u000e\u001e\u0005\b\u00033Y\u0001\u0019AA\u000e\u0003\r\u0001xn\u001d\t\u0004#\u0006u\u0011bAA\u0010%\nA\u0001k\\:ji&|g.\u0001\u0010uef<U\r\u001e'j]\u0016tU/\u001c2fe\u001a\u0013x.\\*uC\u000e\\GO]1dKR!\u0011QEA\u0019!\u0019\t9#!\f\u0002\u00125\u0011\u0011\u0011\u0006\u0006\u0004\u0003W\u0019\u0013\u0001B;uS2LA!a\f\u0002*\t\u0019AK]=\t\r\u0005MB\u00021\u0001y\u0003\u0011a\u0017N\\3\u0015\u0007\t\f9\u0004\u0003\u0004\u0002:5\u0001\r!^\u0001\bG>tG/\u001a8u\u0003Q1\u0017\u000e\\3M_\u000e\fG/[8o\rJ|W\u000eT5oKR!\u0011qHA$!\u0011Ac*!\u0011\u0011\u0007E\u000b\u0019%C\u0002\u0002FI\u0013\u0001\u0002T8dCRLwN\u001c\u0005\u0007\u0003gq\u0001\u0019\u0001=\u0002'M$(/\u001b9FeJ|'oU5h]&4\u0017.\u001a:\u0015\t\u00055\u00131\f\t\u0005\u0003\u001f\nI&\u0004\u0002\u0002R)!\u00111KA+\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0013\u0001\u00026bm\u0006L1A`A)\u0011\u0019\t\u0019d\u0004a\u0001q\u0006AR.Y6f\u000f>$x\u000eT8dCRLwN\\\"pI\u0016dUM\\:\u0015\u000b9\f\t'!\u001a\t\u000f\u0005\r\u0004\u00031\u0001\u0002B\u0005AAn\\2bi&|g\u000eC\u0004\u0002hA\u0001\r!!\u001b\u0002\u000bI\fgnZ3\u0011\u0007E\u000bY'C\u0002\u0002nI\u0013QAU1oO\u0016\f\u0011#\u00198bYfTXm\u0015;bG.$&/Y2f)\ri\u00151\u000f\u0005\u0007\u0003k\n\u0002\u0019\u0001=\u0002\u0015M$\u0018mY6ue\u0006\u001cW-A\u000bnC.,wi\u001c;p\u0007>lW.\u00198e!\u0006\u0014\u0018-\\:\u0015\u0007A\u000bY\bC\u0004\u0002dI\u0001\r!!\u0011\u00021Q\u0014\u0018pU3u\u0019&tWM\u0012:p[N#\u0018mY6ue\u0006\u001cW\r\u0006\u0004\u0002B\u0005\u0005\u00151\u0011\u0005\b\u0003G\u001a\u0002\u0019AA!\u0011\u0019\t\u0019d\u0005a\u0001q\u0006q1/_7c_24%o\\7MS:,G\u0003BAE\u0003\u0017\u00032\u0001\u000b(y\u0011\u0019\t\u0019\u0004\u0006a\u0001q\u0006)R.Y6f\u0011RlGnQ8n[\u0006tG\rU1sC6\u001cHc\u0001)\u0002\u0012\"1\u0011QO\u000bA\u0002a\fAcZ8u_2{7-\u0019;j_:,6/\u001b8h+JLG#\u0002=\u0002\u0018\u0006m\u0005BBAM-\u0001\u0007\u00010A\u0002ve&Dq!a\r\u0017\u0001\u0004\t\t\"A\bqCJ\u001cXMS:p]B\u000b'/Y7t)\u0011\tI)!)\t\u000bm;\u0002\u0019\u0001)\u0002%M#\u0018mY6ue\u0006\u001cW-\u00118bYfTXM\u001d\t\u0003ie\u0019\"!G\u0014\u0015\u0005\u0005\u0015\u0016\u0001\u0005;p)>\u0004H.\u001a<fYNKXNY8m)\r)\u0018q\u0016\u0005\u0007\u0003c[\u0002\u0019\u0001=\u0002\u0011MLXNY8m\u0013:\u0004")
public class StacktraceAnalyzer {
    private final AbsolutePath workspace;
    private final Buffers buffers;
    private final DefinitionProvider definitionProvider;
    private final Icons icons;
    private final boolean commandsInHtmlSupported;

    public static List<String> toToplevelSymbol(String string) {
        return StacktraceAnalyzer$.MODULE$.toToplevelSymbol(string);
    }

    public Option<ExecuteCommandParams> analyzeCommand(ExecuteCommandParams commandParams) {
        return this.parseJsonParams(commandParams).flatMap((Function1 & java.io.Serializable & Serializable)stacktrace -> this.analyzeStackTrace((String)stacktrace));
    }

    public boolean isStackTraceFile(AbsolutePath path) {
        AbsolutePath absolutePath = path;
        AbsolutePath absolutePath2 = this.workspace.resolve(Directories$.MODULE$.stacktrace());
        return !(absolutePath != null ? !absolutePath.equals(absolutePath2) : absolutePath2 != null);
    }

    public Seq<CodeLens> stacktraceLenses(AbsolutePath path) {
        return (Seq)this.readStacktraceFile(path).map((Function1 & java.io.Serializable & Serializable)content -> this.stacktraceLenses((List<String>)content)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> (Seq)Nil$.MODULE$);
    }

    private Option<List<String>> readStacktraceFile(AbsolutePath path) {
        return this.buffers.get(path).map((Function1 & java.io.Serializable & Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$1)).split('\n'))).toList());
    }

    private void setToLineStart(int lineNumber, Position pos) {
        pos.setLine(lineNumber);
        pos.setCharacter(0);
    }

    private Try<Object> tryGetLineNumberFromStacktrace(String line) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> Predef$.MODULE$.Integer2int(Integer.valueOf(line.substring(line.indexOf(":") + 1, line.indexOf(")")))) - 1);
    }

    public Seq<CodeLens> stacktraceLenses(List<String> content) {
        return ((scala.collection.immutable.Seq)((TraversableLike)((TraversableLike)content.zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1 & java.io.Serializable & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)StacktraceAnalyzer.$anonfun$stacktraceLenses$3(check$ifrefutable$1))).map((Function1 & java.io.Serializable & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String line = (String)tuple2._1();
            String cleanedLine = this.stripErrorSignifier(line);
            Tuple2 tuple22 = new Tuple2((Object)tuple2, (Object)cleanedLine);
            return tuple22;
        }, List$.MODULE$.canBuildFrom())).withFilter((Function1 & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StacktraceAnalyzer.$anonfun$stacktraceLenses$5(x$4))).flatMap((Function1 & java.io.Serializable & Serializable)x$6 -> {
            String cleanedLine;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x$6;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    cleanedLine = (String)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int row = tuple2._2$mcI$sp();
            Iterable iterable = Option$.MODULE$.option2Iterable(this.fileLocationFromLine(cleanedLine).map((Function1 & java.io.Serializable & Serializable)location -> {
                Range range = new Range(new Position(row, 0), new Position(row, 0));
                return new Tuple2(location, (Object)range);
            }).map((Function1 & java.io.Serializable & Serializable)x$5 -> {
                Tuple2 tuple2 = x$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Location location = (Location)tuple2._1();
                Range range = (Range)tuple2._2();
                CodeLens codeLens = this.makeGotoLocationCodeLens(location, range);
                return codeLens;
            }));
            return iterable;
        }, List$.MODULE$.canBuildFrom())).toSeq();
    }

    public Option<Location> fileLocationFromLine(String line) {
        return this.symbolFromLine(line).flatMap((Function1 & java.io.Serializable & Serializable)symbol -> StacktraceAnalyzer$.MODULE$.toToplevelSymbol((String)symbol).collectFirst(Function$.MODULE$.unlift((Function1 & java.io.Serializable & Serializable)s -> this.findLocationForSymbol$1((String)s))).map((Function1 & java.io.Serializable & Serializable)location -> this.trySetLineFromStacktrace((Location)location, line)));
    }

    private String stripErrorSignifier(String line) {
        return line.replaceFirst("(\\[E\\]|\\[error\\])", "").trim();
    }

    private CodeLens makeGotoLocationCodeLens(Location location, Range range) {
        return new CodeLens(range, new Command(new StringBuilder(5).append(this.icons.findsuper()).append(" open").toString(), ServerCommands$.MODULE$.GotoPosition().id(), (java.util.List)MetalsEnrichments$.MODULE$.seqAsJavaListConverter(new .colon.colon((Object)location, (List)new .colon.colon((Object)Boolean.TRUE, (List)Nil$.MODULE$))).asJava()), null);
    }

    private Option<ExecuteCommandParams> analyzeStackTrace(String stacktrace) {
        Some some;
        if (this.commandsInHtmlSupported) {
            some = new Some((Object)this.makeHtmlCommandParams(stacktrace));
        } else {
            AbsolutePath path = this.workspace.resolve(Directories$.MODULE$.stacktrace());
            File pathFile = path.toFile();
            String pathStr = pathFile.toString();
            pathFile.createNewFile();
            try (FileWriter fw = new FileWriter(pathStr);){
                fw.write(new StringBuilder(6).append("/*\n").append(stacktrace).append("\n*/").toString());
            }
            Position fileStartPos = new Position(0, 0);
            Range range = new Range(fileStartPos, fileStartPos);
            Location stackTraceLocation = new Location(pathStr, range);
            some = new Some((Object)this.makeGotoCommandParams(stackTraceLocation));
        }
        return some;
    }

    private ExecuteCommandParams makeGotoCommandParams(Location location) {
        return new ExecuteCommandParams(ClientCommands$.MODULE$.GotoLocation().id(), (java.util.List)MetalsEnrichments$.MODULE$.seqAsJavaListConverter(new .colon.colon((Object)location, (List)new .colon.colon((Object)Boolean.TRUE, (List)Nil$.MODULE$))).asJava());
    }

    private Location trySetLineFromStacktrace(Location location, String line) {
        Try<Object> lineNumberOpt = this.tryGetLineNumberFromStacktrace(line);
        lineNumberOpt.foreach((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)lineNumber -> {
            this.setToLineStart(lineNumber, location.getRange().getStart());
            this.setToLineStart(lineNumber, location.getRange().getEnd());
        });
        return location;
    }

    private Option<String> symbolFromLine(String line) {
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> line.substring(line.indexOf("at ") + 3, line.indexOf("("))).toOption();
    }

    private ExecuteCommandParams makeHtmlCommandParams(String stacktrace) {
        HtmlBuilder qual$1 = new HtmlBuilder();
        String x$1 = "h3";
        String x$2 = qual$1.element$default$2();
        Function1 & java.io.Serializable & Serializable x$3 = (Function1 & java.io.Serializable & Serializable)x$7 -> {
            x$7.text("Stacktrace");
            return BoxedUnit.UNIT;
        };
        String output = qual$1.element(x$1, x$2, (Function1<HtmlBuilder, BoxedUnit>)x$3).call((Function1<HtmlBuilder, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)builder -> {
            this.htmlStack$1(builder, stacktrace);
            return BoxedUnit.UNIT;
        }).render();
        return new ExecuteCommandParams("metals-show-stacktrace", (java.util.List)MetalsEnrichments$.MODULE$.seqAsJavaListConverter(new .colon.colon((Object)output, (List)Nil$.MODULE$)).asJava());
    }

    private String gotoLocationUsingUri(String uri, int line) {
        String param = new StringBuilder(10).append("[\"").append(uri).append("\",").append(line).append(",true]").toString();
        return new StringBuilder(29).append("command:metals.goto-path-uri?").append(URLEncoder.encode(param)).toString();
    }

    private Option<String> parseJsonParams(ExecuteCommandParams commandParams) {
        return Option$.MODULE$.apply((Object)commandParams.getArguments()).flatMap((Function1 & java.io.Serializable & Serializable)args -> ((Option)((PartialFunction)MetalsEnrichments$.MODULE$.asScalaBufferConverter(args).asScala()).lift().apply((Object)BoxesRunTime.boxToInteger((int)0))).collect((PartialFunction)new Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                JsonPrimitive jsonPrimitive;
                A1 A1 = x1;
                Object object = A1 instanceof JsonPrimitive ? (jsonPrimitive = (JsonPrimitive)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof JsonPrimitive;
                return bl;
            }
        }).withFilter((Function1 & java.io.Serializable & Serializable)arg -> BoxesRunTime.boxToBoolean((boolean)arg.isString())).map((Function1 & java.io.Serializable & Serializable)arg -> {
            String stacktrace = arg.getAsString();
            return new Tuple2(arg, (Object)stacktrace);
        }).map((Function1 & java.io.Serializable & Serializable)x$8 -> {
            String stacktrace;
            Tuple2 tuple2 = x$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = stacktrace = (String)tuple2._2();
            return string;
        }));
    }

    public static final /* synthetic */ boolean $anonfun$stacktraceLenses$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$stacktraceLenses$5(Tuple2 x$4) {
        String cleanedLine;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$4;
                if (tuple2 == null) break block2;
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                cleanedLine = (String)tuple2._2();
                if (tuple22 != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        boolean bl = cleanedLine.startsWith("at ");
        return bl;
    }

    private final Option findLocationForSymbol$1(String s) {
        return ((TraversableLike)MetalsEnrichments$.MODULE$.asScalaBufferConverter(this.definitionProvider.fromSymbol(s, (Option<AbsolutePath>)None$.MODULE$)).asScala()).headOption();
    }

    private final void htmlStack$1(HtmlBuilder builder, String stacktrace$1) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(stacktrace$1)).split('\n'))).foreach((Function1 & java.io.Serializable & Serializable)line -> {
            HtmlBuilder htmlBuilder;
            if (line.contains("at ")) {
                HtmlBuilder htmlBuilder2;
                Option<Location> option = this.fileLocationFromLine((String)line);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Location location = (Location)some.value();
                    htmlBuilder2 = builder.text("at ").link(this.gotoLocationUsingUri(location.getUri(), location.getRange().getStart().getLine()), line.substring(line.indexOf("at ") + 3));
                } else if (None$.MODULE$.equals(option)) {
                    htmlBuilder2 = builder.raw((String)line);
                } else {
                    throw new MatchError(option);
                }
                htmlBuilder = htmlBuilder2;
            } else {
                htmlBuilder = builder.raw((String)line);
            }
            return builder.raw("<br>");
        });
    }

    public StacktraceAnalyzer(AbsolutePath workspace, Buffers buffers, DefinitionProvider definitionProvider, Icons icons, boolean commandsInHtmlSupported) {
        this.workspace = workspace;
        this.buffers = buffers;
        this.definitionProvider = definitionProvider;
        this.icons = icons;
        this.commandsInHtmlSupported = commandsInHtmlSupported;
    }
}

