/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.meta.inputs.Input;
import scala.meta.internal.metals.Classfile$;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.Messages$WorkspaceSymbolDependencies$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.SemanticdbDefinition;
import scala.meta.internal.metals.SemanticdbDefinition$;
import scala.meta.internal.metals.WorkspaceSymbolQuery;
import scala.meta.internal.mtags.GlobalSymbolIndex;
import scala.meta.internal.mtags.Symbol;
import scala.meta.internal.mtags.Symbol$;
import scala.meta.internal.mtags.SymbolDefinition;
import scala.meta.internal.semanticdb.Scala;
import scala.meta.io.AbsolutePath;
import scala.meta.pc.SymbolSearchVisitor;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\f\u0019\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u001dy\u0005A1A\u0005\nACa!\u0018\u0001!\u0002\u0013\t\u0006b\u00020\u0001\u0005\u0004%I\u0001\u0015\u0005\u0007?\u0002\u0001\u000b\u0011B)\t\u000f\u0001\u0004!\u0019!C\u0005C\"1!\u000f\u0001Q\u0001\n\tDQa\u001d\u0001\u0005\u0002QDqA \u0001C\u0002\u0013%q\u0010\u0003\u0005\u0002\b\u0001\u0001\u000b\u0011BA\u0001\u0011%\tY\u0002\u0001b\u0001\n\u0013\ti\u0002\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\u0010\u0011\u001d\t\t\u0004\u0001C\u0005\u0003gAq!a\u0013\u0001\t\u0003\ni\u0005C\u0004\u0002X\u0001!\t%!\u0017\t\u000f\u00055\u0005\u0001\"\u0011\u0002\u0010\"9\u0011Q\u0013\u0001\u0005B\u0005]\u0005bBAM\u0001\u0011%\u00111\u0014\u0002\u0017/>\u00148n\u001d9bG\u0016\u001cV-\u0019:dQZK7/\u001b;pe*\u0011\u0011DG\u0001\u0007[\u0016$\u0018\r\\:\u000b\u0005ma\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005uq\u0012\u0001B7fi\u0006T\u0011aH\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001!\u0005\u0005\u0002$M5\tAE\u0003\u0002&9\u0005\u0011\u0001oY\u0005\u0003O\u0011\u00121cU=nE>d7+Z1sG\"4\u0016n]5u_J\f\u0011b^8sWN\u0004\u0018mY3\u0011\u0005)jS\"A\u0016\u000b\u00051b\u0012AA5p\u0013\tq3F\u0001\u0007BEN|G.\u001e;f!\u0006$\b.A\u0003rk\u0016\u0014\u0018\u0010\u0005\u00022e5\t\u0001$\u0003\u000241\t!rk\u001c:lgB\f7-Z*z[\n|G.U;fef\fQ\u0001^8lK:\u0004\"AN \u000e\u0003]R!\u0001O\u001d\u0002\u000f)\u001cxN\u001c:qG*\u0011!hO\u0001\u0006YN\u0004HG\u001b\u0006\u0003yu\nq!Z2mSB\u001cXMC\u0001?\u0003\ry'oZ\u0005\u0003\u0001^\u0012QbQ1oG\u0016d7\t[3dW\u0016\u0014\u0018!B5oI\u0016D\bCA\"G\u001b\u0005!%BA#\u001b\u0003\u0015iG/Y4t\u0013\t9EIA\tHY>\u0014\u0017\r\\*z[\n|G.\u00138eKb\fa\u0001P5oSRtD#\u0002&L\u00196s\u0005CA\u0019\u0001\u0011\u0015AS\u00011\u0001*\u0011\u0015yS\u00011\u00011\u0011\u0015!T\u00011\u00016\u0011\u0015\tU\u00011\u0001C\u000351'o\\7X_J\\7\u000f]1dKV\t\u0011\u000bE\u0002S/fk\u0011a\u0015\u0006\u0003)V\u000bA!\u001e;jY*\ta+\u0001\u0003kCZ\f\u0017B\u0001-T\u0005%\t%O]1z\u0019&\u001cH\u000f\u0005\u0002[76\t\u0011(\u0003\u0002]s\t\t2+_7c_2LeNZ8s[\u0006$\u0018n\u001c8\u0002\u001d\u0019\u0014x.\\,pe.\u001c\b/Y2fA\u0005iaM]8n\u00072\f7o\u001d9bi\"\faB\u001a:p[\u000ec\u0017m]:qCRD\u0007%A\tck\u001a4WM]3e\u00072\f7o\u001d9bi\",\u0012A\u0019\t\u0004%^\u001b\u0007\u0003\u00023fO\u001el\u0011AH\u0005\u0003Mz\u0011a\u0001V;qY\u0016\u0014\u0004C\u00015p\u001d\tIW\u000e\u0005\u0002k=5\t1N\u0003\u0002mA\u00051AH]8pizJ!A\u001c\u0010\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0018O\u0001\u0004TiJLgn\u001a\u0006\u0003]z\t!CY;gM\u0016\u0014X\rZ\"mCN\u001c\b/\u0019;iA\u0005Q\u0011\r\u001c7SKN,H\u000e^:\u0015\u0003U\u00042A^>Z\u001d\t9\u0018P\u0004\u0002kq&\tq$\u0003\u0002{=\u00059\u0001/Y2lC\u001e,\u0017B\u0001?~\u0005\r\u0019V-\u001d\u0006\u0003uz\tABY=OC6,G*\u001a8hi\",\"!!\u0001\u0013\r\u0005\r\u0011\u0011BA\u000b\r\u0019\t)A\u0004\u0001\u0002\u0002\taAH]3gS:,W.\u001a8u}\u0005i!-\u001f(b[\u0016dUM\\4uQ\u0002\u0002B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f)\u0016\u0001\u00027b]\u001eLA!a\u0005\u0002\u000e\t1qJ\u00196fGR\u0004BAUA\f3&\u0019\u0011\u0011D*\u0003\u0015\r{W\u000e]1sCR|'/A\u0005jgZK7/\u001b;fIV\u0011\u0011q\u0004\t\u0006\u0003C\tY#K\u0007\u0003\u0003GQA!!\n\u0002(\u00059Q.\u001e;bE2,'bAA\u0015=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u00121\u0005\u0002\u0004'\u0016$\u0018AC5t-&\u001c\u0018\u000e^3eA\u0005QA-\u001a4j]&$\u0018n\u001c8\u0015\u0011\u0005U\u0012\u0011IA#\u0003\u0013\u0002R\u0001ZA\u001c\u0003wI1!!\u000f\u001f\u0005\u0019y\u0005\u000f^5p]B\u00191)!\u0010\n\u0007\u0005}BI\u0001\tTs6\u0014w\u000e\u001c#fM&t\u0017\u000e^5p]\"1\u00111I\tA\u0002\u001d\f1\u0001]6h\u0011\u0019\t9%\u0005a\u0001O\u0006Aa-\u001b7f]\u0006lW\rC\u0003B#\u0001\u0007!)\u0001\ntQ>,H\u000e\u001a,jg&$\b+Y2lC\u001e,G\u0003BA(\u0003+\u00022\u0001ZA)\u0013\r\t\u0019F\b\u0002\b\u0005>|G.Z1o\u0011\u0019\t\u0019E\u0005a\u0001O\u0006!b/[:ji^{'o[:qC\u000e,7+_7c_2$\"\"a\u0017\u0002b\u0005U\u0014\u0011PAB!\r!\u0017QL\u0005\u0004\u0003?r\"aA%oi\"9\u00111M\nA\u0002\u0005\u0015\u0014\u0001\u00029bi\"\u0004B!a\u001a\u0002r5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'\u0001\u0003gS2,'bAA8+\u0006\u0019a.[8\n\t\u0005M\u0014\u0011\u000e\u0002\u0005!\u0006$\b\u000e\u0003\u0004\u0002xM\u0001\raZ\u0001\u0007gfl'm\u001c7\t\u000f\u0005m4\u00031\u0001\u0002~\u0005!1.\u001b8e!\rQ\u0016qP\u0005\u0004\u0003\u0003K$AC*z[\n|GnS5oI\"9\u0011QQ\nA\u0002\u0005\u001d\u0015!\u0002:b]\u001e,\u0007c\u0001.\u0002\n&\u0019\u00111R\u001d\u0003\u000bI\u000bgnZ3\u0002\u001dYL7/\u001b;DY\u0006\u001c8OZ5mKR1\u00111LAI\u0003'Ca!a\u0011\u0015\u0001\u00049\u0007BBA$)\u0001\u0007q-A\u0006jg\u000e\u000bgnY3mY\u0016$GCAA(\u0003=)\u0007\u0010]1oI\u000ec\u0017m]:gS2,GCBA.\u0003;\u000by\n\u0003\u0004\u0002DY\u0001\ra\u001a\u0005\u0007\u0003\u000f2\u0002\u0019A4")
public class WorkspaceSearchVisitor
extends SymbolSearchVisitor {
    private final AbsolutePath workspace;
    private final WorkspaceSymbolQuery query;
    private final CancelChecker token;
    private final GlobalSymbolIndex index;
    private final ArrayList<SymbolInformation> fromWorkspace;
    private final ArrayList<SymbolInformation> fromClasspath;
    private final ArrayList<Tuple2<String, String>> bufferedClasspath;
    private final Comparator<SymbolInformation> byNameLength;
    private final Set<AbsolutePath> isVisited;

    private ArrayList<SymbolInformation> fromWorkspace() {
        return this.fromWorkspace;
    }

    private ArrayList<SymbolInformation> fromClasspath() {
        return this.fromClasspath;
    }

    private ArrayList<Tuple2<String, String>> bufferedClasspath() {
        return this.bufferedClasspath;
    }

    public Seq<SymbolInformation> allResults() {
        Object object;
        if (this.fromWorkspace().isEmpty()) {
            this.bufferedClasspath().forEach((Consumer<Tuple2<String, String>>)((Consumer<Tuple2>)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String pkg = (String)tuple2._1();
                String name = (String)tuple2._2();
                this.expandClassfile(pkg, name);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }));
        }
        this.fromWorkspace().sort(this.byNameLength());
        this.fromClasspath().sort(this.byNameLength());
        ArrayList<SymbolInformation> result = new ArrayList<SymbolInformation>();
        result.addAll(this.fromWorkspace());
        result.addAll(this.fromClasspath());
        if (!this.bufferedClasspath().isEmpty() && this.fromClasspath().isEmpty()) {
            AbsolutePath dependencies = this.workspace.resolve(Directories$.MODULE$.workspaceSymbol());
            if (!dependencies.isFile()) {
                MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(dependencies).writeText(Messages$WorkspaceSymbolDependencies$.MODULE$.title());
            }
            object = BoxesRunTime.boxToBoolean((boolean)result.add(new SymbolInformation(Messages$WorkspaceSymbolDependencies$.MODULE$.title(), SymbolKind.Event, new Location(dependencies.toURI().toString(), new Range(new Position(0, 0), new Position(0, 0))))));
        } else {
            object = BoxedUnit.UNIT;
        }
        return (Seq)MetalsEnrichments$.MODULE$.asScalaBufferConverter(result).asScala();
    }

    private Comparator<SymbolInformation> byNameLength() {
        return this.byNameLength;
    }

    private Set<AbsolutePath> isVisited() {
        return this.isVisited;
    }

    private Option<SymbolDefinition> definition(String pkg, String filename, GlobalSymbolIndex index) {
        String nme = Classfile$.MODULE$.name(filename);
        Symbol tpe = Symbol$.MODULE$.apply(Scala.Symbols$.MODULE$.Global(pkg, (Scala.Descriptor)new Scala.Descriptor$.Type(nme)));
        return index.definition(tpe).orElse((Function0 & java.io.Serializable & Serializable)() -> {
            Symbol term = Symbol$.MODULE$.apply(Scala.Symbols$.MODULE$.Global(pkg, (Scala.Descriptor)new Scala.Descriptor$.Term(nme)));
            return index.definition(term);
        });
    }

    public boolean shouldVisitPackage(String pkg) {
        return true;
    }

    public int visitWorkspaceSymbol(Path path, String symbol, SymbolKind kind, Range range) {
        Tuple2 tuple2 = Scala.DescriptorParser$.MODULE$.apply(symbol);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Scala.Descriptor desc = (Scala.Descriptor)tuple2._1();
        String owner = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)desc, (Object)owner);
        Tuple2 tuple23 = tuple22;
        Scala.Descriptor desc2 = (Scala.Descriptor)tuple23._1();
        String owner2 = (String)tuple23._2();
        this.fromWorkspace().add(new SymbolInformation(desc2.name().value(), kind, new Location(path.toUri().toString(), range), owner2.replace('/', '.')));
        return 1;
    }

    public int visitClassfile(String pkg, String filename) {
        int n;
        if (this.fromWorkspace().isEmpty() || this.query.isClasspath()) {
            n = this.expandClassfile(pkg, filename);
        } else {
            this.bufferedClasspath().add((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pkg), (Object)filename));
            n = 1;
        }
        return n;
    }

    public boolean isCancelled() {
        return MetalsEnrichments$.MODULE$.XtensionCancelChecker(this.token).isCancelled();
    }

    private int expandClassfile(String pkg, String filename) {
        BooleanRef isHit = BooleanRef.create((boolean)false);
        this.definition(pkg, filename, this.index).withFilter((Function1 & java.io.Serializable & Serializable)defn -> BoxesRunTime.boxToBoolean((boolean)WorkspaceSearchVisitor.$anonfun$expandClassfile$1(this, defn))).foreach((Function1 & java.io.Serializable & Serializable)defn -> {
            WorkspaceSearchVisitor.$anonfun$expandClassfile$2(this, isHit, defn);
            return BoxedUnit.UNIT;
        });
        return isHit.elem ? 1 : 0;
    }

    public static final /* synthetic */ boolean $anonfun$expandClassfile$1(WorkspaceSearchVisitor $this, SymbolDefinition defn) {
        return !$this.isVisited().apply((Object)defn.path());
    }

    public static final /* synthetic */ void $anonfun$expandClassfile$3(WorkspaceSearchVisitor $this, SymbolDefinition defn$1, BooleanRef isHit$1, SemanticdbDefinition semanticDefn) {
        block0: {
            if (!$this.query.matches(semanticDefn.info())) break block0;
            String uri = MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(defn$1.path()).toFileOnDisk($this.workspace).toURI().toString();
            $this.fromClasspath().add(semanticDefn.toLSP(uri));
            isHit$1.elem = true;
        }
    }

    public static final /* synthetic */ void $anonfun$expandClassfile$2(WorkspaceSearchVisitor $this, BooleanRef isHit$1, SymbolDefinition defn) {
        $this.isVisited().$plus$eq((Object)defn.path());
        Input.VirtualFile input = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(defn.path()).toInput();
        SemanticdbDefinition$.MODULE$.foreach(input, defn.dialect(), (Function1 & java.io.Serializable & Serializable)semanticDefn -> {
            WorkspaceSearchVisitor.$anonfun$expandClassfile$3($this, defn, isHit$1, semanticDefn);
            return BoxedUnit.UNIT;
        });
    }

    public WorkspaceSearchVisitor(AbsolutePath workspace, WorkspaceSymbolQuery query, CancelChecker token, GlobalSymbolIndex index) {
        this.workspace = workspace;
        this.query = query;
        this.token = token;
        this.index = index;
        this.fromWorkspace = new ArrayList();
        this.fromClasspath = new ArrayList();
        this.bufferedClasspath = new ArrayList();
        this.byNameLength = new Comparator<SymbolInformation>(null){

            public Comparator<SymbolInformation> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<SymbolInformation> thenComparing(Comparator<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<SymbolInformation> thenComparing(Function<? super SymbolInformation, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<SymbolInformation> thenComparing(Function<? super SymbolInformation, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<SymbolInformation> thenComparingInt(ToIntFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<SymbolInformation> thenComparingLong(ToLongFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<SymbolInformation> thenComparingDouble(ToDoubleFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(SymbolInformation x, SymbolInformation y) {
                return Integer.compare(x.getName().length(), y.getName().length());
            }
        };
        this.isVisited = Set$.MODULE$.empty();
    }
}

