/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.meta.Dialect;
import scala.meta.dialects.package$;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.semver.SemVer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

public final class ScalaVersions$ {
    public static ScalaVersions$ MODULE$;
    private final Set<String> _isDeprecatedScalaVersion;
    private final Set<String> _isSupportedScalaVersion;
    private final Set<String> isLatestScalaVersion;
    private final Regex scalaVersionRegex;

    static {
        new ScalaVersions$();
    }

    public boolean isScala3Milestone(String version) {
        return version.startsWith("3.0.0-M") || version.startsWith("3.0.0-RC");
    }

    public String dropVendorSuffix(String version) {
        return version.replaceAll("-bin-.*", "");
    }

    private Set<String> _isDeprecatedScalaVersion() {
        return this._isDeprecatedScalaVersion;
    }

    private Set<String> _isSupportedScalaVersion() {
        return this._isSupportedScalaVersion;
    }

    public boolean isSupportedScalaVersion(String version) {
        return this._isSupportedScalaVersion().apply((Object)this.dropVendorSuffix(version));
    }

    public boolean isDeprecatedScalaVersion(String version) {
        return this._isDeprecatedScalaVersion().apply((Object)this.dropVendorSuffix(version));
    }

    public boolean isSupportedScalaBinaryVersion(String scalaVersion) {
        return BuildInfo$.MODULE$.supportedScalaBinaryVersions().exists((Function1 & java.io.Serializable & Serializable)binaryVersion -> BoxesRunTime.boxToBoolean((boolean)scalaVersion.startsWith(binaryVersion)));
    }

    public boolean isScala3Version(String scalaVersion) {
        return scalaVersion.startsWith("3.");
    }

    public Set<String> supportedScala3Versions() {
        return ((TraversableOnce)BuildInfo$.MODULE$.supportedScalaVersions().filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ScalaVersions$.MODULE$.isScala3Version(x$1)))).toSet();
    }

    public Set<String> isLatestScalaVersion() {
        return this.isLatestScalaVersion;
    }

    public Option<String> latestBinaryVersionFor(String scalaVersion) {
        String binaryVersion = this.scalaBinaryVersionFromFullVersion(scalaVersion);
        return this.isLatestScalaVersion().find((Function1 & java.io.Serializable & Serializable)latest -> BoxesRunTime.boxToBoolean((boolean)ScalaVersions$.$anonfun$latestBinaryVersionFor$1(binaryVersion, latest)));
    }

    public String recommendedVersion(String scalaVersion) {
        return (String)this.latestBinaryVersionFor(scalaVersion).getOrElse((Function0 & java.io.Serializable & Serializable)() -> MODULE$.isScala3Version(scalaVersion) ? BuildInfo$.MODULE$.scala3() : BuildInfo$.MODULE$.scala212());
    }

    public boolean isFutureVersion(String scalaVersion) {
        return BoxesRunTime.unboxToBoolean((Object)this.latestBinaryVersionFor(scalaVersion).map((Function1 & java.io.Serializable & Serializable)latest -> BoxesRunTime.boxToBoolean((boolean)ScalaVersions$.$anonfun$isFutureVersion$1(scalaVersion, latest))).getOrElse((Function0)(JFunction0.mcZ.sp & java.io.Serializable & Serializable)() -> {
            Set versions = MODULE$.isScala3Version(scalaVersion) ? (Set)MODULE$.isLatestScalaVersion().filter((Function1 & java.io.Serializable & Serializable)scalaVersion -> BoxesRunTime.boxToBoolean((boolean)ScalaVersions$.MODULE$.isScala3Version(scalaVersion))) : (Set)MODULE$.isLatestScalaVersion().filter((Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ScalaVersions$.$anonfun$isFutureVersion$4(x$2)));
            return versions.forall((Function1 & java.io.Serializable & Serializable)ver -> BoxesRunTime.boxToBoolean((boolean)SemVer$.MODULE$.isLaterVersion(ver, scalaVersion)));
        }));
    }

    public boolean isCurrentScalaCompilerVersion(String version) {
        String string = this.dropVendorSuffix(version);
        String string2 = scala.meta.internal.mtags.BuildInfo$.MODULE$.scalaCompilerVersion();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public String scalaBinaryVersionFromFullVersion(String scalaVersion) {
        return this.isScala3Milestone(scalaVersion) ? scalaVersion : (scalaVersion.startsWith("3") ? "3" : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(scalaVersion)).split('.'))).take(2))).mkString("."));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Dialect dialectForScalaVersion(String scalaVersion, boolean includeSource3) {
        String scalaBinaryVersion = this.scalaBinaryVersionFromFullVersion(scalaVersion);
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        String string2 = null;
        String string3 = scalaBinaryVersion;
        if ("2.11".equals(string3)) {
            return package$.MODULE$.Scala211();
        }
        if ("2.12".equals(string3)) {
            bl = true;
            string = string3;
            if (includeSource3) {
                return package$.MODULE$.Scala212Source3();
            }
        }
        if (bl) {
            return package$.MODULE$.Scala212();
        }
        if ("2.13".equals(string3)) {
            bl2 = true;
            string2 = string3;
            if (includeSource3) {
                return package$.MODULE$.Scala213Source3();
            }
        }
        if (bl2) {
            return package$.MODULE$.Scala213();
        }
        if (!string3.startsWith("3")) return package$.MODULE$.Scala213();
        return package$.MODULE$.Scala3();
    }

    private Regex scalaVersionRegex() {
        return this.scalaVersionRegex;
    }

    public String scalaBinaryVersionFromJarName(String filename) {
        String dropEnding = new StringOps(Predef$.MODULE$.augmentString(filename)).stripSuffix(".jar");
        return (String)((TraversableLike)((SeqLike)this.scalaVersionRegex().findAllMatchIn((CharSequence)dropEnding).toList().flatMap((Function1 & java.io.Serializable & Serializable)m -> {
            boolean hasUnderscorePrefix = Option$.MODULE$.apply((Object)m.group(1)).isDefined();
            String major = m.group(2);
            String minor = m.group(3);
            String ending = (String)Option$.MODULE$.apply((Object)m.group(4)).map((Function1 & java.io.Serializable & Serializable)s -> String.valueOf(s)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
            String version = new StringBuilder(1).append(major).append(".").append(minor).append(ending).toString();
            return MODULE$.isSupportedScalaBinaryVersion(version) ? Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)version), (Object)BoxesRunTime.boxToBoolean((boolean)hasUnderscorePrefix)))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, List$.MODULE$.canBuildFrom())).sortBy((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3._2$mcZ$sp()), Ordering.Boolean$.MODULE$.reverse())).headOption().map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String version = (String)tuple2._1();
            String string = MODULE$.scalaBinaryVersionFromFullVersion(version);
            return string;
        }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> BuildInfo$.MODULE$.scala213());
    }

    public Dialect dialectForDependencyJar(String filename) {
        return this.dialectForScalaVersion(this.scalaBinaryVersionFromJarName(filename), true);
    }

    public static final /* synthetic */ boolean $anonfun$latestBinaryVersionFor$1(String binaryVersion$1, String latest) {
        String string = binaryVersion$1;
        String string2 = MODULE$.scalaBinaryVersionFromFullVersion(latest);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isFutureVersion$1(String scalaVersion$3, String latest) {
        String string = latest;
        String string2 = scalaVersion$3;
        return (string == null ? string2 != null : !string.equals(string2)) && SemVer$.MODULE$.isLaterVersion(latest, scalaVersion$3);
    }

    public static final /* synthetic */ boolean $anonfun$isFutureVersion$4(String x$2) {
        return !MODULE$.isScala3Version(x$2);
    }

    private ScalaVersions$() {
        MODULE$ = this;
        this._isDeprecatedScalaVersion = BuildInfo$.MODULE$.deprecatedScalaVersions().toSet();
        this._isSupportedScalaVersion = BuildInfo$.MODULE$.supportedScalaVersions().toSet();
        this.isLatestScalaVersion = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{BuildInfo$.MODULE$.scala212(), BuildInfo$.MODULE$.scala213(), BuildInfo$.MODULE$.scala3()}));
        this.scalaVersionRegex = new StringOps(Predef$.MODULE$.augmentString("(_?)(\\d)\\.(\\d{1,2})(\\.\\d(-(RC|M)\\d)?)?")).r();
    }
}

