/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.formatting;

import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.meta.internal.metals.formatting.IndentOnPaste;
import scala.meta.internal.metals.formatting.IndentOnPaste$FmtOptions$;
import scala.meta.internal.metals.formatting.IndentOnPaste$PastedLine$;
import scala.meta.internal.metals.formatting.RangeFormatter;
import scala.meta.internal.metals.formatting.RangeFormatterParams;
import scala.meta.internal.mtags.MtagsEnrichments$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

public final class IndentOnPaste$
implements RangeFormatter {
    public static IndentOnPaste$ MODULE$;
    private final String noEndClause;
    private final String ifThenClause;
    private final String keywordClause;
    private final String openBraceClause;
    private final String extensionClause;
    private final Regex increaseIndentPatternRegex;
    private final Regex indentRegex;

    static {
        new IndentOnPaste$();
    }

    private String noEndClause() {
        return this.noEndClause;
    }

    private String ifThenClause() {
        return this.ifThenClause;
    }

    private String keywordClause() {
        return this.keywordClause;
    }

    private String openBraceClause() {
        return this.openBraceClause;
    }

    private String extensionClause() {
        return this.extensionClause;
    }

    public Regex increaseIndentPatternRegex() {
        return this.increaseIndentPatternRegex;
    }

    public Regex indentRegex() {
        return this.indentRegex;
    }

    public Option<Object> scala$meta$internal$metals$formatting$IndentOnPaste$$codeStartPosition(String line) {
        return this.indentRegex().findFirstMatchIn((CharSequence)line).map((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.start()));
    }

    private boolean increaseIndentation(String line) {
        return this.increaseIndentPatternRegex().findFirstIn((CharSequence)line).nonEmpty();
    }

    public String scala$meta$internal$metals$formatting$IndentOnPaste$$stringRepeat(char s, int n) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(3).append("%0").append(n).append("d").toString())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})).replace("0", Character.toString(s));
    }

    private String normalizeSpacesAndTabs(String line, IndentOnPaste.FmtOptions opts) {
        String string;
        Option option = this.scala$meta$internal$metals$formatting$IndentOnPaste$$codeStartPosition(line).filter((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$2 -> x$2 > 0);
        if (option instanceof Some) {
            String string2;
            Some some = (Some)option;
            int codeStartPos = BoxesRunTime.unboxToInt((Object)some.value());
            Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(line)).splitAt(codeStartPos);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String indentation = (String)tuple2._1();
            String code = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indentation, (Object)code);
            Tuple2 tuple23 = tuple22;
            String indentation2 = (String)tuple23._1();
            String code2 = (String)tuple23._2();
            char pastedBlank = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(indentation2)).head());
            char c = opts.blank();
            if (pastedBlank == opts.blank()) {
                string2 = line;
            } else if ('\t' == c && pastedBlank == ' ') {
                int tabNum = (int)package$.MODULE$.ceil((double)indentation2.length() / (double)2);
                string2 = new StringBuilder(0).append(this.scala$meta$internal$metals$formatting$IndentOnPaste$$stringRepeat(opts.blank(), tabNum)).append(code2).toString();
            } else {
                string2 = ' ' == c && pastedBlank == '\t' ? new StringBuilder(0).append(this.scala$meta$internal$metals$formatting$IndentOnPaste$$stringRepeat(opts.blank(), opts.tabSize() * indentation2.length())).append(code2).toString() : line;
            }
            string = string2;
        } else if (None$.MODULE$.equals(option)) {
            string = line;
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    @Override
    public Option<List<TextEdit>> contribute(RangeFormatterParams rangeFormatterParams) {
        None$ none$;
        FormattingOptions formattingOptions = rangeFormatterParams.formattingOptions();
        scala.meta.inputs.Position startPos = rangeFormatterParams.startPos();
        scala.meta.inputs.Position endPos = rangeFormatterParams.endPos();
        String[] splitLines = rangeFormatterParams.splitLines();
        Position rangeStart = MtagsEnrichments$.MODULE$.XtensionMetaPosition(startPos).toLSP().getStart();
        rangeStart.setCharacter(0);
        int realEndColumn = endPos.endLine() < new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splitLines)).size() ? new StringOps(Predef$.MODULE$.augmentString(splitLines[endPos.endLine()])).size() : endPos.endColumn();
        Range pastedRange = new Range(rangeStart, new Position(endPos.endLine(), realEndColumn));
        int startLine = MtagsEnrichments$.MODULE$.XtensionMetaPosition(startPos).toLSP().getStart().getLine();
        int endLine = MtagsEnrichments$.MODULE$.XtensionMetaPosition(endPos).toLSP().getEnd().getLine();
        IndentOnPaste.FmtOptions opts = formattingOptions.isInsertSpaces() ? IndentOnPaste$FmtOptions$.MODULE$.spaces(formattingOptions.getTabSize()) : IndentOnPaste$FmtOptions$.MODULE$.tabs();
        String[] pastedLines = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splitLines)).slice(startLine, endLine + 1))).map((Function1 & java.io.Serializable & Serializable)x$4 -> MODULE$.normalizeSpacesAndTabs((String)x$4, opts), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] prePastedLines = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splitLines)).take(startLine))).reverse();
        int currentIndentationLevel = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])prePastedLines)).find((Function1 & java.io.Serializable & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)IndentOnPaste$.$anonfun$contribute$2(t))).flatMap((Function1 & java.io.Serializable & Serializable)line -> MODULE$.scala$meta$internal$metals$formatting$IndentOnPaste$$codeStartPosition((String)line).map((Function1 & java.io.Serializable & Serializable)indentation -> IndentOnPaste$.$anonfun$contribute$4(line, BoxesRunTime.unboxToInt((Object)indentation))).map((Function1 & java.io.Serializable & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)IndentOnPaste$.$anonfun$contribute$5(opts, x$5)))).getOrElse((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0));
        String[] formatted = this.processLines(currentIndentationLevel, pastedLines, opts, MtagsEnrichments$.MODULE$.XtensionMetaPosition(startPos).toLSP().getStart());
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])formatted)).nonEmpty()) {
            TextEdit textEdit = new TextEdit(pastedRange, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])formatted)).mkString(System.lineSeparator()));
            Some some = new Some((Object)Nil$.MODULE$.$colon$colon((Object)textEdit));
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private String[] processLines(int expectedIndent, String[] lines, IndentOnPaste.FmtOptions opts, Position start2) {
        IndentOnPaste.PastedLine[] converted = (IndentOnPaste.PastedLine[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String line = (String)tuple2._1();
                int n = tuple2._2$mcI$sp();
                if (0 == n) {
                    return IndentOnPaste$PastedLine$.MODULE$.firstOrEmpty(line, start2.getCharacter());
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String line = (String)tuple2._1();
            return IndentOnPaste$PastedLine$.MODULE$.plainOrEmpty(line);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(IndentOnPaste.PastedLine.class)));
        int[] indents = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])converted)).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends IndentOnPaste.PastedLine, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IndentOnPaste.PastedLine.NonEmpty) {
                    IndentOnPaste.PastedLine.NonEmpty nonEmpty = (IndentOnPaste.PastedLine.NonEmpty)A1;
                    object = BoxesRunTime.boxToInteger((int)nonEmpty.pastedIndent());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(IndentOnPaste.PastedLine x1) {
                IndentOnPaste.PastedLine pastedLine = x1;
                boolean bl = pastedLine instanceof IndentOnPaste.PastedLine.NonEmpty;
                return bl;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        int overIndent = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indents)).nonEmpty() ? BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indents)).min((Ordering)Ordering.Int$.MODULE$)) : 0;
        String[] idented = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])converted)).map((Function1 & java.io.Serializable & Serializable)x$7 -> x$7.reformat(expectedIndent, overIndent, opts), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        int lastIdx = idented.length - 1;
        Range.Inclusive range = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), lastIdx);
        int trimmedStart = BoxesRunTime.unboxToInt((Object)range.dropWhile((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$8 -> converted[x$8].isEmpty()).headOption().getOrElse((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0));
        int trimmedEnd = BoxesRunTime.unboxToInt((Object)range.reverse().dropWhile((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$9 -> converted[x$9].isEmpty()).headOption().getOrElse((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> lastIdx)) + 1;
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])idented)).slice(trimmedStart, trimmedEnd);
    }

    public static final /* synthetic */ boolean $anonfun$contribute$2(String t) {
        String trimmed = t.trim();
        return new StringOps(Predef$.MODULE$.augmentString(trimmed)).nonEmpty() && !trimmed.startsWith("|");
    }

    public static final /* synthetic */ Tuple2 $anonfun$contribute$4(String line$1, int indentation) {
        boolean nextIncrease = MODULE$.increaseIndentation(line$1);
        return new Tuple2.mcIZ.sp(indentation, nextIncrease);
    }

    public static final /* synthetic */ int $anonfun$contribute$5(IndentOnPaste.FmtOptions opts$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int indentation = tuple2._1$mcI$sp();
        boolean nextIncrease = tuple2._2$mcZ$sp();
        int n = nextIncrease ? indentation + opts$1.tabSize() : indentation;
        return n;
    }

    private IndentOnPaste$() {
        MODULE$ = this;
        RangeFormatter.$init$(this);
        this.noEndClause = "((<!\\bend\\b\\s*?)\\b(if|while|for|match|try))";
        this.ifThenClause = "(\\bif\\s+(?!.*?\\bthen\\b.*?$)[^\\s]*?)";
        this.keywordClause = "\\b(then|else|do|catch|finally|yield|case)";
        this.openBraceClause = "(^.*\\{[^}\"']*$)";
        this.extensionClause = "extension\\s*((\\(|\\[).*(\\)|\\]))+";
        this.increaseIndentPatternRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(25).append("(").append(this.noEndClause()).append("|").append(this.ifThenClause()).append("|").append(this.keywordClause()).append("|").append(this.extensionClause()).append("|=|=>|<-|=>>|:)\\s*?$|").append(this.openBraceClause()).toString())).r();
        this.indentRegex = new StringOps(Predef$.MODULE$.augmentString("\\S")).r();
    }
}

