/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.remotels;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import geny.Writable$;
import java.net.URI;
import javax.net.ssl.SSLContext;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import requests.Cert;
import requests.Compress;
import requests.RequestAuth;
import requests.RequestBlob;
import requests.RequestBlob$;
import requests.Response;
import requests.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.meta.internal.metals.Buffers;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.DefinitionResult;
import scala.meta.internal.metals.JsonParser$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsServerConfig;
import scala.meta.internal.metals.ReferencesResult;
import scala.meta.internal.metals.UserConfiguration;
import scala.meta.internal.mtags.MD5$;
import scala.meta.internal.remotels.RemoteLocationResult;
import scala.meta.internal.semanticdb.Scala;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.io.AbsolutePath;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;
import scribe.Loggable;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\t\u0013\u0001mA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tU\u0001\u0011\t\u0011)A\u0005W!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b1B \t\u000b\u0015\u0003A\u0011\u0001$\t\u000fA\u0003!\u0019!C\u0001#\"1\u0001\f\u0001Q\u0001\nICQ!\u0017\u0001\u0005\u0002iCQ\u0001\u0019\u0001\u0005\u0002\u0005DQ\u0001\u001e\u0001\u0005\u0002UDQA\u001f\u0001\u0005\u0002mDq!a\u0003\u0001\t\u0013\ti\u0001C\u0004\u0002L\u0001!I!!\u0014\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\n!\"+Z7pi\u0016d\u0015M\\4vC\u001e,7+\u001a:wKJT!a\u0005\u000b\u0002\u0011I,Wn\u001c;fYNT!!\u0006\f\u0002\u0011%tG/\u001a:oC2T!a\u0006\r\u0002\t5,G/\u0019\u0006\u00023\u0005)1oY1mC\u000e\u00011C\u0001\u0001\u001d!\tib$D\u0001\u0019\u0013\ty\u0002D\u0001\u0004B]f\u0014VMZ\u0001\no>\u00148n\u001d9bG\u0016\u00042!\b\u0012%\u0013\t\u0019\u0003DA\u0005Gk:\u001cG/[8oaA\u0011Q\u0005K\u0007\u0002M)\u0011qEF\u0001\u0003S>L!!\u000b\u0014\u0003\u0019\u0005\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5\u0002\u0015U\u001cXM]\"p]\u001aLw\rE\u0002\u001eE1\u0002\"!\f\u0019\u000e\u00039R!a\f\u000b\u0002\r5,G/\u00197t\u0013\t\tdFA\tVg\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\fAb]3sm\u0016\u00148i\u001c8gS\u001e\u0004\"!\f\u001b\n\u0005Ur#AE'fi\u0006d7oU3sm\u0016\u00148i\u001c8gS\u001e\fqAY;gM\u0016\u00148\u000f\u0005\u0002.q%\u0011\u0011H\f\u0002\b\u0005V4g-\u001a:t\u00031\u0011W/\u001b7e)\u0006\u0014x-\u001a;t!\tiC(\u0003\u0002>]\ta!)^5mIR\u000b'oZ3ug\u0006\u0011Qm\u0019\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005b\t!bY8oGV\u0014(/\u001a8u\u0013\t!\u0015I\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"baR&M\u001b:{EC\u0001%K!\tI\u0005!D\u0001\u0013\u0011\u0015qt\u0001q\u0001@\u0011\u0015\u0001s\u00011\u0001\"\u0011\u0015Qs\u00011\u0001,\u0011\u0015\u0011t\u00011\u00014\u0011\u00151t\u00011\u00018\u0011\u0015Qt\u00011\u0001<\u0003\u001d!\u0018.\\3pkR,\u0012A\u0015\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u0006\u000b\u0001\u0002Z;sCRLwN\\\u0005\u0003/R\u0013\u0001\u0002R;sCRLwN\\\u0001\ti&lWm\\;uA\u0005\u0001\u0012n]#oC\ndW\r\u001a$peB\u000bG\u000f\u001b\u000b\u00037z\u0003\"!\b/\n\u0005uC\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006?*\u0001\r\u0001J\u0001\u0005a\u0006$\b.\u0001\nsK\u001a,'/\u001a8dKN\u0014En\\2lS:<GC\u00012i!\ri2-Z\u0005\u0003Ib\u0011aa\u00149uS>t\u0007CA\u0017g\u0013\t9gF\u0001\tSK\u001a,'/\u001a8dKN\u0014Vm];mi\")\u0011n\u0003a\u0001U\u00061\u0001/\u0019:b[N\u0004\"a\u001b:\u000e\u00031T!!\u001c8\u0002\u000b1\u001c\b\u000f\u000e6\u000b\u0005=\u0004\u0018aB3dY&\u00048/\u001a\u0006\u0002c\u0006\u0019qN]4\n\u0005Md'a\u0004*fM\u0016\u0014XM\\2f!\u0006\u0014\u0018-\\:\u0002\u0015I,g-\u001a:f]\u000e,7\u000f\u0006\u0002wsB\u0019\u0001i\u001e2\n\u0005a\f%A\u0002$viV\u0014X\rC\u0003j\u0019\u0001\u0007!.\u0001\u0006eK\u001aLg.\u001b;j_:$2\u0001`A\u0002!\r\u0001u/ \t\u0004;\rt\bCA\u0017\u0000\u0013\r\t\tA\f\u0002\u0011\t\u00164\u0017N\\5uS>t'+Z:vYRDa![\u0007A\u0002\u0005\u0015\u0001cA6\u0002\b%\u0019\u0011\u0011\u00027\u00035Q+\u0007\u0010\u001e#pGVlWM\u001c;Q_NLG/[8o!\u0006\u0014\u0018-\\:\u0002\u001f\tdwnY6j]\u001e\u0014V-];fgR,B!a\u0004\u0002\u001aQ!\u0011\u0011CA\u0016!\u0011\u0001u/a\u0005\u0011\tu\u0019\u0017Q\u0003\t\u0005\u0003/\tI\u0002\u0004\u0001\u0005\u000f\u0005maB1\u0001\u0002\u001e\t\tA+\u0005\u0003\u0002 \u0005\u0015\u0002cA\u000f\u0002\"%\u0019\u00111\u0005\r\u0003\u000f9{G\u000f[5oOB\u0019Q$a\n\n\u0007\u0005%\u0002DA\u0002B]fDq!!\f\u000f\u0001\u0004\ty#\u0001\u0002g]B9Q$!\r\u00026\u0005M\u0011bAA\u001a1\tIa)\u001e8di&|g.\r\t\u0005\u0003o\t)E\u0004\u0003\u0002:\u0005\u0005\u0003cAA\u001e15\u0011\u0011Q\b\u0006\u0004\u0003\u007fQ\u0012A\u0002\u001fs_>$h(C\u0002\u0002Da\ta\u0001\u0015:fI\u00164\u0017\u0002BA$\u0003\u0013\u0012aa\u0015;sS:<'bAA\"1\u0005\u0019\u0002o\\:u\u0019>\u001c\u0017\r^5p]J+\u0017/^3tiRA\u0011qJA4\u0003W\n\t\t\u0005\u0003\u001eG\u0006E\u0003CBA*\u0003;\n\t'\u0004\u0002\u0002V)!\u0011qKA-\u0003\u0011)H/\u001b7\u000b\u0005\u0005m\u0013\u0001\u00026bm\u0006LA!a\u0018\u0002V\t!A*[:u!\rY\u00171M\u0005\u0004\u0003Kb'\u0001\u0003'pG\u0006$\u0018n\u001c8\t\u000f\u0005%t\u00021\u0001\u00026\u0005\u0019QO\u001d7\t\r%|\u0001\u0019AA7!\u0011\ty'! \u000e\u0005\u0005E$\u0002BA:\u0003k\nAaZ:p]*!\u0011qOA=\u0003\u00199wn\\4mK*\u0011\u00111P\u0001\u0004G>l\u0017\u0002BA@\u0003c\u0012!BS:p]>\u0013'.Z2u\u0011\u001d\t\u0019i\u0004a\u0001\u0003k\ta!\\3uQ>$\u0017AE1t%\u0016lw\u000e^3QCJ\fW.\u001a;feN$b!!\u001c\u0002\n\u0006-\u0005BB5\u0011\u0001\u0004\ti\u0007C\u0004\u0002\u0004B\u0001\r!!\u000e")
public class RemoteLanguageServer {
    private final Function0<AbsolutePath> workspace;
    private final Function0<UserConfiguration> userConfig;
    private final Buffers buffers;
    private final BuildTargets buildTargets;
    private final ExecutionContext ec;
    private final Duration timeout;

    public Duration timeout() {
        return this.timeout;
    }

    public boolean isEnabledForPath(AbsolutePath path) {
        return ((UserConfiguration)this.userConfig.apply()).remoteLanguageServer().isDefined() && this.buildTargets.inverseSources(path).isEmpty();
    }

    public Option<ReferencesResult> referencesBlocking(ReferenceParams params) {
        return (Option)Await$.MODULE$.result(this.references(params), this.timeout());
    }

    public Future<Option<ReferencesResult>> references(ReferenceParams params) {
        return this.blockingRequest((Function1 & java.io.Serializable & Serializable)url -> this.postLocationRequest((String)url, JsonParser$.MODULE$.XtensionSerializableToJson(params).toJsonObject(), "textDocument/references").map((Function1 & java.io.Serializable & Serializable)locations -> new ReferencesResult(Scala.Symbols$.MODULE$.None(), (Seq<Location>)((Seq)MetalsEnrichments$.MODULE$.asScalaBufferConverter(locations).asScala()))));
    }

    public Future<Option<DefinitionResult>> definition(TextDocumentPositionParams params) {
        return this.blockingRequest((Function1 & java.io.Serializable & Serializable)url -> this.postLocationRequest((String)url, JsonParser$.MODULE$.XtensionSerializableToJson(params).toJsonObject(), "textDocument/definition").map((Function1 & java.io.Serializable & Serializable)locations -> new DefinitionResult((java.util.List<Location>)locations, Scala.Symbols$.MODULE$.None(), (Option<AbsolutePath>)None$.MODULE$, (Option<TextDocument>)None$.MODULE$)));
    }

    private <T> Future<Option<T>> blockingRequest(Function1<String, Option<T>> fn) {
        Future future;
        Option<String> option = ((UserConfiguration)this.userConfig.apply()).remoteLanguageServer();
        if (option instanceof Some) {
            Some some = (Some)option;
            String url = (String)some.value();
            future = Future$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> (Option)scala.concurrent.package$.MODULE$.blocking((Function0 & java.io.Serializable & Serializable)() -> (Option)fn.apply((Object)url)), this.ec);
        } else if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.successful((Object)None$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    private Option<java.util.List<Location>> postLocationRequest(String url, JsonObject params, String method) {
        Try maybeResponse = Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> {
            String x$1 = url;
            RequestBlob.ByteSourceRequestBlob x$2 = RequestBlob$.MODULE$.ByteSourceRequestBlob((Object)this.asRemoteParameters(params, method).toString(), (Function1 & java.io.Serializable & Serializable)s -> Writable$.MODULE$.StringWritable(s));
            .colon.colon x$3 = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Content-Type"), (Object)"application/json"), (List)Nil$.MODULE$);
            RequestAuth x$4 = package$.MODULE$.post().apply$default$2();
            Iterable x$5 = package$.MODULE$.post().apply$default$3();
            int x$6 = package$.MODULE$.post().apply$default$6();
            int x$7 = package$.MODULE$.post().apply$default$7();
            Tuple2 x$8 = package$.MODULE$.post().apply$default$8();
            Cert x$9 = package$.MODULE$.post().apply$default$9();
            SSLContext x$10 = package$.MODULE$.post().apply$default$10();
            Map x$11 = package$.MODULE$.post().apply$default$11();
            Map x$12 = package$.MODULE$.post().apply$default$12();
            int x$13 = package$.MODULE$.post().apply$default$13();
            boolean x$14 = package$.MODULE$.post().apply$default$14();
            boolean x$15 = package$.MODULE$.post().apply$default$15();
            Compress x$16 = package$.MODULE$.post().apply$default$16();
            boolean x$17 = package$.MODULE$.post().apply$default$17();
            boolean x$18 = package$.MODULE$.post().apply$default$18();
            boolean x$19 = package$.MODULE$.post().apply$default$19();
            return package$.MODULE$.post().apply(x$1, x$4, x$5, (Iterable)x$3, (RequestBlob)x$2, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19);
        });
        maybeResponse.toEither().left().foreach((Function1 & java.io.Serializable & Serializable)error -> {
            scribe.package$.MODULE$.error((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(25).append("remote: request failed '").append(error.getMessage()).append("'").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.remotels"), new FileName("RemoteLanguageServer.scala"), new Name("postLocationRequest"), new Line(96));
            return BoxedUnit.UNIT;
        });
        return maybeResponse.toOption().withFilter((Function1 & java.io.Serializable & Serializable)response -> BoxesRunTime.boxToBoolean((boolean)RemoteLanguageServer.$anonfun$postLocationRequest$5(response))).flatMap((Function1 & java.io.Serializable & Serializable)response -> JsonParser$.MODULE$.XtensionSerializedAsJson(JsonParser$.MODULE$.XtensionSerializedJson(response.text()).parseJson()).as(ClassTag$.MODULE$.apply(RemoteLocationResult.class)).toOption().flatMap((Function1 & java.io.Serializable & Serializable)result -> Option$.MODULE$.apply(result.result()).map((Function1 & java.io.Serializable & Serializable)locations -> {
            locations.forEach(location -> {
                String relativeUri = new StringOps(Predef$.MODULE$.augmentString(location.getUri())).stripPrefix("source://");
                String absoluteUri = ((AbsolutePath)$this.workspace.apply()).resolve(relativeUri).toURI().toString();
                location.setUri(absoluteUri);
            });
            return locations;
        })));
    }

    private JsonObject asRemoteParameters(JsonObject params, String method) {
        JsonObject textDocument = params.get("textDocument").getAsJsonObject();
        AbsolutePath absolutePath = MetalsEnrichments$.MODULE$.XtensionString(textDocument.get("uri").getAsString()).toAbsolutePath();
        URI relativeUri = absolutePath.toRelative((AbsolutePath)this.workspace.apply()).toURI(false);
        String md5 = MD5$.MODULE$.compute((String)this.buffers.get(absolutePath).getOrElse((Function0 & java.io.Serializable & Serializable)() -> ""));
        textDocument.add("uri", (JsonElement)new JsonPrimitive(new StringBuilder(9).append("source://").append(relativeUri).toString()));
        textDocument.add("md5", (JsonElement)new JsonPrimitive(md5));
        JsonObject result = new JsonObject();
        result.add("method", (JsonElement)new JsonPrimitive(method));
        result.add("params", (JsonElement)params);
        result.add("id", (JsonElement)new JsonPrimitive((Number)Predef$.MODULE$.int2Integer(10)));
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$postLocationRequest$5(Response response) {
        return response.statusCode() == 200;
    }

    public RemoteLanguageServer(Function0<AbsolutePath> workspace, Function0<UserConfiguration> userConfig, MetalsServerConfig serverConfig, Buffers buffers, BuildTargets buildTargets, ExecutionContext ec) {
        this.workspace = workspace;
        this.userConfig = userConfig;
        this.buffers = buffers;
        this.buildTargets = buildTargets;
        this.ec = ec;
        this.timeout = Duration$.MODULE$.apply(serverConfig.remoteTimeout());
    }
}

