/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.meta.cli.Reporter;
import scala.meta.cli.Reporter$;
import scala.meta.internal.builds.ShellRunner;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.ClientConfiguration;
import scala.meta.internal.metals.Compilers;
import scala.meta.internal.metals.DecoderResponse;
import scala.meta.internal.metals.DecoderResponse$;
import scala.meta.internal.metals.FileDecoderProvider$PathInfo$;
import scala.meta.internal.metals.FileSystemSemanticdbs;
import scala.meta.internal.metals.JavaBinary$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsLanguageClient;
import scala.meta.internal.metals.MetalsQuickPickItem;
import scala.meta.internal.metals.MetalsQuickPickItem$;
import scala.meta.internal.metals.MetalsQuickPickParams;
import scala.meta.internal.metals.MetalsQuickPickParams$;
import scala.meta.internal.metals.ScalaTarget;
import scala.meta.internal.metals.UserConfiguration;
import scala.meta.internal.metap.Main;
import scala.meta.internal.mtags.SemanticdbClasspath$;
import scala.meta.internal.parsing.ClassFinder;
import scala.meta.internal.parsing.ClassWithPos;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.metap.Format;
import scala.meta.metap.Settings;
import scala.meta.metap.Settings$;
import scala.meta.pc.PresentationCompiler;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scribe.Loggable;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0001\r}a\u0001B\u001b7\u0005}B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!Y\u0006A!A!\u0002\u0013a\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011\u0019\u0004!\u0011!Q\u0001\n\u001dD\u0001B\u001b\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\t]\u0002\u0011\t\u0011)A\u0005_\"AQ\u000f\u0001B\u0001B\u0003-a\u000fC\u0003}\u0001\u0011\u0005QP\u0002\u0004\u0002\u0016\u0001!\u0015q\u0003\u0005\u000b\u0003Ka!Q3A\u0005\u0002\u0005\u001d\u0002BCA \u0019\tE\t\u0015!\u0003\u0002*!Q\u0011\u0011\t\u0007\u0003\u0016\u0004%\t!a\u0011\t\u0013\u0005\u0015CB!E!\u0002\u0013)\u0005B\u0002?\r\t\u0003\t9\u0005C\u0005\u0002R1\t\t\u0011\"\u0001\u0002T!I\u0011\u0011\f\u0007\u0012\u0002\u0013\u0005\u00111\f\u0005\n\u0003cb\u0011\u0013!C\u0001\u0003gB\u0011\"a\u001e\r\u0003\u0003%\t%!\u001f\t\u0013\u0005-E\"!A\u0005\u0002\u00055\u0005\"CAK\u0019\u0005\u0005I\u0011AAL\u0011%\t\u0019\u000bDA\u0001\n\u0003\n)\u000bC\u0005\u000242\t\t\u0011\"\u0001\u00026\"I\u0011q\u0018\u0007\u0002\u0002\u0013\u0005\u0013\u0011\u0019\u0005\n\u0003\u0007d\u0011\u0011!C!\u0003\u000bD\u0011\"a2\r\u0003\u0003%\t%!3\b\u0013\u00055\u0007!!A\t\n\u0005=g!CA\u000b\u0001\u0005\u0005\t\u0012BAi\u0011\u0019ah\u0004\"\u0001\u0002`\"I\u00111\u0019\u0010\u0002\u0002\u0013\u0015\u0013Q\u0019\u0005\n\u0003Ct\u0012\u0011!CA\u0003GD\u0011\"!;\u001f\u0003\u0003%\t)a;\t\u000f\u0005u\b\u0001\"\u0001\u0002\u0000\"9!Q\u0005\u0001\u0005\n\t\u001d\u0002b\u0002B\u001d\u0001\u0011%!1\b\u0005\b\u0005\u007f\u0001A\u0011\u0002B!\u0011\u001d\u0011Y\u0006\u0001C\u0005\u0005;BqA!\u001a\u0001\t\u0013\u00119\u0007C\u0004\u0003|\u0001!IA! \t\u000f\t\u0005\u0005\u0001\"\u0003\u0003\u0004\"9!q\u0012\u0001\u0005\n\tE\u0005b\u0002BL\u0001\u0011%!\u0011\u0014\u0005\b\u0005\u007f\u0003A\u0011\u0002Ba\u0011\u001d\u00119\u000e\u0001C\u0005\u00053DqAa8\u0001\t\u0013\u0011\t\u000fC\u0004\u0003t\u0002!IA!>\t\u000f\tu\b\u0001\"\u0003\u0003\u0000\"91Q\u0001\u0001\u0005\n\r\u001d\u0001bBB\u0007\u0001\u0011\u00051q\u0002\u0005\b\u0007/\u0001A\u0011AB\r\u0005M1\u0015\u000e\\3EK\u000e|G-\u001a:Qe>4\u0018\u000eZ3s\u0015\t9\u0004(\u0001\u0004nKR\fGn\u001d\u0006\u0003si\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003wq\nA!\\3uC*\tQ(A\u0003tG\u0006d\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0005CA!C\u001b\u0005a\u0014BA\"=\u0005\u0019\te.\u001f*fM\u0006Iqo\u001c:lgB\f7-\u001a\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011j\n!![8\n\u0005);%\u0001D!cg>dW\u000f^3QCRD\u0017!C2p[BLG.\u001a:t!\tie*D\u00017\u0013\tyeGA\u0005D_6\u0004\u0018\u000e\\3sg\u0006a!-^5mIR\u000b'oZ3ugB\u0011QJU\u0005\u0003'Z\u0012ABQ;jY\u0012$\u0016M]4fiN\f!\"^:fe\u000e{gNZ5h!\r\te\u000bW\u0005\u0003/r\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u00055K\u0016B\u0001.7\u0005E)6/\u001a:D_:4\u0017nZ;sCRLwN\\\u0001\fg\",G\u000e\u001c*v]:,'\u000f\u0005\u0002^A6\taL\u0003\u0002`q\u00051!-^5mINL!!\u00190\u0003\u0017MCW\r\u001c7Sk:tWM]\u0001\u0016M&dWmU=ti\u0016l7+Z7b]RL7\r\u001a2t!\tiE-\u0003\u0002fm\t)b)\u001b7f'f\u001cH/Z7TK6\fg\u000e^5dI\n\u001c\u0018A\u00047b]\u001e,\u0018mZ3DY&,g\u000e\u001e\t\u0003\u001b\"L!!\u001b\u001c\u0003)5+G/\u00197t\u0019\u0006tw-^1hK\u000ec\u0017.\u001a8u\u00031\u0019G.[3oi\u000e{gNZ5h!\tiE.\u0003\u0002nm\t\u00192\t\\5f]R\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006Y1\r\\1tg\u001aKg\u000eZ3s!\t\u00018/D\u0001r\u0015\t\u0011\b(A\u0004qCJ\u001c\u0018N\\4\n\u0005Q\f(aC\"mCN\u001ch)\u001b8eKJ\f!!Z2\u0011\u0005]TX\"\u0001=\u000b\u0005ed\u0014AC2p]\u000e,(O]3oi&\u00111\u0010\u001f\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDc\u0005@\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti!a\u0004\u0002\u0012\u0005MAcA@\u0002\u0002A\u0011Q\n\u0001\u0005\u0006k.\u0001\u001dA\u001e\u0005\u0006\t.\u0001\r!\u0012\u0005\u0006\u0017.\u0001\r\u0001\u0014\u0005\u0006!.\u0001\r!\u0015\u0005\u0006).\u0001\r!\u0016\u0005\u00067.\u0001\r\u0001\u0018\u0005\u0006E.\u0001\ra\u0019\u0005\u0006M.\u0001\ra\u001a\u0005\u0006U.\u0001\ra\u001b\u0005\u0006].\u0001\ra\u001c\u0002\t!\u0006$\b.\u00138g_N1A\u0002QA\r\u0003?\u00012!QA\u000e\u0013\r\ti\u0002\u0010\u0002\b!J|G-^2u!\r\t\u0015\u0011E\u0005\u0004\u0003Ga$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u0003;be\u001e,G/\u00133\u0016\u0005\u0005%\u0002\u0003BA\u0016\u0003wi!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\u0006EN\u0004HG\u001b\u0006\u0004{\u0005M\"\u0002BA\u001b\u0003o\tA!\u001a9gY*\u0011\u0011\u0011H\u0001\u0003G\"LA!!\u0010\u0002.\t)\")^5mIR\u000b'oZ3u\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018!\u0003;be\u001e,G/\u00133!\u0003\u0011\u0001\u0018\r\u001e5\u0016\u0003\u0015\u000bQ\u0001]1uQ\u0002\"b!!\u0013\u0002N\u0005=\u0003cAA&\u00195\t\u0001\u0001C\u0004\u0002&E\u0001\r!!\u000b\t\r\u0005\u0005\u0013\u00031\u0001F\u0003\u0011\u0019w\u000e]=\u0015\r\u0005%\u0013QKA,\u0011%\t)C\u0005I\u0001\u0002\u0004\tI\u0003\u0003\u0005\u0002BI\u0001\n\u00111\u0001F\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0018+\t\u0005%\u0012qL\u0016\u0003\u0003C\u0002B!a\u0019\u0002n5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'A\u0005v]\u000eDWmY6fI*\u0019\u00111\u000e\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002p\u0005\u0015$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA;U\r)\u0015qL\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005m\u0004\u0003BA?\u0003\u000fk!!a \u000b\t\u0005\u0005\u00151Q\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0006\u0006!!.\u0019<b\u0013\u0011\tI)a \u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\tE\u0002B\u0003#K1!a%=\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI*a(\u0011\u0007\u0005\u000bY*C\u0002\u0002\u001er\u00121!\u00118z\u0011%\t\tkFA\u0001\u0002\u0004\ty)A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003O\u0003b!!+\u00020\u0006eUBAAV\u0015\r\ti\u000bP\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAY\u0003W\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qWA_!\r\t\u0015\u0011X\u0005\u0004\u0003wc$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003CK\u0012\u0011!a\u0001\u00033\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u001f\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003w\na!Z9vC2\u001cH\u0003BA\\\u0003\u0017D\u0011\"!)\u001d\u0003\u0003\u0005\r!!'\u0002\u0011A\u000bG\u000f[%oM>\u00042!a\u0013\u001f'\u0015q\u00121[A\u0010!%\t).a7\u0002*\u0015\u000bI%\u0004\u0002\u0002X*\u0019\u0011\u0011\u001c\u001f\u0002\u000fI,h\u000e^5nK&!\u0011Q\\Al\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003\u001f\fQ!\u00199qYf$b!!\u0013\u0002f\u0006\u001d\bbBA\u0013C\u0001\u0007\u0011\u0011\u0006\u0005\u0007\u0003\u0003\n\u0003\u0019A#\u0002\u000fUt\u0017\r\u001d9msR!\u0011Q^A}!\u0015\t\u0015q^Az\u0013\r\t\t\u0010\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u0005\u000b)0!\u000bF\u0013\r\t9\u0010\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005m(%!AA\u0002\u0005%\u0013a\u0001=%a\u0005\u0019B-Z2pI\u0016$g)\u001b7f\u0007>tG/\u001a8ugR!!\u0011\u0001B\u0007!\u00159(1\u0001B\u0004\u0013\r\u0011)\u0001\u001f\u0002\u0007\rV$XO]3\u0011\u00075\u0013I!C\u0002\u0003\fY\u0012q\u0002R3d_\u0012,'OU3ta>t7/\u001a\u0005\b\u0005\u001f\u0019\u0003\u0019\u0001B\t\u0003!)(/[!t'R\u0014\b\u0003\u0002B\n\u0005CqAA!\u0006\u0003\u001eA\u0019!q\u0003\u001f\u000e\u0005\te!b\u0001B\u000e}\u00051AH]8pizJ1Aa\b=\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011\u0012B\u0012\u0015\r\u0011y\u0002P\u0001\nI\u0016\u001cw\u000eZ3KCJ$BAa\u0002\u0003*!9!1\u0006\u0013A\u0002\t5\u0012aA;sSB!!q\u0006B\u001b\u001b\t\u0011\tD\u0003\u0003\u00034\u0005\r\u0015a\u00018fi&!!q\u0007B\u0019\u0005\r)&+S\u0001\u0011I\u0016\u001cw\u000eZ3NKR\fGn\u001d$jY\u0016$BA!\u0001\u0003>!9!1F\u0013A\u0002\t5\u0012A\u0002;p\r&dW\r\u0006\u0004\u0003D\tU#q\u000b\t\b\u0005\u000b\u0012yEa\u0002F\u001d\u0011\u00119Ea\u0013\u000f\t\t]!\u0011J\u0005\u0002{%\u0019!Q\n\u001f\u0002\u000fA\f7m[1hK&!!\u0011\u000bB*\u0005\u0019)\u0015\u000e\u001e5fe*\u0019!Q\n\u001f\t\u000f\t-b\u00051\u0001\u0003.!9!\u0011\f\u0014A\u0002\tE\u0011AD:vM\u001aL\u0007\u0010V8SK6|g/Z\u0001\fI\u0016\u001cw\u000eZ3KCZ\f\u0007\u000f\u0006\u0004\u0003\u0002\t}#\u0011\r\u0005\u0007\u0003\u0003:\u0003\u0019A#\t\u000f\t\rt\u00051\u0001\u00028\u0006I\u0011n\u001d,fe\n|7/Z\u0001\u0011I\u0016\u001cw\u000eZ3TK6\fg\u000e^5d\t\n$bAa\u0002\u0003j\t-\u0004BBA!Q\u0001\u0007Q\tC\u0004\u0003n!\u0002\rAa\u001c\u0002\r\u0019|'/\\1u!\u0011\u0011\tHa\u001e\u000e\u0005\tM$b\u0001B;u\u0005)Q.\u001a;ba&!!\u0011\u0010B:\u0005\u00191uN]7bi\u0006YA-Z2pI\u0016$\u0016m\u001d;z)\u0011\u0011\tAa \t\r\u0005\u0005\u0013\u00061\u0001F\u0003Y1\u0017N\u001c3QCRD\u0017J\u001c4p\rJ|WnU8ve\u000e,GC\u0002BC\u0005\u000f\u0013Y\t\u0005\u0005\u0003F\t=#\u0011CA%\u0011\u0019\u0011II\u000ba\u0001\u000b\u0006Q1o\\;sG\u00164\u0015\u000e\\3\t\u000f\t5%\u00061\u0001\u0003\u0012\u0005aa.Z<FqR,gn]5p]\u0006qb-\u001b8e!\u0006$\b.\u00138g_\u001a{'o\u00117bgN,7\u000fU1uQ\u001aKG.\u001a\u000b\u0005\u0005'\u0013)\nE\u0003B\u0003_\fI\u0005\u0003\u0004\u0002B-\u0002\r!R\u0001\"g\u0016dWm\u0019;DY\u0006\u001c8O\u0012:p[N\u001b\u0017\r\\1GS2,\u0017I\u001c3EK\u000e|G-Z\u000b\u0005\u00057\u0013\u0019\f\u0006\u0005\u0003\u001e\n%&Q\u0016BX)\u0011\u0011\tAa(\t\u000f\t\u0005F\u00061\u0001\u0003$\u00061A-Z2pI\u0016\u0004r!\u0011BS\u0003\u0013\u0012\t!C\u0002\u0003(r\u0012\u0011BR;oGRLwN\\\u0019\t\u000f\t-F\u00061\u0001\u0003.\u0005a!/Z9vKN$X\rZ+S\u0013\"1\u0011\u0011\t\u0017A\u0002\u0015CqA!--\u0001\u0004\t9,A\nj]\u000edW\u000fZ3J]:,'o\u00117bgN,7\u000fB\u0004\u000362\u0012\rAa.\u0003\u0003Q\u000bBA!/\u0002\u001aB\u0019\u0011Ia/\n\u0007\tuFHA\u0004O_RD\u0017N\\4\u0002\u0013AL7m[\"mCN\u001cH\u0003\u0002Bb\u0005\u000f\u0004Ra\u001eB\u0002\u0005\u000b\u0004R!QAx\u0005#AqA!3.\u0001\u0004\u0011Y-A\u0004dY\u0006\u001c8/Z:\u0011\r\t\u0015#Q\u001aBi\u0013\u0011\u0011yMa\u0015\u0003\t1K7\u000f\u001e\t\u0004a\nM\u0017b\u0001Bkc\na1\t\\1tg^KG\u000f\u001b)pg\u00061b-\u001b8e'\u0016l\u0017M\u001c;jG\u0012\u0013\u0007+\u0019;i\u0013:4w\u000e\u0006\u0003\u0003\\\nu\u0007c\u0002B#\u0005\u001f\u0012\t\"\u0012\u0005\u0007\u0005\u0013s\u0003\u0019A#\u0002/\u0019Lg\u000e\u001a\"vS2$G+\u0019:hKRlU\r^1eCR\fG\u0003\u0002Br\u0005c\u0004\u0002B!\u0012\u0003P\tE!Q\u001d\t\t\u0003\n\u001d\u0018\u0011\u0006Bv\u000b&\u0019!\u0011\u001e\u001f\u0003\rQ+\b\u000f\\34!\ri%Q^\u0005\u0004\u0005_4$aC*dC2\fG+\u0019:hKRDaA!#0\u0001\u0004)\u0015\u0001\u00073fG>$WMS1wCB4%o\\7DY\u0006\u001c8OR5mKR1!\u0011\u0001B|\u0005sDa!!\u00111\u0001\u0004)\u0005b\u0002B~a\u0001\u0007\u0011qW\u0001\bm\u0016\u0014(m\\:f\u0003a!WmY8eK\u001a\u0013x.\\*f[\u0006tG/[2E\u0005\u001aKG.\u001a\u000b\u0007\u0005\u000f\u0019\taa\u0001\t\r\u0005\u0005\u0013\u00071\u0001F\u0011\u001d\u0011i'\ra\u0001\u0005_\n1\u0003Z3d_\u0012,gI]8n)\u0006\u001cH/\u001f$jY\u0016$BA!\u0001\u0004\n!911\u0002\u001aA\u0002\u0005%\u0013\u0001\u00039bi\"LeNZ8\u0002\u001d\u001d,G\u000fV1tif4uN]+S\u0013R!1\u0011CB\u000b!\u00159(1AB\n!!\u0011)Ea\u0014\u0003\u0012\tE\u0001b\u0002B\u0016g\u0001\u0007!QF\u0001\u0014G\"|wn]3DY\u0006\u001c8O\u0012:p[\u001aKG.\u001a\u000b\u0007\u0005\u0003\u0019Yb!\b\t\r\u0005\u0005C\u00071\u0001F\u0011\u001d\u0011\t\f\u000ea\u0001\u0003o\u0003")
public final class FileDecoderProvider {
    private volatile FileDecoderProvider$PathInfo$ PathInfo$module;
    private final AbsolutePath workspace;
    private final Compilers compilers;
    private final BuildTargets buildTargets;
    private final Function0<UserConfiguration> userConfig;
    private final ShellRunner shellRunner;
    private final FileSystemSemanticdbs fileSystemSemanticdbs;
    private final MetalsLanguageClient languageClient;
    private final ClientConfiguration clientConfig;
    private final ClassFinder classFinder;
    private final ExecutionContext ec;

    private FileDecoderProvider$PathInfo$ PathInfo() {
        if (this.PathInfo$module == null) {
            this.PathInfo$lzycompute$1();
        }
        return this.PathInfo$module;
    }

    public Future<DecoderResponse> decodedFileContents(String uriAsStr) {
        Future future;
        block8: {
            Try try_;
            while ((try_ = Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> URI.create(uriAsStr))) instanceof Success) {
                Future future2;
                Success success = (Success)try_;
                URI uri = (URI)success.value();
                String string = uri.getScheme();
                if ("jar".equals(string)) {
                    future2 = Future$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> this.decodeJar(uri), this.ec);
                } else if ("file".equals(string)) {
                    future2 = this.decodeMetalsFile(uri);
                } else {
                    if ("metalsDecode".equals(string)) {
                        uriAsStr = uri.getSchemeSpecificPart();
                        continue;
                    }
                    future2 = Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(uri, new java.lang.StringBuilder(18).append("Unexpected scheme ").append(uri.getScheme()).toString()));
                }
                future = future2;
                break block8;
            }
            if (try_ instanceof Failure) {
                future = Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(uriAsStr, new java.lang.StringBuilder(18).append(uriAsStr).append(" is an invalid URI").toString()));
            } else {
                throw new MatchError((Object)try_);
            }
        }
        return future;
    }

    private DecoderResponse decodeJar(URI uri) {
        DecoderResponse decoderResponse;
        Try try_ = Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> {
            String decodedUriStr = URLDecoder.decode(uri.toString(), "UTF-8");
            URI decodedUri = URI.create(decodedUriStr);
            AbsolutePath path = AbsolutePath$.MODULE$.apply(Paths.get(decodedUri), AbsolutePath$.MODULE$.workingDirectory());
            return FileIO$.MODULE$.slurp(path, StandardCharsets.UTF_8);
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            decoderResponse = DecoderResponse$.MODULE$.failed(uri, exception);
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            String value = (String)success.value();
            decoderResponse = DecoderResponse$.MODULE$.success(uri, value);
        } else {
            throw new MatchError((Object)try_);
        }
        return decoderResponse;
    }

    private Future<DecoderResponse> decodeMetalsFile(URI uri) {
        Future future;
        String additionalExtension;
        Set supportedExtensions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"javap", "javap-verbose", "tasty-decoded", "semanticdb-compact", "semanticdb-detailed", "semanticdb-proto"}));
        if (supportedExtensions.apply((Object)(additionalExtension = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(uri.toString())).split('.'))).toList().last()))) {
            Future future2;
            Either<DecoderResponse, AbsolutePath> stripped = this.toFile(uri, new java.lang.StringBuilder(1).append(".").append(additionalExtension).toString());
            Either<DecoderResponse, AbsolutePath> either = stripped;
            if (either instanceof Left) {
                Left left = (Left)either;
                DecoderResponse value = (DecoderResponse)left.value();
                future2 = Future$.MODULE$.successful((Object)value);
            } else if (either instanceof Right) {
                Future future3;
                Right right = (Right)either;
                AbsolutePath path = (AbsolutePath)right.value();
                String string = additionalExtension;
                if ("javap".equals(string)) {
                    future3 = this.decodeJavap(path, false);
                } else if ("javap-verbose".equals(string)) {
                    future3 = this.decodeJavap(path, true);
                } else if ("tasty-decoded".equals(string)) {
                    future3 = this.decodeTasty(path);
                } else if ("semanticdb-compact".equals(string)) {
                    future3 = Future$.MODULE$.successful((Object)this.decodeSemanticDb(path, (Format)Format.Compact$.MODULE$));
                } else if ("semanticdb-detailed".equals(string)) {
                    future3 = Future$.MODULE$.successful((Object)this.decodeSemanticDb(path, (Format)Format.Detailed$.MODULE$));
                } else if ("semanticdb-proto".equals(string)) {
                    future3 = Future$.MODULE$.successful((Object)this.decodeSemanticDb(path, (Format)Format.Proto$.MODULE$));
                } else {
                    throw new MatchError((Object)string);
                }
                future2 = future3;
            } else {
                throw new MatchError(either);
            }
            future = future2;
        } else {
            future = Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(uri, "Unsupported extension"));
        }
        return future;
    }

    private Either<DecoderResponse, AbsolutePath> toFile(URI uri, String suffixToRemove) {
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> MetalsEnrichments$.MODULE$.XtensionString(new StringOps(Predef$.MODULE$.augmentString(uri.toString())).stripSuffix(suffixToRemove)).toAbsolutePath()).filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileDecoderProvider.$anonfun$toFile$2(x$1))).toOption().toRight((Function0 & java.io.Serializable & Serializable)() -> DecoderResponse$.MODULE$.failed(uri, new java.lang.StringBuilder(19).append("File ").append(uri).append(" doesn't exist").toString()));
    }

    private Future<DecoderResponse> decodeJavap(AbsolutePath path, boolean isVerbose) {
        Future future;
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isClassfile()) {
            future = this.decodeJavapFromClassFile(path, isVerbose);
        } else if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isJava()) {
            Future future2;
            Either either = this.findPathInfoFromSource(path, ".class").map((Function1 & java.io.Serializable & Serializable)p -> this.decodeJavapFromClassFile(p.path(), isVerbose));
            if (either instanceof Left) {
                Left left = (Left)either;
                String err = (String)left.value();
                future2 = Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(path.toURI(), err));
            } else if (either instanceof Right) {
                Future response;
                Right right = (Right)either;
                future2 = response = (Future)right.value();
            } else {
                throw new MatchError((Object)either);
            }
            future = future2;
        } else {
            future = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isScala() ? this.selectClassFromScalaFileAndDecode(path.toURI(), path, true, (Function1<PathInfo, Future<DecoderResponse>>)(Function1 & java.io.Serializable & Serializable)p -> this.decodeJavapFromClassFile(p.path(), isVerbose)) : Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(path.toURI(), "Invalid extension"));
        }
        return future;
    }

    private DecoderResponse decodeSemanticDb(AbsolutePath path, Format format) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isScalaOrJava() ? (DecoderResponse)MetalsEnrichments$.MODULE$.XtensionEitherCross(this.findSemanticDbPathInfo(path)).mapLeft((Function1 & java.io.Serializable & Serializable)s -> DecoderResponse$.MODULE$.failed(path.toURI(), (String)s)).map((Function1 & java.io.Serializable & Serializable)x$2 -> this.decodeFromSemanticDBFile((AbsolutePath)x$2, format)).fold((Function1 & java.io.Serializable & Serializable)x -> (DecoderResponse)Predef$.MODULE$.identity(x), (Function1 & java.io.Serializable & Serializable)x -> (DecoderResponse)Predef$.MODULE$.identity(x)) : (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isSemanticdb() ? this.decodeFromSemanticDBFile(path, format) : DecoderResponse$.MODULE$.failed(path.toURI(), "Unsupported extension"));
    }

    private Future<DecoderResponse> decodeTasty(AbsolutePath path) {
        Future future;
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isScala()) {
            future = this.selectClassFromScalaFileAndDecode(path.toURI(), path, false, (Function1<PathInfo, Future<DecoderResponse>>)(Function1 & java.io.Serializable & Serializable)pathInfo -> this.decodeFromTastyFile((PathInfo)pathInfo));
        } else if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isTasty()) {
            Future future2;
            Option<PathInfo> option = this.findPathInfoForClassesPathFile(path);
            if (option instanceof Some) {
                Some some = (Some)option;
                PathInfo pathInfo2 = (PathInfo)some.value();
                future2 = this.decodeFromTastyFile(pathInfo2);
            } else if (None$.MODULE$.equals(option)) {
                future2 = Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(path.toURI(), "Cannot find build target for a given file"));
            } else {
                throw new MatchError(option);
            }
            future = future2;
        } else {
            future = Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(path.toURI(), "Invalid extension"));
        }
        return future;
    }

    private Either<String, PathInfo> findPathInfoFromSource(AbsolutePath sourceFile, String newExtension) {
        return this.findBuildTargetMetadata(sourceFile).map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            BuildTargetIdentifier targetId = (BuildTargetIdentifier)tuple3._1();
            ScalaTarget target = (ScalaTarget)tuple3._2();
            AbsolutePath sourceRoot = (AbsolutePath)tuple3._3();
            AbsolutePath classDir = MetalsEnrichments$.MODULE$.XtensionString(target.classDirectory()).toAbsolutePath();
            String oldExtension = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(sourceFile).extension();
            RelativePath relativePath = sourceFile.toRelative(sourceRoot).resolveSibling((Function1 & java.io.Serializable & Serializable)x$3 -> new java.lang.StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString(x$3)).stripSuffix(oldExtension)).append(newExtension).toString());
            PathInfo pathInfo = new PathInfo(this, targetId, classDir.resolve(relativePath));
            return pathInfo;
        });
    }

    private Option<PathInfo> findPathInfoForClassesPathFile(AbsolutePath path) {
        Iterator pathInfos = this.buildTargets.all().map((Function1 & java.io.Serializable & Serializable)scalaTarget -> {
            AbsolutePath classPath = MetalsEnrichments$.MODULE$.XtensionString(scalaTarget.classDirectory()).toAbsolutePath();
            return new Tuple2(scalaTarget, (Object)classPath);
        }).withFilter((Function1 & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FileDecoderProvider.$anonfun$findPathInfoForClassesPathFile$2(path, x$4))).map((Function1 & java.io.Serializable & Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ScalaTarget scalaTarget = (ScalaTarget)tuple2._1();
            PathInfo pathInfo = new PathInfo(this, scalaTarget.id(), path);
            return pathInfo;
        });
        return pathInfos.toList().headOption();
    }

    private <T> Future<DecoderResponse> selectClassFromScalaFileAndDecode(URI requestedURI, AbsolutePath path, boolean includeInnerClasses, Function1<PathInfo, Future<DecoderResponse>> decode) {
        Future future;
        Some some;
        List classes;
        Option<List<ClassWithPos>> availableClasses = this.classFinder.findAllClasses(path, includeInnerClasses);
        Option<List<ClassWithPos>> option = availableClasses;
        if (option instanceof Some && (classes = (List)(some = (Some)option).value()).nonEmpty()) {
            Future<Option<String>> resourceToDecode = this.pickClass((List<ClassWithPos>)classes);
            future = resourceToDecode.flatMap((Function1 & java.io.Serializable & Serializable)picked -> {
                Future future;
                Either response = picked.toRight((Function0 & java.io.Serializable & Serializable)() -> DecoderResponse$.MODULE$.cancelled(path.toURI())).flatMap((Function1 & java.io.Serializable & Serializable)resourcePath -> MetalsEnrichments$.MODULE$.XtensionEitherCross(this.findBuildTargetMetadata(path)).mapLeft((Function1 & java.io.Serializable & Serializable)x$6 -> DecoderResponse$.MODULE$.failed(requestedURI, (String)x$6)).map((Function1 & java.io.Serializable & Serializable)buildMetadata -> {
                    Tuple3 tuple3 = buildMetadata;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    BuildTargetIdentifier targetId = (BuildTargetIdentifier)tuple3._1();
                    ScalaTarget target = (ScalaTarget)tuple3._2();
                    Tuple2 tuple2 = new Tuple2((Object)targetId, (Object)target);
                    Tuple2 tuple22 = tuple2;
                    BuildTargetIdentifier targetId2 = (BuildTargetIdentifier)tuple22._1();
                    ScalaTarget target2 = (ScalaTarget)tuple22._2();
                    AbsolutePath classDir = MetalsEnrichments$.MODULE$.XtensionString(target2.classDirectory()).toAbsolutePath();
                    AbsolutePath pathToResource = classDir.resolve(resourcePath);
                    return new PathInfo(this, targetId2, pathToResource);
                }));
                Either either = response;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    DecoderResponse decoderResponse = (DecoderResponse)left.value();
                    future = Future$.MODULE$.successful((Object)decoderResponse);
                } else if (either instanceof Right) {
                    Right right = (Right)either;
                    PathInfo pathInfo = (PathInfo)right.value();
                    future = (Future)decode.apply((Object)pathInfo);
                } else {
                    throw new MatchError((Object)either);
                }
                return future;
            }, this.ec);
        } else {
            future = Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(requestedURI, "File doesn't contain any definitions"));
        }
        return future;
    }

    private Future<Option<String>> pickClass(List<ClassWithPos> classes) {
        Future future;
        if (classes.size() > 1) {
            java.util.List x$1 = (java.util.List)MetalsEnrichments$.MODULE$.seqAsJavaListConverter((Seq)classes.map((Function1 & java.io.Serializable & Serializable)c -> new MetalsQuickPickItem(c.path(), c.friendlyName(), c.description(), MetalsQuickPickItem$.MODULE$.apply$default$4(), MetalsQuickPickItem$.MODULE$.apply$default$5()), List$.MODULE$.canBuildFrom())).asJava();
            String x$2 = "Pick the class you want to decode";
            Boolean x$3 = MetalsQuickPickParams$.MODULE$.apply$default$2();
            Boolean x$4 = MetalsQuickPickParams$.MODULE$.apply$default$3();
            Boolean x$5 = MetalsQuickPickParams$.MODULE$.apply$default$5();
            MetalsQuickPickParams quickPickParams = new MetalsQuickPickParams(x$1, x$3, x$4, x$2, x$5);
            future = MetalsEnrichments$.MODULE$.XtensionJavaFuture(this.languageClient.metalsQuickPick(quickPickParams)).asScala().map((Function1 & java.io.Serializable & Serializable)result -> result.cancelled() != null && Predef$.MODULE$.Boolean2boolean(result.cancelled()) ? None$.MODULE$ : new Some((Object)result.itemId()), this.ec);
        } else {
            future = Future$.MODULE$.successful((Object)new Some((Object)((ClassWithPos)classes.head()).path()));
        }
        return future;
    }

    private Either<String, AbsolutePath> findSemanticDbPathInfo(AbsolutePath sourceFile) {
        return this.findBuildTargetMetadata(sourceFile).map((Function1 & java.io.Serializable & Serializable)metadata -> {
            Tuple3 tuple3 = metadata;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            BuildTargetIdentifier targetId = (BuildTargetIdentifier)tuple3._1();
            ScalaTarget target = (ScalaTarget)tuple3._2();
            AbsolutePath sourceRoot = (AbsolutePath)tuple3._3();
            Tuple4 tuple4 = new Tuple4((Object)tuple3, (Object)targetId, (Object)target, (Object)sourceRoot);
            Tuple4 tuple42 = tuple4;
            Tuple3 x$8 = (Tuple3)tuple42._1();
            BuildTargetIdentifier targetId2 = (BuildTargetIdentifier)tuple42._2();
            ScalaTarget target2 = (ScalaTarget)tuple42._3();
            AbsolutePath sourceRoot2 = (AbsolutePath)tuple42._4();
            return new Tuple2(metadata, (Object)x$8);
        }).flatMap((Function1 & java.io.Serializable & Serializable)x$10 -> {
            Tuple3 tuple3;
            Tuple2 tuple2 = x$10;
            if (tuple2 == null || (tuple3 = (Tuple3)tuple2._2()) == null) {
                throw new MatchError((Object)tuple2);
            }
            ScalaTarget target = (ScalaTarget)tuple3._2();
            AbsolutePath sourceRoot = (AbsolutePath)tuple3._3();
            AbsolutePath targetRoot = target.targetroot();
            RelativePath relativePath = SemanticdbClasspath$.MODULE$.fromScala(sourceFile.toRelative(MetalsEnrichments$.MODULE$.XtensionAbsolutePath(sourceRoot).dealias()));
            Either either = $this.fileSystemSemanticdbs.findSemanticDb(relativePath, targetRoot, sourceFile, $this.workspace).toRight((Function0 & java.io.Serializable & Serializable)() -> new java.lang.StringBuilder(27).append("Cannot find semanticDB for ").append(sourceFile.toURI().toString()).toString()).map((Function1 & java.io.Serializable & Serializable)foundSemanticDbPath -> foundSemanticDbPath.path());
            return either;
        });
    }

    private Either<String, Tuple3<BuildTargetIdentifier, ScalaTarget, AbsolutePath>> findBuildTargetMetadata(AbsolutePath sourceFile) {
        Option metadata = this.buildTargets.inverseSources(sourceFile).flatMap((Function1 & java.io.Serializable & Serializable)targetId -> $this.buildTargets.scalaTarget((BuildTargetIdentifier)targetId).flatMap((Function1 & java.io.Serializable & Serializable)target -> $this.buildTargets.workspaceDirectory((BuildTargetIdentifier)targetId).map((Function1 & java.io.Serializable & Serializable)sourceRoot -> new Tuple3(targetId, target, sourceRoot))));
        return metadata.toRight((Function0 & java.io.Serializable & Serializable)() -> new java.lang.StringBuilder(33).append("Cannot find build's metadata for ").append(sourceFile.toURI().toString()).toString());
    }

    private Future<DecoderResponse> decodeJavapFromClassFile(AbsolutePath path, boolean verbose) {
        Future future;
        try {
            Nil$ args = verbose ? new .colon.colon((Object)"-verbose", (List)Nil$.MODULE$) : Nil$.MODULE$;
            StringBuilder sb = new StringBuilder();
            String string = JavaBinary$.MODULE$.apply(((UserConfiguration)this.userConfig.apply()).javaHome(), "javap");
            Nil$ nil$ = args;
            future = this.shellRunner.run("Decode using javap", (List<String>)new .colon.colon((Object)MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).filename(), (List)Nil$.MODULE$).$colon$colon$colon((List)nil$).$colon$colon((Object)string), MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).parent(), true, (Map<String, String>)Predef$.MODULE$.Map().empty(), (Function1<String, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)s -> {
                FileDecoderProvider.$anonfun$decodeJavapFromClassFile$1(sb, s);
                return BoxedUnit.UNIT;
            }, (Function1<String, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)s -> {
                FileDecoderProvider.$anonfun$decodeJavapFromClassFile$2(s);
                return BoxedUnit.UNIT;
            }, true, false).map((Function1 & java.io.Serializable & Serializable)x$13 -> DecoderResponse$.MODULE$.success(path.toURI(), sb.toString()), this.ec);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            scribe.package$.MODULE$.error((Function0 & java.io.Serializable & Serializable)() -> e.toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("FileDecoderProvider.scala"), new Name("decodeJavapFromClassFile"), new Line(404));
            Future future2 = Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(path.toURI(), e));
            future = future2;
        }
        return future;
    }

    private DecoderResponse decodeFromSemanticDBFile(AbsolutePath path, Format format) {
        DecoderResponse decoderResponse;
        Try try_ = Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> {
            String string;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            PrintStream psOut = new PrintStream(out);
            PrintStream psErr = new PrintStream(err);
            try {
                Reporter reporter = Reporter$.MODULE$.apply().withOut(psOut).withErr(psErr);
                Settings settings = Settings$.MODULE$.apply().withPaths((List)new .colon.colon((Object)path.toNIO(), (List)Nil$.MODULE$)).withFormat(format);
                Main main = new Main(settings, reporter);
                main.process();
                String output = new String(out.toByteArray());
                String error = new String(err.toByteArray());
                string = error.isEmpty() ? output : error;
            }
            finally {
                psOut.close();
                psErr.close();
            }
            return string;
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            decoderResponse = DecoderResponse$.MODULE$.failed(path.toString(), exception);
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            String value = (String)success.value();
            decoderResponse = DecoderResponse$.MODULE$.success(path.toURI(), value);
        } else {
            throw new MatchError((Object)try_);
        }
        return decoderResponse;
    }

    private Future<DecoderResponse> decodeFromTastyFile(PathInfo pathInfo) {
        Future future;
        Option<PresentationCompiler> option = this.compilers.loadCompiler(pathInfo.targetId());
        if (option instanceof Some) {
            Some some = (Some)option;
            PresentationCompiler pc = (PresentationCompiler)some.value();
            future = MetalsEnrichments$.MODULE$.XtensionJavaFuture(pc.getTasty(pathInfo.path().toURI(), this.clientConfig.isHttpEnabled())).asScala().map((Function1 & java.io.Serializable & Serializable)x$14 -> DecoderResponse$.MODULE$.success(pathInfo.path().toURI(), (String)x$14), this.ec);
        } else if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(pathInfo.path().toURI(), "Cannot load presentation compiler"));
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    public Future<Either<String, String>> getTastyForURI(URI uri) {
        return this.decodeTasty(AbsolutePath$.MODULE$.fromAbsoluteUri(uri, AbsolutePath$.MODULE$.workingDirectory())).map((Function1 & java.io.Serializable & Serializable)response -> response.value() != null ? package$.MODULE$.Right().apply((Object)response.value()) : package$.MODULE$.Left().apply((Object)response.error()), this.ec);
    }

    public Future<DecoderResponse> chooseClassFromFile(AbsolutePath path, boolean includeInnerClasses) {
        return this.selectClassFromScalaFileAndDecode(path.toURI(), path, includeInnerClasses, (Function1<PathInfo, Future<DecoderResponse>>)(Function1 & java.io.Serializable & Serializable)pathInfo -> Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.success(path.toURI(), pathInfo.path().toURI().toString())));
    }

    private final void PathInfo$lzycompute$1() {
        FileDecoderProvider fileDecoderProvider = this;
        synchronized (fileDecoderProvider) {
            if (this.PathInfo$module == null) {
                this.PathInfo$module = new FileDecoderProvider$PathInfo$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$toFile$2(AbsolutePath x$1) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePath(x$1).exists();
    }

    public static final /* synthetic */ boolean $anonfun$findPathInfoForClassesPathFile$2(AbsolutePath path$2, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AbsolutePath classPath = (AbsolutePath)tuple2._2();
        boolean bl = MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(path$2).isInside(classPath);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$decodeJavapFromClassFile$1(StringBuilder sb$1, String s) {
        sb$1.append(s);
        sb$1.append(Properties$.MODULE$.lineSeparator());
    }

    public static final /* synthetic */ void $anonfun$decodeJavapFromClassFile$2(String s) {
    }

    public FileDecoderProvider(AbsolutePath workspace, Compilers compilers, BuildTargets buildTargets, Function0<UserConfiguration> userConfig, ShellRunner shellRunner, FileSystemSemanticdbs fileSystemSemanticdbs, MetalsLanguageClient languageClient, ClientConfiguration clientConfig, ClassFinder classFinder, ExecutionContext ec) {
        this.workspace = workspace;
        this.compilers = compilers;
        this.buildTargets = buildTargets;
        this.userConfig = userConfig;
        this.shellRunner = shellRunner;
        this.fileSystemSemanticdbs = fileSystemSemanticdbs;
        this.languageClient = languageClient;
        this.clientConfig = clientConfig;
        this.classFinder = classFinder;
        this.ec = ec;
    }

    private class PathInfo
    implements Product,
    Serializable {
        private final BuildTargetIdentifier targetId;
        private final AbsolutePath path;
        public final /* synthetic */ FileDecoderProvider $outer;

        public BuildTargetIdentifier targetId() {
            return this.targetId;
        }

        public AbsolutePath path() {
            return this.path;
        }

        public PathInfo copy(BuildTargetIdentifier targetId, AbsolutePath path) {
            return new PathInfo(this.scala$meta$internal$metals$FileDecoderProvider$PathInfo$$$outer(), targetId, path);
        }

        public BuildTargetIdentifier copy$default$1() {
            return this.targetId();
        }

        public AbsolutePath copy$default$2() {
            return this.path();
        }

        public String productPrefix() {
            return "PathInfo";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            BuildTargetIdentifier buildTargetIdentifier;
            int n = x$1;
            switch (n) {
                case 0: {
                    buildTargetIdentifier = this.targetId();
                    break;
                }
                case 1: {
                    buildTargetIdentifier = this.path();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return buildTargetIdentifier;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PathInfo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PathInfo)) return false;
            if (((PathInfo)object).scala$meta$internal$metals$FileDecoderProvider$PathInfo$$$outer() != this.scala$meta$internal$metals$FileDecoderProvider$PathInfo$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            PathInfo pathInfo = (PathInfo)x$1;
            BuildTargetIdentifier buildTargetIdentifier = this.targetId();
            BuildTargetIdentifier buildTargetIdentifier2 = pathInfo.targetId();
            if (buildTargetIdentifier == null) {
                if (buildTargetIdentifier2 != null) {
                    return false;
                }
            } else if (!buildTargetIdentifier.equals(buildTargetIdentifier2)) return false;
            AbsolutePath absolutePath = this.path();
            AbsolutePath absolutePath2 = pathInfo.path();
            if (absolutePath == null) {
                if (absolutePath2 != null) {
                    return false;
                }
            } else if (!absolutePath.equals(absolutePath2)) return false;
            if (!pathInfo.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ FileDecoderProvider scala$meta$internal$metals$FileDecoderProvider$PathInfo$$$outer() {
            return this.$outer;
        }

        public PathInfo(FileDecoderProvider $outer, BuildTargetIdentifier targetId, AbsolutePath path) {
            this.targetId = targetId;
            this.path = path;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

