/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.File;
import java.io.FileWriter;
import java.net.URLEncoder;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.meta.internal.metals.Buffers;
import scala.meta.internal.metals.ClientCommands$;
import scala.meta.internal.metals.DefinitionProvider;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.HtmlBuilder;
import scala.meta.internal.metals.Icons;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ServerCommands$;
import scala.meta.internal.metals.StacktraceAnalyzer$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u000e\u001d\u0001\u0015B\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!q\u0004A!A!\u0002\u0013y\u0004\"\u0002\"\u0001\t\u0003\u0019\u0005\"\u0002&\u0001\t\u0003Y\u0005\"\u00024\u0001\t\u00039\u0007\"\u00026\u0001\t\u0003Y\u0007\"B=\u0001\t\u0013Q\bbBA\u0001\u0001\u0011%\u00111\u0001\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u0019Q\u0007\u0001\"\u0001\u00024!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA$\u0001\u0011%\u0011\u0011\n\u0005\b\u00037\u0002A\u0011BA/\u0011\u001d\ti\u0007\u0001C\u0005\u0003_Bq!a\u001d\u0001\t\u0013\t)\bC\u0004\u0002z\u0001!I!a\u001f\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\"9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0005bBAH\u0001\u0011%\u0011\u0011S\u0004\b\u00033c\u0002\u0012AAN\r\u0019YB\u0004#\u0001\u0002\u001e\"1!\t\u0007C\u0001\u0003?Cq!!)\u0019\t\u0003\t\u0019K\u0001\nTi\u0006\u001c7\u000e\u001e:bG\u0016\fe.\u00197zu\u0016\u0014(BA\u000f\u001f\u0003\u0019iW\r^1mg*\u0011q\u0004I\u0001\tS:$XM\u001d8bY*\u0011\u0011EI\u0001\u0005[\u0016$\u0018MC\u0001$\u0003\u0015\u00198-\u00197b\u0007\u0001\u0019\"\u0001\u0001\u0014\u0011\u0005\u001dBS\"\u0001\u0012\n\u0005%\u0012#AB!osJ+g-A\u0005x_J\\7\u000f]1dKB\u0011AfL\u0007\u0002[)\u0011a\u0006I\u0001\u0003S>L!\u0001M\u0017\u0003\u0019\u0005\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5\u0002\u000f\t,hMZ3sgB\u00111\u0007N\u0007\u00029%\u0011Q\u0007\b\u0002\b\u0005V4g-\u001a:t\u0003I!WMZ5oSRLwN\u001c)s_ZLG-\u001a:\u0011\u0005MB\u0014BA\u001d\u001d\u0005I!UMZ5oSRLwN\u001c)s_ZLG-\u001a:\u0002\u000b%\u001cwN\\:\u0011\u0005Mb\u0014BA\u001f\u001d\u0005\u0015I5m\u001c8t\u0003]\u0019w.\\7b]\u0012\u001c\u0018J\u001c%u[2\u001cV\u000f\u001d9peR,G\r\u0005\u0002(\u0001&\u0011\u0011I\t\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q1A)\u0012$H\u0011&\u0003\"a\r\u0001\t\u000b)2\u0001\u0019A\u0016\t\u000bE2\u0001\u0019\u0001\u001a\t\u000bY2\u0001\u0019A\u001c\t\u000bi2\u0001\u0019A\u001e\t\u000by2\u0001\u0019A \u0002\u001d\u0005t\u0017\r\\={K\u000e{W.\\1oIR\u0011A*\u0017\t\u0004O5{\u0015B\u0001(#\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001kV\u0007\u0002#*\u0011!kU\u0001\u0006YN\u0004HG\u001b\u0006\u0003)V\u000bq!Z2mSB\u001cXMC\u0001W\u0003\ry'oZ\u0005\u00031F\u0013A#\u0012=fGV$XmQ8n[\u0006tG\rU1sC6\u001c\b\"\u0002.\b\u0001\u0004Y\u0016AC:uC\u000e\\GO]1dKB\u0011Al\u0019\b\u0003;\u0006\u0004\"A\u0018\u0012\u000e\u0003}S!\u0001\u0019\u0013\u0002\rq\u0012xn\u001c;?\u0013\t\u0011'%\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0016\u0014aa\u0015;sS:<'B\u00012#\u0003AI7o\u0015;bG.$&/Y2f\r&dW\r\u0006\u0002@Q\")\u0011\u000e\u0003a\u0001W\u0005!\u0001/\u0019;i\u0003A\u0019H/Y2liJ\f7-\u001a'f]N,7\u000f\u0006\u0002mqB\u0019QN];\u000f\u00059\u0004hB\u00010p\u0013\u0005\u0019\u0013BA9#\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001d;\u0003\u0007M+\u0017O\u0003\u0002rEA\u0011\u0001K^\u0005\u0003oF\u0013\u0001bQ8eK2+gn\u001d\u0005\u0006S&\u0001\raK\u0001\u0013e\u0016\fGm\u0015;bG.$(/Y2f\r&dW\r\u0006\u0002|\u007fB\u0019q%\u0014?\u0011\u00075l8,\u0003\u0002\u007fi\n!A*[:u\u0011\u0015I'\u00021\u0001,\u00039\u0019X\r\u001e+p\u0019&tWm\u0015;beR$b!!\u0002\u0002\f\u0005U\u0001cA\u0014\u0002\b%\u0019\u0011\u0011\u0002\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u001bY\u0001\u0019AA\b\u0003)a\u0017N\\3Ok6\u0014WM\u001d\t\u0004O\u0005E\u0011bAA\nE\t\u0019\u0011J\u001c;\t\u000f\u0005]1\u00021\u0001\u0002\u001a\u0005\u0019\u0001o\\:\u0011\u0007A\u000bY\"C\u0002\u0002\u001eE\u0013\u0001\u0002U8tSRLwN\\\u0001\u001fiJLx)\u001a;MS:,g*^7cKJ4%o\\7Ti\u0006\u001c7\u000e\u001e:bG\u0016$B!a\t\u00020A1\u0011QEA\u0016\u0003\u001fi!!a\n\u000b\u0007\u0005%\"%\u0001\u0003vi&d\u0017\u0002BA\u0017\u0003O\u00111\u0001\u0016:z\u0011\u0019\t\t\u0004\u0004a\u00017\u0006!A.\u001b8f)\ra\u0017Q\u0007\u0005\u0007\u0003oi\u0001\u0019\u0001?\u0002\u000f\r|g\u000e^3oi\u0006!b-\u001b7f\u0019>\u001c\u0017\r^5p]\u001a\u0013x.\u001c'j]\u0016$B!!\u0010\u0002FA!q%TA !\r\u0001\u0016\u0011I\u0005\u0004\u0003\u0007\n&\u0001\u0003'pG\u0006$\u0018n\u001c8\t\r\u0005Eb\u00021\u0001\\\u0003M\u0019HO]5q\u000bJ\u0014xN]*jO:Lg-[3s)\u0011\tY%!\u0017\u0011\t\u00055\u0013qK\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005!A.\u00198h\u0015\t\t)&\u0001\u0003kCZ\f\u0017b\u00013\u0002P!1\u0011\u0011G\bA\u0002m\u000b\u0001$\\1lK\u001e{Go\u001c'pG\u0006$\u0018n\u001c8D_\u0012,G*\u001a8t)\u0015)\u0018qLA2\u0011\u001d\t\t\u0007\u0005a\u0001\u0003\u007f\t\u0001\u0002\\8dCRLwN\u001c\u0005\b\u0003K\u0002\u0002\u0019AA4\u0003\u0015\u0011\u0018M\\4f!\r\u0001\u0016\u0011N\u0005\u0004\u0003W\n&!\u0002*b]\u001e,\u0017!E1oC2L(0Z*uC\u000e\\GK]1dKR\u0019A*!\u001d\t\u000bi\u000b\u0002\u0019A.\u0002+5\f7.Z$pi>\u001cu.\\7b]\u0012\u0004\u0016M]1ngR\u0019q*a\u001e\t\u000f\u0005\u0005$\u00031\u0001\u0002@\u0005ABO]=TKRd\u0015N\\3Ge>l7\u000b^1dWR\u0014\u0018mY3\u0015\r\u0005}\u0012QPA@\u0011\u001d\t\tg\u0005a\u0001\u0003\u007fAa!!\r\u0014\u0001\u0004Y\u0016AD:z[\n|GN\u0012:p[2Kg.\u001a\u000b\u0005\u0003\u000b\u000b9\tE\u0002(\u001bnCa!!\r\u0015\u0001\u0004Y\u0016!F7bW\u0016DE/\u001c7D_6l\u0017M\u001c3QCJ\fWn\u001d\u000b\u0004\u001f\u00065\u0005\"\u0002.\u0016\u0001\u0004Y\u0016\u0001F4pi>dunY1uS>tWk]5oOV\u0013\u0018\u000eF\u0003\\\u0003'\u000b9\n\u0003\u0004\u0002\u0016Z\u0001\raW\u0001\u0004kJL\u0007bBA\u0019-\u0001\u0007\u0011qB\u0001\u0013'R\f7m\u001b;sC\u000e,\u0017I\\1msj,'\u000f\u0005\u000241M\u0011\u0001D\n\u000b\u0003\u00037\u000b\u0001\u0003^8U_BdWM^3m'fl'm\u001c7\u0015\u0007q\f)\u000b\u0003\u0004\u0002(j\u0001\raW\u0001\tgfl'm\u001c7J]\u0002")
public class StacktraceAnalyzer {
    private final AbsolutePath workspace;
    private final Buffers buffers;
    private final DefinitionProvider definitionProvider;
    private final Icons icons;
    private final boolean commandsInHtmlSupported;

    public static List<String> toToplevelSymbol(String string) {
        return StacktraceAnalyzer$.MODULE$.toToplevelSymbol(string);
    }

    public Option<ExecuteCommandParams> analyzeCommand(String stacktrace) {
        return this.analyzeStackTrace(stacktrace);
    }

    public boolean isStackTraceFile(AbsolutePath path) {
        AbsolutePath absolutePath = path;
        AbsolutePath absolutePath2 = this.workspace.resolve(Directories$.MODULE$.stacktrace());
        return !(absolutePath != null ? !absolutePath.equals(absolutePath2) : absolutePath2 != null);
    }

    public Seq<CodeLens> stacktraceLenses(AbsolutePath path) {
        return (Seq)this.readStacktraceFile(path).map((Function1 & java.io.Serializable & Serializable)content -> this.stacktraceLenses((List<String>)content)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> (Seq)Nil$.MODULE$);
    }

    private Option<List<String>> readStacktraceFile(AbsolutePath path) {
        return this.buffers.get(path).map((Function1 & java.io.Serializable & Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$1)).split('\n'))).toList());
    }

    private void setToLineStart(int lineNumber, Position pos) {
        pos.setLine(lineNumber);
        pos.setCharacter(0);
    }

    private Try<Object> tryGetLineNumberFromStacktrace(String line) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> Predef$.MODULE$.Integer2int(Integer.valueOf(line.substring(line.indexOf(":") + 1, line.indexOf(")")))) - 1);
    }

    public Seq<CodeLens> stacktraceLenses(List<String> content) {
        return ((scala.collection.immutable.Seq)((TraversableLike)((TraversableLike)content.zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1 & java.io.Serializable & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)StacktraceAnalyzer.$anonfun$stacktraceLenses$3(check$ifrefutable$1))).map((Function1 & java.io.Serializable & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String line = (String)tuple2._1();
            String cleanedLine = this.stripErrorSignifier(line);
            Tuple2 tuple22 = new Tuple2((Object)tuple2, (Object)cleanedLine);
            return tuple22;
        }, List$.MODULE$.canBuildFrom())).withFilter((Function1 & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StacktraceAnalyzer.$anonfun$stacktraceLenses$5(x$4))).flatMap((Function1 & java.io.Serializable & Serializable)x$6 -> {
            String cleanedLine;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x$6;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    cleanedLine = (String)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int row = tuple2._2$mcI$sp();
            Iterable iterable = Option$.MODULE$.option2Iterable(this.fileLocationFromLine(cleanedLine).map((Function1 & java.io.Serializable & Serializable)location -> {
                Range range = new Range(new Position(row, 0), new Position(row, 0));
                return new Tuple2(location, (Object)range);
            }).map((Function1 & java.io.Serializable & Serializable)x$5 -> {
                Tuple2 tuple2 = x$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Location location = (Location)tuple2._1();
                Range range = (Range)tuple2._2();
                CodeLens codeLens = this.makeGotoLocationCodeLens(location, range);
                return codeLens;
            }));
            return iterable;
        }, List$.MODULE$.canBuildFrom())).toSeq();
    }

    public Option<Location> fileLocationFromLine(String line) {
        return this.symbolFromLine(line).flatMap((Function1 & java.io.Serializable & Serializable)symbol -> StacktraceAnalyzer$.MODULE$.toToplevelSymbol((String)symbol).collectFirst(Function$.MODULE$.unlift((Function1 & java.io.Serializable & Serializable)s -> this.findLocationForSymbol$1((String)s))).map((Function1 & java.io.Serializable & Serializable)location -> this.trySetLineFromStacktrace((Location)location, line)));
    }

    private String stripErrorSignifier(String line) {
        return line.replaceFirst("(\\[E\\]|\\[error\\]|\\[info\\])", "").trim();
    }

    private CodeLens makeGotoLocationCodeLens(Location location, Range range) {
        return new CodeLens(range, new Command(new StringBuilder(5).append(this.icons.findsuper()).append(" open").toString(), ServerCommands$.MODULE$.GotoPosition().id(), (java.util.List)MetalsEnrichments$.MODULE$.seqAsJavaListConverter(new .colon.colon((Object)location, (List)Nil$.MODULE$)).asJava()), null);
    }

    private Option<ExecuteCommandParams> analyzeStackTrace(String stacktrace) {
        Some some;
        if (this.commandsInHtmlSupported) {
            some = new Some((Object)this.makeHtmlCommandParams(stacktrace));
        } else {
            AbsolutePath path = this.workspace.resolve(Directories$.MODULE$.stacktrace());
            File pathFile = path.toFile();
            String pathStr = pathFile.toString();
            pathFile.createNewFile();
            try (FileWriter fw = new FileWriter(pathStr);){
                fw.write(new StringBuilder(6).append("/*\n").append(stacktrace).append("\n*/").toString());
            }
            Position fileStartPos = new Position(0, 0);
            Range range = new Range(fileStartPos, fileStartPos);
            Location stackTraceLocation = new Location(path.toURI().toString(), range);
            some = new Some((Object)this.makeGotoCommandParams(stackTraceLocation));
        }
        return some;
    }

    private ExecuteCommandParams makeGotoCommandParams(Location location) {
        return new ExecuteCommandParams(ClientCommands$.MODULE$.GotoLocation().id(), (java.util.List)MetalsEnrichments$.MODULE$.seqAsJavaListConverter(new .colon.colon((Object)location, (List)new .colon.colon((Object)Boolean.TRUE, (List)Nil$.MODULE$))).asJava());
    }

    private Location trySetLineFromStacktrace(Location location, String line) {
        Try<Object> lineNumberOpt = this.tryGetLineNumberFromStacktrace(line);
        lineNumberOpt.foreach((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)lineNumber -> {
            this.setToLineStart(lineNumber, location.getRange().getStart());
            this.setToLineStart(lineNumber, location.getRange().getEnd());
        });
        return location;
    }

    private Option<String> symbolFromLine(String line) {
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> line.substring(line.indexOf("at ") + 3, line.indexOf("("))).toOption();
    }

    private ExecuteCommandParams makeHtmlCommandParams(String stacktrace) {
        HtmlBuilder qual$1 = new HtmlBuilder();
        String x$1 = "h3";
        String x$2 = qual$1.element$default$2();
        Function1 & java.io.Serializable & Serializable x$3 = (Function1 & java.io.Serializable & Serializable)x$7 -> {
            x$7.text("Stacktrace");
            return BoxedUnit.UNIT;
        };
        String output = qual$1.element(x$1, x$2, (Function1)x$3).call((Function1 & java.io.Serializable & Serializable)builder -> {
            this.htmlStack$1(builder, stacktrace);
            return BoxedUnit.UNIT;
        }).render();
        return new ExecuteCommandParams("metals-show-stacktrace", (java.util.List)MetalsEnrichments$.MODULE$.seqAsJavaListConverter(new .colon.colon((Object)output, (List)Nil$.MODULE$)).asJava());
    }

    private String gotoLocationUsingUri(String uri, int line) {
        String param = new StringBuilder(10).append("[\"").append(uri).append("\",").append(line).append(",true]").toString();
        return new StringBuilder(29).append("command:metals.goto-path-uri?").append(URLEncoder.encode(param)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$stacktraceLenses$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$stacktraceLenses$5(Tuple2 x$4) {
        String cleanedLine;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$4;
                if (tuple2 == null) break block2;
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                cleanedLine = (String)tuple2._2();
                if (tuple22 != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        boolean bl = cleanedLine.startsWith("at ");
        return bl;
    }

    private final Option findLocationForSymbol$1(String s) {
        return ((TraversableLike)MetalsEnrichments$.MODULE$.asScalaBufferConverter(this.definitionProvider.fromSymbol(s, (Option<AbsolutePath>)None$.MODULE$)).asScala()).headOption();
    }

    private final void htmlStack$1(HtmlBuilder builder, String stacktrace$1) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(stacktrace$1)).split('\n'))).foreach((Function1 & java.io.Serializable & Serializable)line -> {
            HtmlBuilder htmlBuilder;
            if (line.contains("at ")) {
                HtmlBuilder htmlBuilder2;
                Option<Location> option = this.fileLocationFromLine((String)line);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Location location = (Location)some.value();
                    htmlBuilder2 = builder.text("at ").link(this.gotoLocationUsingUri(location.getUri(), location.getRange().getStart().getLine()), line.substring(line.indexOf("at ") + 3));
                } else if (None$.MODULE$.equals(option)) {
                    htmlBuilder2 = builder.raw(line);
                } else {
                    throw new MatchError(option);
                }
                htmlBuilder = htmlBuilder2;
            } else {
                htmlBuilder = builder.raw(line);
            }
            return builder.raw("<br>");
        });
    }

    public StacktraceAnalyzer(AbsolutePath workspace, Buffers buffers, DefinitionProvider definitionProvider, Icons icons, boolean commandsInHtmlSupported) {
        this.workspace = workspace;
        this.buffers = buffers;
        this.definitionProvider = definitionProvider;
        this.icons = icons;
        this.commandsInHtmlSupported = commandsInHtmlSupported;
    }
}

