/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.watcher;

import ch.epfl.scala.bsp4j.ScalacOptionsItem;
import com.swoval.files.FileTreeDataViews;
import com.swoval.files.FileTreeRepositories;
import com.swoval.files.FileTreeRepository;
import com.swoval.functional.Either;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Set;
import scala.math.Ordering$;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.watcher.FileWatcher;
import scala.meta.internal.metals.watcher.FileWatcherEvent;
import scala.meta.internal.metals.watcher.FileWatcherEvent$;
import scala.meta.internal.metals.watcher.PathTrie;
import scala.meta.internal.metals.watcher.PathTrie$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Properties$;
import scala.util.hashing.MurmurHash3$;

public final class FileWatcher$ {
    public static FileWatcher$ MODULE$;

    static {
        new FileWatcher$();
    }

    public FileWatcher.FilesToWatch scala$meta$internal$metals$watcher$FileWatcher$$collectFilesToWatch(BuildTargets buildTargets) {
        Set sourceDirectoriesToWatch = scala.collection.mutable.Set$.MODULE$.empty();
        Set sourceFilesToWatch = scala.collection.mutable.Set$.MODULE$.empty();
        buildTargets.sourceRoots().foreach((Function1 & java.io.Serializable & Serializable)path -> {
            FileWatcher$.collect$1(path, buildTargets, sourceFilesToWatch, sourceDirectoriesToWatch);
            return BoxedUnit.UNIT;
        });
        buildTargets.sourceItems().foreach((Function1 & java.io.Serializable & Serializable)path -> {
            FileWatcher$.collect$1(path, buildTargets, sourceFilesToWatch, sourceDirectoriesToWatch);
            return BoxedUnit.UNIT;
        });
        Iterable semanticdbs = (Iterable)buildTargets.scalacOptions().flatMap((Function1 & java.io.Serializable & Serializable)item -> Option$.MODULE$.option2Iterable(buildTargets.scalaInfo(item.getTarget()).map((Function1 & java.io.Serializable & Serializable)scalaInfo -> {
            AbsolutePath targetroot = MetalsEnrichments$.MODULE$.XtensionScalacOptions((ScalacOptionsItem)item).targetroot(scalaInfo.getScalaVersion());
            AbsolutePath path = targetroot.resolve(Directories$.MODULE$.semanticdb());
            return new Tuple3(scalaInfo, (Object)targetroot, (Object)path);
        }).withFilter((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FileWatcher$.$anonfun$collectFilesToWatch$5(x$3))).map((Function1 & java.io.Serializable & Serializable)x$4 -> {
            Tuple3 tuple3 = x$4;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            AbsolutePath path = (AbsolutePath)tuple3._3();
            Path path2 = path.toNIO();
            return path2;
        })), Iterable$.MODULE$.canBuildFrom());
        return new FileWatcher.FilesToWatch((scala.collection.immutable.Set<Path>)sourceFilesToWatch.toSet(), (scala.collection.immutable.Set<Path>)sourceDirectoriesToWatch.toSet(), (scala.collection.immutable.Set<Path>)semanticdbs.toSet());
    }

    public Function0<BoxedUnit> scala$meta$internal$metals$watcher$FileWatcher$$startWatch(Path workspace, FileWatcher.FilesToWatch filesToWatch, Function1<FileWatcherEvent, BoxedUnit> callback, Function1<Path, Object> watchFilter) {
        JFunction0.mcV.sp & java.io.Serializable & Serializable intersect;
        if (Properties$.MODULE$.isMac()) {
            PathTrie trie = PathTrie$.MODULE$.apply((scala.collection.immutable.Set<Path>)((scala.collection.immutable.Set)filesToWatch.sourceFiles().$plus$plus(filesToWatch.sourceDirectories()).$plus$plus(filesToWatch.semanticdDirectories())));
            Function1 & java.io.Serializable & Serializable isWatched = (Function1 & java.io.Serializable & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)trie.containsPrefixOf(path));
            FileTreeRepository<Object> repo = this.initFileTreeRepository((Function1<Path, Object>)(Function1 & java.io.Serializable & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)FileWatcher$.$anonfun$startWatch$2(watchFilter, isWatched, path)), callback);
            repo.register(workspace, Integer.MAX_VALUE);
            intersect = (JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> repo.close();
        } else {
            FileTreeRepository<Object> repo = this.initFileTreeRepository(watchFilter, callback);
            scala.collection.immutable.Set directoriesToCreate = (scala.collection.immutable.Set)filesToWatch.sourceDirectories().$plus$plus((GenTraversableOnce)filesToWatch.sourceFiles().map((Function1 & java.io.Serializable & Serializable)x$5 -> x$5.getParent(), Set$.MODULE$.canBuildFrom()));
            scala.collection.immutable.Set createdDirectories = (scala.collection.immutable.Set)directoriesToCreate.flatMap((Function1 & java.io.Serializable & Serializable)path -> MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(AbsolutePath$.MODULE$.apply(path, AbsolutePath$.MODULE$.workingDirectory())).createAndGetDirectories(), Set$.MODULE$.canBuildFrom());
            filesToWatch.sourceDirectories().foreach((Function1 & java.io.Serializable & Serializable)x$6 -> repo.register(x$6, Integer.MAX_VALUE));
            filesToWatch.semanticdDirectories().foreach((Function1 & java.io.Serializable & Serializable)x$7 -> repo.register(x$7, Integer.MAX_VALUE));
            filesToWatch.sourceFiles().foreach((Function1 & java.io.Serializable & Serializable)x$8 -> repo.register(x$8, -1));
            ((IterableLike)((SeqLike)createdDirectories.toSeq().sortBy((Function1 & java.io.Serializable & Serializable)x$9 -> x$9.toNIO(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).reverse()).foreach((Function1 & java.io.Serializable & Serializable)dir -> {
                FileWatcher$.$anonfun$startWatch$10(dir);
                return BoxedUnit.UNIT;
            });
            intersect = (JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> repo.close();
        }
        return intersect;
    }

    private FileTreeRepository<Object> initFileTreeRepository(Function1<Path, Object> watchFilter, Function1<FileWatcherEvent, BoxedUnit> callback) {
        FileTreeDataViews.Converter converter = typedPath -> BoxesRunTime.boxToInteger((int)FileWatcher$.MODULE$.hashFile(typedPath.getPath(), (Function1<Path, Object>)watchFilter));
        FileTreeRepository repo = FileTreeRepositories.get((FileTreeDataViews.Converter)converter, (boolean)true);
        repo.addCacheObserver((FileTreeDataViews.CacheObserver)new FileTreeDataViews.CacheObserver<Object>(watchFilter, callback){
            private final Function1 watchFilter$2;
            private final Function1 callback$1;

            public void onCreate(FileTreeDataViews.Entry<Object> entry) {
                block0: {
                    Path path = entry.getTypedPath().getPath();
                    if (!BoxesRunTime.unboxToBoolean((Object)this.watchFilter$2.apply((Object)path))) break block0;
                    this.callback$1.apply((Object)FileWatcherEvent$.MODULE$.create(path));
                }
            }

            public void onDelete(FileTreeDataViews.Entry<Object> entry) {
                block0: {
                    Path path = entry.getTypedPath().getPath();
                    if (!BoxesRunTime.unboxToBoolean((Object)this.watchFilter$2.apply((Object)path))) break block0;
                    this.callback$1.apply((Object)FileWatcherEvent$.MODULE$.delete(path));
                }
            }

            public void onUpdate(FileTreeDataViews.Entry<Object> previous, FileTreeDataViews.Entry<Object> current) {
                block0: {
                    Path path = current.getTypedPath().getPath();
                    Either either = previous.getValue();
                    Either either2 = current.getValue();
                    if (!(either == null ? either2 != null : !either.equals(either2)) || !BoxesRunTime.unboxToBoolean((Object)this.watchFilter$2.apply((Object)path))) break block0;
                    this.callback$1.apply((Object)FileWatcherEvent$.MODULE$.modify(path));
                }
            }

            public void onError(IOException ex) {
            }
            {
                this.watchFilter$2 = watchFilter$2;
                this.callback$1 = callback$1;
            }
        });
        return repo;
    }

    private int hashFile(Path path, Function1<Path, Object> hashFilter) {
        int n;
        if (BoxesRunTime.unboxToBoolean((Object)hashFilter.apply((Object)path))) {
            try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                try {
                    n = MurmurHash3$.MODULE$.orderedHash((TraversableOnce)package$.MODULE$.Stream().continually((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> inputStream.read()).takeWhile((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$10 -> x$10 != -1));
                }
                catch (IOException iOException) {
                    n = 0;
                }
            }
        } else {
            n = 0;
        }
        return n;
    }

    private static final void collect$1(AbsolutePath path, BuildTargets buildTargets$1, Set sourceFilesToWatch$1, Set sourceDirectoriesToWatch$1) {
        if (!buildTargets$1.isInsideSourceRoot(path)) {
            if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isScalaOrJava()) {
                sourceFilesToWatch$1.add((Object)path.toNIO());
            } else {
                sourceDirectoriesToWatch$1.add((Object)path.toNIO());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$collectFilesToWatch$5(Tuple3 x$3) {
        Tuple3 tuple3 = x$3;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        AbsolutePath targetroot = (AbsolutePath)tuple3._2();
        boolean bl = !MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(targetroot).isJar();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$startWatch$2(Function1 watchFilter$1, Function1 isWatched$1, Path path) {
        return BoxesRunTime.unboxToBoolean((Object)watchFilter$1.apply((Object)path)) && BoxesRunTime.unboxToBoolean((Object)isWatched$1.apply((Object)path));
    }

    public static final /* synthetic */ void $anonfun$startWatch$10(AbsolutePath dir) {
        block0: {
            if (!MetalsEnrichments$.MODULE$.XtensionAbsolutePath(dir).isEmptyDirectory()) break block0;
            MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(dir).delete();
        }
    }

    private FileWatcher$() {
        MODULE$ = this;
    }
}

