/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.meta.internal.decorations.SyntheticsDecorationProvider;
import scala.meta.internal.implementation.ImplementationProvider;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ReferenceProvider;
import scala.meta.internal.mtags.SemanticdbClasspath$;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.internal.semanticdb.TextDocuments;
import scala.meta.internal.semanticdb.TextDocuments$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;
import scribe.Loggable;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0004\b\u0001/!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0011!A\u0003A!A!\u0002\u0013I\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u0011M\u0002!\u0011!Q\u0001\nQBQA\u000f\u0001\u0005\u0002mBQA\u0011\u0001\u0005\u0002\rCQa\u0012\u0001\u0005\u0002\rCQ\u0001\u0013\u0001\u0005\u0002%CQ!\u0016\u0001\u0005\nYCQ!\u0017\u0001\u0005\u0002iCQ!\u0017\u0001\u0005\u0002\u0015\u0014\u0011cU3nC:$\u0018n\u00193c\u0013:$W\r_3s\u0015\ty\u0001#\u0001\u0004nKR\fGn\u001d\u0006\u0003#I\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003'Q\tA!\\3uC*\tQ#A\u0003tG\u0006d\u0017m\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001b\u001b\u0005!\u0012BA\u000e\u0015\u0005\u0019\te.\u001f*fM\u0006\t\"/\u001a4fe\u0016t7-\u001a)s_ZLG-\u001a:\u0011\u0005yyR\"\u0001\b\n\u0005\u0001r!!\u0005*fM\u0016\u0014XM\\2f!J|g/\u001b3fe\u00061\u0012.\u001c9mK6,g\u000e^1uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002$M5\tAE\u0003\u0002&!\u0005q\u0011.\u001c9mK6,g\u000e^1uS>t\u0017BA\u0014%\u0005YIU\u000e\u001d7f[\u0016tG/\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\u0018!E5na2L7-\u001b;EK\u000e|'/\u0019;peB\u0011!&L\u0007\u0002W)\u0011A\u0006E\u0001\fI\u0016\u001cwN]1uS>t7/\u0003\u0002/W\ta2+\u001f8uQ\u0016$\u0018nY:EK\u000e|'/\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\u0018\u0001\u00042vS2$G+\u0019:hKR\u001c\bC\u0001\u00102\u0013\t\u0011dB\u0001\u0007Ck&dG\rV1sO\u0016$8/A\u0005x_J\\7\u000f]1dKB\u0011Q\u0007O\u0007\u0002m)\u0011qGE\u0001\u0003S>L!!\u000f\u001c\u0003\u0019\u0005\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5\u0002\rqJg.\u001b;?)\u0019aTHP A\u0003B\u0011a\u0004\u0001\u0005\u00069\u0019\u0001\r!\b\u0005\u0006C\u0019\u0001\rA\t\u0005\u0006Q\u0019\u0001\r!\u000b\u0005\u0006_\u0019\u0001\r\u0001\r\u0005\u0006g\u0019\u0001\r\u0001N\u0001\u000e_:$\u0016M]4fiJ{w\u000e^:\u0015\u0003\u0011\u0003\"!G#\n\u0005\u0019#\"\u0001B+oSR\fQA]3tKR\f\u0001b\u001c8EK2,G/\u001a\u000b\u0003\t*CQaS\u0005A\u00021\u000bAAZ5mKB\u0011QjU\u0007\u0002\u001d*\u00111j\u0014\u0006\u0003!F\u000b1A\\5p\u0015\u0005\u0011\u0016\u0001\u00026bm\u0006L!\u0001\u0016(\u0003\tA\u000bG\u000f[\u0001\u0012_:\u001c\u0005.\u00198hK\u0012K'/Z2u_JLHC\u0001#X\u0011\u0015A&\u00021\u0001M\u0003\r!\u0017N]\u0001\t_:\u001c\u0005.\u00198hKR\u0019AiW/\t\u000bq[\u0001\u0019\u0001\u001b\u0002\tA\fG\u000f\u001b\u0005\u0006=.\u0001\raX\u0001\ri\u0016DH\u000fR8dk6,g\u000e\u001e\t\u0003A\u000el\u0011!\u0019\u0006\u0003EB\t!b]3nC:$\u0018n\u00193c\u0013\t!\u0017M\u0001\u0007UKb$Hi\\2v[\u0016tG\u000f\u0006\u0002EM\")1\n\u0004a\u0001\u0019\u0002")
public class SemanticdbIndexer {
    private final ReferenceProvider referenceProvider;
    private final ImplementationProvider implementationProvider;
    private final SyntheticsDecorationProvider implicitDecorator;
    private final BuildTargets buildTargets;
    private final AbsolutePath workspace;

    public void onTargetRoots() {
        this.buildTargets.allTargetRoots().foreach((Function1 & java.io.Serializable & Serializable)targetRoot -> {
            this.onChangeDirectory(targetRoot.resolve(Directories$.MODULE$.semanticdb()).toNIO());
            return BoxedUnit.UNIT;
        });
    }

    public void reset() {
        this.referenceProvider.reset();
        this.implementationProvider.clear();
    }

    public void onDelete(Path file) {
        this.referenceProvider.onDelete(file);
        this.implementationProvider.onDelete(file);
    }

    private void onChangeDirectory(Path dir) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                stream.forEach(x$1 -> this.onChange((Path)x$1));
            }
        }
    }

    public void onChange(AbsolutePath path, TextDocument textDocument) {
        TextDocuments docs = new TextDocuments((Seq)new .colon.colon((Object)textDocument, (List)Nil$.MODULE$));
        this.referenceProvider.onChange(docs, path);
        this.implementationProvider.onChange(docs, path);
        this.implicitDecorator.onChange(docs, path);
    }

    public void onChange(Path file) {
        block7: {
            if (Files.isDirectory(file, new LinkOption[0])) break block7;
            if (MetalsEnrichments$.MODULE$.XtensionPath(file).isSemanticdb()) {
                try {
                    TextDocuments doc = (TextDocuments)TextDocuments$.MODULE$.parseFrom(Files.readAllBytes(file));
                    SemanticdbClasspath$.MODULE$.toScala(this.workspace, AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory())).foreach((Function1 & java.io.Serializable & Serializable)scalaSourceFile -> {
                        SemanticdbIndexer.$anonfun$onChange$1(this, doc, scalaSourceFile);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof InvalidProtocolBufferException) {
                        InvalidProtocolBufferException invalidProtocolBufferException = (InvalidProtocolBufferException)throwable2;
                        package$.MODULE$.debug((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(17).append(file).append(" is not yet ready").toString(), (Throwable)invalidProtocolBufferException, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(80));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    if (throwable2 instanceof FileSystemException) {
                        FileSystemException fileSystemException = (FileSystemException)throwable2;
                        package$.MODULE$.debug((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(17).append(file).append(" is not yet ready").toString(), (Throwable)fileSystemException, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(83));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        package$.MODULE$.warn((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(37).append("unexpected error processing the file ").append(file).toString(), e, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(85));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            } else {
                package$.MODULE$.warn((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(23).append("not a semanticdb file: ").append(file).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(88));
            }
        }
    }

    public static final /* synthetic */ void $anonfun$onChange$1(SemanticdbIndexer $this, TextDocuments doc$1, AbsolutePath scalaSourceFile) {
        $this.referenceProvider.onChange(doc$1, scalaSourceFile);
        $this.implementationProvider.onChange(doc$1, scalaSourceFile);
        $this.implicitDecorator.onChange(doc$1, scalaSourceFile);
    }

    public SemanticdbIndexer(ReferenceProvider referenceProvider, ImplementationProvider implementationProvider, SyntheticsDecorationProvider implicitDecorator, BuildTargets buildTargets, AbsolutePath workspace) {
        this.referenceProvider = referenceProvider;
        this.implementationProvider = implementationProvider;
        this.implicitDecorator = implicitDecorator;
        this.buildTargets = buildTargets;
        this.workspace = workspace;
    }
}

